
#include <stdio.h>
#include "ofdm.h"
#include "eti.h"
#include "parameters.h"
#include "symcon.h"
#include "fft.h"

FFT_TYPE frqsymbol[2*2048];
extern BYTE ofdm_diffsymb[];

void main(void) {
  int i;

  mode_init(1);
  printf("qpsksymbole:\n");
  for (i=0;i<16;i++) {
    printf(" %3.3f\n",ofdm_qpsksymbol[i]);
  }
  printf("digital tfpr:\n");
  for (i=-768;i<-749;i++) {
    printf(" carrier %3d   phase %d\n",i,tfpr_phi(i));
  }
  TFPR_Symbol(frqsymbol);
  printf("TFPR-Symbol\n");
  for (i=0;i<48;i++) {
    printf("i%d %3.6f + %3.6fj\n",i,frqsymbol[2*i],frqsymbol[2*i+1]);
  } 
  printf("ofdm_diffsymb\n");
  for (i=0;i<48;i++) {
    printf("i%d %3.6f + %3.6fj\n",i,ofdm_diffsymb[2*i],ofdm_diffsymb[2*i+1]);
  }
}
