


/*


  Burrus/Parks algorithm

1024 Punkte, short
maxinput    1023
maxoutput  32768
maxerr       -11.382798
usefull bits  11.49

  */
#include "conf.h"
#include "fft.h"
#include "fft_reversal.h"

void main(void) {
  int i,j,q;
  FFT_TYPE work[2048*2];
  double work2[2048*2];
  int size,base;
  FILE *out;


  base=10;
  size=(1<<(base));

  printf("init size%d base%d\n",size,base);
  printf("FFT_TYPE %d FFT_ONE %3.3f\n",sizeof(FFT_TYPE),FFT_ONE);
  printf("FFT_ONE %d\n",FFT_ONE);
  fft_init(size);
  fft_init_double();
  out=fopen("./testfft.m","w");
  fprintf(out,"function testfft\n\n");
  fprintf(out,"global rr qq\n");
  
  for (i=0;i<2*size;i++) { work[i]=0;work2[i]=0; }
  for (j=1;j<2;j++) {
    srand(j);
    for (i=0;i<2*size;i++) {
      q=1-2*(rand() > (RAND_MAX/2));
      work[i]=q*15;
      work2[i]=q*15;
    }
    
    fft_r2(size,work);
    fftreversal_r2(work,base);
    fft_double(work2,base);
    
    fprintf(out,"qq(:,%d)=[\n",j);
#ifdef FFT_FLOAT
    for (i=0;i<size*2;i++) fprintf(out,"%10.7f\n",work[i]);
#endif
#ifdef FFT_INT15
    for (i=0;i<size*2;i++) fprintf(out,"%10d\n",work[i]);
#endif
    fprintf(out,"];\n");
    fprintf(out,"rr(:,%d)=[\n",j);
    for (i=0;i<size*2;i++) fprintf(out,"%10.7f\n",work2[i]);
    fprintf(out,"];\n");
  }

  fclose(out);
  exit(0);
}
