
/*


  frame-control

  works on fixed eti-frames - for benchmarking purposes

  */



#include "conf.h"
#include "eti.h"
#include "parameters.h"
#include "symcon.h"
#include "ofdm.h"
#include "profile.h"
#include "fft.h"
#include "fft_reversal.h"

/* #include "eti_frame.c" */
/* #include "print_eti.c" */


short testb[1024*2]; /* max=null-symbol,mode-1,*2 */
short Wk[1024*2];

int fftreversal_radix4(short *symb,int base);
int fftreversal_radix2(short *symb,int base);
void radix4asm(int size,short *work,short *wk);
void radix2asm(int size,short *work,short *wk);

void dofft(int size,short *work,short *wk) {
  radix4asm(size,work,wk);
}

void main(void) {
  int i;
  int size,base,dummy;
  float phi;
  clock_t start,stop;

  printf("testdemo starting\n");
#ifdef ARCHC6X
  printf("compiled for TMS320C62xx\n");
#endif
  
  base=10;
  size=(1<<base);

  printf("init size%d\n",size);

  for (i=0;i<size;i++) {
    phi= 2*M_PI*i/size;
    testb[2*i]=0;
    testb[2*i+1]=0;
    Wk[2*i]=sin(phi)*32767;
    Wk[2*i+1]=cos(phi)*32767;
  }
  testb[2]=32767;
  printf("data size%d\n",size);
  /* for (i=0;i<16;i++) printf(" %8d  %8d\n",testb[2*i],testb[2*i+1]); */
  start=clock();
  radix4asm(size,testb,Wk);
  stop=clock();
  printf("calculation %d\n",stop-start);
  fftreversal_radix4(testb,base/2);
  printf("fft\n");
  for (i=0;i<16;i++) printf(" %8d  %8d\n",testb[2*i],testb[2*i+1]);  
  printf("testdemo exit\n");
  exit(0);
}




int fftreversal_radix4(short *symb,int base) {
  int i,j,k,size;
  FFT_TYPE tmp;

#ifdef COFDM_PROFILE
  prof_start(profile_reversal);
#endif
  /* first and last element are never touched. All others can
     be symetrically switched - but i have to check, i switch
     them only once!
   */
  size=(1<<(base*2));
  for (i=1;i<size-1;i++) {
    j=quadreversal(i,base);
    
    if (i<j) {
      tmp=symb[2*i];
      symb[2*i]=symb[2*j];
      symb[2*j]=tmp;
      
      tmp=symb[2*i+1];
      symb[2*i+1]=symb[2*j+1];
      symb[2*j+1]=tmp;
    }
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}

int fftreversal_radix2(short *symb,int base) {
  int i,j,size;
  FFT_TYPE tmp;

  /* first and last element are never touched. All others can
     be symetrically switched - but i have to check, i switch
     them only once!
   */
#ifdef COFDM_PROFILE
  prof_start(profile_reversal);
#endif
  size=(1<<base);
  for (i=1;i<size;i++) {
    j=bitreversal(i,base);
    if (i<j) {
      tmp=symb[2*i];
      symb[2*i]=symb[2*j];
      symb[2*j]=tmp;

      tmp=symb[2*i+1];
      symb[2*i+1]=symb[2*j+1];
      symb[2*j+1]=tmp;
    }
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}
