

/*

  File for testing the performance of 
  different orderings of c-code

*/


#include "conf.h"
#include "fft.h"

FFT_TYPE testb[2048*2];
FFT_TYPE fft_Wk[1];

void main(void) {
  int breversal[16]={ 0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15 };
  register WORD tmp,cu[15],ina,inb,outa,outb;
  register int i,j;
  clock_t start,stop;
  
  
  /* inner interleaver-loop */
  start=clock();
  /* 1.step: read out */
  outa=ina&0x80008000;
  outb=inb&0x80008000;
  for (i=1;i<16;i++) {
    j=breversal[i];
    outa^=((cu[j-1]&0x80008000)>>i);
    tmp=(cu[15-j]&(0x00010001<<(j-1)))>>(j-1);
    tmp<<=(15-i);
    outb^=tmp;
  }
  
  /* write out */
  
  /* 2.,3. step: shift&clear */
  for (i=0;i<15;i++) {
    cu[i]<<=1;
    cu[i]&=((0x80008000>>i)^0xfffefffe);
  }
  
  /* 4.step: write in CU */
  for (i=1;i<16;i++) {
    j=breversal[i];
    tmp=((ina&(0x80008000>>i))<<1);
    if (j>i) {
      tmp>>=(j-i); 
    } else {
      tmp<<=(i-j);
    }
    cu[j-1]^=tmp;
    tmp=((inb&(0x80008000>>i))>>(15-i));
    cu[15-j]^=tmp;
  }
  stop=clock();
  printf("time %d\n",start-stop);
}
