
/*

  Reed-Solomon demo

  BUFSIZE must be check!!!
 */


#include <stdlib.h>
#include "conf.h"
#include "rs.h"
#include "gfq.h"

WORD msg[250];

/* this size works, but is not the size i expected! */
WORD buf[2*(14)+24];

void main(int argc,char **argv) {
  int i,errs,j,t0,t1,t2,t3,q;

  /* Init */
  printf("rs-starting\n");
  printf("log(69)=%d\n",logatab(69));
  printf("log(225)=%d\n",logatab(225));
  printf("69*225=%d\n",gfq_multiplic(69,225));

  printf("init\n");
  prof_init();
  for (i=0;i<226;i++) msg[i]=i;
  printf("encoding\n");
  rs_Wencode(msg,226,120,14,buf);
  /*
  printf("inserting errors\n");
  msg[30]=0xffffffff;            // 4 burst Fehler
  msg[20]=(msg[20]&0xffffff00);  // 1 Fehler
  msg[40]=(msg[40]|0x0000ff00);  // 1 Fehler
  msg[59]=(msg[59]&0xff00ffff);  // 1 Fehler in Paraty bytes
  */
  printf("decoding\n");
  q=rs_Wcorrect(msg,226,120,14,buf);
  printf("finished\n");
  if (q==-1) {       printf("decoder failure\n");
  } else if (q==0) { printf("no errors\n");
  } else {           printf("%d errors\n",q);
  }	       
  prof_printf();
  exit(1);
}

/* Analysis:
   10,000 cycles,
   1..100 errors: decoder failures 9158; decoder errors 6;
   1...20 errors: decoder failures 5859; decoder errors 1;
   1....7 errors: decoder failures 0; decoder errors 0;
*/

/* eti-NI requires 9 calls to rs_correct!
   thats 36 calls for mode 1
*/


/* Interesting profile:
inserting error at  31, value 202
inserting error at  68, value 107
inserting error at  91, value 185
inserting error at 162, value 234
inserting error at   3, value 200
inserting error at  43, value 191
inserting error at 125, value 145
inserting error at  44, value  16
inserting error at 188, value 135
inserting error at 125, value 205
inserting error at 103, value 168
inserting error at 108, value 187
inserting error at 211, value 126
inserting error at 152, value  52
inserting error at 144, value 219
inserting error at   0, value 225
inserting error at 143, value  81
*/
