
/*

  Reed-Solomon demo

 */


#include <stdlib.h>
#include "../../src/libCOFDM/reedsolomon/rs_byte.c"
#include "rs.h"
#include "gfq.h"

void main(int argc,char **argv) {
  int gen=(256+128+4+2+1);
  int i,errs,j,t0,t1,t2,t3;
  int decodermistmatch=0,decoderfailures=0,decodererrors=0;
  WORD buffer[256*256];
  WORD msg[214];
  WORD buf[59];

  /* Init */
  printf("rs init\n");
  gfq_init(gen,buffer);
  printf("log(2)=%d\n",gfq_log(2));

  for(i=0;i<214;i++) msg[i]=i;
  rs_encode(msg,200,120,14,buf);
  
  /* some errors */
  printf("------------------------------\n");
  t0=(rand()*20.0/RAND_MAX);
  printf("run %d errors %d\n",j,t0);
  for(i=0;i<1;i++) {
    t1=(rand()*214.0/RAND_MAX);
    t2=(rand()*255.0/RAND_MAX);
    printf("inserting error at %3d, value %3d\n",t1,t2);
    msg[t1]=t2;
  }

  t3=rs_correct(msg,200,120,14,buf);
  errs=FALSE;
  for (i=0;i<200;i++) {
    if (msg[i]!=i) {
      errs=TRUE;
      printf("undetected error at %d\n",i);
      break;
    }
  }
  if (errs) printf("Message NOT corrected !!!\n");
  else printf("corrected\n");
  printf("------------------------------\n");
  if (t3==-1) decoderfailures++;
  if ((t3==-1) && (t0<8)) decodermistmatch++;
  if ((t3!=-1) && (errs)) decodererrors++;

  printf("decoder failures %d; decoder errors %d; mistmatch %d\n",
	 decoderfailures,decodererrors,decodermistmatch);
}

/* Analysis:
   10,000 cycles,
   1..100 errors: decoder failures 9158; decoder errors 6;
   1...20 errors: decoder failures 5859; decoder errors 1;
   1....7 errors: decoder failures 0; decoder errors 0;
*/


/* Interesting profile:
inserting error at  31, value 202
inserting error at  68, value 107
inserting error at  91, value 185
inserting error at 162, value 234
inserting error at   3, value 200
inserting error at  43, value 191
inserting error at 125, value 145
inserting error at  44, value  16
inserting error at 188, value 135
inserting error at 125, value 205
inserting error at 103, value 168
inserting error at 108, value 187
inserting error at 211, value 126
inserting error at 152, value  52
inserting error at 144, value 219
inserting error at   0, value 225
inserting error at 143, value  81
*/
