
/*


  checking the flow from differential modulation
  to frequency signal, by setting the differential symbol
  to zero

  */

#include "ofdm.h"

FFT_TYPE frqsymbol[2048*2];
WORD ddsymb[96+6];
extern BYTE ofdm_diffsymb[];

void main(void) {
  int i,q;

  mode_init(1);
  printf("-- clearing diffsymb --\n");
  for(i=0;i<96+6;i++) ofdm_diffsymb[i]=0;
  printf("-- setting ddsymb --\n");
  for(i=0;i<96+6;i++) ddsymb[i]=0;
  ddsymb[0]=0xffffffff;
  printf("-- calculating symbol --\n");
  ofdm_dqpsk(ddsymb,frqsymbol);
  printf("-- Next Symbol --\n");
  for(i=0;i<2048;i++) {
    printf("%d %7.4f + ( %7.4f *j)\n",i,frqsymbol[2*i],frqsymbol[2*i+1]);
  }
  printf("this sould equal phase %d\n",q);
}
  
