
#include <stdio.h>
#include "prbs.h"

/* the binary prbs sequence (first 100,last 31)
     000001111011111000101110011001000001001010011101
     101000111100111110011011000101010010001110001101
     1010 ...        10011010000111011110000111111111

     the bytewise prbs sequence from 1:511
     1...10:   7 190 46 100 18 157 163 207 155 21
    60...70: 219 52 59 195 254 15 124 92 200 37 59
   500..511: 57 210 122 234 36 51 133 237 154 29 225 255

   the hexadecimal prbs sequence
     1...10:  07 be 2e 64 12 9d a3 cf 9b 15
    60...70:  db 34 3b c3 fe 0f 7c 5c c8 25 3b
   500..511:  39 d2 7a ea 24 33 85 ed 9a 1d e1 ff

   */

WORD buf[511];

void main(int argc,char **argv) {
  int i,t,j;

  printf("prbs starting...\n");
  prbs_reset();
  printf("the binary prbs sequence\n");
  for (i=0;i<511;i++) {
    t=prbs_step1();
    printf("%d",t);
  }
  printf(" end of binary sequence\n");
  printf("the Word prbs sequence\n");
  prbs_init();
  for (i=0;i<511;i++) buf[i]=0;
  prbs_scramble(buf,511,0);
  for (i=0;i<102;i++) {
    for (j=0;j<5;j++) printf(" 0x%x,",buf[i*5+j]);
    printf("\n");
  }
  for (j=510;j<511;j++) printf(" 0x%x,",buf[j]);
  printf("\n");
  printf("len %d  off %d\n",14,1522);
  prbs_generate(buf,14,1522);
  for (i=0;i<14;i++) printf(" %8x",buf[i]);
  printf("\n");
}

/* load6x bench:
Interrupt to abort . . .
prbs starting...
the binary prbs sequence
0000011110111110001011100110010000010010100111011010001111001111100110110001010100100011100011011010101110001001100010001000000001000010001100001001110010101011000011011110100110111001000101000010101101001111110110010010010110111111001001101010011001100000001100011001010001101001011111110100010110001110101100101100111100011111011101000001101011011011101100000101101011111010101010000001010010101111001011101110000001110011101001001111010111010100010010000110011100001011110110110011010000111011110000111111111 end of binary sequence
the Word prbs sequence
1..10:   7be2e64 129da3cf 9b15238d ab898880 42309cab  de9b914 2b4fd925 bf26a660 3194697f 458eb2cf
 
60..70: 82d7d540 a5797703 9d27aea2 43385ed9 a1de1ff0 7be2e641 29da3cf9 b15238da b8988804 2309cab0 de9b9142
 
500..511: 21184e55 86f4dc8a 15a7ec92 df935330 18ca34bf a2c75967 8fba0d6d d82d7d54  a579770 39d27aea 243385ed 9a1de1ff
len 14  off 1522
 86f4dc8a 15a7ec92 df935330 18ca34bf a2c75967 8fba0d6d d82d7d54  a579770 39d27aea 243385ed 9a1de1ff  7be2e64 129da3cf 9b15238d
NORMAL COMPLETION: 1856796 cycles
*/
