
/*

  generates a list of primitiv polynomials
  from 'Error Control Systems'

  */

#define N 256
#include <stdio.h>

int i,n,xx;
char d[N];

void see() {
  for (i=n;i>=0;i--) printf("%c",d[i]+'0');
  printf("\n");
}

char s[N],t,j,f;
unsigned long c,max;

void visit () {
  for(i=0;i<n;i++) s[i]=1;
  c=0;
  
  do {
    c++;
    for(i=t=0;i<n;i++) t=(t^(s[i]&d[i]));
    for(i=0;i<n-1;i++) s[i]=s[i+1];
    s[n-1]=t;
    for (i=f=0;i<n;i++) {
      if (!s[i]) {
	f=1;
	break;
      }
    }
  } while (f);
  
  if (c==max) see();
}

void gp(l) char l; {
  if (!l) {
    visit();
  } else {
    d[l]=0;gp(l-1);
    d[l]=1;gp(l-1);
  }
}

void gc(l,rw) char l,rw; {
  char q;
  if (rw==2) { visit();return; }
  for(q=l;q>=rw-2;q--) {
    d[q]=1;gc(q-1,rw-1);d[q]=0;
  }
}

void main(int argc,char **argv) {
  int a,b;
  if (argc != 4) {
    printf("usage: %s <start-degree> <stop-degree> <weight>\n",argv[0]);
    exit(1);
  }
  a=atoi(argv[1]);
  b=atoi(argv[2]);
  c=atoi(argv[3]);
  if (b>N) {
    printf("sorry, max stopdegree is  %d. Change and compile!\n",N);
    exit(1);
  }

  printf("\n");
  for (n=a;n<=b;n++) {
    printf("length %d\n",n);
    for (xx=max=1;xx<=n;xx++) max=2*max;max--;
    d[n]=d[0]=1;
    gc(n-1,c);
    printf("\n");
  }
}
  
