
/*

  frame-control

  supervises frame-io via files and symbolgeneration
  
  this routine is not destined for final execution

  */

#include <stdio.h>
#include "eti.h"
#include "parameters.h"
#include "symcon.h"
#include "ofdm.h"
#include "profile.h"
#include "fft.h"
#include "print_eti.c"

#define FILE_END_ERROR 1
#define NO_ERROR 0

int eti_fetch(FILE *fdesc,WORD *ETIframe) {
  int i;
  WORD t;
  
  for(i=1;i<1537;i++) {
    t  = (fgetc(fdesc)<<24);
    t += (fgetc(fdesc)<<16);
    t += (fgetc(fdesc)<<8);
    t += (fgetc(fdesc));
    ETIframe[i]=t;
  }
  ETIframe[0]=ETIframe[1536];
  if (feof(fdesc)) {
    return(1);
  } else {
    return(0);
  }
}

void main(void) {
  int i;
  int error;
  int status;
  int symbolcount;
  int ficcount;
  int cifcount;
  int framecount;
  WORD eti[4][1537];      /* max 4 frames for mode 1 (for 1537 see etifetch) */
  FFT_TYPE timesymbol[5312]; /* max=null-symbol,mode-1,*2 */
  FFT_TYPE *frqsymbol;
  char *etiname="../../../data/test.eti";
  char *outname="../../../data/test.dabf";
  FILE *eti_fdesc,*outfile;

  error=0;
  symbolcount=0;
  cifcount=0;
  ficcount=0;
  framecount=0;

  outfile=fopen(outname,"w");
  eti_fdesc=fopen(etiname,"r");
  if (eti_fdesc==NULL) {
    printf("Error, can't open %s\n",etiname);
    exit(1);
  }
  /* sync hab ich noch nicht */
  printf("reading file: %s\n",etiname);
  printf("writing file: %s\n",outname);

  /* intro */
  eti_fetch(eti_fdesc,eti[0]);
  /* crc_check */
  mode_init(eti_MID(eti[0]));
  eti_sort_STC(eti[0]);
  time_config(eti[0]);
  frqsymbol=timesymbol+2*ProtIntervall;

  print_eti(eti[0]);
  for (i=1;i<NbrLogicFrames;i++) {
    error=eti_fetch(eti_fdesc,eti[i]);
    /* crc_check */
  }

  Null_symbol(timesymbol);
  symbolcount++;


  /* mainloop */
  while(!error) {

    
    /* generate frequency-symbol */
    if (symbolcount==0) {
      for (i=0;i<NbrLogicFrames;i++) {
	error=eti_fetch(eti_fdesc,eti[i]);
	/* crc_check */
	error=2;
      }
      framecount++;
      Null_symbol(timesymbol);
      symbolcount++;
    }
#ifdef COFDM_PROFILE
    prof_start(profile_symbol);
#endif
    if (symbolcount==1) {
      TFPR_Symbol(frqsymbol);
      symbolcount++;
      time_config(eti[0]); /* reconfiguration only on framephase 0 */
    } else if (symbolcount<SymbolsPerFIC+2) {
      printf("FIC calculation\n");
      ficcount+=FIC_symbol(eti[ficcount],eti[(ficcount+1)%NbrLogicFrames],frqsymbol);
      printf("FIC symbol %d,ficcount=%d\n",symbolcount,ficcount);
      symbolcount++;
    } else if (symbolcount==SymbolsPerFIC+2) {
      eti_sort_STC(eti[0]);
      printf("MST_calculation cifcount %d\n",cifcount);
      cifcount+=MST_symbol(eti[cifcount],frqsymbol);
      printf("MST symbol %d,cifcount=%d\n",symbolcount,cifcount);
      symbolcount++;
    } else if (symbolcount<SymbolsPerFrame) {
      printf("MST_calculation cifcount %d\n",cifcount);
      i=MST_symbol(eti[cifcount],frqsymbol);
      cifcount+=i;
      if (i>0) eti_sort_STC(eti[cifcount]);
      printf("MST symbol %d,cifcount=%d\n",symbolcount,cifcount);
      symbolcount++;
    } else {
      ficcount=0;
      cifcount=0;
      symbolcount=0;
    }
    

    /* write out */
    if (symbolcount==1) {
      /* Nullsymbol */
#ifdef COFDM_PROFILE
    prof_stop();
#endif
      fprintf(outfile,"--- NullSymbol, frame %d\n",framecount);
      for (i=0;i<NullSymbLen/2;i++) {
	fprintf(outfile,"%d %3.3f+%3.3fj\n",i,timesymbol[2*i],timesymbol[2*i+1]);
      }
    } else {
      /* generate timesymbol */
      ifft_r2(VirtualCarriers,frqsymbol);
      fftreversal_r2(VirtualBase,frqsymbol);
      ofdm_protintervall(timesymbol);
#ifdef COFDM_PROFILE
    prof_stop();
#endif

      fprintf(outfile,"--- Symbol %d, framecount %d\n",symbolcount-1,framecount);
      for (i=0;i<SymbolSize/2;i++) {
	fprintf(outfile,"%d %9.4f + ( %9.4f *j)\n",i,timesymbol[2*i],timesymbol[2*i+1]);
      }
    }
  }
  printf("framecon exit: %d\n",error);
  fclose(eti_fdesc);
  fclose(outfile);
}
