
/*


  frame-control

  works on fixed eti-frames - for benchmarking purposes

  */



#include "conf.h"
#include "eti.h"
#include "parameters.h"
#include "symcon.h"
#include "ofdm.h"
#include "profile.h"
#include "fft.h"
#include "fft_reversal.h"
#include "eti_frame.c"
#include "print_eti.c"

FFT_TYPE timesymbol[5312]; /* max=null-symbol,mode-1,*2 */

void main(void) {
  int i;
  int symbolcount;
  int ficcount;
  int cifcount;
  int framecount;
  int erroccured;
  WORD *eti[4];
  FFT_TYPE *frqsymbol;

  erroccured=0;
  cifcount=0;
  ficcount=0;
  framecount=0;

  /* sync hab ich noch nicht */
  eti[0]=eti_data1;
  eti[1]=eti_data2;
  eti[2]=eti_data3;
  eti[3]=eti_data4;
  printf("framebench starting...\n");
  
  /* crc_check */
  mode_init(1);
  frqsymbol=timesymbol+2*ProtIntervall;

  print_eti(eti[0]);

  i=eti_checkcrch(eti[0]);
  i+=eti_checkcrch(eti[1]);
  i+=eti_checkcrch(eti[2]);
  i+=eti_checkcrch(eti[3]);
  i+=eti_checkcrcm(eti[0]);
  i+=eti_checkcrcm(eti[1]);
  i+=eti_checkcrcm(eti[2]);
  i+=eti_checkcrcm(eti[3]);
  printf("CRC passed: %d (out of 8) \n",i);

  Null_symbol(timesymbol);
  symbolcount=1;

  prof_init();
  /* mainloop */
  while(!erroccured) {
#ifdef COFDM_PROFILE
    prof_start(profile_symbol);
#endif

    /* generate frequency-symbol */
    if (symbolcount==0) {
      /* eti-fetch */
      framecount++;
      if (framecount==10) erroccured=TRUE;
      Null_symbol(timesymbol);
      myprintf("Null symbol\n");
      symbolcount++;
    } else if (symbolcount==1) {
      TFPR_Symbol(frqsymbol);
      myprintf("TFPR symbol\n");
      symbolcount++;
    } else if (symbolcount<SymbolsPerFIC+2) {
      ficcount+=FIC_symbol(eti[ficcount],eti[(ficcount+1)%NbrLogicFrames],frqsymbol);
      myprintf("FIC symbol %d,ficcount=%d\n",symbolcount,ficcount);
      symbolcount++;
    } else if (symbolcount==SymbolsPerFIC+2) {
      eti_sort_STC(eti[0]);
      time_config(eti[0]);
      cifcount+=MST_symbol(eti[cifcount],frqsymbol);
      myprintf("MST symbol %d,cifcount=%d\n",symbolcount,cifcount);
      symbolcount++;
    } else if (symbolcount<SymbolsPerFrame) {
      if (symbolcount>10) erroccured=TRUE;
      i=MST_symbol(eti[cifcount],frqsymbol);
      cifcount+=i;
      if ((i>0) & (cifcount<4)) {
	eti_sort_STC(eti[cifcount]);
	time_config(eti[cifcount]);
      }
      myprintf("MST symbol %d,cifcount=%d\n",symbolcount,cifcount);
      symbolcount++;
    }
    /* generate timesymbol */
    if (symbolcount>1) {
      ifft_r2(VirtualCarriers,frqsymbol);
      fftreversal_r2(frqsymbol,VirtualBase);
      ofdm_protintervall(timesymbol);
    }
    if (symbolcount>=SymbolsPerFrame) {
      ficcount=0;
      cifcount=0;
      symbolcount=0;
    }
#ifdef COFDM_PROFILE
    prof_stop();
#endif
  }
#ifdef COFDM_PROFILE
  prof_printf();
#endif
  printf("framecon exit %d frames\n",framecount);
}
