
/*

  fft_demo

  int, 20bits used
  jede multilpikation vergroessert den fehler um +/- 1
  d.h. 200000 muls == 17.6 bits fehler
  alle FFT_MAX==2048 koeff multipliziert ergeben fehler von 10.3 Bit

  */

#include "values.h"
#include "fft_int20.h"
#include <time.h>

int testa[2*8]={ 1,0, 0,0, 1,0, 0,0, 0,0, 0,0, 0,0, 0,0 };
int testb[2*4096];

void main(int argc,char **argv) {
  int i,j,base,size,tmp,random;
  int maxr=0,maxi=0,minr=0,mini=0;
  double a,b;
  long start,stop;

  base=6;
  size=(1<<(base*2));
  /*  fft_init_int20();*/

  /* init */
  
  random=2*j;
  srand(random);
#define fft_real(x)  (1<<(i%19))
#define fft_imag(x)  (1<<(i%17))
  for(i=0;i<2*size;i+=2) {
    testb[i]=fft_real(i);
    testb[i+1]=fft_imag(i);
  }

#define FFT_PRINT
  fftmax=0;
  for (j=0;j<1;j++) {
#ifdef FFT_PRINT
  start=clock();
    random=2*j;
    srand(random);
    for(i=0;i<2*size;i+=2) {
      testb[i]=fft_real(i);
      testb[i+1]=fft_imag(i);
    }
    printf("input\n");
    for(i=0;i<16;i++) printf(" %8d + ( %8d *j )\n",testb[2*i],testb[2*i+1]);
#endif
    fft_radix4(testb,base);
#ifdef FFT_PRINT
    printf("fft\n");
    for(i=0;i<16;i++) printf(" %8d + ( %8d *j )\n",testb[2*i],testb[2*i+1]);
#endif
    ifft_radix4(testb,base);
#ifdef FFT_PRINT
    printf("ifft\n");
    for(i=0;i<16;i++) printf(" %8d + ( %8d *j )\n",testb[2*i],testb[2*i+1]);
    printf("fftmax*%10.7f\n",fftmax);
#endif
    srand(random);
#ifdef FFT_PRINT
    for(i=0;i<2*size;i+=2) {
      tmp=fft_real(i)/size-testb[i];
      if (tmp>maxr) maxr=tmp;
      if (tmp<minr) minr=tmp;
      tmp=fft_imag(i)/size-testb[i+1];
      if (tmp>maxi) maxi=tmp;
      if (tmp<mini) mini=tmp;
    }	
#endif
  }
#ifdef FFT_PRINT
  stop=clock();
  printf("stop-start %d\n",stop-start);
  printf("Max Errors: real=%d , imag=%d\n",maxr,maxi);
  printf("Min Errors: real=%d , imag=%d\n",minr,mini);
#endif
  exit(0);
}



