
/*

  fft_demo

  int, 30bits used
  fehler durch fft: 2048 werte, 10.7549bit => 1728 absolut, relativ 1.6e-6
  */

#include "fft_int30.h"

int testa[2*8]={ 1,0, 0,0, 1,0, 0,0, 0,0, 0,0, 0,0, 0,0 };
int testb[2*2048];

void main(int argc,char **argv) {
  int i,j,base,size,tmp;
  int maxr=0,maxi=0;

  printf("fft_init()\n");
  fft_init_int30();
  base=11;
  size=(1<<base);

  /* init */
  for(i=0;i<2*size;i+=2) {
    testb[i]=(1<<9);
    testb[i+1]=(1<<(i%30))-(1<<9);
  }


#define FFT_PRINT
#ifdef FFT_PRINT
  printf("input\n");
  for(i=0;i<10;i++) printf(" %10d + ( %10d *j )\n",testb[2*i],testb[2*i+1]);
#endif
  for (j=0;j<1;j++) {
    fft_int30(testb,base);
#ifdef FFT_PRINT
      printf("fft\n");
      for (i=0;i<10;i++) printf(" %10d + ( %10d *j )\n",testb[2*i],testb[2*i+1]);
#endif
    ifft_int30(testb,base);
#ifdef FFT_PRINT
      printf("ifft\n");
      for(i=0;i<10;i++) printf(" %10d + ( %10d *j )\n",testb[2*i],testb[2*i+1]);
      for(i=0;i<2*size;i+=2) {
	tmp=((1<<9))/2048-testb[i];
	if (abs(tmp)>abs(maxr)) maxr=tmp;
	tmp=((1<<(i%30))-(1<<9))/2048-testb[i+1];
	if (abs(tmp)>abs(maxi)) maxi=tmp;
      }
#endif
  }
#ifdef FFT_PRINT
  printf("Max absolut Error: real=%d , imag=%d\n",maxr,maxi);
#endif
  exit(0);
}

