
/*

  fft_demo

  int, 20bits used

  */

#include "values.h"
#include "fft_int20.h"

int testb[2*FFT_MAXSIZE];

void main(int argc,char **argv) {
  int i,j,base,size,tmp,random;
  int maxr=0,maxi=0,minr=0,mini=0;

  fft_init_int20();
  base=11;
  size=(1<<base);

  /* init */
  
  random=2*j;
  srand(random);
#define fft_real(x) (1<<(i%19))
#define fft_imag(x) (1<<(i%17))
  for(i=0;i<2*size;i+=2) {
    testb[i]=fft_real(i);
    testb[i+1]=fft_imag(i);
  }

#define FFT_PRINT
  fftmax=0;
#ifdef FFT_PRINT
  printf("input\n");
  for(i=0;i<16;i++) printf(" %8d + ( %8d *j )\n",testb[2*i],testb[2*i+1]);
#endif
  for (j=0;j<1;j++) {
    fft_int20(testb,base);
#ifdef FFT_PRINT
      printf("fft\n");
      for(i=0;i<16;i++) printf(" %8d + ( %8d *j )\n",testb[2*i],testb[2*i+1]);
#endif
      ifft_int20(testb,base);
#ifdef FFT_PRINT
      printf("ifft\n");
      for(i=0;i<16;i++) printf(" %8d + ( %8d *j )\n",testb[2*i],testb[2*i+1]);
      printf("fftmax*%10.7f\n",fftmax);
      srand(random);
      for(i=0;i<2*size;i+=2) {
	tmp=fft_real(i)/size-testb[i];
	if (tmp>maxr) maxr=tmp;
	if (tmp<minr) minr=tmp;
	tmp=fft_imag(i)/size-testb[i+1];
	if (tmp>maxi) maxi=tmp;
	if (tmp<mini) mini=tmp;
      }
#endif
  }
#ifdef FFT_PRINT
  printf("Max Errors: real=%d , imag=%d\n",maxr,maxi);
  printf("Min Errors: real=%d , imag=%d\n",minr,mini);
#endif
  exit(0);
}



