
/*

  fft_demo

  tcl-time (init + 10*fft-ifft) p166-linux
  int_15      : 2216884us 
  int_20      : 2219081us
  int_fast_20 :  524851us
  int_30      : 1341791us - well, no checks enabled
  float       :  958580us - oh,wow

  (init + 10*fft-ifft):
  int_20-2048        354579us
  int_20-4096        770000us (should be int20-2048 us*2*12/11)
  radix4-fasttwiddle 570000us
  radix4-512          54321us
  radix4-1024        133000us
  mixradix-2048      297000us
  mixradix-4096      620402us

  radix4-fasttwiddle 570000us
  ohne complex-conj  540000us
  ohne twiddle       300000us
  NUR twiddle        500000us
  ohne init()        500000us
  ohne reversal      460000us

  comparable
  -------------------------------------
  radix-2    256       51685us
  mixradix   256       47337us

  mixradix   512       81089us
  radix-2    512       88760us

  radix-2   2048      354579us
  mixradix  2048      301538us

  radix-2   4096      765519us
  mix int20 4096      630000us (optimized 570000)
  mix int15 4096               (optimized 590000 ??)
  mix int30 4096      940000us (optimized 876599)
  mix float 4096               (optimized 978251)
  mix doubl 4096               (optimized 970523)

  radix-2  16384     3531523us
  mixradix 16384     2936033us
-----------------------------------------------------------
  fftstep01       1311743us
  alt_fftstep01   1107148us - 20% speed-up

  calls per 2048 points fft complex_mul 8194
  percent of time complex_mul 43.86
                  bitreversal 12.28
		  fft_step0_1  5.26

  RAND_MAX=2147483647
  5000 random runs fftmax*1303660050.
  Max  Errors: real=3 , imag=9,Min  Errors: real=-9 , imag=-3

  */

#include <stdlib.h>
#include "values.h"
#include "fft_int15.h"

int testa[2*8]={ 1,0, 0,0, 1,0, 0,0, 0,0, 0,0, 0,0, 0,0 };
int testb[2*2048];

void main(int argc,char **argv) {
  int i,j,base,size,tmp,random;
  int maxr=0,maxi=0,minr=0,mini=0;

  printf("fft_init()\n");
  fft_init_int15();
  base=11;
  size=(1<<base);

  fftmax=0;
#define FFT_PRINT
  for (j=0;j<1;j++) {
    printf("run %d\n",j);
    random=2*j;
    srand(random);
    /* init */
#define fft_real(x) (((rand())%(1<<16))-(1<<15))
#define fft_imag(x) (((rand())%(1<<16))-(1<<15))
    for(i=0;i<2*size;i+=2) {
      testb[i]=fft_real(i);
      testb[i+1]=fft_imag(i);
    }
#ifdef FFT_PRINT
    printf("input\n");
    for(i=0;i<5;i++) printf(" %10d + ( %10d *j )\n",testb[2*i],testb[2*i+1]);
#endif

    fft_int15(testb,base);
#ifdef FFT_PRINT
      printf("fft\n");
      for(i=0;i<5;i++) printf(" %10d + ( %10d *j )\n",testb[2*i],testb[2*i+1]);
#endif
    ifft_int15(testb,base);
#ifdef FFT_PRINT
    printf("ifft\n");
    for(i=0;i<5;i++) printf(" %10d + ( %10d *j )\n",testb[2*i],testb[2*i+1]);
#endif
    srand(random);
    for(i=0;i<2*size;i+=2) {
      tmp=fft_real(i)/2048-testb[i];
      if (tmp>maxr) maxr=tmp;
      if (tmp<minr) minr=tmp;
      tmp=fft_imag(i)/2048-testb[i+1];
      if (tmp>maxi) maxi=tmp;
      if (tmp<mini) mini=tmp;
    }
  }
  printf("Max  Errors: real=%d , imag=%d\n",maxr,maxi);
  printf("Min  Errors: real=%d , imag=%d\n",minr,mini);
  printf("fftmax*%10.7f\n",fftmax);
  exit(0);
}
