
/*
  ETI-demuxer
  */

#include <stdio.h>

#include "conf.h"
#include "parameters.h"
#include "eti.h"
#include "print_eti.c"

char *ETIname="../data/test.eti";

WORD ETIframe[1538];
int offset=0;

void ETIfetch(void) {
  FILE *etif;
  int i;
  WORD tval;

  etif=fopen(ETIname,"rb");
  if (etif==NULL) {
    printf("ERROR opening %s\n",ETIname);
    exit(1);
  }
  for(i=0;i<offset;i++) {
    fgetc(etif);
  }
  for(i=1;i<1537;i++) {
    tval  = (fgetc(etif)<<24);
    tval += (fgetc(etif)<<16);
    tval += (fgetc(etif)<<8);
    tval += (fgetc(etif));
    ETIframe[i]=tval;
  }
  ETIframe[0]=ETIframe[1536];
  close(etif);
}

void main(int argc,char **argv) {
  int i,j;

  if ((argc<2) || (argc>3)) {
    printf("\nusage: %s <filename> [<offset>]\n",argv[0]);
    exit(1);
  }
  ETIname=argv[1];
  if (argc==3) {
    offset=atoi(argv[2]);
  }
  printf("File %s\n",ETIname);
  ETIfetch();
  crc_init();
  printf("True = %d\n",TRUE);
  printf("check crch: %d\n",eti_checkcrch(ETIframe));
  printf("check crcm: %d\n",eti_checkcrcm(ETIframe));
  mode_init(eti_MID(ETIframe));
  eti_sort_STC(ETIframe);
  print_eti(ETIframe);
  for(j=0;j<eti_NST(ETIframe);j++) {
    printf(" Stream %d first Data: ",j);
    for(i=0;i<4;i++) printf(" %8x",(eti_DATA(j))[i]);
    printf("\n");
  }

}
