
/*


  checking the flow from differential modulation
  to frequency signal, by comparing the TFPR_Symbol
  with the Signal generated with zeros as input.


  */

#include "conf.h"
#include "ofdm.h"
#include "fft.h"
#include "profile.h"

FFT_TYPE frqsymbol[2048*2];
WORD ddsymb[96+6];


void main(void) {
  int i;

  mode_init(1);
  prof_init();
  TFPR_Symbol(frqsymbol);
  printf("-- Anfang TFPR-symbol --\n");
  for(i=0;i<20;i++) {
    printf(" %7.4f + ( %7.4f *j)\n",frqsymbol[2*i],frqsymbol[2*i+1]);
  }
  printf("-- clearing ddsymb --\n");
  for(i=0;i<96;i++) ddsymb[i]=0xffffffff;
  printf("-- calculating symbol --\n");
  for (i=0;i<1;i++) ofdm_dqpsk(ddsymb,frqsymbol);
  printf("-- Next Symbol --\n");
  for(i=0;i<20;i++) {
    printf(" %7.4f + ( %7.4f *j)\n",frqsymbol[2*i],frqsymbol[2*i+1]);
  }
  printf("this sould equal TFPR_Symbol*exp(j*pi/4)\n");
  prof_printf();
}
  
