
/*
  
  CRC-Test
  Heiko Penschuck
  16.09.97

 */

#include <stdio.h>
#include "crc.h"
#include "../libCOFDM/crc/crc.c"

#define MSGLEN 34
/* last 2 Bytes are CRC! (0x7497) */
int msgbuf[]={
  0,135,12,64,8,116,76,72,32,0,76,72,12,
  232,76,72,17,92,76,72,21,208,76,72,
  26,68,76,72,30,184,76,96,0,0,   116,151
};
/* 
   Hexadezimal:

   00 87 0C 40   08 74 4C 48   20 00 4C 48
   0C E8 4C 48   11 5C 4C 48   15 D0 4C 48
   1A 44 4C 48   1E B8 4C 60   00 00 74 97
   */

void print_lookuptable() {
  int i,j;

  printf(" crc-lookup table\n");
  for (i=0;i<32;i++) {
    for(j=0;j<8;j++) {
      printf(" 0x%x,",crc_lookup[i*8+j]);
    }
    printf("\n");
  }
}

void main(int argc,char **argv) {
  int i,t;

  crc_init();
  if (argc>1) print_lookuptable();
  crc_initreg(0xFFFF);
  for(i=0;i<MSGLEN;i++) {
    crc_step8(msgbuf[i]);
  }
  t=crc_getreg();
  t^=0xffff;
  printf("\n Final value : 0x%4x << should be 7497\n",t);
  printf("(Final CRCreg: 0x%4x)\n",crc_getreg());
  printf("processing CRC... should be 0x1D0F\n");
  crc_step8(msgbuf[MSGLEN]);
  crc_step8(msgbuf[MSGLEN+1]);
  t=crc_getreg();
  printf("CRCreg: %4x\n",t);
}

/* load6x benchmark -o2 :

TMS320C6x C I/O COFF Loader      Version 1.00
Copyright (c) 1989-1997 Texas Instruments Incorporated
Interrupt to abort . . .
 
 Final value : 0x7497 << should be 7497
(Final CRCreg: 0x8b68)
processing CRC... should be 0x1D0F
CRCreg: 1d0f
NORMAL COMPLETION: 38556 cycles
*/
