
/*

  Symbol control Demo


  */

#include <stdio.h>
#include "conf.h"
#include "eti.h"
#include "timeint.h"
#include "tpl.h"
#include "parameters.h"
#include "symcon.h"
#include "ofdm.h"

#include "print_eti.c"

WORD eti[4][1538];
FFT_TYPE frqsymbol[2048*2];

int eti_fetch(FILE *fdesc,WORD *ETIframe) {
  int i;
  WORD t;
  
  for(i=1;i<1537;i++) {
    t  = (fgetc(fdesc)<<24);
    t += (fgetc(fdesc)<<16);
    t += (fgetc(fdesc)<<8);
    t += (fgetc(fdesc));
    ETIframe[i]=t;
  }
  ETIframe[0]=ETIframe[1536];
  if (feof(fdesc)) {
    return(1);
  } else {
    return(0);
  }
}

void main(int argc,char **argv) {
  FILE *eti_fdesc,*out;
  int i,j,ficcount,error;

  if (argc!=2) {
    printf("usage: %s <eti-NI-file>\n",argv[0]);
    exit(1);
  }
  eti_fdesc=fopen(argv[1],"r");
  if (eti_fdesc==NULL) {
    printf("Error, can't open %s\n",argv[1]);
    exit(1);
  }
  printf("reading file: %s\n",argv[1]);
  printf("writing file: test.FIC\n");
  eti_fetch(eti_fdesc,eti[0]);

  mode_init(eti_MID(eti[0]));
  eti_sort_STC(eti[0]);
  time_config(eti[0]);
  for (i=1;i<NbrLogicFrames;i++) {
    error=eti_fetch(eti_fdesc,eti[i]);
    /* crc_check */
    eti_sort_STC(eti[i]);
  }
  print_eti(eti[0]);

  out=fopen("test.FIC","w");
  ficcount=0;
  for(i=0;i<SymbolsPerFIC;i++) {
    ficcount+=FIC_symbol(eti[ficcount],eti[(ficcount+1)%NbrLogicFrames],frqsymbol);
    printf("symbol %d ficcount %d\n",i,ficcount);
    for(j=0;j<WordsPerDSymb;j++) fprintf(out,"%3d %3d   %8x\n",i,j,dsymb[j]);
  }
  fclose(out);

}
