
/*

  Symbol control Demo


  */

#include <stdio.h>

#include "eti.h"
#include "timeint.h"
#include "tpl.h"
#include "parameters.h"
#include "symcon.h"
#include "ofdm.h"

#include "print_eti.c"

WORD ETIframe[1538];
FFT_TYPE frqsymbol[2048*2];

int eti_fetch(FILE *fdesc,WORD *ETIframe) {
  int i;
  WORD t;
  
  for(i=1;i<1537;i++) {
    t  = (fgetc(fdesc)<<24);
    t += (fgetc(fdesc)<<16);
    t += (fgetc(fdesc)<<8);
    t += (fgetc(fdesc));
    ETIframe[i]=t;
  }
  ETIframe[0]=ETIframe[1536];
  if (feof(fdesc)) {
    return(1);
  } else {
    return(0);
  }
}

void main(int argc,char **argv) {
  WORD *eti,*ptr,tmp;
  FILE *out,*eti_fdesc;
  int i,j,k,a;

  if (argc!=2) {
    printf("usage: %s <eti-NI-file>\n",argv[0]);
    exit(1);
  }
  eti_fdesc=fopen(argv[1],"r");
  if (eti_fdesc==NULL) {
    printf("Error, can't open %s\n",argv[1]);
    exit(1);
  }
  if (eti_fetch(eti_fdesc,ETIframe)==1) {
    printf("can't read %s\n",argv[0]);
    exit(1);
  }
  printf("reading file: %s\n",argv[1]);
  printf("writing file: test.CIF\n");
  eti=ETIframe;
  print_eti(eti);
  mode_init(eti_MID(eti));
  eti_sort_STC(eti);
  time_config(eti);

  out=fopen("test.CIF","w");
  for(i=0;i<SymbolsPerCIF;i++) {
    MST_symbol(ETIframe,frqsymbol);
    fprintf(out,"-bit symbol %d-\n",i);
    for(j=0;j<WordsPerDSymb;j++) {
      tmp=dsymb[j];
      fprintf(out,"j%d %8x  ",j,tmp);
      for(k=0;k<32;k++) {
	a=((tmp&0x80000000)>0);
	fprintf(out,"%d;",a);
	tmp<<=1;
      }
      fprintf(out,"\n");
    }
  }
  fclose(out);

}
