
/* some useful funcs
 */

#include <stdio.h>
#include "parameters.h"
#include "eti.h"

int eti_fetch(FILE *fdesc,WORD *ETIframe) {
  int i;
  WORD t;
  
  for(i=1;i<1537;i++) {
    t  = (fgetc(fdesc)<<24);
    t += (fgetc(fdesc)<<16);
    t += (fgetc(fdesc)<<8);
    t += (fgetc(fdesc));
    ETIframe[i]=t;
  }
  ETIframe[0]=ETIframe[1536];
  if (feof(fdesc)) {
    return(1);
  } else {
    return(0);
  }
}

void print_eti(WORD *eti) {
  int i,j;

  printf("\n ERR %2x , Sync %4x\n",eti_ERR(eti),eti_FSYNC(eti));
  printf(" FCT %3d , FICF %d , FicSize %d , NST %2d , FP %d , FL %4d , MID %d\n",
	 eti_FCT(eti),eti_FICF(eti),FicSize,eti_NST(eti),eti_FP(eti),
	 eti_FL(eti),eti_MID(eti));
  printf("\n        Raw Stream Characterisation\n");
  printf(" id  ");
  for(i=0;i<eti_NST(eti);i++) {
    printf(" %4d",eti_u_SCID(eti,i));
  }
  printf("\n");
  printf(" sad ");
  for(i=0;i<eti_NST(eti);i++) {
    printf(" %4d",eti_u_SAD(eti,i));
  }
  printf("\n");
  printf(" TPL ");
  for(i=0;i<eti_NST(eti);i++) {
    printf(" %4d",eti_u_TPL(eti,i));
  }
  printf("\n");
  printf(" STL ");
  for(i=0;i<eti_NST(eti);i++) {
    printf(" %4d",eti_u_STL(eti,i));
  }
  printf("\n");
  printf("\n      Sorted Stream Characterisation\n");
  printf(" id  ");
  for(i=0;i<eti_NST(eti);i++) {
    printf(" %4d",eti_SCID(i));
  }
  printf("\n");
  printf(" sad ");
  for(i=0;i<eti_NST(eti);i++) {
    printf(" %4d",eti_SAD(i));
  }
  printf("\n");
  printf(" TPL ");
  for(i=0;i<eti_NST(eti);i++) {
    printf(" %4d",eti_TPL(i));
  }
  printf("\n");
  printf(" STL ");
  for(i=0;i<eti_NST(eti);i++) {
    printf(" %4d",eti_STL(i));
  }
  printf("\n");
  printf(" DATA");
  for(i=0;i<eti_NST(eti);i++) {
    printf(" %4d",(eti_DOFFSET(i)));
  }
  printf("\n\n");
  printf(" MNSC %4x , CRCH %4x , CRCM %4x , Rfu %4x , TIST %8x\n",
	 eti_MNSC(eti),eti_CRCH(eti),eti_CRCM(eti),eti_Rfu(eti),eti_TIST(eti));
  printf("\n");
}
