

/*


  cofdm-c server, which does output on demand
  communication via FIFO: message_in
  dataout is specified with messages. theres no message-feedback-channel.
  and a set of specified messages

  
  */

#include <stdio.h>
#include <string.h>
#include "cofdm_server.h"
#include "cofdm_messag.h"


interp_errno cmd_help(int argc,char **argv);

/* variables */

typedef interp_errno (*cmdcall)(int argc,char **argv);

typedef struct _cmdentry {
  char *name;
  cmdcall func;
} cmdentry;


cmdentry cmdarray[]={
  { "test",cmd_test },
  { "exit",cmd_kill },
  { "quit",cmd_kill },
  { "help",cmd_help },
  { "?",cmd_help },
  { "reset",cofdm_reset },
  { "stat",cofdm_stat },
  { "etiprint",cofdm_printeti },
  { "etiopen",cofdm_etiopen },
  { "outopen",cofdm_outopen },
  { "etifetch",cofdm_etifetch },
  { "modeset",cofdm_modeset },
  { "modeeti",cofdm_modeeti },
  { "etisort",cofdm_etisort },
  { "timeconfig",cofdm_timeconfig },
  { "crch",cofdm_crch },
  { "crcm",cofdm_crcm },
  { "nullsymbol",cofdm_nullsymbol },
  { "tiisymbol",cofdm_tiisymbol },
  { "tfprsymbol",cofdm_tfprsymbol },
  { "ficsymbol",cofdm_ficsymbol },
  { "cifsymbol",cofdm_cifsymbol },
  { "nextsymbol",cofdm_nextsymbol },
  { "protinter",cofdm_protinter },
  { "write",cofdm_write },
  { "writefrq",cofdm_writefrq },
  { "writedsymb",cofdm_writedsymb },
  { "fft",cofdm_fft },
  { "fillfft",cofdm_fillfft },
  { "ifft",cofdm_ifft },
  { "systpl",cofdm_systpl },
  { "syssym",cofdm_syssym },
  { "sysprbs",cofdm_sysprbs },
  { "sysgfq",cofdm_sysgfq },
  { "sysfft",cofdm_sysfft },
  { "syscrc",cofdm_syscrc },
  { "sysmode",cofdm_sysmode },
  { "systime",cofdm_systime },
  { "sysCC",cofdm_sysCC }
};

char *(margv[CSERV_MAXARGS]);

/* functions */

int tokenizer(char *msg) {
  int i,margc,stat,len;

  stat=0;margc=0;
  len=strlen(msg);
  for (i=0;i<len;i++) {
    if ((msg[i]==' ')||(msg[i]=='\n')) {
      msg[i]='\0';
      if (stat==1) {
	margc++;
	stat=0;
      }
    } else {
      if (stat==0) {
	margv[margc]=msg+i;
	stat=1;
      }
    }
    /* here should be some kind of errormsg ? */
    if (margc==CSERV_MAXARGS) break;
  }
  return(margc);
}

interp_errno cmd_help(int argc,char **argv) {
  int i;
  if (argc>1) {
    printf("Usage: help\n");
    sprintf(interperrmsg,"Error: too many args\n");
    return(ERR);
  }
  for (i=0;i<cmdnumber;i++) {
    printf("%d    %s\n",i,cmdarray[i].name);
  }
  return(OK);
}

void interp(char *input) {
  int i,margc;

  margc=tokenizer(input);
  if (margc==0) {
    printf("Parse error: No command\n");
    return;
  }
  if (strlen(margv[0])<1) {
    printf("Parse error: Command too short, min 1 chars required\n");
    return;
  }
  interperror=UNKNOWN;
  sprintf(interperrmsg,"Unknown command");
  i=0;
  while(i<cmdnumber) {
    if (strncmp(cmdarray[i].name,margv[0],strlen(margv[0]))==0) {
      sprintf(interperrmsg,"OK");
      interperror=OK;
      margv[0]=cmdarray[i].name;
      interperror=cmdarray[i].func(margc,margv);
      break;
    }
    i++;
  }
  printf("Msg%d> %s\n",interperror,interperrmsg);
}

void main(int argc,char **argv) {
  FILE *msgin,*msgout;
  char msg[1000]="";
  int c;

  if (argc != 2) {
    printf("Error: wrong args. Should be: %s [File: message_in]\n",argv[0]);
    exit(1);
  }
  
  cmdnumber=(sizeof(cmdarray)/sizeof(cmdentry));
  interperror=OK;
  cofdm_reset(0,NULL);
  printf("registered commands: %d\n",cmdnumber);

  while(!(interperror==QUIT)) {
    printf("check for clients\n");
    printf("please connect to %s\n",argv[1]);
    msgin=fopen(argv[1],"r");
    if (msgin==NULL) {
      printf("Error opening msgin=%s\n",argv[1]);
      exit(1);
    }
    printf("server is listening\n");
    while((!feof(msgin))&&!(interperror==QUIT)) {
      fgets(msg,1000,msgin);
      if (!feof(msgin)) {
	interp(msg);
      }
    }
    printf("received EOF\n");
    fclose(msgin);
  }
  printf("server going down\n");
  exit(0);
}

