
/*


  this file contains all msg-handlers for
  framecheck_server. to run a new message,
  the associated command names plus the function-pointer
  must be registered by the server.



  */

#include <stdio.h>
#include "cofdm_server.h"
#include "cofdm_messag.h"
#include "eti.h"
#include "parameters.h"
#include "symcon.h"
#include "ofdm.h"
#include "crc.h"
#include "fft.h"
#include "fft_reversal.h"
#include "gfq.h"
#include "tpl.h"
#include "prbs.h"
#include "timeint.h"
#include "symcon.h"

#include "print_eti.c"

typedef enum _cofdm_errno {
  READY,NOETI,WRONGETI,COFDMERR
} cofdm_errno;

cofdm_errno cofdm_error;
WORD eti[4][1537];
FFT_TYPE timesymbol[5312];
FFT_TYPE *frqsymbol;
char etiname[500];
char outname[500];
FILE *etifile;
FILE *outfile;
int etiframecount;
int dabframecount;
int symbolcount;
int ficcount;
int cifcount;

int eti_fetch(FILE *fdesc,WORD *ETIframe) {
  int i;
  WORD t;
  
  for(i=1;i<1537;i++) {
    t  = (fgetc(fdesc)<<24);
    t += (fgetc(fdesc)<<16);
    t += (fgetc(fdesc)<<8);
    t += (fgetc(fdesc));
    ETIframe[i]=t;
  }
  ETIframe[0]=ETIframe[1536];
  if (feof(fdesc)) {
    return(1);
  } else {
    return(0);
  }
}

interp_errno cofdm_reset(int argc,char **argv) {
  if (etifile!=NULL) fclose(etifile);
  if (outfile!=NULL) fclose(outfile);
  etifile=NULL;
  outfile=NULL;
  cofdm_error=NOETI;
  etiframecount=0;
  dabframecount=0;
  symbolcount=0;
  cifcount=0;
  ficcount=0;
  DABMode=0;
  return(OK);
}

interp_errno cmd_kill(int argc,char **argv) {
  printf("server going down\n");
  return(QUIT);
}

interp_errno cmd_test(int argc,char **argv) {
  int i;
  printf("\ncmd 0 %s     argc%d\n",argv[0],argc);
  for (i=1;i<argc;i++) {
    printf("param%d %s\n",i,argv[i]);
  }
  printf("parser ok\n");
  sprintf(interperrmsg,"Interpreter ok");
  return(TEST);
}

interp_errno cofdm_stat(int argc,char **argv) {
  if (cofdm_error==READY) {
    printf(" COFDM-READY\n");
    if (etifile!=NULL) {
      printf(" used input %s\n",etiname);
      printf(" eti ferror :%d\n",ferror(etifile));
      printf(" eti feof :%d\n",feof(etifile));
    } else printf(" NO ETI (internal status error), run etiopen\n");
    if (outfile!=NULL) {
      printf(" used output %s\n",outname);
      printf(" out ferror :%d\n",ferror(outfile));
      printf(" out feof :%d\n",feof(outfile));
    } else printf(" NO OUTPUT, run outopen\n");
    if (DABMode>0) {
      printf(" using DAB mode   %d\n",DABMode);
      printf(" current etiframe %d\n",etiframecount);
      printf(" current dabframe %d\n",dabframecount);
      printf("         cifcount %d\n",cifcount);
      printf("         ficcount %d\n",ficcount);
      printf(" next symbol      %d\n",symbolcount);
    } else printf(" NO DAB-MODE, run modeset/modeeti\n");
  } else if (cofdm_error==NOETI) {
    printf(" NO-ETI-SOURCE, run etiopen\n");
  } else {
    printf(" COFDM-ERROR: %d\n",cofdm_error);
  }
  return(OK);
}

interp_errno cofdm_sysmode(int argc,char **argv) {
  printf("-- ModeInit ----------\n");
  printf(" DAB Mode           %d [1..4]\n",DABMode);
  printf(" SymbolSize         %d complex samples\n",SymbolSize);
  printf(" Comb               %d\n",Comb);
  printf(" Pattern            %d\n",Pattern);
  printf(" CarrierNbr         %d\n",CarrierNbr);
  printf(" ProtIntervall      %d complex samples\n",ProtIntervall);
  printf(" VirtualCarriers    %d\n",VirtualCarriers);
  printf(" VirtualBase        %d\n",VirtualBase);
  printf(" FicSize            %d words\n",FicSize);
  printf(" NullSymbLen        %d complex samples\n",NullSymbLen);
  printf(" NbrLogicFrames     %d\n",NbrLogicFrames);
  printf(" WordsPerDSymb      %d words\n",WordsPerDSymb);
  printf(" SymbolsPerCIF      %d\n",SymbolsPerCIF);
  printf(" SymbolsPerFIC      %d\n",SymbolsPerFIC);
  printf(" SymbolsPerFrame    %d\n",SymbolsPerFrame);
  return(OK);
}

interp_errno cofdm_syscrc(int argc,char **argv) {
  printf(" CRC-Register %d\n",crc_getreg);
  return(OK);
}

interp_errno cofdm_sysfft(int argc,char **argv) {
  printf(" FFT-MaxSize %d\n",FFT_MAXSIZE);
#ifdef FFT_FLOAT
  printf(" FFT-Float, bits %d\n",8*sizeof(FFT_TYPE));
#endif
#ifdef FFT_INT20
  printf(" FFT-INT20\n");
#endif
#ifdef FFT_INT15
  printf(" FFT-INT15\n");
#endif
#ifdef FFT_INT30
  printf(" FFT-INT30\n");
#endif
  return(OK);
}

interp_errno cofdm_sysgfq(int argc,char **argv) {
  printf("-- Galois Field ----\n");
  printf("gfq_n %d\n",gfq_n);
  printf("alpha %d\n",expotab(0));
  return(OK);
}

interp_errno cofdm_sysprbs(int argc,char **argv) {
  printf("-- Pseudo Random Binary Sequence --\n");
  printf("--      (energy dispersal)       --\n");
  printf(" PRBS start= (HEX) %8x %8x %8x %8x\n",prbs_32(0),prbs_32(1),prbs_32(2),prbs_32(3));
  return(OK);
}

interp_errno cofdm_syssym(int argc,char **argv) {
  printf("-- Symbol Control --\n");
  printf(" CIFSIZE %d\n",CIFSIZE);
  return(OK);
}

interp_errno cofdm_systpl(int argc,char **argv) {
  printf("-- Type and Protectionlevel --\n");
  printf(" L  %d %d %d %d\n",Profil.L[0],Profil.L[1],Profil.L[2],Profil.L[3]);
  printf(" PrI %d %d %d %d\n",Profil.PrI[0],Profil.PrI[1],Profil.PrI[2],Profil.PrI[3]);
  printf(" SCS %d\n",Profil.SCS);
  return(OK);
}

interp_errno cofdm_systime(int argc,char **argv) {
  int i,j;
  printf("--     Time interl. IC-table     --\n");
  printf("(last entry (idx 865) always zero!)\n");
  for (i=0;i<86;i++) {
    for (j=0;j<10;j++) {
      printf(" %3d(%3d)",i*10+j,OldMapping[i*10+j]);
    }
    printf("\n");
  }
  for (j=0;j<5;j++) printf(" %3d(%3d)",i*10+j,OldMapping[i*10+j]);
  printf("\n");
  return(OK);
}

interp_errno cofdm_sysCC(int argc,char **argv) {
  int i,id;
  printf("-- Time Interl. Channel Characterisation --\n");
  printf("       (using ETI[0] NST: %d)\n",eti_NST(eti[0]));
  printf(" (make sure, you called eti_sort_STC before)\n");
  for (i=0;i<eti_NST(eti[0]);i++) {
    id=eti_SCID(i);
    printf(" %3d ID(%2d)OldSAD(%3d) NewSCS(%3d) OldSCS(%3d)\n",i,id,
	   OldSAD(id),NewSCS(id),OldSCS(id));
  }
}

interp_errno cofdm_etiopen(int argc,char **argv) {
  if (argc!=2) {
    printf("Usage: %s <filename>\n",argv[0]);
    return(ERR);
  }
  if (etifile!=NULL) {
    printf("Error: etifile already in use\n");
    return(ERR);
  }
  strcpy(etiname,argv[1]);
  if ((etifile=fopen(etiname,"r"))==NULL) {
    printf("Error: can't open %s\n",etiname);
    return(ERR);
  }
  cofdm_error=READY;
  return(OK);
}

interp_errno cofdm_outopen(int argc,char **argv) {
  if (argc!=2) {
    printf("Usage: %s <filename>\n",argv[0]);
    return(ERR);
  }
  if (outfile!=NULL) {
    printf("Error: outfile already in use\n");
    return(ERR);
  }
  strcpy(outname,argv[1]);
  printf("opening %s\n",outname);
  outfile=fopen(outname,"w+");
  if (outfile==NULL) {printf("Error: can't open %s\n",outname);return(ERR); }
  return(OK);
}

interp_errno cofdm_etifetch(int argc,char **argv) {
  int etino=-1,stat=0;
  if (argc!=2) {
    printf("Usage: %s <etino>\n",argv[0]);
    return(ERR);
  }
  etino=atoi(argv[1]);
  if ((etino<0)|| (etino>3)) {
    printf("Error: etino out of range (0..3)\n");
    return(ERR);
  }
  stat=eti_fetch(etifile,eti[etino]);
  if (stat!=0) {
    printf("An error occured! Use: stat\n");
  }
  return(OK);
}

interp_errno cofdm_printeti(int argc,char **argv) {
  int etino=-1;
  if (argc!=2) { printf("Usage: %s <etino>\n",argv[0]);return(ERR); }
  etino=atoi(argv[1]);
  if ((etino<0)|| (etino>3)) {
    printf("Error: etino out of range (0..3)\n");
    return(ERR);
  }
  print_eti(eti[etino]);
  return(OK);
}

interp_errno cofdm_modeset(int argc,char **argv) {
  int mod;
  if (argc!=2) { printf("Usage: %s <mode:[1..4]>\n",argv[0]); return(ERR); }
  mod=atoi(argv[1]);
  if ((mod<1)||(mod>4)) {
    printf("Error: DAB mode out of range:%d, valid 1..4\n",mod);
    return(ERR);
  }
  mode_init(mod);
  frqsymbol=timesymbol+2*ProtIntervall;
  return(OK);
}

interp_errno cofdm_modeeti(int argc,char **argv) {
  printf("Using eti[0], mode is %d\n",eti_MID(eti[0]));
  mode_init(eti_MID(eti[0]));
  frqsymbol=timesymbol+2*ProtIntervall;
  return(OK);
}

interp_errno cofdm_etisort(int argc,char **argv) {
  int etino;
  if (argc!=2) { printf("Usage:%s <etino>\n",argv[0]);return(ERR); }
  etino=atoi(argv[1]);
  if ((etino<0)|| (etino>3)) {
    printf("Error: etino out of range (0..3)\n");
    return(ERR);
  }
  eti_sort_STC(eti[etino]);
  return(OK);
}

interp_errno cofdm_timeconfig(int argc,char **argv) {
  int etino;
  if (argc!=2) { printf("Usage:%s <etino>\n",argv[0]);return(ERR); }
  etino=atoi(argv[1]);
  if ((etino<0)|| (etino>3)) {
    printf("Error: etino out of range (0..3)\n");
    return(ERR);
  }
  time_config(eti[etino]);
  return(OK);
}

interp_errno cofdm_crch(int argc,char **argv) {
  int etino;
  if (argc!=2) { printf("Usage:%s <etino>\n",argv[0]);return(ERR); }
  etino=atoi(argv[1]);
  if ((etino<0)|| (etino>3)) {
    printf("Error: etino out of range (0..3)\n");
    return(ERR);
  }
  if (eti_checkcrch(eti[etino])==TRUE) {
    printf("CRCH is ok\n");
  } else {
    printf("CRCH is wrong %d\n",eti_checkcrch(eti[etino]));
  }
  return(OK);
}

interp_errno cofdm_crcm(int argc,char **argv) {
  int etino;
  if (argc!=2) { printf("Usage:%s <etino>\n",argv[0]);return(ERR); }
  etino=atoi(argv[1]);
  if ((etino<0)|| (etino>3)) {
    printf("Error: etino out of range (0..3)\n");
    return(ERR);
  }
  if (eti_checkcrcm(eti[etino])==TRUE) {
    printf("CRCM is ok\n");
  } else {
    printf("CRCM is wrong\n");
  }
  return(OK);
}

interp_errno cofdm_nullsymbol(int argc,char **argv) {
  Null_symbol(timesymbol);
  return(OK);
}

interp_errno cofdm_tiisymbol(int argc,char **argv) {
  int comb,pattern;
  if (argc!=3) { printf("Usage:%s <comb> <pattern>\n",argv[0]);return(ERR); }
  comb=atoi(argv[1]);
  pattern=atoi(argv[2]);
  TII_symbol(comb,pattern,frqsymbol);
  return(OK);
}

interp_errno cofdm_tfprsymbol(int argc,char **argv) {
  TFPR_Symbol(frqsymbol);
  return(OK);
}

interp_errno cofdm_ficsymbol(int argc,char **argv) {
  int etino,etic;
  if (argc!=2) {printf("Usage: %s <etino>\n",argv[0]);return(ERR); }
  etino=atoi(argv[1]);
  if ((etino<0)|| (etino>3)) {
    printf("Error: etino out of range (0..3)\n");
    return(ERR);
  }
  etic=FIC_symbol(eti[etino],eti[(etino+1)%NbrLogicFrames],frqsymbol); 
  printf("eticount+=%d\n",etic);
  return(OK);
}

interp_errno cofdm_cifsymbol(int argc,char **argv) {
  int etino,cifc;
  if (argc!=2) { printf("Usage:%s <etino>\n",argv[0]);return(ERR); }
  etino=atoi(argv[1]);
  if ((etino<0)|| (etino>3)) {
    printf("Error: etino out of range (0..3)\n");
    return(ERR);
  }
  eti_sort_STC(eti[etino]);
  cifc=MST_symbol(eti[etino],frqsymbol);
  printf("cifc+=%d\n",cifc);
  return(OK);
}

interp_errno cofdm_nextsymbol(int argc,char **argv) {
  int i,error;
  if (symbolcount==0) {
    printf("Nullsymbol\n");
    for (i=0;i<NbrLogicFrames;i++) {
      error=eti_fetch(etifile,eti[i]);
      etiframecount++;
    }
    if (error!=0) { printf("Error during read!\n");return(ERR); };
    dabframecount++;
    Null_symbol(timesymbol);
    symbolcount++;
  } else if (symbolcount==1) {
    TFPR_Symbol(frqsymbol);
    printf("TFPR symbol\n");
    symbolcount++;
  } else if (symbolcount<SymbolsPerFIC+2) {
    ficcount+=FIC_symbol(eti[ficcount],eti[(ficcount+1)%NbrLogicFrames],frqsymbol);
    printf("FIC symbol %d, ficcount=%d\n",symbolcount,ficcount);
    symbolcount++;
  } else if (symbolcount==SymbolsPerFIC+2) {
    eti_sort_STC(eti[0]);
    time_config(eti[0]);
    cifcount+=MST_symbol(eti[cifcount],frqsymbol);
    printf("MST symbol %d, cifcount %d\n",symbolcount,cifcount);
    symbolcount++;
  } else if (symbolcount<SymbolsPerFrame) {
    i=MST_symbol(eti[cifcount],frqsymbol);
    cifcount+=i;
    symbolcount++;
    if ((i>0) & (symbolcount<SymbolsPerFrame)) {
      eti_sort_STC(eti[cifcount]);
      time_config(eti[cifcount]);
    }
    printf("MST symbol %d, cifcount=%d\n",symbolcount,cifcount);
  } else {
    ficcount=0;
    cifcount=0;
    symbolcount=0;
    cofdm_nextsymbol(argc,argv); /* recursion! */
  }
  return(OK);
}

interp_errno cofdm_protinter(int argc,char **argv) {
  ofdm_protintervall(timesymbol);
  return(OK);
}

interp_errno cofdm_write(int argc,char **argv) {
  int requested,received,err;
  if (argc!=2) {printf("Usage: %s <number>\n",argv[0]);return(ERR); }
  requested=atoi(argv[1]);
  if ((requested<1)|| (requested>NullSymbLen)) {
    printf("Error: number out of range (1..%d)\n",NullSymbLen);
    return(ERR);
  }
  received=fwrite(timesymbol,sizeof(*timesymbol),requested,outfile);
  if (received<requested) {
    printf("An error occured during writing!\n Only %d of %d words written\n",received,requested);
    return(ERR);
  }
  fflush(outfile);
  printf("write %d x %d Bytes complete\n",received,sizeof(*timesymbol));
  return(OK);
}

interp_errno cofdm_writedsymb(int argc,char **argv) {
  int requested,received,err;

  if (argc!=2) {printf("Usage: %s <number>\n",argv[0]);return(ERR); }
  requested=atoi(argv[1]);
  if ((requested<1)|| (requested>(WordsPerDSymb+6)*4)) {
    printf("Error: number out of range (1..%d)\n",(WordsPerDSymb+6)*4);
    return(ERR);
  }
  /* Warning! Byte order depends on the Endian of your mashine! */
  received=fwrite(dsymb,1,requested,outfile);
  if (received<requested) {
    printf("An error occured during writing!\n Only %d of %d words written\n",received,requested);
    return(ERR);
  }
  fflush(outfile);
  printf("writedsymb %d complete\n",received);
  return(OK);
}

interp_errno cofdm_writefrq(int argc,char **argv) {
  int requested,received,err,samples;
  samples=VirtualCarriers*2;
  if (argc!=2) {printf("Usage: %s <number>\n",argv[0]);return(ERR); }
  requested=atoi(argv[1]);
  if ((requested<1)|| (requested>samples)) {
    printf("Error: number out of range (1..%d)\n",samples);
    return(ERR);
  }
  received=fwrite(frqsymbol,sizeof(*frqsymbol),requested,outfile);
  if (received<requested) {
    printf("An error occured during writing!\n Only %d of %d words written\n",received,requested);
    return(ERR);
  }
  fflush(outfile);
  printf("writefrq %d x %d Bytes complete\n",received,sizeof(*frqsymbol));
  return(OK);
}

interp_errno cofdm_fft(int argc,char **argv) {
  fft_r2(VirtualCarriers,frqsymbol);
  fftreversal_r2(frqsymbol,VirtualBase);
  printf("fft carriers %d, base %d\n",VirtualCarriers,VirtualBase);
  return(OK);
}

interp_errno cofdm_fillfft(int argc,char **argv) {
  int i;
  for (i=0;i<2*VirtualCarriers;i++) {
    frqsymbol[i]=0;
  }
  frqsymbol[2]=1024;
  printf("Carrier 2 set to 1024\n");
  return(OK);
}

interp_errno cofdm_ifft(int argc,char **argv) {
  ifft_r2(VirtualCarriers,frqsymbol);
  fftreversal_r2(frqsymbol,VirtualBase);
  printf("ifft carriers %d, base %d\n",VirtualCarriers,VirtualBase);
  return(OK);
}

