


/*
  
  
  Procedures for configuring the Time Interleaver

  (make sure eti_sort_STC is called before)

  */

#include "timeint.h"
#include "eti.h"
#include "tpl.h"
#include "profile.h"

#define cleared 999
int RECONF=0;
#ifdef ARCHC6X
far SHORT OldMapping[865];
far SHORT newmapping[865];
#else
SHORT OldMapping[865];
SHORT newmapping[865];
#endif

void time_init(void) {
  int i;

  RECONF=0;
  for(i=0;i<15*864;i++) ICArray[i]=0;
  for(i=0;i<864;i++) OldMapping[i]=i;
  for(i=0;i<64;i++) CC[i]=0;
  OldMapping[864]=0; /* stop-value for search through OldMapping */
}

/* 
   this routine checks and performs reconfigurations
   It is called once per ETI-frame
   */
void time_config(WORD *etiframe) {
  int i,j,idx,newsad,newscs,oldsad,oldscs,nst;

#ifdef COFDM_PROFILE
  prof_start(profile_timeconfig);
#endif
  
  if (RECONF>0) RECONF--;

  /* complete reconfiguration */
  if (RECONF==1) {
    for(i=0;i<64;i++)
      CC[i]=(CC[i]&0xfffffc00)+((CC[i]>>10)&1023);
    RECONF=0;
  }

  /* check reconf */
  nst=eti_NST(etiframe);
  if (RECONF==0) {
    for (i=0;i<nst;i++) {
      idx=eti_SCID(i);
      newsad=eti_SAD(i);
      decode_TPL(eti_SSTC(i));
      newscs=Profil.SCS;
      oldsad=OldSAD(idx);
      oldscs=OldSCS(idx);
      printf("%d %d %d %d %d %d\n",i,idx,newsad,newscs,oldsad,oldscs);
      if ((newscs!=oldscs) || (newsad!=oldsad)) {
	if ((RECONF>0) && (RECONF!=16))
	  printf("Error in time_config: 2nd reconfiguration in 15 frames\n");
	RECONF=16;
      }
    }
  }

  /* do time_reconf */
  printf("RECONF %d nst %d\n",RECONF,nst);
  if (RECONF==16) {
    for(i=0;i<864;i++) newmapping[i]=cleared;
    for (i=0;i<nst;i++) {
      idx=eti_SCID(i);
      newsad=eti_SAD(i);
      decode_TPL(eti_SSTC(i));
      newscs=Profil.SCS;
      oldsad=OldSAD(idx);
      oldscs=OldSCS(idx);
      for(j=0;j<oldscs;j++) {
	newmapping[newsad+j]=OldMapping[oldsad+j];
	OldMapping[oldsad+j]=cleared;
      }
      if (newscs<=oldscs) CC[idx]=(newsad<<20)+(newscs<<10)+oldscs;
      else CC[idx]=(newsad<<20)+(newscs<<10)+newscs;
    }
    
    j=i=0;
    newmapping[864]=cleared;
    OldMapping[864]=0;
    while(i<865) {
      while(OldMapping[i]==cleared) i++;
      while(newmapping[j]!=cleared) j++;
      newmapping[j]=OldMapping[i];
      i++;
      j++;
    }
    if (i!=j) printf("Error in time_config: overlapping Channels? \n");
    for(i=0;i<864;i++) OldMapping[i]=newmapping[i];
  }

#ifdef COFDM_PROFILE
  prof_stop();
#endif
}
