
/*

  Interleaving, writing & reading from Interleaver-Cells


  */

#include "conf.h"
#include "timeint.h"
#include "profile.h"

#ifdef ARCHC6X
far WORD ICArray[15*864];
#else
WORD ICArray[15*864];
#endif
WORD CC[64];


void interleave_cus(WORD *in,int length,int offset) {
  int breversal[16]={ 0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15 };
  register WORD ina,inb,*cu;
  register WORD outa,outb,tmp;
  register int i,j,k,l;

#ifdef COFDM_PROFILE
  prof_start(profile_interleave);
#endif

  for (k=0;k<length;k++) {
    cu=ICArray+OldMapping[offset]*15;
    ina=in[0];
    inb=in[1];
    /* 1.step: read out */
    outa=ina&0x80008000;
    outb=inb&0x80008000;
    for (i=1;i<16;i++) {
      j=breversal[i];
      outa^=((cu[j-1]&0x80008000)>>i);
      tmp=(cu[15-j]&(0x00010001<<(j-1)))>>(j-1);
      tmp<<=(15-i);
      outb^=tmp;
    }
    
    /* write out */
    in[0]=outa;
    in[1]=outb;
    
    /* 2.,3. step: shift&clear */
    for (i=0;i<15;i++) {
      cu[i]<<=1;
      cu[i]&=((0x80008000>>i)^0xfffefffe);
    }
    
    /* 4.step: write in CU 
    printf("revstart\n");
    for (i=1;i<16;i++) {
      j=breversal[i];
      tmp=((ina&(0x80008000>>i))<<1);
      if (j>i) {
	tmp>>=(j-i); 
	printf("ina %d >>%d\n",j-1,j-i-1);
      } else {
	tmp<<=(i-j);
	printf("ina %d <<%d\n",j-1,i-j+1);
      }
      cu[j-1]^=tmp;
      tmp=((inb&(0x80008000>>i))>>(15-i));
      cu[15-j]^=tmp;
      printf("inb %d >>%d\n",15-j,15-i);
    }
    printf("revend\n");
    /* Expanded the loop */

    tmp=0x40004000;
    cu[7] ^=(ina&tmp)>>6; // i1,j8   
    cu[7] ^=(inb&tmp)>>14;tmp>>=1;
    cu[3] ^=(ina&tmp)>>1; // i2,j4   
    cu[11]^=(inb&tmp)>>13;tmp>>=1;
    cu[11]^=(ina&tmp)>>8; // i3,j12  
    cu[3] ^=(inb&tmp)>>12;tmp>>=1;
    cu[1] ^=(ina&tmp)<<3; // i4,j2   
    cu[13]^=(inb&tmp)>>11;tmp>>=1;
    cu[9] ^=(ina&tmp)>>4; // i5,j10  
    cu[5] ^=(inb&tmp)>>10;tmp>>=1;
    cu[5] ^=(ina&tmp)<<1; // i6,j6   
    cu[9] ^=(inb&tmp)>>9;tmp>>=1;
    cu[13]^=(ina&tmp)>>6; // i7,j14  
    cu[1] ^=(inb&tmp)>>8;tmp>>=1;
    *cu   ^=(ina&tmp)<<8; // i8,j1   
    cu[14]^=(inb&tmp)>>7;tmp>>=1;
    cu[8] ^=(ina&tmp)<<1; // i9,j9   
    cu[6] ^=(inb&tmp)>>6;tmp>>=1;
    cu[4] ^=(ina&tmp)<<6; // i10,j5  
    cu[10]^=(inb&tmp)>>5;tmp>>=1;
    cu[12]^=(ina&tmp)>>1; // i11,j13 
    cu[2] ^=(inb&tmp)>>4;tmp>>=1;
    cu[2] ^=(ina&tmp)<<10;// i12,j3  
    cu[12]^=(inb&tmp)>>3;tmp>>=1;
    cu[10]^=(ina&tmp)<<3; // i13,j11 
    cu[4] ^=(inb&tmp)>>2;tmp>>=1;
    cu[6] ^=(ina&tmp)<<8; // i14,j7  
    cu[8] ^=(inb&tmp)>>1;tmp>>=1;
    cu[14]^=(ina&tmp)<<1; // i15,j15 
    *cu   ^=(inb&tmp);

    in+=2;
    offset++;
  }
    
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}


