
/*

  function calls to generate one symbol from data
  
  public:
  MST_symbol()
  FIC_symbol()

  private:
  calculate_pi()

  */

#include "conf.h"
#include "parameters.h"
#include "timeint.h"
#include "eti.h"
#include "tpl.h"
#include "ofdm.h"
#include "symcon.h"
#include "profile.h"

#define PRINT_SYMCON_OFF

WORD dsymb[96+6];

/* private prototype - but no, it doesn't calculate the
   circular constant - it calculates the ProtectionIntervall
 */
void calculate_pi(int streamoffset,int symboloff,int *pi,int *llength);

/* CIF */
int currentstream; /* 0-eti_NST */
WORD *streamptr;   /* pointer to eti */
int streamoffset;  /* number of read uncoded WORDS from stream */
int cifoffset;     /* in BITS (max 864CU's*64Bit/CU == 55296) */
int dointerleave;  /* offset in CU's for the next CU in dsymb to interleave */

/* FIC */
int ficoffset;     /* number of read WORDS from FIC max: mode3=32 */
int ficsymoff;     /* symbol offset in BITS */


/* Once initialized, the routines check themselfs for the end
   of a CIF/FIC and reinitialize the variables */
void symb_init(void) {
  cifoffset=0;
  streamoffset=0;
  currentstream=0;
  streamptr=NULL;
  ficoffset=0;
  ficsymoff=0;
  dointerleave=0;
}

/* 
   This routine depends on a special eti-demuxer. This demuxer
   has the streams sorted by SAD, minimum first, and a finishing
   stream with SAD 864, STL 0;

   dest points to the Memory of one Symbol, plus 6 Words space;
   the overhead from the last call is assumed in the last 6 Words.
   
   The returned value signals the end of the CIF.
   0 normal, 1=Cif complete.

   this routine assumes that all channels are multiples of 64Bits

   MSC Variable explanation:
   There is no complete CIF stored in memory! But the digital symbol
   (dsymb) can be viewed as a partial window over a CIF. Since the
   startaddresses of a stream is given absolute in CU's pointing into
   the CIF, there are variables, which hold the momentary offset of
   the window compared to a complete CIF. Since symbols must be
   calculated complete and in consequtive order, there is a sequential
   pointer, counting each bit of the CIF (0..864*64-1), called:
   int cifoffset;

   int streamoffset; (0..max-stream(==864*64)) index into the source
       datastream, pointing to the position of the last read data
       used for coding a stream.
   int currentstream=0; 0-63, number (not ID!) of the current (or next) 
       stream to work on.
   WORD *streamptr; pointer to the first word of the source data stream.
   int i;int j; temporary variables used for indexing the interleaver
   int symbofW; number of complete WORDs of the current digital symbol.
   int symbofB; number of generated bits of the current digital symbol
   int symbnr; number of the symbols, generated from the current CIF
   int symbnext; "symbnr+1"
   int llength; number of words, variable use. number of words required to
       fill up a symbol or number of words remaining from a protection
       intervall.
   int pi; protection index - used to determine the punctering profile
   int id; Id of the stream as given in ETI
   int sad; start address in CU's, pointing into the virtual CIF
   int stl; stream length in CU's as given in the ETI
   int tmp; well temporary - used for storing the number of coded output bits.
   int dointerleave; last interleaved cu-index, pointing into a cif of a stream
   int lastcifoffset; Debug, to check if cifoffset changes every run.
*/
int MST_symbol(WORD *eti,FFT_TYPE *symbol) {
  int i,j,symbofW,symbofB,symbnr,symbnext;
  int llength,pi,id,sad,stl,tmp;
  /* Debug */
  int lastcifoffset;
  

  /* Conv-Coder-Call */
#ifdef COFDM_PROFILE
  prof_start(profile_mstsymbol);
#endif
  
  /* copy overhead from the last call */
  for(i=0;i<6;i++) dsymb[i]=dsymb[WordsPerDSymb+i];

  /* Loop over Symbollength */
  symbnr=(cifoffset/WORDSIZE)/WordsPerDSymb;
  symbnext=symbnr+1;
  dointerleave-=(WordsPerDSymb/2);
#ifdef PRINT_SYMCON
  myprintf("***sym=%d, streamoff=%d, cifoff=%d, currentstr=%d, WordsPerDSymb=%d\n",symbnr,streamoffset,cifoffset,currentstream,WordsPerDSymb);
#endif
  while (symbnr<symbnext) {

    /* Debug */
    lastcifoffset=cifoffset;

    symbofW=(cifoffset/WORDSIZE)%WordsPerDSymb;
    symbofB=(cifoffset-WORDSIZE*WordsPerDSymb*symbnr);

    /* no more channels check - trailing framepadding */
    if (currentstream==eti_NST(eti)) {
#ifdef PRINT_SYMCON
      myprintf("%d trailing padding len=%d off=%d\n",cifoffset,WordsPerDSymb-symbofW,cifoffset/WORDSIZE);
#endif
      prbs_generate(dsymb+symbofW,WordsPerDSymb-symbofW,cifoffset/WORDSIZE);
      cifoffset+=(WordsPerDSymb-symbofW)*32;
      symbnr=(cifoffset/WORDSIZE)/WordsPerDSymb;
      break;
    }
    
    id=eti_SCID(currentstream);
    sad=eti_SAD(currentstream);
    stl=eti_STL(currentstream);
#ifdef PRINT_SYMCON
    myprintf("%d symbofB=%d, symbofW=%d, idx=%d, id=%d, sad=%d, stl=%d\n",cifoffset,symbofB,symbofW,currentstream,id,sad,stl);
#endif

    if ((cifoffset/64)<sad) {
      /* leading framepadding */
#ifdef PRINT_SYMCON
      myprintf("%d framepadding\n",cifoffset);
#endif
      llength=MIN(sad*2-cifoffset/WORDSIZE,WordsPerDSymb-symbofW);
      if (llength>0) {
	prbs_generate(dsymb+symbofW,llength,cifoffset/WORDSIZE);
	cifoffset+=llength*WORDSIZE;
      }
    } else {
      /* new stream */
      if ((cifoffset/64)==sad) {
#ifdef PRINT_SYMCON
	myprintf("%d newstream\n",cifoffset);
#endif
	streamptr=eti_DATA(currentstream);
	streamoffset=0;
	dointerleave=symbofB/64; /* a new stream will always fit a new CU */
	decode_TPL(eti_SSTC(currentstream));
      }
      /* stream */
      if (streamoffset < stl*2) {
	calculate_pi(streamoffset,symbofW,&pi,&llength);
	tmp=endisp_conv_punct(streamptr+streamoffset,streamoffset,
			      symbofB,dsymb,llength,pi);
#ifdef PRINT_SYMCON
	myprintf("%d stream, pi=%d, llength=%d dbits=%d\n",
	       cifoffset,pi,llength,tmp);
#endif
	cifoffset+=tmp;
	symbofB+=tmp;
	streamoffset+=llength;
	/* stream end */
	if (streamoffset == stl*2) {
	  tmp=conv_punct_tail(symbofB,dsymb);
#ifdef PRINT_SYMCON
	  myprintf("%d streamend dbits=%d\n",cifoffset,tmp);
#endif
	  cifoffset+=tmp;
	  symbofB+=tmp;
	}

	llength=(symbofB/64)-dointerleave;
#ifdef PRINT_SYMCON
	myprintf("Timeinterleaver len=%d doint=%d\n",llength,dointerleave);
#endif
	/* for(i=0;i<llength;i++) {
	  j=symbnr*(WordsPerDSymb/2)+dointerleave+i;
	  interleave_cu(dsymb+(dointerleave+i)*2,ICArray+OldMapping[j]*15);
	  }
	*/
	interleave_cus(dsymb+dointerleave*2,llength,symbnr*(WordsPerDSymb/2)+dointerleave);
	dointerleave+=llength;

      } else {
	/* Padding Zeros for time_int */
#ifdef PRINT_SYMCON
	myprintf("%d paddingzeros\n",cifoffset);
#endif
	llength=MIN(OldSCS(id)*2-symbofW,WordsPerDSymb-symbofW);
	if (llength>0) {
	  for (i=0;i<llength;i++) dsymb[symbofW+i]=0;
	  cifoffset+=llength*WORDSIZE;

	  llength=(symbofB/64)-dointerleave;
#ifdef PRINT_SYMCON
	  myprintf("Timeinterleaver len=%d doint=%d\n",llength,dointerleave);
#endif
	  /*
	  for(i=0;i<llength;i++) {
	    /* map Word32 to CU64 and add prev symbols + symboffset
	    j=symbnr*(WordsPerDSymb/2)+dointerleave+i;
	    interleave_cu(dsymb+(dointerleave+i)*2,ICArray+OldMapping[j]*15);
	  }
	  */
	  interleave_cus(dsymb+dointerleave*2,llength,symbnr*(WordsPerDSymb/2)+dointerleave);
	  dointerleave+=llength;

	}
      }
      /* channel end */
#ifdef PRINT_SYMCON
      myprintf("%d sad=%d scs=%d\n",cifoffset,sad,OldSCS(id));
#endif
      if ((cifoffset/64) == (sad+OldSCS(id))) {
#ifdef PRINT_SYMCON
	myprintf("%d nextstream\n",cifoffset);
#endif
	currentstream++;
	/* Debug */
	lastcifoffset--;
      }
    }
    symbnr=(cifoffset/WORDSIZE)/WordsPerDSymb;
    if (cifoffset==lastcifoffset) {
#ifdef PRINT_SYMCON
      myprintf("Uh -something went wrong in MST_Symbol\n");
#endif
      exit(1);
    }
  }

  /* Time Interleaver Call */

  /* OFDM-Modulator Call */
#ifdef PRINT_SYMCON
  myprintf("DQPSK...\n");
#endif
  ofdm_dqpsk(dsymb,symbol);
#ifdef PRINT_SYMCON
  myprintf("fetisch\n");
#endif

#ifdef COFDM_PROFILE
  prof_stop();
#endif

  if (cifoffset==CIFSIZE) {
    /* new init */
    cifoffset=0;
    streamoffset=0;
    currentstream=0;
    streamptr=NULL;
    return(1);
  } else {
    return(0);
  }
}

/* FIC's are not synchron with Symbols !
   the first part of the Symbol is always from etiA.
   if this is not sufficient, the rest is taken from etiB
   the returned value is the index of the last used etiframe,
   0 for etiA,1 for etiB (etiA is used up),2 if etiB is used up
   - but two etis will always be sufficient for a symbol.
*/
int FIC_symbol(WORD *etiA,WORD *etiB,FFT_TYPE *symbol) {
  int L[4]={21,3,0,0};
  int PrI[4]={16,15,0,0};
  int pi,llength,symbofW,usedeti,i,tmp;
  WORD *ficdata;

#ifdef COFDM_PROFILE
  prof_start(profile_ficsymbol);
#endif
  /* "decode" TPL */
  for (i=0;i<4;i++) { 
    Profil.L[i]=L[i];
    Profil.PrI[i]=PrI[i];
  }
  
  /* overhead from last call */
  for(i=0;i<6;i++) dsymb[i]=dsymb[WordsPerDSymb+i];
  symbofW=ficsymoff/32;
  ficdata=eti_FIC(etiA);
  usedeti=0;
  while (symbofW<WordsPerDSymb) {
    calculate_pi(ficoffset,symbofW,&pi,&llength);
    tmp=endisp_conv_punct(ficdata+ficoffset,ficoffset,
			  ficsymoff,dsymb,llength,pi);
#ifdef PRINT_SYMCON
    myprintf("FIC ficoffset=%d, ficsymoffset=%d, pi=%d, llength=%d dbits=%d\n",
	   ficoffset,ficsymoff,pi,llength,tmp);
#endif
    ficoffset+=llength;
    ficsymoff+=tmp;
    symbofW=ficsymoff/32;

    if (ficoffset>=FicSize) {
      tmp=conv_punct_tail(ficsymoff,dsymb);
#ifdef PRINT_SYMCON
      myprintf("FIC ficoffset=%d, ficsymoffset=%d, Tail dbits=%d\n",
	   ficoffset,ficsymoff,tmp);
#endif
      ficsymoff+=tmp;
      symbofW=ficsymoff/32;
      /* new init */
      ficdata=eti_FIC(etiB);
      ficoffset=0;
      usedeti++;
    }
  }
  
  ficsymoff-=(WordsPerDSymb*WORDSIZE);
  ofdm_dqpsk(dsymb,symbol);

#ifdef COFDM_PROFILE
  prof_stop();
#endif

  return(usedeti);
}

void calculate_pi(int streamoffset,int symboloff,int *pi,int *llength) {
  int maxlen,l,p;
  /* DEBUG */
  int i;
  /* much code, only to calculate the PunctureVector and the
     number of words which can be punctured with it
     */

#ifdef COFDM_PROFILE
  prof_start(profile_calcpi);
#endif

  /* streamoffset is in WORDS (32Bits), L1-4 are in 128Bit,
     but since each WORD is coded into 128 Bit, each L? denotes the
     number of WORDS, which can be coded and punctured by the 
     corresponding P?
     */
  l=Profil.L[0];
  if (streamoffset >= l) {
    l+=Profil.L[1];
    if (streamoffset >= l) {
      l+=Profil.L[2];
      if (streamoffset >= l) {
	l+=Profil.L[3];
	if (streamoffset >= l){
	  myprintf("Uh -somthing went wrong in calculate_pi()\n");
	  myprintf("streamoffset :%d\n",streamoffset);
	  for(i=0;i<4;i++) {
	    myprintf(" L[%d]=%d  PrI[%d]=%d\n",i,Profil.L[i],i,Profil.PrI[i]);
	  }
	  exit(1);
	}
	p=Profil.PrI[3];
      } else {
	p=Profil.PrI[2];
      }
    } else {
      p=Profil.PrI[1];
    }
  } else {
    p=Profil.PrI[0];
  }

  /* 1 Word more then Symbollength may be coded */
  maxlen=((WordsPerDSymb-symboloff)*8)/(8+p) +1;
#ifdef PRINT_SYMCON
  myprintf("calculate_pi: maxlen=%d,len=%d\n",maxlen,l-streamoffset);
#endif
  /* checking maximum length */
  *llength=MIN(l-streamoffset,maxlen);
  *pi=p;
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}
