


/*

  reedsolomon encoder/decoder
  working on input/output of Bytes, 4 of them packed into a 32-Bit WORD
  and gfq(q) => q<=256;

  
  */

#include "conf.h"
#include "profile.h"
#include "rs.h"
#include "gfq.h"

#define PRINT_RSWORD_OFF


/* ll in bytes ! */
WORD gfq_Wsyndrom (WORD *poly,int ll,int x) {
  int i,j,logx,t,sum;
  WORD cell;

  if (x==0) {
    ll--;
    t=byteoutofword(poly[ll/4],(ll%4));
    return(t);
  }
  sum=0;
  logx=logatab(x);
  for (i=0;i<ll;i++) {
    if ((i%4)==0) cell=poly[i/4];
    t=nextbyte(cell);
    shiftout(cell);
    if (t>0) sum=gfq_add(sum,expotab(((ll-i-1)*logx+logatab(t))%gfq_n));
  }
  return(sum);
}

/* ll in bytes 
   buf must be of size 2*rootnbr+8 (Well I should check this!!)
*/
int rs_Wcorrect(WORD *msg,int ll,int rootoff,int rootnr,WORD *buf) {
  int t,i,lengthA,foundroots,errs;
  WORD tmp,t0,t1,t2,f7,t6,t7;
  int idx;
  clock_t start;
  t=rootnr/2;
  
#ifdef COFDM_PROFILE
  prof_start(profile_rscorrect);
#endif
  /* calculates roots, MSB first and the
     corresponding syndroms in buf        */
  errs=FALSE;
  for (i=0;i<rootnr;i++) {
    if ((buf[rootnr-i-1]=gfq_Wsyndrom(msg,ll+rootnr,gfq_exp(rootoff+i))) != 0)
      errs=TRUE;
  }
#ifdef PRINT_RSWORD
  myprintf("t %d, syndrom:",t);
  print_poly(buf,rootnr);
#endif
  /* check for errors */
  if (!errs) {
#ifdef COFDM_PROFILE
    prof_stop();
#endif
    return(0);
  }
  /* buf: 0..rootnr-1=syn; */

  /* errorlocator */
  lengthA=berlekamp(buf,rootnr,buf+rootnr,buf+rootnr+t+1,buf+rootnr+2*t+2);
  /* buf: 0..rootnr-1=syn; rootnr..rootnr+t=A; rootnr+t+1..rootnr+2t+1=A; */
#ifdef PRINT_RSWORD
  myprintf("A-locator %d:",lengthA);
  print_poly(buf+rootnr,lengthA);
#endif
  
  foundroots=gfq_roots(buf+rootnr+t+1,lengthA,buf+rootnr+2*t+2);
  /* buf: 0..rootnr-1=syn; rootnr..rootnr+t=A; rootnr+t+1..rootnr+2*t=errloc */
#ifdef PRINT_RSWORD
  myprintf(" %d roots of A: ",foundroots);
  print_poly(buf+rootnr+t+1,foundroots);
#endif

  /* Check for decoder failure */
  if (foundroots!=lengthA-1) {
#ifdef PRINT_RSWORD
    myprintf("decoder failure\n");
#endif
#ifdef COFDM_PROFILE
  prof_stop();
#endif
    return(-1);
  }

  /* Omega */
#ifdef PRINT_RSWORD
  myprintf("syn:");
  print_poly(buf,rootnr);
#endif
  gfq_polymulti(buf,rootnr,buf+rootnr,lengthA,buf+rootnr+2*t+1);
  /* buf: 
     0                           ... rootnr-1               =syn; 
     rootnr                      ... rootnr+t               =A;
     rootnr+t+1                  ... rootnr+2*t             =errloc;
     rootnr+2*t+1                ... 2*rootnr+3*t+1         =Omega+*  
    #rootnr+3*t+1-lengthA        ... 2*rootnr+3*t+1         =Omega*    */
#ifdef PRINT_RSWORD
  myprintf("Omega+*");
  print_poly(buf+rootnr+2*t+1,rootnr+lengthA-1);
  myprintf("Omega*");
  print_poly(buf+2*rootnr+lengthA,2*t);
#endif
  
  /* Aderiv */
  for (i=0;i<lengthA;i++) {
    if ((lengthA+i)%2==0) buf[i]=buf[rootnr+i];
    else buf[i]=0;
  }
#ifdef PRINT_RSWORD
  myprintf("Aderiv:");
  print_poly(buf,lengthA-1);
#endif

  /* buf: 0..t=Aderiv; rootnr..rootnr+t=A; 
     rootnr+t+1..rootnr+2*t=errloc; rootnr+2*t+1..2*rootnr+3*t+1 Omega+*  */
  
  for (i=0;i<foundroots;i++) {
    t0=buf[rootnr+t+1+i];             /* Xk^-1 */
    t1=gfq_invert(t0);                /* Xk */
    idx=ll+rootnr-gfq_log(t1)-1;
#ifdef PRINT_RSWORD
    myprintf("error at %d  ",idx);
#endif
    /* Check if error lies in message polynomial */
    if ((idx>=0) && (idx<ll)) {
      t2=gfq_syndrom(buf,lengthA-1,t0);
      f7=gfq_add(gfq_multiplic(gfq_power(t0,rootoff),
			       gfq_syndrom(buf+2*rootnr+lengthA,2*t,t0)),
		 gfq_syndrom(buf+rootnr,t+1,t0));
      t6=gfq_multiplic(gfq_multiplic(t1,f7),gfq_invert(t2));
      t7=byteoutofword(msg[idx/4],(idx%4));
#ifdef PRINT_RSWORD
      myprintf("old=%d new=%d",t7,gfq_add(t6,t7));
#endif
      byteintoword(msg[idx/4],gfq_add(t6,t7),(idx%4));
    }
#ifdef PRINT_RSWORD
    myprintf("\n");
#endif
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
  return(foundroots);
}


/* buf must be of size 2*rootnbr+4; */
/* msgbuf must be of size msglen+rootnbr */
void rs_Wencode(WORD *msgbuf,int msglen,int rootoff,int rootnbr,WORD *buf) {
  int i,j,k;
  WORD *polyA,*polyB,*tmp,*multiplicand;
  WORD t,s,cell;
  
  /* much code - only to set the paritybytes to zero */
  t=0;
  k=msglen/4;
  j=msglen%4;
  cell=msgbuf[k];
  if (j>0) {
    for (i=0;i<j;i++) {
      shiftin(t,nextbyte(cell));
      shiftout(cell);
    }
    s=t;
    for (i=0;i<(4-j);i++) shiftout(s);
    msgbuf[k]=s;
  } else {
    msgbuf[k]=0;
  }
  for (i=k+1;i<(msglen+rootnbr+3)/4;i++) msgbuf[i]=0;

  /* buf: 0..rootnbr=polyA; rootnbr+1..2*rootnbr+1=polyB;
     2*rootnbr+2..2*rootnbr+3=multiplicand */

  /* calculate generator_polynom */
  if (rootnbr%2) {
    polyA=buf;
    polyB=buf+rootnbr+1;
  } else {
    polyA=buf+rootnbr+1;
    polyB=buf;
  }

  polyA[0]=1;
  polyA[1]=gfq_exp(rootoff);
  multiplicand=buf+2*rootnbr+2;
  multiplicand[0]=1;
  for (i=1;i<rootnbr;i++) {
    multiplicand[1]=gfq_exp(rootoff+i);
    gfq_polymulti(polyA,i+1,multiplicand,2,polyB);
    tmp=polyA;
    polyA=polyB;
    polyB=tmp;
  }
#ifdef PRINT_RSWORD
  myprintf("poly:");
  print_poly(polyA,rootnbr+1);
#endif

  /* buf: 0..rootnbr=generatorpoly */
  gfq_Wpolydivi(msgbuf,msglen+rootnbr,polyA,rootnbr+1,buf+rootnbr+1);
  /* buf: 0..rootnbr=polyA; rootnbr+1..2*rootnbr=rs-extension; */

  /* copy rs-extension into msg
     assumption: always more than 4 roots!!! */
  for (i=0;i<4-j;i++) shiftin(t,buf[rootnbr+1+i]);
  msgbuf[k]=t;
  k++;
  j=0;
  t=0;
  for(;i<rootnbr;i++) {
    shiftin(t,buf[rootnbr+1+i]);
    j++;
    if ((j%4)==0) {
      msgbuf[k]=t;
      k++;
    }
  }
  if ((j%4)!=0) {
    for (i=0;i<(4-j);i++) shiftin(t,0);
    msgbuf[k]=t;
  }
}

/* polydivi in gfq whith WORDSIZE input
   a in 4Bytes/Word, b in words;
   lba in bytes; lwb in words;
*/
void gfq_Wpolydivi(WORD *a,int lba,WORD *b,int lwb,WORD *remainder) {
  int i,j,k;
  WORD t,cell;

  j=MIN(lba,lwb-1);
  for(i=0;i<j;i++) {
    if ((i%4)==0) cell=a[i/4];
    remainder[i]=nextbyte(cell);
    shiftout(cell);
  }

  if (lba<lwb) return;
  if ((lwb==0) || (b[0]==0)) {
    myprintf("DIVISION BY ZERO ERROR: gfq_Wpolydivi()\n");
    return;
  }

  if (b[0]!=1) {
    t=gfq_invert(b[0]);
    b[0]=1;
    for(i=1;i<lwb;i++) b[i]=gfq_multiplic(b[i],t);
  }

  for (i=lwb-1;i<lba;i++) {
    if ((i%4)==0) cell=a[i/4];
    t=remainder[0];
    for (j=1;j<(lwb-1);j++) remainder[j-1]=remainder[j];
    remainder[j-1]=nextbyte(cell);
    shiftout(cell);
    if (t>0) {
      for (j=0;j<lwb-1;j++) {
	remainder[j]=gfq_add(remainder[j],gfq_multiplic(t,b[j+1]));
      }
    }
  }

}

