

/* 

   routines working on input/output stored in seperate 32Bit Words
   - only for completeness/debugging


   */
#include "rs.h"
#include "gfq.h"


/* buf must be of size 2*rootnbr+4; */
/* msgbuf must be of size msglen+rootnbr */
void rs_encode(WORD *msgbuf,int msglen,int rootoff,int rootnbr,WORD *buf) {
  int i;
  WORD *polyA,*polyB,*tmp,*multiplicand;
  
  /* buf: 0..rootnbr=polyA; rootnbr+1..2*rootnbr+1=polyB;
     2*rootnbr+2..2*rootnbr+3=multiplicand */
  for (i=0;i<rootnbr;i++) msgbuf[msglen+i]=0;
  if (rootnbr%2) {
    polyA=buf;
    polyB=buf+rootnbr+1;
  } else {
    polyA=buf+rootnbr+1;
    polyB=buf;
  }
  polyA[0]=1;
  polyA[1]=gfq_exp(rootoff);
  multiplicand=buf+2*rootnbr+2;
  multiplicand[0]=1;
  for (i=1;i<rootnbr;i++) {
    multiplicand[1]=gfq_exp(rootoff+i);
    gfq_polymulti(polyA,i+1,multiplicand,2,polyB);
    tmp=polyA;
    polyA=polyB;
    polyB=tmp;
  }
  printf("poly:");
  print_poly(polyA,rootnbr+1);

  /* buf: 0..rootnbr=generatorpoly */
  gfq_polydivi(msgbuf,msglen+rootnbr,polyA,rootnbr+1,buf+rootnbr+1);
  /* buf: 0..rootnbr=polyA; rootnbr+1..2*rootnbr=rs-extension;

  /* copy rs-extension into msg */
  for(i=0;i<rootnbr;i++) msgbuf[msglen+i]=buf[rootnbr+1+i];
}



/*
  Memory of rs_correct: buf should be size of 4*rootnr+3

                  fixed            temp             LIFE
  roots            nr                       >| 
  syndrom*         nr                       <| >|
  locator A        t+1             nr+3*t+3     | >|           <---MemA
  locations        t                            |  | >|
  Omega*           2*t             nr+t+2      <|  |  |  >|    <---MemB
  Aderiv           t+1                             |  |   |
  <end>                                            v  v   v

  t<=nr/2+1;
  MemA <= nr+nr+3*t+3 == (7/2)*nr+1 <= 4*nr+1
  MemB <= t+1+nr+t+2+t+t+1 == 3*nr+4
  nr>=3: MemA>=MemB
  nr=1: MemA+2>=MemB
  MaxMem<=4*nr+3;

  *) only relevant position of x^m
 */


/*  ll is the messagelength - without reedsolomon parity-bytes  */
int rs_correct(WORD *msg,int ll,int rootoff,int rootnr,WORD *buf) {
  int t,i,lengthA,foundroots,errs;
  WORD tmp,t0,t1,t2,f7;
  int idx;
  t=rootnr/2;
  
  /* calculates roots, MSB first and the
     corresponding syndroms in buf        */
  errs=FALSE;
  for (i=0;i<rootnr;i++)
    if ((buf[rootnr-i-1]=gfq_syndrom(msg,ll+rootnr,gfq_exp(rootoff+i))) != 0)
      errs=TRUE;

  printf("t %d, syndrom:",t);
  print_poly(buf,rootnr);

  /* check for errors */
  if (!errs) {
    return(0);
  }
  /* buf: 0..rootnr-1=syn; */

  /* errorlocator */
  lengthA=berlekamp(buf,rootnr,buf+rootnr,buf+rootnr+t+1,buf+rootnr+2*t+2);
  /* buf: 0..rootnr-1=syn; rootnr..rootnr+t=A; rootnr+t+1..rootnr+2t+1=A; */
  printf("A-locator %d:",lengthA);
  print_poly(buf+rootnr,lengthA);
  
  foundroots=gfq_roots(buf+rootnr+t+1,lengthA,buf+rootnr+2*t+2);
  /* buf: 0..rootnr-1=syn; rootnr..rootnr+t=A; rootnr+t+1..rootnr+2*t=errloc */
  printf(" %d roots of A: ",foundroots);
  print_poly(buf+rootnr+t+1,foundroots);

  /* Check for decoder failure */
  if (foundroots!=lengthA-1) {
    printf("decoder failure\n");
    return(-1);
  }

  /* Omega */
  printf("syn:");
  print_poly(buf,rootnr);
  gfq_polymulti(buf,rootnr,buf+rootnr,lengthA,buf+rootnr+2*t+1);
  /* buf: 
     0                           ... rootnr-1               =syn; 
     rootnr                      ... rootnr+t               =A;
     rootnr+t+1                  ... rootnr+2*t             =errloc;
     rootnr+2*t+1                ... 2*rootnr+3*t+1         =Omega+*  
    #rootnr+3*t+1-lengthA        ... 2*rootnr+3*t+1         =Omega*    */

  printf("Omega+*");
  print_poly(buf+rootnr+2*t+1,rootnr+lengthA-1);
  printf("Omega*");
  print_poly(buf+2*rootnr+lengthA,2*t);
  
  /* Aderiv */
  for (i=0;i<lengthA;i++) {
    if ((lengthA+i)%2==0) buf[i]=buf[rootnr+i];
    else buf[i]=0;
  }
  printf("Aderiv:");
  print_poly(buf,lengthA-1);

  /* buf: 0..t=Aderiv; rootnr..rootnr+t=A; 
     rootnr+t+1..rootnr+2*t=errloc; rootnr+2*t+1..2*rootnr+3*t+1 Omega+*  */
  
  for (i=0;i<foundroots;i++) {
    t0=buf[rootnr+t+1+i];             /* Xk^-1 */
    t1=gfq_invert(t0);                /* Xk */
    idx=ll+rootnr-gfq_log(t1)-1;
    printf("error at %d\n",idx);
    /* Check if error lies in message polynomial */
    if ((idx>=0) && (idx<ll)) {
      t2=gfq_syndrom(buf,lengthA-1,t0);
      f7=gfq_add(gfq_multiplic(gfq_power(t0,rootoff),
			       gfq_syndrom(buf+2*rootnr+lengthA,2*t,t0)),
		 gfq_syndrom(buf+rootnr,t+1,t0));
      msg[idx]=gfq_add(msg[idx],gfq_multiplic(gfq_multiplic(t1,f7),gfq_invert(t2)));
    }
  }
  return(foundroots);
}

