

/*
  

  Functions for calculations in GF(2^gfq_n)[x]


  */

#include "gfq.h"

int gfq_n=255;

/* bin_polydivi()
   can divide only polynoms up to x^31. nenner is the bitvector.
   Zaehler may have any length of multiples of 32,
   where lwz is the number of occopied words. Zaehler may have
   leading zeros, so an arbitrary length is possible */
WORD bin_polydivi(WORD *zaehler,int lwz,WORD nenner) {
  int i,j,t1,t2,bits,offset;
  WORD remainder,next;

  bits=31;
  while ((nenner&MSB)==0) {
    nenner<<=1;
    bits--;
  }
  nenner<<=1;

  remainder=zaehler[0];
  for (i=1;i<lwz;i++) {
    next=zaehler[i];
    for (j=0;j<WORDSIZE;j++) {
      t1=((remainder&MSB)>0);
      remainder<<=1;
      remainder+=((next&MSB)>0);
      next<<=1;
      if (t1>0) remainder^=nenner;
    }
  }
  for(j=0;j<WORDSIZE-bits;j++) {
    t1=((remainder&MSB)>0);
    remainder<<=1;
    if (t1>0) remainder^=nenner;
  }

  remainder>>=(WORDSIZE-bits);
  return (remainder);
}

/* gfq_init()
   not very sophisticated ...
   can calculate tables of up to 2^WORDSIZE entrys
   (you should first think about it, before you alloc mem ...)
   the variable <t> holds the nescessary dynamic memory and must be
   of size TABLESIZE/32 (max 2^(WORDSIZE-5))
   Used to initialize the gfq-log()-lookup tabs.
   Cause calculation is memory consuming, the tabs are precalculated
   and stored as fixed tabs
*/
void gfq_init(WORD poly,WORD *temporary) {
  int i,j;
  WORD rem;
  WORD t[256*256];

  expotab[0]=1;
  expotab[1]=2;
  i=2;
  j=1;
  *t=1<<2;
  while (rem != expotab[1]) {
    rem=bin_polydivi(t,j,poly);
    expotab[i]=rem;
    logatab[rem]=i;
    if (rem == expotab[1]) break;
    *t<<=1;
    if (*t==0) {
      *t=1;
      j++;
    }
    i++;
  }
  gfq_n=i-1;
  myprintf(" gfq_n=%d\n",gfq_n);
  logatab[0]=-1; /*err*/
  logatab[1]=0;
  logatab[2]=1;
}

WORD gfq_multiplic(WORD a,WORD b) {

  if ((a==0) | (b==0)) return(0);
  return(expotab((logatab(a)+logatab(b))%gfq_n));
}

WORD gfq_invert(WORD a) {
  
  if (a==0) {
    myprintf("Error in gfq_invert, zero parameter\n");
    return(-1);
  }
  return(expotab((gfq_n-logatab(a))));
}

WORD gfq_power(WORD a,int b) {
  if (a==0) return(0);
  return(expotab(((logatab(a)*b)%gfq_n)));
}

WORD gfq_exp(WORD a) {
  return(expotab(a));
}

WORD gfq_log(WORD a) {
  if (a==0) {
    myprintf("Error in gfq_log: zero parameter\n");
    return(-1);
  }
  return(logatab(a));
}

void print_poly(WORD *poly,int ll) {
  int i;
  for(i=0;i<ll;i++) myprintf(" %d",poly[i]);
  myprintf("\n");
}

/* every WORD is a Symbol */
void gfq_polymulti(WORD *a,int lwa,WORD *b,int lwb,WORD *prod) {
  int i,j;

  for(i=0;i<(lwa+lwb-1);i++) prod[i]=0;

  for (i=lwa-1;i>=0;i--) {
    for (j=lwb-1;j>=0;j--) {
      prod[i+j]=gfq_add(prod[i+j],gfq_multiplic(a[i],b[j]));
    }
  }
}

/*
  every WORD is a Symbol
  */
void gfq_polydivi(WORD *a,int lwa,WORD *b,int lwb,WORD *remainder) {
  int i,j;
  WORD t;

  j=MIN(lwa,lwb-1);
  for (i=0;i<j;i++) remainder[i]=a[i];
  if (lwa<lwb) return;
  if ((lwb==0) || (b[0]==0)) {
    myprintf("DIVISION BY ZERO ERROR: gfq_polydivi()\n");
    return;
  }

  if (b[0]!=1) {
    t=gfq_invert(b[0]);
    b[0]=1;
    for(i=1;i<lwb;i++) b[i]=gfq_multiplic(b[i],t);
  }
  for (i=lwb-1;i<lwa;i++) {
    t=remainder[0];
    for (j=1;j<(lwb-1);j++) remainder[j-1]=remainder[j];
    remainder[j-1]=a[i];
    if (t>0) {
      for (j=0;j<lwb-1;j++) {
	remainder[j]=gfq_add(remainder[j],gfq_multiplic(t,b[j+1]));
      }
    }
  }
}

WORD gfq_syndrom(WORD *poly,int ll,WORD x) {
  int i,logx;
  WORD t,sum;

  if (x==0) return(poly[ll-1]);
  sum=0;
  logx=logatab(x);
  for (i=0;i<ll;i++) {
    t=poly[i];
    if (t>0) sum=gfq_add(sum,expotab(((ll-i-1)*logx+logatab(t))%gfq_n));
  }
  return(sum);
}

/* Warning, this works destructive! */
int gfq_roots(WORD *poly,int ll,WORD *roots) {
  int i,j,c,d;
  WORD t;
  WORD *tmp;
  
  c=0;
  roots[c]=0;
  if (ll<2) return(0);
  for (i=0;i<=gfq_n;i++) {
    if (c==ll-2) {
      poly[c]=roots[c]=gfq_multiplic(gfq_invert(poly[c]),poly[c+1]);
      c++;
      return(c);
    }
    roots[c+1]=poly[c];
    for (j=c+2;j<ll;j++) {
      roots[j]=gfq_add(poly[j-1],gfq_multiplic(i,roots[j-1]));
    }
    if (gfq_multiplic(i,roots[j-1])==poly[j-1]) {
      roots[c]=i;
      poly[c]=i;   /* copied, so roots _and_ poly point to the roots */
      c++;
      tmp=poly;
      poly=roots;
      roots=tmp;
    }
  }
  return(c);
}
