
/*

  Reed-solomon procedures:

  berlekamp(): algorithm to calculate the errorlocator polynom
  rs_encode(): appends the parity-bytes to a message
  rs_correct(): tries to correct a given message with parity-bytes

  */

#include "conf.h"
#include "gfq.h"
#include "profile.h"


/* Syndrom MUST be in DESCENDING order !! 
   ( eg. from alpha^5 to alpha^1 )
   therefor A is returned MSB first

   size of A:t+1, Abuf: t+1, Tbuf: t+1

   ll is the length of the syndrom (no. of paritybytes)
 */
int berlekamp(WORD *syn,int ll,WORD *A,WORD *Abuf,WORD *Tbuf) {
  int i,j,t,k,L;
  WORD D,Dinv,tmp;

#ifdef COFDM_PROFILE
  prof_start(profile_berlekamp);
#endif
  t=ll/2;
  for (i=0;i<ll;i++) Tbuf[i]=A[i]=Abuf[i]=0;
  /* reverting syn */
  for (i=0;i<t;i++) {
    tmp=syn[i];
    syn[i]=syn[ll-i-1];
    syn[ll-i-1]=tmp;
  }

  Tbuf[1]=Abuf[0]=A[0]=1;
  k=0;
  L=0;
  while (k<2*t) {
    k++;
    D=syn[k-1];
    for (i=1;i<=L;i++) D=gfq_add(D,gfq_multiplic(Abuf[i],syn[k-i-1]));
    if (D>0) {
      for (i=0;i<=t;i++) {
	A[i]=gfq_add(Abuf[i],gfq_multiplic(D,Tbuf[i]));
      }
      if (2*L<k) {
	L=k-L;
	Dinv=gfq_invert(D);
	for (i=0;i<=t;i++) Tbuf[i]=gfq_multiplic(Dinv,Abuf[i]);
      }
    }
    for (i=t;i>0;i--) {
      Tbuf[i]=Tbuf[i-1];
      Abuf[i]=A[i];
    }
    Tbuf[0]=0;
    Abuf[0]=A[0];
  }
  /* reverting A and Abuf, to return the result twice.
     (cause gfq_roots works destructive but A is still needed) */
  t=(L+1)/2;
  for (i=0;i<t;i++) {
    tmp=A[i];
    A[i]=A[L-i];
    Abuf[i]=A[L-i];
    A[L-i]=tmp;
    Abuf[L-i]=tmp;
  }
  /* reverting syn back */
  t=ll/2;
  for (i=0;i<t;i++) {
    tmp=syn[i];
    syn[i]=syn[ll-i-1];
    syn[ll-i-1]=tmp;
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
  return(L+1);
}

