
/*


  routines for profiling

  WARNING!
  take care, that for each prof_start exists an prof_stop!
  else the results are not usable.
  recursive loops may fail or return unreliable data!
  use for each start/stop -pair an unique index.
  idx 0-2 are reserved for calibration.
  the accumulated and printed cycles are dependend on the systems
  clock() return value. (POSIX uses 10ms, which is seldom equal to
  a real cycle). Rever to your time.h file or clock() manual page.
  */

#include <time.h>
#include "conf.h"

#include "profile.h"


tprof_entry profiles[PROFILE_MAXENTRYS];
int prof_current=-1;
clock_t current_clock;
clock_t prof_calibrate=0;

char *profile_names[]={
   "calib0","calib1","overhead","suspend","conv_punct","convtail","ifft","fft",
   "prbs_scramble","prbs_generate","calc_pi","mst symbol","fic symbol",
   "interleaver","time config","symbols complete","crc_calc","berlekamp",
   "gfq syndrom","rs correct","dqpsk","program complete","fft reversal",
   "outer interleave"
};

void prof_init() {
  int i;
  tprof_entry tmp;

  for (i=0;i<PROFILE_MAXENTRYS;i++) {
    tmp=profiles[i];
    tmp.count=0;
    tmp.cycles=0;
    tmp.called_by=-1;
  }
  prof_start(overhead);
  prof_stop();
}

/* not used */
clock_t prof_calib() {

  /* first run */
  prof_start(0);
  prof_start(1);
  prof_stop();
  prof_stop();
  
  /* second run */
  prof_start(calib0);
  prof_start(calib1);
  prof_start(overhead);
  prof_stop();
  prof_stop();
  prof_stop();

  return(profiles[0].cycles-profiles[1].cycles);
}

void prof_start(int idx) {
  register int tmp;

  if (prof_current<0) {
    prof_current=idx;
    profiles[idx].start=clock();
  } else {
    tmp=prof_current;
    prof_current=idx;
    profiles[idx].called_by=tmp;
    profiles[idx].start=clock();
  }
  profiles[idx].count++;
}

void prof_suspend(void) {
  register int tmp;

  tmp=prof_current;
  prof_current=suspend;
  profiles[suspend].start=clock();
  profiles[suspend].called_by=tmp;
}
  
void prof_resume(void) {
  register int tmp;
  register clock_t cycl;

  cycl=clock()-profiles[suspend].start-prof_calibrate;
  prof_current=profiles[suspend].called_by;
  profiles[prof_current].start+=cycl;
}

void prof_stop(void) {
  profiles[prof_current].cycles+=(clock() - profiles[prof_current].start - prof_calibrate);
  prof_current=profiles[prof_current].called_by;
}

void prof_printf(void) {
  register int i;

  printf("------- Profile ----------\n");
  for (i=0;i<PROFILE_MAXENTRYS;i++) {
    if (profiles[i].count>0) {
      printf(" %2d <%18s> calls: %5d,  cycles/call: %5d, cycles: %6d\n",i,profile_names[i],profiles[i].count,(profiles[i].cycles/profiles[i].count),profiles[i].cycles);
    }
  }
}


