
/*

  energy_dispersal

 */

#include "conf.h"
#include "prbs.h"
#include "profile.h"

WORD PRBS_tab[511]={
 0x7be2e64, 0x129da3cf, 0x9b15238d, 0xab898880, 0x42309cab,
 0xde9b914, 0x2b4fd925, 0xbf26a660, 0x3194697f, 0x458eb2cf,
 0x1f741adb, 0xb05afaa8, 0x14af2ee0, 0x73a4f5d4, 0x48670bdb,
 0x343bc3fe, 0xf7c5cc8, 0x253b479f, 0x362a471b, 0x57131100,
 0x84613956, 0x1bd37228, 0x569fb24b, 0x7e4d4cc0, 0x6328d2fe,
 0x8b1d659e, 0x3ee835b7, 0x60b5f550, 0x295e5dc0, 0xe749eba8,
 0x90ce17b6, 0x687787fc, 0x1ef8b990, 0x4a768f3e, 0x6c548e36,
 0xae262201, 0x8c272ac, 0x37a6e450, 0xad3f6496, 0xfc9a9980,
 0xc651a5fd, 0x163acb3c, 0x7dd06b6e, 0xc16beaa0, 0x52bcbb81,
 0xce93d751, 0x219c2f6c, 0xd0ef0ff8, 0x3df17320, 0x94ed1e7c,
 0xd8a91c6d, 0x5c4c4402, 0x1184e558, 0x6f4dc8a1, 0x5a7ec92d,
 0xf9353301, 0x8ca34bfa, 0x2c759678, 0xfba0d6dd, 0x82d7d540,
 0xa5797703, 0x9d27aea2, 0x43385ed9, 0xa1de1ff0, 0x7be2e641,
 0x29da3cf9, 0xb15238da, 0xb8988804, 0x2309cab0, 0xde9b9142,
 0xb4fd925b, 0xf26a6603, 0x194697f4, 0x58eb2cf1, 0xf741adbb,
 0x5afaa81, 0x4af2ee07, 0x3a4f5d44, 0x8670bdb3, 0x43bc3fe0,
 0xf7c5cc82, 0x53b479f3, 0x62a471b5, 0x71311008, 0x46139561,
 0xbd372285, 0x69fb24b7, 0xe4d4cc06, 0x328d2fe8, 0xb1d659e3,
 0xee835b76, 0xb5f5502, 0x95e5dc0e, 0x749eba89, 0xce17b66,
 0x87787fc1, 0xef8b9904, 0xa768f3e6, 0xc548e36a, 0xe2622010,
 0x8c272ac3, 0x7a6e450a, 0xd3f6496f, 0xc9a9980c, 0x651a5fd1,
 0x63acb3c7, 0xdd06b6ec, 0x16beaa05, 0x2bcbb81c, 0xe93d7512,
 0x19c2f6cd, 0xef0ff83, 0xdf173209, 0x4ed1e7cd, 0x8a91c6d5,
 0xc4c44021, 0x184e5586, 0xf4dc8a15, 0xa7ec92df, 0x93533018,
 0xca34bfa2, 0xc759678f, 0xba0d6dd8, 0x2d7d540a, 0x57977039,
 0xd27aea24, 0x3385ed9a, 0x1de1ff07, 0xbe2e6412, 0x9da3cf9b,
 0x15238dab, 0x89888042, 0x309cab0d, 0xe9b9142b, 0x4fd925bf,
 0x26a66031, 0x94697f45, 0x8eb2cf1f, 0x741adbb0, 0x5afaa814,
 0xaf2ee073, 0xa4f5d448, 0x670bdb34, 0x3bc3fe0f, 0x7c5cc825,
 0x3b479f36, 0x2a471b57, 0x13110084, 0x6139561b, 0xd3722856,
 0x9fb24b7e, 0x4d4cc063, 0x28d2fe8b, 0x1d659e3e, 0xe835b760,
 0xb5f55029, 0x5e5dc0e7, 0x49eba890, 0xce17b668, 0x7787fc1e,
 0xf8b9904a, 0x768f3e6c, 0x548e36ae, 0x26220108, 0xc272ac37,
 0xa6e450ad, 0x3f6496fc, 0x9a9980c6, 0x51a5fd16, 0x3acb3c7d,
 0xd06b6ec1, 0x6beaa052, 0xbcbb81ce, 0x93d75121, 0x9c2f6cd0,
 0xef0ff83d, 0xf1732094, 0xed1e7cd8, 0xa91c6d5c, 0x4c440211,
 0x84e5586f, 0x4dc8a15a, 0x7ec92df9, 0x3533018c, 0xa34bfa2c,
 0x759678fb, 0xa0d6dd82, 0xd7d540a5, 0x7977039d, 0x27aea243,
 0x385ed9a1, 0xde1ff07b, 0xe2e64129, 0xda3cf9b1, 0x5238dab8,
 0x98880423, 0x9cab0de, 0x9b9142b4, 0xfd925bf2, 0x6a660319,
 0x4697f458, 0xeb2cf1f7, 0x41adbb05, 0xafaa814a, 0xf2ee073a,
 0x4f5d4486, 0x70bdb343, 0xbc3fe0f7, 0xc5cc8253, 0xb479f362,
 0xa471b571, 0x31100846, 0x139561bd, 0x37228569, 0xfb24b7e4,
 0xd4cc0632, 0x8d2fe8b1, 0xd659e3ee, 0x835b760b, 0x5f550295,
 0xe5dc0e74, 0x9eba890c, 0xe17b6687, 0x787fc1ef, 0x8b9904a7,
 0x68f3e6c5, 0x48e36ae2, 0x6220108c, 0x272ac37a, 0x6e450ad3,
 0xf6496fc9, 0xa9980c65, 0x1a5fd163, 0xacb3c7dd, 0x6b6ec16,
 0xbeaa052b, 0xcbb81ce9, 0x3d751219, 0xc2f6cd0e, 0xf0ff83df,
 0x1732094e, 0xd1e7cd8a, 0x91c6d5c4, 0xc4402118, 0x4e5586f4,
 0xdc8a15a7, 0xec92df93, 0x533018ca, 0x34bfa2c7, 0x59678fba,
 0xd6dd82d, 0x7d540a57, 0x977039d2, 0x7aea2433, 0x85ed9a1d,
 0xe1ff07be, 0x2e64129d, 0xa3cf9b15, 0x238dab89, 0x88804230,
 0x9cab0de9, 0xb9142b4f, 0xd925bf26, 0xa6603194, 0x697f458e,
 0xb2cf1f74, 0x1adbb05a, 0xfaa814af, 0x2ee073a4, 0xf5d44867,
 0xbdb343b, 0xc3fe0f7c, 0x5cc8253b, 0x479f362a, 0x471b5713,
 0x11008461, 0x39561bd3, 0x7228569f, 0xb24b7e4d, 0x4cc06328,
 0xd2fe8b1d, 0x659e3ee8, 0x35b760b5, 0xf550295e, 0x5dc0e749,
 0xeba890ce, 0x17b66877, 0x87fc1ef8, 0xb9904a76, 0x8f3e6c54,
 0x8e36ae26, 0x220108c2, 0x72ac37a6, 0xe450ad3f, 0x6496fc9a,
 0x9980c651, 0xa5fd163a, 0xcb3c7dd0, 0x6b6ec16b, 0xeaa052bc,
 0xbb81ce93, 0xd751219c, 0x2f6cd0ef, 0xff83df1, 0x732094ed,
 0x1e7cd8a9, 0x1c6d5c4c, 0x44021184, 0xe5586f4d, 0xc8a15a7e,
 0xc92df935, 0x33018ca3, 0x4bfa2c75, 0x9678fba0, 0xd6dd82d7,
 0xd540a579, 0x77039d27, 0xaea24338, 0x5ed9a1de, 0x1ff07be2,
 0xe64129da, 0x3cf9b152, 0x38dab898, 0x88042309, 0xcab0de9b,
 0x9142b4fd, 0x925bf26a, 0x66031946, 0x97f458eb, 0x2cf1f741,
 0xadbb05af, 0xaa814af2, 0xee073a4f, 0x5d448670, 0xbdb343bc,
 0x3fe0f7c5, 0xcc8253b4, 0x79f362a4, 0x71b57131, 0x10084613,
 0x9561bd37, 0x228569fb, 0x24b7e4d4, 0xcc06328d, 0x2fe8b1d6,
 0x59e3ee83, 0x5b760b5f, 0x550295e5, 0xdc0e749e, 0xba890ce1,
 0x7b668778, 0x7fc1ef8b, 0x9904a768, 0xf3e6c548, 0xe36ae262,
 0x20108c27, 0x2ac37a6e, 0x450ad3f6, 0x496fc9a9, 0x980c651a,
 0x5fd163ac, 0xb3c7dd06, 0xb6ec16be, 0xaa052bcb, 0xb81ce93d,
 0x751219c2, 0xf6cd0ef0, 0xff83df17, 0x32094ed1, 0xe7cd8a91,
 0xc6d5c4c4, 0x4021184e, 0x5586f4dc, 0x8a15a7ec, 0x92df9353,
 0x3018ca34, 0xbfa2c759, 0x678fba0d, 0x6dd82d7d, 0x540a5797,
 0x7039d27a, 0xea243385, 0xed9a1de1, 0xff07be2e, 0x64129da3,
 0xcf9b1523, 0x8dab8988, 0x8042309c, 0xab0de9b9, 0x142b4fd9,
 0x25bf26a6, 0x60319469, 0x7f458eb2, 0xcf1f741a, 0xdbb05afa,
 0xa814af2e, 0xe073a4f5, 0xd448670b, 0xdb343bc3, 0xfe0f7c5c,
 0xc8253b47, 0x9f362a47, 0x1b571311, 0x846139, 0x561bd372,
 0x28569fb2, 0x4b7e4d4c, 0xc06328d2, 0xfe8b1d65, 0x9e3ee835,
 0xb760b5f5, 0x50295e5d, 0xc0e749eb, 0xa890ce17, 0xb6687787,
 0xfc1ef8b9, 0x904a768f, 0x3e6c548e, 0x36ae2622, 0x108c272,
 0xac37a6e4, 0x50ad3f64, 0x96fc9a99, 0x80c651a5, 0xfd163acb,
 0x3c7dd06b, 0x6ec16bea, 0xa052bcbb, 0x81ce93d7, 0x51219c2f,
 0x6cd0ef0f, 0xf83df173, 0x2094ed1e, 0x7cd8a91c, 0x6d5c4c44,
 0x21184e5, 0x586f4dc8, 0xa15a7ec9, 0x2df93533, 0x18ca34b,
 0xfa2c7596, 0x78fba0d6, 0xdd82d7d5, 0x40a57977, 0x39d27ae,
 0xa243385e, 0xd9a1de1f, 0xf07be2e6, 0x4129da3c, 0xf9b15238,
 0xdab89888, 0x42309ca, 0xb0de9b91, 0x42b4fd92, 0x5bf26a66,
 0x3194697, 0xf458eb2c, 0xf1f741ad, 0xbb05afaa, 0x814af2ee,
 0x73a4f5d, 0x448670bd, 0xb343bc3f, 0xe0f7c5cc, 0x8253b479,
 0xf362a471, 0xb5713110, 0x8461395, 0x61bd3722, 0x8569fb24,
 0xb7e4d4cc, 0x6328d2f, 0xe8b1d659, 0xe3ee835b, 0x760b5f55,
 0x295e5dc, 0xe749eba, 0x890ce17b, 0x6687787f, 0xc1ef8b99,
 0x4a768f3, 0xe6c548e3, 0x6ae26220, 0x108c272a, 0xc37a6e45,
 0xad3f649, 0x6fc9a998, 0xc651a5f, 0xd163acb3, 0xc7dd06b6,
 0xec16beaa, 0x52bcbb8, 0x1ce93d75, 0x1219c2f6, 0xcd0ef0ff,
 0x83df1732, 0x94ed1e7, 0xcd8a91c6, 0xd5c4c440, 0x21184e55,
 0x86f4dc8a, 0x15a7ec92, 0xdf935330, 0x18ca34bf, 0xa2c75967,
 0x8fba0d6d, 0xd82d7d54, 0xa579770, 0x39d27aea, 0x243385ed,
 0x9a1de1ff
};

int prbs_reg;

void prbs_reset(void) {
  prbs_reg=511;
}

int prbs_step1(void) {
  int t;
  t=((prbs_reg&256)>0)^((prbs_reg&16)>0);
  prbs_reg<<=1;
  prbs_reg+=t;
  return(t);
}

/* precalculated - nothing to do */
void prbs_init(void) {}

void prbs_inittab(void) {
  int i,j;
  WORD t;

  prbs_reset();
  for (i=0;i<511;i++) {
    t=0;
    for (j=0;j<WORDSIZE;j++) {
      t<<=1;
      t+=prbs_step1();
    }
    PRBS_tab[i]=t;
  }
}

void prbs_generate(WORD *ptr,int length,int offset) {
  int i;
#ifdef COFDM_PROFILE
  prof_start(profile_prbsgenerate);
#endif
  for (i=0;i<length;i++) ptr[i]=PRBS_tab[(i+offset)%511];
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}

void prbs_scramble(WORD *ptr,int length,int offset) {
  int i;
  
#ifdef COFDM_PROFILE
  prof_start(profile_prbsscramble);
#endif
  for (i=0;i<length;i++) ptr[i]^=PRBS_tab[(i+offset)%511];
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}
