

/*

  inits the basic procedures


  */

#include "conf.h"
#include "parameters.h"
#include "conv_punct.h"
#include "eti.h"
#include "timeint.h"
#include "fft.h"
#include "ofdm.h"
#include "tpl.h"

/* gloabal variables */
int Comb;
int Pattern;
int CarrierNbr;
int ProtIntervall;
int VirtualCarriers;
int VirtualBase;
int FicSize;
int NullSymbLen;
int NbrLogicFrames;
int WordsPerDSymb;
int SymbolsPerCIF;
int SymbolsPerFIC;
int SymbolsPerFrame;
int SymbolSize;
int DABMode;

/* required with every modechange
   identical to a reset
*/
void mode_init(int dabmode) {
  int NbrLogicFramesMode[4]= { 4,1,1,2 }; /* frames */
  int CarrierNbrMode[4]    = { 1536,384,192,768 }; /* iq-samples */
  int SymbolsPerFrameMode[4]={ 77,77,154,77 }; /* with null- & TFPR-sym */
  int ProtIntervallMode[4] = { 504,126,63,252 }; /* iq-samples */
  int VirtualCarrierMode[4]= { 2048,512,256,1024 }; /* iq-samples */
  int VirtualBaseMode[4]   = {   11,  9,   8, 10 }; /* log2(VirtualCarriers) */
  int NullSymbLenMode[4]   = { 5312,1328,690,2656 }; /* floats */
  int SymbolSizeMode[4]    = { 5104,1276,638,2552 }; /* floats */
  int WordsPerDSymbMode[4] = { 96,24,12,48 };  /* words */
  int SymbolsPerCIFMode[4] = { 18,72,144,36 }; /* symbols */
  int SymbolsPerFICMode[4] = { 3, 3, 8, 3 };   /* symbols */
  int FicSizeMode[4]     = { 24,24,32,24 };  /* Words */
  
  /* FIC perCIF
     Bits          768 768 1024 768
     WORDS          24  24   32  24
     convcoded (PI=16) => *3
     ConvWORDS      72  72   96  72
     FIC's/DABframe  4   1    1   2
     WORDS/DABfram 288  72   96 144
     Words/Dsymb    96  24   12  48
     macht FICSymbole:
     FICSymb/Frame   3   3    8   3
     

     CIF/Frame       4    1    1    2
     CU's         3456  864  864 1728
     Words/CIF    6912 1728 1728 3456
     Carrier      1536  384  192  768
     Bits/DSymb   3072  768  384 1024
     Words/DSymb    96   24   12   48
     CIFSymb/Frame  72   72  144   72
     Symb/CIF       18   72  144   36

     Symbole
     samples      2048  512  256  1024
     protint       504  126   63   252
     float/symbol 5104 1276  638  2552
   */

  DABMode=dabmode;
  if (DABMode==0) DABMode=4;
  dabmode=DABMode-1;
  NbrLogicFrames=NbrLogicFramesMode[dabmode];
  NullSymbLen=NullSymbLenMode[dabmode];
  SymbolSize=SymbolSizeMode[dabmode];
  VirtualCarriers=VirtualCarrierMode[dabmode];
  VirtualBase=VirtualBaseMode[dabmode];
  ProtIntervall=ProtIntervallMode[dabmode];
  SymbolsPerFrame=SymbolsPerFrameMode[dabmode];
  CarrierNbr=CarrierNbrMode[dabmode];
  WordsPerDSymb=WordsPerDSymbMode[dabmode];
  SymbolsPerCIF=SymbolsPerCIFMode[dabmode];
  SymbolsPerFIC=SymbolsPerFICMode[dabmode];
  FicSize=FicSizeMode[dabmode];

  crc_init();
  prbs_init();
  time_init();
  ofdm_init();
  tfpr_init();
  fft_init(VirtualCarriers);
  conv_init();
  symb_init();
}

