

/*


  OFDM-generator

  ofdm_dqpsk includes:
  * qpsk-mapper
  * differential modulation
  * frequency-interleaving
  
  a function is provided for the
  * protection intervall

  the fft-algorithm is a part on its own

  */

#include "conf.h"
#include "parameters.h"
#include "ofdm.h"
#include "fft_burrus.h"
#include "profile.h"

SHORT ofdm_freqtab[1536];
#ifdef ARCHC6X
far FFT_TYPE ofdm_diffsymb[2048*2];
#else
FFT_TYPE ofdm_diffsymb[2048*2];
#endif

/* Phases for all used dqpsk-symbols
	       Imag
	        2
	     3\	| /1 
	       \|/
	----4-------0----- Real
	       /|\
	     5/ | \7
	        6
 */
FFT_TYPE ofdm_qpsksymbol[16]={
   FFT_ONE,0, onedivsqrt2, onedivsqrt2,  0,FFT_ONE, -onedivsqrt2,onedivsqrt2,
  -FFT_ONE,0, -onedivsqrt2,-onedivsqrt2, 0,-FFT_ONE, onedivsqrt2,-onedivsqrt2
};

void ofdm_init(void) {
  int i;

  ofdm_initfrqtab(CarrierNbr);
  for (i=0;i<2*2048;i++) ofdm_diffsymb[i]=0;
}

/*
  calculates only <carriers> values from
  2*1..2*2048; 0 is the high frequency modulation Carrier
  this includes FFT-shift. All indices are doubled, cause
  each carrier needs two values, real and imaginary part.
  */
void ofdm_initfrqtab(int carriers) {
  int Q,P,R,count,i,v,dist;

  count=0;
  Q=0;
  v=carriers*4/3; /* virtual carriers */
  dist=v/8;
  for(i=1;i<v;i++) {
    P=(13*Q+v/4-1)%v; /* P is now of 0..(VirtCarriers-1) */
    R=P-v/2;
    if ((R>=-carriers/2) && (R<=carriers/2) && (R!=0)) {
      ofdm_freqtab[count]=2*(ofdm_fftshift(R));
      count++;
    }
    Q=P;
  }
}

/* clears the frequency-space-symbol.
   cause there are only 3/4 of the carriers modified, only these
   are reset to zero. the others will always be zero after init()
*/
void ofdm_clearfreq(FFT_TYPE *fsymbol) {
  int i;
  /* clear destination (main carrier) */
  fsymbol[0]=0;
  fsymbol[1]=0;
  /* clear destination (between right and left subband) */
  for (i=CarrierNbr+2;i<(VirtualCarriers*5)/4;i++) fsymbol[i]=0;
}


/* 
   data: is the data for the new symbol, size WordsPerDSymb

   dest: is the destination for the timedomain symbol,
   size SymbolSize

   real and imaginary part are written in consecutive words,
   real part first.
 */
void ofdm_dqpsk(WORD *data,FFT_TYPE *dest) {
  int i,j,k;
  WORD real,imag;
  FFT_TYPE ar,ai;

#ifdef COFDM_PROFILE
  prof_start(profile_dqpsk);
#endif

  ofdm_clearfreq(dest);
  /* qpsk-mapper + frequencyinterleaving + differential modulation
     the first Carrier/2 bits of data are realpart, the
     second Carrier/2 bits the imaginary part
     */
  for(i=0;i<CarrierNbr/32;i++) {
    real=*data;
    imag=*(data+WordsPerDSymb/2);
    data++;

    for (k=0;k<32;k++) {
      /* qpsk-mapper */
      ar=ai=onedivsqrt2;
      ar*=(1-2*(real>0x7fffffff));
      ai*=(1-2*(imag>0x7fffffff));
      /* freqint index */
      j=ofdm_frqtab((i<<5)+k);
      
      /* differential modulation + operand store */
      dest[j]=((ar*ofdm_diffsymb[j])-(ai*ofdm_diffsymb[j+1]));
      dest[j+1]=((ar*ofdm_diffsymb[j+1])+(ai*ofdm_diffsymb[j]));
      /* _complex_mul(ar,ai,ofdm_diffsymb[j],ofdm_diffsymb[j+1],dest[j],dest[j+1]);
       */

      /*
	printf("i%4d j%4d  dibit%d%d  diffsymb %4.2f+(%4.2fj)  qpsk %4.2f+(%4.2fj)   result %4.2f+(%4.2fj)\n",i,j,(real&0x80000000)>0,(imag&0x80000000)>0,ofdm_diffsymb[j],ofdm_diffsymb[j+1],tmp[0],tmp[1],dest[j],dest[j+1]);
	*/
      
      /* copy differential symbol */
      ofdm_diffsymb[j]=dest[j];
      ofdm_diffsymb[j+1]=dest[j+1];
      
      real<<=1;
      imag<<=1;
    }
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}

ofdm_protintervall(int *symb) {
  int i;

  for(i=0;i<2*ProtIntervall;i++)
    symb[i]=symb[i+VirtualCarriers*2];
}
