

/*

  Transmission Frame Phase Reference Symbol

  This routines generate only the Frequency Symbol

  i is calculated from k - no table needed
 */

#include "ofdm.h"
#include "parameters.h"
#include "fft_burrus.h"

/* refers to alt1_ofdm.c */
extern FFT_TYPE ofdm_diffsymb[];

BYTE *tfpr_n;

BYTE tfpr_nmode1[48]={
  1,2,0,1,3,2,2,3,2,1,2,3,1,2,3,3,2,2,2,1,1,3,1,2,
  3,1,1,1,2,2,1,0,2,2,3,3,0,2,1,3,3,3,3,0,3,0,1,1 };
BYTE tfpr_nmode2[12]={ 2,3,2,2,1,2,0,2,2,1,0,3 };
BYTE tfpr_nmode3[6]= { 2,3,0,2,2,2 };
BYTE tfpr_nmode4[24]={ 0,1,1,2,2,2,0,3,3,1,3,2,0,1,0,2,0,1,2,2,2,1,3,0 };

BYTE tfpr_h[4*32]={
  0,2,0,0,0,0,1,1,2,0,0,0,2,2,1,1,0,2,0,0,0,0,1,1,2,0,0,0,2,2,1,1,
  0,3,2,3,0,1,3,0,2,1,2,3,2,3,3,0,0,3,2,3,0,1,3,0,2,1,2,3,2,3,3,0,
  0,0,0,2,0,2,1,3,2,2,0,2,2,0,1,3,0,0,0,2,0,2,1,3,2,2,0,2,2,0,1,3,
  0,1,2,1,0,3,3,2,2,3,2,1,2,1,3,2,0,1,2,1,0,3,3,2,2,3,2,1,2,1,3,2
};

void tfpr_init(void) {
  switch(DABMode) {
  case 1:
    tfpr_n=tfpr_nmode1;
    break;
  case 2:
    tfpr_n=tfpr_nmode2;
    break;
  case 3:
    tfpr_n=tfpr_nmode3;
    break;
  case 4:
    tfpr_n=tfpr_nmode4;
  }
}


/* calculation of the phase from the carrierindex */

/* this definition is in ofdm.h and repeated for convenience
   this accepts carrierindices of 0 to CarrierNbr-1   
   #define tfpr_phiN(x) (tfpr_phi(((x)-CarrierNbr/2)+((x)>CarrierNbr/2)))
   */

/* accepts carrierindices of -768 to 768 */
int tfpr_phi(int k) {
  int i,h,n;

  if (k==0) {
    return(0);
  } else if (k<0) {
    i=3-(((-k-1)/32)%4);
    h=tfpr_h[i*32+(((k+1)%32)+31)];
    n=tfpr_n[(k+CarrierNbr/2)/32];
  } else if (k>0) {
    i=3-(((k+95)/32)%4);
    h=tfpr_h[i*32+((k-1)%32)];
    n=tfpr_n[(k-1+CarrierNbr/2)/32];
  }
  return(((h+n)%4)<<1);
}



/* the TFPR - routine serves two purposes
   first, the tfprsymbol must be generated
   second, the predecessing (differential) symbol must be set.
 */
void TFPR_Symbol(FFT_TYPE *dest) {
  int i,j,l,k;

  ofdm_clearfreq(dest);

  for (i=0;i<CarrierNbr;i++) {

    /* Carrier index calculation */
    l=ofdm_realtraegermap(i);
    /* Symbol-offset */
    j=2*ofdm_fftshift(l);
    /* calculate coded phase */
    k=2*tfpr_phi(l);

    /* storing real */
    ofdm_diffsymb[j]=ofdm_qpsksymbol[k];
    dest[j]=ofdm_qpsksymbol[k];
    k++;
    j++;
    /* storing imag */
    ofdm_diffsymb[j]=ofdm_qpsksymbol[k];
    dest[j]=ofdm_qpsksymbol[k];
  }
}


/* this routine inits only the differential symbol
   (in case you stored the TFPR-Symbol permanent in memory)
 */
void ofdm_initdiffmod(void) {
  int i,j;
  
  /* set up diffsymb */
  for(i=0;i<CarrierNbr;i++) {
    j=ofdm_frqtab(i);              /* frq_index */
    j=(((j/2)+CarrierNbr/2)%VirtualCarriers)-CarrierNbr/2; 
    ofdm_diffsymb[i]=tfpr_phi(j); /* calculate phase */
  }
}

