

/*


  Transmitter Identification Information
  standard NULL-symbol

  This Routine generates only the Frequency Symbol

  (there's a speedup, if the Nullsymbol is stored
  permanently in memory. same for TII or TFPR symbol.)
  */

#include "parameters.h"
#include "ofdm.h"
#include "fft.h"

/* tables may be calculated (but that's time consuming)*/
/* mode 1,2,4 */
BYTE ofdm_TII[70]={
  240,232,228,226,225,216,212,210,209,204,202,201,
  198,197,195,184,180,178,177,172,170,169,166,165,
  163,156,154,153,150,149,147,142,141,139,135,120,
  116,114,113,108,106,105,102,101,99,92,90,89,86,
  85,83,78,77,75,71,60,58,57,54,53,51,46,45,43,39,30,29,27,23,15
};

/* mode 3 */
BYTE ofdm_TII3[6]={ 12,10,6,7,5,3 };


/* what do you expected ? 
*/
void Null_symbol(FFT_TYPE *dest) {
  int i;

  for(i=0;i<NullSymbLen;i++) dest[i]=0;
}

/* subroutine sets two adjacent carriers with given carrierindex k */
void TII_setcarriers(int k,FFT_TYPE *dest) {
  int j,l;

  j=2*ofdm_fftshift(k); /* fftshift+ real/imag-expand */
  l=tfpr_phi(k);
  dest[j]=ofdm_qpsksymbol[2*l];
  dest[j+2]=ofdm_qpsksymbol[2*l];
  dest[j+1]=ofdm_qpsksymbol[2*l+1];
  dest[j+3]=ofdm_qpsksymbol[2*l+1];
}

/*
   requires the frequency-interleaving-tabs
   requires the TFPR-Tabs - cause the TII-Symbol consists
   of selected carriers of the TFPR-Symbol
*/
void TII_symbol(int comb,int pattern,FFT_TYPE *dest) {
  int i,j,k,l,a;
  
  if ((comb>23) || (pattern>69)) {
    myprintf("error: comb or pattern out of range\n");
    Null_symbol(dest);
    return;
  }
  if ((DABMode==3) && pattern>5) {
    myprintf("error: pattern out of range (mode 3)\n");
    Null_symbol(dest);
    return;
  }

  switch(DABMode) {
  case 1:
    a=ofdm_TII[pattern];
    for (i=0;i<8;i++) {
      if ((a&(1<<i))>0) {
	k=-768+2*comb+48*i;
	if (k<-384) TII_setcarriers(k,dest);
	k=-384+2*comb+48*i;
	if (k<0) TII_setcarriers(k,dest);
	k=1+2*comb+48*i;
	if (k<=384) TII_setcarriers(k,dest);
	k=385+2*comb+48*i;
	if (k<=768) TII_setcarriers(k,dest);
      }
    }
    break;
  case 2:
    a=ofdm_TII[pattern];
    for (i=0;i<8;i++) {
      if ((a&(1<<i))>0) {
	k=-192+2*comb+48*i+(i>3);
	TII_setcarriers(k,dest);
      }
    }
    break;
  case 3:
    a=ofdm_TII3[pattern];
    for (i=0;i<4;i++) {
      if ((a&(1<<i))>0) {
	k=-96+2*comb+48*i+(i>1);
	TII_setcarriers(k,dest);
      }
    }
    break;
  case 4:
    a=ofdm_TII[pattern];
    for (i=0;i<8;i++) {
      if ((a&(1<<i))>0) {
	k=-384+2*comb+48*i;
	if (k<0) TII_setcarriers(k,dest);
	k=1+2*comb+48*i;
	if (k<=384) TII_setcarriers(k,dest);
      }
    }
  }
}
