

#include "conf.h"
#include "fft.h"
#include "profile.h"

FFT_TYPE FFT_SIN[(5*FFT_MAXSIZE)/4];
FFT_TYPE *fft_SIN;
FFT_TYPE *fft_COS;

void fft_init(int size) {
  int i;

  for(i=0;i<(5*size)/4;i++) {
    FFT_SIN[i]=FFT_ONE*sin(2*M_PI*i/size);
  }
  fft_SIN=FFT_SIN;
  fft_COS=FFT_SIN+size/4;
}


/* straight algorithm (may be speeded up) 
   the input's bits of a will be mirrored. It's easy to extend the
   algorithm to an quad- or Q-reversal.
   a0*2^0+a1*2^1+...+abase*2^base =>> abase*2^0+abase-1*2^1+...+a0*2^base
*/
int bitreversal(int a,int base) {
  int i,b,res=0;

  for (i=0;i<base;i++) {
    b=a/2;
    res=2*res+(a>2*b);
    a=b;
  }
  return(res);
}

/* base is the logarithm log2(N) of the number N of elements in *symb
   though there are two pointers, one for real and one for imaginary
   part, it is assumed that they are spliced together. therefore only
   every second element is taken to calculations.
 */
int fftreversal_r2(FFT_TYPE *symb,int base) {
  int i,j,size;
  FFT_TYPE tmp;

  /* first and last element are never touched. All others can
     be symetrically switched - but i have to check, i switch
     them only once!
   */
#ifdef COFDM_PROFILE
  prof_start(profile_reversal);
#endif
  size=(1<<base);
  for (i=1;i<size;i++) {
    j=bitreversal(i,base);
    if (i<j) {
      tmp=symb[2*i];
      symb[2*i]=symb[2*j];
      symb[2*j]=tmp;

      tmp=symb[2*i+1];
      symb[2*i+1]=symb[2*j+1];
      symb[2*j+1]=tmp;
    }
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}

int quadreversal(int a,int base) {
  int i,b,res=0;

  for (i=0;i<base;i++) {
    b=a/4;
    res=4*res+(a-4*b);
    a=b;
  }
  return(res);
}

/* base is the logarithm log2(N) of the number N of elements in *symb
 */
int fftreversal_r4(FFT_TYPE *symb,int base) {
  int i,j,k,size;
  FFT_TYPE tmp;

#ifdef COFDM_PROFILE
  prof_start(profile_reversal);
#endif
  /* first and last element are never touched. All others can
     be symetrically switched - but i have to check, i switch
     them only once!
   */
  size=(1<<(base*2));
  for (i=1;i<size-1;i++) {
    j=quadreversal(i,base);
    
    if (i<j) {
      tmp=symb[2*i];
      symb[2*i]=symb[2*j];
      symb[2*j]=tmp;
      
      tmp=symb[2*i+1];
      symb[2*i+1]=symb[2*j+1];
      symb[2*j+1]=tmp;
    }
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}
