;***************************************************************
;* TMS320C6x ANSI C Codegen                       Version 1.00 *
;* Date/Time created: Fri Apr  3 11:16:54 1998                 *
;***************************************************************

;***************************************************************
;* GLOBAL FILE PARAMETERS                                      *
;*                                                             *
;*   Architecture    : TMS320C6200                             *
;*   Endian          : Little                                  *
;*   Memory Model    : Small                                   *
;*   Redundant Loops : Enabled                                 *
;*   Pipelining      : Enabled                                 *
;*   Debug Info      : Debug                                   *
;*                                                             *
;***************************************************************

FP	.set	A15
DP	.set	B14
SP	.set	B15

;	ac6x -DARCHC6X -i/import/home.hi213001/guest52/projekt/include -i/usr/local/dsp/c6x_tools/include fft_reversal.c /import/home.hi213001/guest52/projekt/obj/c6x/libCOFDM/fft_reversal.if 
	.file	"fft_reversal.c"
	.file	"/usr/local/dsp/c6x_tools/include/assert.h"
	.file	"/usr/local/dsp/c6x_tools/include/stdarg.h"
	.sym	_va_list,0,18,13,32
	.file	"/usr/local/dsp/c6x_tools/include/stdlib.h"
	.stag	.fake0,64
	.member	_quot,0,4,8,32
	.member	_rem,32,4,8,32
	.eos
	.sym	_div_t,0,8,13,64,.fake0
	.stag	.fake1,128
	.member	_quot,0,5,8,40
	.member	_rem,64,5,8,40
	.eos
	.sym	_ldiv_t,0,8,13,128,.fake1
	.sym	_size_t,0,14,13,32
	.sym	_wchar_t,0,2,13,8
	.file	"/usr/local/dsp/c6x_tools/include/ctype.h"
	.file	"/usr/local/dsp/c6x_tools/include/math.h"
	.file	"/usr/local/dsp/c6x_tools/include/stddef.h"
	.sym	_ptrdiff_t,0,4,13,32
	.file	"/usr/local/dsp/c6x_tools/include/string.h"
	.file	"/usr/local/dsp/c6x_tools/include/errno.h"
	.file	"/usr/local/dsp/c6x_tools/include/setjmp.h"
	.sym	_jmp_buf,0,52,13,416,,13
	.file	"/usr/local/dsp/c6x_tools/include/stdio.h"
	.stag	.fake2,224
	.member	_fd,0,4,8,32
	.member	_buf,32,28,8,32
	.member	_pos,64,28,8,32
	.member	_bufend,96,28,8,32
	.member	_buff_stop,128,28,8,32
	.member	_flags,160,14,8,32
	.member	_index,192,4,8,32
	.eos
	.sym	_FILE,0,8,13,224,.fake2
	.sym	_fpos_t,0,4,13,32
	.stag	.fake3,320
	.member	_name,0,50,8,72,,9
	.member	_flags,80,13,8,16
	.member	_OPEN,96,148,8,32
	.member	_CLOSE,128,148,8,32
	.member	_READ,160,148,8,32
	.member	_WRITE,192,148,8,32
	.member	_LSEEK,224,148,8,32
	.member	_UNLINK,256,148,8,32
	.member	_RENAME,288,148,8,32
	.eos
	.sym	__DEVICE,0,8,13,320,.fake3
	.file	"/usr/local/dsp/c6x_tools/include/time.h"
	.sym	_clock_t,0,14,13,32
	.sym	_time_t,0,14,13,32
	.stag	_tm,288
	.member	_tm_sec,0,14,8,32
	.member	_tm_min,32,4,8,32
	.member	_tm_hour,64,4,8,32
	.member	_tm_mday,96,4,8,32
	.member	_tm_mon,128,4,8,32
	.member	_tm_year,160,4,8,32
	.member	_tm_wday,192,4,8,32
	.member	_tm_yday,224,4,8,32
	.member	_tm_isdst,256,4,8,32
	.eos
	.stag	.fake4,128
	.member	_daylight,0,3,8,16
	.member	_timezone,32,14,8,32
	.member	_tzname,64,50,8,32,,4
	.member	_dstname,96,50,8,32,,4
	.eos
	.sym	_TZ,0,8,13,128,.fake4
	.file	"/import/home.hi213001/guest52/projekt/include/conf.h"
	.sym	_WORD,0,14,13,32
	.sym	_BYTE,0,12,13,8
	.sym	_SHORT,0,13,13,16
	.file	"/import/home.hi213001/guest52/projekt/include/fft.h"
	.file	"/import/home.hi213001/guest52/projekt/include/profile.h"
	.etag	_profile_functions,32
	.member	_calib0,0,4,16,32
	.member	_calib1,1,4,16,32
	.member	_overhead,2,4,16,32
	.member	_suspend,3,4,16,32
	.member	_profile_conv,4,4,16,32
	.member	_profile_convtail,5,4,16,32
	.member	_profile_ifft,6,4,16,32
	.member	_profile_fft,7,4,16,32
	.member	_profile_prbsgenerate,8,4,16,32
	.member	_profile_prbsscramble,9,4,16,32
	.member	_profile_calcpi,10,4,16,32
	.member	_profile_mstsymbol,11,4,16,32
	.member	_profile_ficsymbol,12,4,16,32
	.member	_profile_interleave,13,4,16,32
	.member	_profile_timeconfig,14,4,16,32
	.member	_profile_symbol,15,4,16,32
	.member	_profile_crccalc,16,4,16,32
	.member	_profile_berlekamp,17,4,16,32
	.member	_profile_syndrom,18,4,16,32
	.member	_profile_rscorrect,19,4,16,32
	.member	_profile_dqpsk,20,4,16,32
	.member	_profile_program,21,4,16,32
	.member	_profile_reversal,22,4,16,32
	.member	_profile_outinterleave,23,4,16,32
	.eos
	.sym	_profile_funcs,0,10,13,32,_profile_functions
	.stag	_sprof_entry,128
	.member	_count,0,4,8,32
	.member	_start,32,14,8,32
	.member	_cycles,64,14,8,32
	.member	_called_by,96,4,8,32
	.eos
	.sym	_tprof_entry,0,8,13,128,_sprof_entry
	.file	"fft_reversal.c"
	.sect	".text"
	.global	_fft_init
	.sym	_fft_init,_fft_init,32,2,0
	.func	10

;***************************************************************
;* FUNCTION NAME: _fft_init                                    *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           B0,B1,B2,B3,B4,B5,B6,B7,B8,B9,B10,*
;*                           SP                                *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           B0,B1,B2,B3,B4,B5,B6,B7,B8,B9,B10,*
;*                           B14,SP                            *
;*   Local Frame Size  : 0 Args + 8 Auto + 16 Save = 24 byte   *
;***************************************************************
_fft_init:
           STW     .D2     B10,*SP--(24)
           STW     .D2     A10,*+SP(12)
           STW     .D2     A11,*+SP(16)
           STW     .D2     B3,*+SP(20)
	.sym	_size,4,4,17,32
	.sym	_size,4,4,1,32
	.sym	_i,8,4,1,32
	.line	1
;------------------------------------------------------------------------------
;  10 | void fft_init(int size) {
;  11 | int i;
;------------------------------------------------------------------------------
           STW     .D2     A4,*+SP(4)
	.line	4
;------------------------------------------------------------------------------
;  13 | for(i=0;i<(5*size)/4;i++) {
;------------------------------------------------------------------------------
           ZERO    .L1     A0
           STW     .D2     A0,*+SP(8)

           MVK     .S2     5,B5
||         MV      .L2X    A4,B6
           MPYLHU  .M2     B5,B6,B4
           MPYU    .M2     B5,B6,B5
           SHL     .S2     B4,0x10,B4
           ADD     .L2     B5,B4,B4
           SHR     .S2     B4,1,B5
           SHRU    .S2     B5,30,B5
           ADD     .L2     B5,B4,B4

           SHR     .S2     B4,2,B4
||         MV      .L2X    A0,B6
           CMPLT   .L2     B6,B4,B0
   [!B0]   B       .S1     L3
           NOP             4
           MVK     .S2     5,B10
           ; BRANCH OCCURS
L2:        
	.line	5
;------------------------------------------------------------------------------
;  14 | fft_SIN[i]=FFT_ONE*sin(2*M_PI*i/size);
;------------------------------------------------------------------------------
           B       .S1     __F_ITOD
           LDW     .D2     *+SP(8),A4
           NOP             2
           MVK     .S2     RL34,B3
           MVKH    .S2     RL34,B3
RL34:      ; CALL OCCURS
           B       .S1     __D_MUL
           NOP             1

           MVK     .S1     0x401921fb,A5
||         MV      .L2X    A5,B5

           MVK     .S1     0x54442d18,A4
||         MV      .L2X    A4,B4

           MVKH    .S1     0x401921fb,A5
||         MVK     .S2     RL35,B3

           MVKH    .S1     0x54442d18,A4
||         MVKH    .S2     RL35,B3
RL35:      ; CALL OCCURS

           B       .S1     __F_ITOD
||         MV      .L1     A4,A11
           LDW     .D2     *+SP(4),A4
           NOP             2
           MVK     .S2     RL36,B3

           MVKH    .S2     RL36,B3
||         MV      .L1     A5,A10
RL36:      ; CALL OCCURS
           B       .S1     __D_DIV
           NOP             3

           MV      .L2X    A4,B4
||         MVK     .S2     RL37,B3

           MV      .L1     A10,A5
||         MV      .S1     A11,A4
||         MVKH    .S2     RL37,B3
||         MV      .L2X    A5,B5
RL37:      ; CALL OCCURS
           B       .S1     _sin
           NOP             3
           MVK     .S2     RL38,B3
           MVKH    .S2     RL38,B3
RL38:      ; CALL OCCURS
           B       .S1     __D_MUL
           NOP             1

           MVK     .S1     0x40e00000,A5
||         MV      .L2X    A5,B5

           MVK     .S1     0x0,A4
||         MV      .L2X    A4,B4

           MVKH    .S1     0x40e00000,A5
||         MVK     .S2     RL39,B3

           MVKH    .S1     0x0,A4
||         MVKH    .S2     RL39,B3
RL39:      ; CALL OCCURS
           B       .S1     __F_DTOI
           NOP             3
           MVK     .S2     RL40,B3
           MVKH    .S2     RL40,B3
RL40:      ; CALL OCCURS
           LDW     .D2     *+SP(8),A3
           NOP             2
           MVK     .S1     _fft_SIN,A0
           MVKH    .S1     _fft_SIN,A0
           STW     .D1     A4,*+A0[A3]
	.line	4
           LDW     .D2     *+SP(8),A0
           NOP             4
           ADD     .L1     1,A0,A0
           STW     .D2     A0,*+SP(8)
           LDW     .D2     *+SP(4),B5
           NOP             4
           MPYLHU  .M2     B10,B5,B4
           MPYU    .M2     B10,B5,B5
           SHL     .S2     B4,0x10,B4
           ADD     .L2     B5,B4,B5
           SHR     .S2     B5,1,B4
           SHRU    .S2     B4,30,B4
           ADD     .L2     B4,B5,B4

           MV      .L2X    A0,B6
||         SHR     .S2     B4,2,B4
           CMPLT   .L2     B6,B4,B0
   [ B0]   B       .S1     L2
           NOP             5
           ; BRANCH OCCURS
L3:        
	.line	7
;------------------------------------------------------------------------------
;  16 | fft_COS=fft_SIN+size/4;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),B4
           NOP             4
           SHR     .S2     B4,1,B5
           SHRU    .S2     B5,30,B5
           ADD     .L2     B5,B4,B4

           SHR     .S2     B4,2,B4
||         MVK     .S1     _fft_SIN,A3

           MV      .L1X    B4,A0
||         MVKH    .S1     _fft_SIN,A3
           ADDAW   .D1     A3,A0,A0
           MV      .L2X    A0,B4
           STW     .D2     B4,*+B14(_fft_COS)
	.line	8
           LDW     .D2     *+SP(20),B3
           NOP             3
           LDW     .D2     *+SP(12),A10

           B       .S2     B3
||         LDW     .D2     *+SP(16),A11
           LDW     .D2     *++SP(24),B10
           NOP             4
           ; BRANCH OCCURS
	.endfunc	17,004080c00h,24


	.sect	".text"
	.global	_bitreversal
	.sym	_bitreversal,_bitreversal,36,2,0
	.func	25

;***************************************************************
;* FUNCTION NAME: _bitreversal                                 *
;*                                                             *
;*   Regs Modified     : A0,A1,A3,A4,B0,B4,B5,SP               *
;*   Regs Used         : A0,A1,A3,A4,B0,B3,B4,B5,SP            *
;*   Local Frame Size  : 0 Args + 20 Auto + 0 Save = 20 byte   *
;***************************************************************
_bitreversal:
           SUBAW   .D2     SP,5,SP
	.sym	_a,4,4,17,32
	.sym	_base,20,4,17,32
	.sym	_a,4,4,1,32
	.sym	_base,8,4,1,32
	.sym	_i,12,4,1,32
	.sym	_b,16,4,1,32
	.sym	_res,20,4,1,32
	.line	1
;------------------------------------------------------------------------------
;  25 | int bitreversal(int a,int base) {
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	2
;------------------------------------------------------------------------------
;  26 | int i,b,res=0;
;------------------------------------------------------------------------------
           ZERO    .L2     B5
           STW     .D2     B5,*+SP(20)
	.line	4
;------------------------------------------------------------------------------
;  28 | for (i=0;i<base;i++) {
;------------------------------------------------------------------------------
           ZERO    .L1     A0
           STW     .D2     A0,*+SP(12)
           MV      .L2X    A0,B5
           CMPLT   .L2     B5,B4,B0
   [!B0]   B       .S1     L8
           NOP             5
           ; BRANCH OCCURS
L7:        
	.line	5
;------------------------------------------------------------------------------
;  29 | b=a/2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),B4
           NOP             4
           SHRU    .S2     B4,31,B5
           ADD     .L2     B5,B4,B4
           SHR     .S2     B4,1,B4
           STW     .D2     B4,*+SP(16)
	.line	6
;------------------------------------------------------------------------------
;  30 | res=2*res+(a>2*b);
;------------------------------------------------------------------------------
           MV      .L1X    B4,A4
           LDW     .D2     *+SP(4),B4
           NOP             1
           LDW     .D2     *+SP(20),A0
           NOP             1
           SHL     .S1     A4,1,A4

           CMPGT   .L1X    B4,A4,A1
||         ZERO    .S1     A3
   [ A1]   MVK     .S1     1,A3
           ADDAH   .D1     A3,A0,A0
           MV      .L2X    A0,B4
           STW     .D2     B4,*+SP(20)
	.line	7
;------------------------------------------------------------------------------
;  31 | a=b;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),B4
           NOP             4
           STW     .D2     B4,*+SP(4)
	.line	4
           LDW     .D2     *+SP(12),A0
           NOP             4
           ADD     .L1     1,A0,A0
           STW     .D2     A0,*+SP(12)
           LDW     .D2     *+SP(8),A0
           LDW     .D2     *+SP(12),B4
           NOP             4
           CMPLT   .L2X    B4,A0,B0
   [ B0]   B       .S1     L7
           NOP             5
           ; BRANCH OCCURS
L8:        
	.line	9
;------------------------------------------------------------------------------
;  33 | return(res);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(20),A4
           NOP             3
	.line	10
           B       .S2     B3
           NOP             4
           ADDK    .S2     20,SP
           ; BRANCH OCCURS
	.endfunc	34,000000000h,20


	.sect	".text"
	.global	_fftreversal_r2
	.sym	_fftreversal_r2,_fftreversal_r2,36,2,0
	.func	41

;***************************************************************
;* FUNCTION NAME: _fftreversal_r2                              *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Local Frame Size  : 0 Args + 24 Auto + 4 Save = 28 byte   *
;***************************************************************
_fftreversal_r2:
           STW     .D2     B3,*SP--(28)
	.sym	_symb,4,20,17,32
	.sym	_base,20,4,17,32
	.sym	_symb,4,20,1,32
	.sym	_base,8,4,1,32
	.sym	_i,12,4,1,32
	.sym	_j,16,4,1,32
	.sym	_size,20,4,1,32
	.sym	_tmp,24,4,1,32
	.line	1
;------------------------------------------------------------------------------
;  41 | int fftreversal_r2(FFT_TYPE *symb,int base) {
;  42 | int i,j,size;
;  43 | FFT_TYPE tmp;
;  49 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	10
;------------------------------------------------------------------------------
;  50 | prof_start(profile_reversal);
;  51 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_start
           NOP             3
           MVK     .S2     RL41,B3

           MVK     .S1     22,A4
||         MVKH    .S2     RL41,B3
RL41:      ; CALL OCCURS
	.line	12
;------------------------------------------------------------------------------
;  52 | size=(1<<base);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B4
           NOP             3
           MVK     .S2     1,B5
           SHL     .S2     B5,B4,B4
           STW     .D2     B4,*+SP(20)
	.line	13
;------------------------------------------------------------------------------
;  53 | for (i=1;i<size;i++) {
;------------------------------------------------------------------------------
           MVK     .S1     1,A0
           STW     .D2     A0,*+SP(12)
           MV      .L2X    A0,B4
           LDW     .D2     *+SP(20),A0
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [!A1]   B       .S1     L15
           NOP             5
           ; BRANCH OCCURS
L12:        
	.line	14
;------------------------------------------------------------------------------
;  54 | j=bitreversal(i,base);
;------------------------------------------------------------------------------

           B       .S1     _bitreversal
||         LDW     .D2     *+SP(8),B4
           LDW     .D2     *+SP(12),A4
           NOP             2
           MVK     .S2     RL42,B3
           MVKH    .S2     RL42,B3
RL42:      ; CALL OCCURS
           STW     .D2     A4,*+SP(16)
	.line	15
;------------------------------------------------------------------------------
;  55 | if (i<j) {
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(12),B5
           NOP             3
           MV      .L2X    A4,B4
           CMPLT   .L2     B5,B4,B0
   [!B0]   B       .S1     L14
           NOP             5
           ; BRANCH OCCURS
	.line	16
;------------------------------------------------------------------------------
;  56 | tmp=symb[2*i];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),B4
           NOP             3
           SHL     .S2     B5,3,B5
           ADD     .L2     B5,B4,B4
           LDW     .D2     *B4,A0
           NOP             4
           STW     .D2     A0,*+SP(24)
	.line	17
;------------------------------------------------------------------------------
;  57 | symb[2*i]=symb[2*j];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),B5
           NOP             2
           MV      .L2X    A4,B4

           SHL     .S2     B4,3,B4
||         LDW     .D2     *+SP(12),A3
           ADD     .L2     B4,B5,B4
           LDW     .D2     *B4,B4
           NOP             2

           MV      .L1X    B5,A0
||         SHL     .S1     A3,3,A3
           ADD     .L1     A3,A0,A0
           STW     .D1     B4,*A0
	.line	18
;------------------------------------------------------------------------------
;  58 | symb[2*j]=tmp;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),B4
           LDW     .D2     *+SP(4),B5
           LDW     .D2     *+SP(24),A0
           NOP             2
           SHL     .S2     B4,3,B4
           ADD     .L2     B4,B5,B4
           STW     .D2     A0,*B4
	.line	20
;------------------------------------------------------------------------------
;  60 | tmp=symb[2*i+1];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(12),B4
           NOP             1
           LDW     .D2     *+SP(4),A0
           NOP             2
           SHL     .S2     B4,1,B4
           ADD     .L1X    1,B4,A3
           LDW     .D1     *+A0[A3],A0
           NOP             4
           STW     .D2     A0,*+SP(24)
	.line	21
;------------------------------------------------------------------------------
;  61 | symb[2*i+1]=symb[2*j+1];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),B4
           NOP             1
           LDW     .D2     *+SP(4),B5
           NOP             2

           LDW     .D2     *+SP(12),A3
||         SHL     .S2     B4,1,B4
           ADD     .L2     1,B4,B4
           LDW     .D2     *+B5[B4],B4
           NOP             2
           SHL     .S1     A3,1,A3

           MV      .L1X    B5,A0
||         ADD     .S1     1,A3,A3
           STW     .D1     B4,*+A0[A3]
	.line	22
;------------------------------------------------------------------------------
;  62 | symb[2*j+1]=tmp;
;  65 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),A3
           LDW     .D2     *+SP(4),A0
           LDW     .D2     *+SP(24),A4
           NOP             2
           SHL     .S1     A3,1,A3
           ADD     .L1     1,A3,A3
           STW     .D1     A4,*+A0[A3]
L14:        
	.line	13
           LDW     .D2     *+SP(12),B4
           NOP             4
           ADD     .L2     1,B4,B4
           STW     .D2     B4,*+SP(12)
           LDW     .D2     *+SP(20),A0
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [ A1]   B       .S1     L12
           NOP             5
           ; BRANCH OCCURS
L15:        
	.line	26
;------------------------------------------------------------------------------
;  66 | prof_stop();
;  67 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_stop
           NOP             3
           MVK     .S2     RL43,B3
           MVKH    .S2     RL43,B3
RL43:      ; CALL OCCURS
	.line	28
           LDW     .D2     *++SP(28),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	68,000080000h,28


	.sect	".text"
	.global	_quadreversal
	.sym	_quadreversal,_quadreversal,36,2,0
	.func	70

;***************************************************************
;* FUNCTION NAME: _quadreversal                                *
;*                                                             *
;*   Regs Modified     : A0,A1,A3,A4,B0,B4,B5,SP               *
;*   Regs Used         : A0,A1,A3,A4,B0,B3,B4,B5,SP            *
;*   Local Frame Size  : 0 Args + 20 Auto + 0 Save = 20 byte   *
;***************************************************************
_quadreversal:
           SUBAW   .D2     SP,5,SP
	.sym	_a,4,4,17,32
	.sym	_base,20,4,17,32
	.sym	_a,4,4,1,32
	.sym	_base,8,4,1,32
	.sym	_i,12,4,1,32
	.sym	_b,16,4,1,32
	.sym	_res,20,4,1,32
	.line	1
;------------------------------------------------------------------------------
;  70 | int quadreversal(int a,int base) {
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	2
;------------------------------------------------------------------------------
;  71 | int i,b,res=0;
;------------------------------------------------------------------------------
           ZERO    .L2     B5
           STW     .D2     B5,*+SP(20)
	.line	4
;------------------------------------------------------------------------------
;  73 | for (i=0;i<base;i++) {
;------------------------------------------------------------------------------
           ZERO    .L1     A0
           STW     .D2     A0,*+SP(12)
           MV      .L2X    A0,B5
           CMPLT   .L2     B5,B4,B0
   [!B0]   B       .S1     L20
           NOP             5
           ; BRANCH OCCURS
L19:        
	.line	5
;------------------------------------------------------------------------------
;  74 | b=a/4;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),B4
           NOP             4
           SHR     .S2     B4,1,B5
           SHRU    .S2     B5,30,B5
           ADD     .L2     B5,B4,B4
           SHR     .S2     B4,2,B4
           STW     .D2     B4,*+SP(16)
	.line	6
;------------------------------------------------------------------------------
;  75 | res=4*res+(a-4*b);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),A0
           LDW     .D2     *+SP(20),A3
           NOP             4

           MV      .L1X    B4,A4
||         ADDAW   .D1     A0,A3,A0
           SUBAW   .D1     A0,A4,A0
           STW     .D2     A0,*+SP(20)
	.line	7
;------------------------------------------------------------------------------
;  76 | a=b;
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(4)
	.line	4
           LDW     .D2     *+SP(12),B4
           NOP             4
           ADD     .L2     1,B4,B4
           STW     .D2     B4,*+SP(12)
           LDW     .D2     *+SP(8),A0
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [ A1]   B       .S1     L19
           NOP             5
           ; BRANCH OCCURS
L20:        
	.line	9
;------------------------------------------------------------------------------
;  78 | return(res);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(20),A4
           NOP             3
	.line	10
           B       .S2     B3
           NOP             4
           ADDK    .S2     20,SP
           ; BRANCH OCCURS
	.endfunc	79,000000000h,20


	.sect	".text"
	.global	_fftreversal_r4
	.sym	_fftreversal_r4,_fftreversal_r4,36,2,0
	.func	83

;***************************************************************
;* FUNCTION NAME: _fftreversal_r4                              *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Local Frame Size  : 0 Args + 28 Auto + 4 Save = 32 byte   *
;***************************************************************
_fftreversal_r4:
           STW     .D2     B3,*SP--(32)
	.sym	_symb,4,20,17,32
	.sym	_base,20,4,17,32
	.sym	_symb,4,20,1,32
	.sym	_base,8,4,1,32
	.sym	_i,12,4,1,32
	.sym	_j,16,4,1,32
	.sym	_k,20,4,1,32
	.sym	_size,24,4,1,32
	.sym	_tmp,28,4,1,32
	.line	1
;------------------------------------------------------------------------------
;  83 | int fftreversal_r4(FFT_TYPE *symb,int base) {
;  84 | int i,j,k,size;
;  85 | FFT_TYPE tmp;
;  87 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	6
;------------------------------------------------------------------------------
;  88 | prof_start(profile_reversal);
;  89 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_start
           NOP             3
           MVK     .S2     RL44,B3

           MVK     .S1     22,A4
||         MVKH    .S2     RL44,B3
RL44:      ; CALL OCCURS
	.line	12
;------------------------------------------------------------------------------
;  94 | size=(1<<(base*2));
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B4
           NOP             3
           MVK     .S2     1,B5
           SHL     .S2     B4,1,B4
           SHL     .S2     B5,B4,B4
           STW     .D2     B4,*+SP(24)
	.line	13
;------------------------------------------------------------------------------
;  95 | for (i=1;i<size-1;i++) {
;------------------------------------------------------------------------------
           MVK     .S1     1,A0
           STW     .D2     A0,*+SP(12)
           MV      .L1X    B4,A0
           LDW     .D2     *+SP(12),B4
           NOP             3
           SUB     .L1     A0,1,A0
           CMPLT   .L1X    B4,A0,A1
   [!A1]   B       .S1     L27
           NOP             5
           ; BRANCH OCCURS
L24:        
	.line	14
;------------------------------------------------------------------------------
;  96 | j=quadreversal(i,base);
;------------------------------------------------------------------------------

           B       .S1     _quadreversal
||         LDW     .D2     *+SP(8),B4
           LDW     .D2     *+SP(12),A4
           NOP             2
           MVK     .S2     RL45,B3
           MVKH    .S2     RL45,B3
RL45:      ; CALL OCCURS
           STW     .D2     A4,*+SP(16)
	.line	16
;------------------------------------------------------------------------------
;  98 | if (i<j) {
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(12),B5
           NOP             3
           MV      .L2X    A4,B4
           CMPLT   .L2     B5,B4,B0
   [!B0]   B       .S1     L26
           NOP             5
           ; BRANCH OCCURS
	.line	17
;------------------------------------------------------------------------------
;  99 | tmp=symb[2*i];
;------------------------------------------------------------------------------
           MV      .L2     B5,B4
           LDW     .D2     *+SP(4),B5
           NOP             3
           SHL     .S2     B4,3,B4
           ADD     .L2     B4,B5,B4
           LDW     .D2     *B4,A0
           NOP             4
           STW     .D2     A0,*+SP(28)
	.line	18
;------------------------------------------------------------------------------
; 100 | symb[2*i]=symb[2*j];
;------------------------------------------------------------------------------
           MV      .L2X    A4,B4

           SHL     .S2     B4,3,B4
||         LDW     .D2     *+SP(12),A3
           ADD     .L2     B4,B5,B4
           LDW     .D2     *B4,B4
           NOP             2

           MV      .L1X    B5,A0
||         SHL     .S1     A3,3,A3
           ADD     .L1     A3,A0,A0
           STW     .D1     B4,*A0
	.line	19
;------------------------------------------------------------------------------
; 101 | symb[2*j]=tmp;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),B5
           LDW     .D2     *+SP(4),B4
           LDW     .D2     *+SP(28),A0
           NOP             2
           SHL     .S2     B5,3,B5
           ADD     .L2     B5,B4,B4
           STW     .D2     A0,*B4
	.line	21
;------------------------------------------------------------------------------
; 103 | tmp=symb[2*i+1];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(12),B4
           NOP             1
           LDW     .D2     *+SP(4),A0
           NOP             2
           SHL     .S2     B4,1,B4
           ADD     .L1X    1,B4,A3
           LDW     .D1     *+A0[A3],A0
           NOP             4
           STW     .D2     A0,*+SP(28)
	.line	22
;------------------------------------------------------------------------------
; 104 | symb[2*i+1]=symb[2*j+1];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),B5
           LDW     .D2     *+SP(4),B4
           NOP             3

           LDW     .D2     *+SP(12),A3
||         SHL     .S2     B5,1,B5

           ADD     .L2     1,B5,B5
||         MV      .L1X    B4,A0
           LDW     .D2     *+B4[B5],B4
           NOP             2
           SHL     .S1     A3,1,A3
           ADD     .L1     1,A3,A3
           STW     .D1     B4,*+A0[A3]
	.line	23
;------------------------------------------------------------------------------
; 105 | symb[2*j+1]=tmp;
; 108 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),A4
           LDW     .D2     *+SP(4),A3
           LDW     .D2     *+SP(28),A0
           NOP             2
           SHL     .S1     A4,1,A4
           ADD     .L1     1,A4,A4
           STW     .D1     A0,*+A3[A4]
L26:        
	.line	13
           LDW     .D2     *+SP(12),A0
           NOP             4
           ADD     .L1     1,A0,A0
           STW     .D2     A0,*+SP(12)
           LDW     .D2     *+SP(24),B4
           NOP             4

           MV      .L2X    A0,B5
||         SUB     .S2     B4,1,B4
           CMPLT   .L2     B5,B4,B0
   [ B0]   B       .S1     L24
           NOP             5
           ; BRANCH OCCURS
L27:        
	.line	27
;------------------------------------------------------------------------------
; 109 | prof_stop();
; 110 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_stop
           NOP             3
           MVK     .S2     RL46,B3
           MVKH    .S2     RL46,B3
RL46:      ; CALL OCCURS
	.line	29
           LDW     .D2     *++SP(32),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	111,000080000h,32


	.global	_fft_COS
	.bss	_fft_COS,4,4
	.sym	_fft_COS,_fft_COS,20,2,32
	.global	_fft_SIN
	.bss	_fft_SIN,10240,4
	.sym	_fft_SIN,_fft_SIN,52,2,81920,,2560

;******************************************************
;* UNDEFINED EXTERNAL REFERENCES                      *
;******************************************************
	.global	_sin
	.global	_prof_start
	.global	_prof_stop
	.global	__D_DIV
	.global	__F_ITOD
	.global	__D_MUL
	.global	__F_DTOI
