;***************************************************************
;* TMS320C6x ANSI C Codegen                       Version 1.00 *
;* Date/Time created: Fri Apr  3 11:16:43 1998                 *
;***************************************************************

;***************************************************************
;* GLOBAL FILE PARAMETERS                                      *
;*                                                             *
;*   Architecture    : TMS320C6200                             *
;*   Endian          : Little                                  *
;*   Memory Model    : Small                                   *
;*   Redundant Loops : Enabled                                 *
;*   Pipelining      : Enabled                                 *
;*   Debug Info      : Debug                                   *
;*                                                             *
;***************************************************************

FP	.set	A15
DP	.set	B14
SP	.set	B15

;	ac6x -DARCHC6X -i/import/home.hi213001/guest52/projekt/include -i/usr/local/dsp/c6x_tools/include fft_mixed.c /import/home.hi213001/guest52/projekt/obj/c6x/libCOFDM/fft_mixed.if 
	.file	"fft_mixed.c"
	.file	"/usr/local/dsp/c6x_tools/include/assert.h"
	.file	"/usr/local/dsp/c6x_tools/include/stdarg.h"
	.sym	_va_list,0,18,13,32
	.file	"/usr/local/dsp/c6x_tools/include/stdlib.h"
	.stag	.fake0,64
	.member	_quot,0,4,8,32
	.member	_rem,32,4,8,32
	.eos
	.sym	_div_t,0,8,13,64,.fake0
	.stag	.fake1,128
	.member	_quot,0,5,8,40
	.member	_rem,64,5,8,40
	.eos
	.sym	_ldiv_t,0,8,13,128,.fake1
	.sym	_size_t,0,14,13,32
	.sym	_wchar_t,0,2,13,8
	.file	"/usr/local/dsp/c6x_tools/include/ctype.h"
	.file	"/usr/local/dsp/c6x_tools/include/math.h"
	.file	"/usr/local/dsp/c6x_tools/include/stddef.h"
	.sym	_ptrdiff_t,0,4,13,32
	.file	"/usr/local/dsp/c6x_tools/include/string.h"
	.file	"/usr/local/dsp/c6x_tools/include/errno.h"
	.file	"/usr/local/dsp/c6x_tools/include/setjmp.h"
	.sym	_jmp_buf,0,52,13,416,,13
	.file	"/usr/local/dsp/c6x_tools/include/stdio.h"
	.stag	.fake2,224
	.member	_fd,0,4,8,32
	.member	_buf,32,28,8,32
	.member	_pos,64,28,8,32
	.member	_bufend,96,28,8,32
	.member	_buff_stop,128,28,8,32
	.member	_flags,160,14,8,32
	.member	_index,192,4,8,32
	.eos
	.sym	_FILE,0,8,13,224,.fake2
	.sym	_fpos_t,0,4,13,32
	.stag	.fake3,320
	.member	_name,0,50,8,72,,9
	.member	_flags,80,13,8,16
	.member	_OPEN,96,148,8,32
	.member	_CLOSE,128,148,8,32
	.member	_READ,160,148,8,32
	.member	_WRITE,192,148,8,32
	.member	_LSEEK,224,148,8,32
	.member	_UNLINK,256,148,8,32
	.member	_RENAME,288,148,8,32
	.eos
	.sym	__DEVICE,0,8,13,320,.fake3
	.file	"/usr/local/dsp/c6x_tools/include/time.h"
	.sym	_clock_t,0,14,13,32
	.sym	_time_t,0,14,13,32
	.stag	_tm,288
	.member	_tm_sec,0,14,8,32
	.member	_tm_min,32,4,8,32
	.member	_tm_hour,64,4,8,32
	.member	_tm_mday,96,4,8,32
	.member	_tm_mon,128,4,8,32
	.member	_tm_year,160,4,8,32
	.member	_tm_wday,192,4,8,32
	.member	_tm_yday,224,4,8,32
	.member	_tm_isdst,256,4,8,32
	.eos
	.stag	.fake4,128
	.member	_daylight,0,3,8,16
	.member	_timezone,32,14,8,32
	.member	_tzname,64,50,8,32,,4
	.member	_dstname,96,50,8,32,,4
	.eos
	.sym	_TZ,0,8,13,128,.fake4
	.file	"/import/home.hi213001/guest52/projekt/include/conf.h"
	.sym	_WORD,0,14,13,32
	.sym	_BYTE,0,12,13,8
	.sym	_SHORT,0,13,13,16
	.file	"/import/home.hi213001/guest52/projekt/include/fft.h"
	.file	"/import/home.hi213001/guest52/projekt/include/profile.h"
	.etag	_profile_functions,32
	.member	_calib0,0,4,16,32
	.member	_calib1,1,4,16,32
	.member	_overhead,2,4,16,32
	.member	_suspend,3,4,16,32
	.member	_profile_conv,4,4,16,32
	.member	_profile_convtail,5,4,16,32
	.member	_profile_ifft,6,4,16,32
	.member	_profile_fft,7,4,16,32
	.member	_profile_prbsgenerate,8,4,16,32
	.member	_profile_prbsscramble,9,4,16,32
	.member	_profile_calcpi,10,4,16,32
	.member	_profile_mstsymbol,11,4,16,32
	.member	_profile_ficsymbol,12,4,16,32
	.member	_profile_interleave,13,4,16,32
	.member	_profile_timeconfig,14,4,16,32
	.member	_profile_symbol,15,4,16,32
	.member	_profile_crccalc,16,4,16,32
	.member	_profile_berlekamp,17,4,16,32
	.member	_profile_syndrom,18,4,16,32
	.member	_profile_rscorrect,19,4,16,32
	.member	_profile_dqpsk,20,4,16,32
	.member	_profile_program,21,4,16,32
	.member	_profile_reversal,22,4,16,32
	.member	_profile_outinterleave,23,4,16,32
	.eos
	.sym	_profile_funcs,0,10,13,32,_profile_functions
	.stag	_sprof_entry,128
	.member	_count,0,4,8,32
	.member	_start,32,14,8,32
	.member	_cycles,64,14,8,32
	.member	_called_by,96,4,8,32
	.eos
	.sym	_tprof_entry,0,8,13,128,_sprof_entry
	.file	"fft_mixed.c"
	.sect	".text"
	.global	_fft_radix2_step
	.sym	_fft_radix2_step,_fft_radix2_step,32,2,0
	.func	26

;***************************************************************
;* FUNCTION NAME: _fft_radix2_step                             *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           A12,B0,B1,B2,B3,B4,B5,B6,B7,B8,B9,*
;*                           SP                                *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           A12,B0,B1,B2,B3,B4,B5,B6,B7,B8,B9,*
;*                           B14,SP                            *
;*   Local Frame Size  : 0 Args + 16 Auto + 16 Save = 32 byte  *
;***************************************************************
_fft_radix2_step:
           STW     .D2     B3,*SP--(32)
           STW     .D2     A10,*+SP(20)
           STW     .D2     A11,*+SP(24)
           STW     .D2     A12,*+SP(28)
	.sym	_preal,4,20,17,32
	.sym	_pimag,20,20,17,32
	.sym	_size,6,4,17,32
	.sym	_step,22,4,17,32
	.sym	_preal,4,20,1,32
	.sym	_pimag,8,20,1,32
	.sym	_size,12,4,1,32
	.sym	_step,16,4,1,32
	.sym	_i,7,4,4,32
	.sym	_j,25,4,4,32
	.sym	_k,10,4,4,32
	.sym	_alpha,3,4,4,32
	.sym	_u,4,4,4,32
	.sym	_alpha2,23,4,4,32
	.sym	_alpha05,22,4,4,32
	.sym	_wkreal,2,20,4,32
	.sym	_wkimag,9,20,4,32
	.sym	_real,0,20,4,32
	.sym	_imag,1,20,4,32
	.sym	_ar,5,4,4,32
	.sym	_ai,21,4,4,32
	.sym	_br,24,4,4,32
	.sym	_bi,8,4,4,32
	.sym	_cr,11,4,4,32
	.sym	_ci,6,4,4,32
	.line	1
;------------------------------------------------------------------------------
;  26 | void fft_radix2_step(FFT_TYPE *preal,FFT_TYPE *pimag,const int size,  \
;       const int step) {
;  27 | register int i,j,k,alpha,u,alpha2,alpha05;
;  28 | register FFT_TYPE *wkreal,*wkimag,*real,*imag;
;  29 | register FFT_TYPE ar,ai,br,bi,cr,ci;
;------------------------------------------------------------------------------
           STW     .D2     B6,*+SP(16)

           STW     .D2     A6,*+SP(12)
||         MV      .L1X    B4,A0
           STW     .D2     A0,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	6
;------------------------------------------------------------------------------
;  31 | alpha=(2<<step);
;------------------------------------------------------------------------------

           MV      .L1X    B6,A0
||         MVK     .S1     2,A3
           SHL     .S1     A3,A0,A3
	.line	7
;------------------------------------------------------------------------------
;  32 | alpha2=2*alpha;
;------------------------------------------------------------------------------
           SHL     .S2X    A3,1,B7
	.line	8
;------------------------------------------------------------------------------
;  33 | alpha05=alpha/2;
;------------------------------------------------------------------------------
           SHRU    .S1     A3,31,A0
           ADD     .L1     A0,A3,A0
           SHR     .S1     A0,1,A0
           MV      .L2X    A0,B6
	.line	9
;------------------------------------------------------------------------------
;  34 | u=2*FFT_MAXSIZE/alpha;
;------------------------------------------------------------------------------
           B       .S1     __I_DIV
           NOP             3
           MVK     .S2     RL0,B3

           MV      .L2X    A3,B4
||         MVK     .S1     4096,A4
||         MVKH    .S2     RL0,B3
RL0:       ; CALL OCCURS
	.line	10
;------------------------------------------------------------------------------
;  35 | wkreal=fft_COS; /* cos */
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_COS),A2
	.line	11
;------------------------------------------------------------------------------
;  36 | wkimag=fft_SIN;
;------------------------------------------------------------------------------
           MVK     .S1     _fft_SIN,A0
           MVKH    .S1     _fft_SIN,A0
           MV      .L1     A0,A9
	.line	12
;------------------------------------------------------------------------------
;  37 | for (i=0;i<2*size;i+=alpha2) {
;------------------------------------------------------------------------------
           ZERO    .L1     A7
           LDW     .D2     *+SP(12),B4
           NOP             4

           SHL     .S2     B4,1,B4
||         MV      .L2X    A7,B5
           CMPLT   .L2     B5,B4,B0
   [!B0]   B       .S1     L5
           NOP             5
           ; BRANCH OCCURS
L2:        
	.line	13
;------------------------------------------------------------------------------
;  38 | real=preal+i;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),B4
           NOP             3
           MV      .L2X    A7,B5
           ADDAW   .D2     B4,B5,B4
           MV      .L1X    B4,A0
	.line	14
;------------------------------------------------------------------------------
;  39 | imag=pimag+i;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),A5
           NOP             4
           ADDAW   .D1     A5,A7,A1
	.line	17
;------------------------------------------------------------------------------
;  42 | ar=*real;
;------------------------------------------------------------------------------
           LDW     .D1     *A0,A5
	.line	18
;------------------------------------------------------------------------------
;  43 | ai=*imag;
;------------------------------------------------------------------------------
           LDW     .D1     *A1,B5
	.line	19
;------------------------------------------------------------------------------
;  44 | br=real[alpha];
;------------------------------------------------------------------------------
           LDW     .D1     *+A0[A3],B8
           NOP             3
	.line	20
;------------------------------------------------------------------------------
;  45 | bi=imag[alpha];
;------------------------------------------------------------------------------
           LDW     .D1     *+A1[A3],A8
	.line	21
;------------------------------------------------------------------------------
;  46 | *real=(ar+br)/2;
;------------------------------------------------------------------------------
           ADD     .L1X    B8,A5,A6
           SHRU    .S2X    A6,31,B4
           ADD     .L2X    B4,A6,B4
           SHR     .S2     B4,1,B4
           STW     .D1     B4,*A0
	.line	22
;------------------------------------------------------------------------------
;  47 | *imag=(ai+bi)/2;
;------------------------------------------------------------------------------
           ADD     .L1X    A8,B5,A6
           SHRU    .S1     A6,31,A10
           ADD     .L1     A10,A6,A6
           SHR     .S1     A6,1,A6
           STW     .D1     A6,*A1
	.line	23
;------------------------------------------------------------------------------
;  48 | real[alpha]=(ar-br)/2;
;------------------------------------------------------------------------------
           SUB     .L2X    A5,B8,B4
           SHRU    .S2     B4,31,B8
           ADD     .L2     B8,B4,B4
           SHR     .S2     B4,1,B4
           STW     .D1     B4,*+A0[A3]
	.line	24
;------------------------------------------------------------------------------
;  49 | imag[alpha]=(ai-bi)/2;
;------------------------------------------------------------------------------
           SUB     .L1X    B5,A8,A5
           SHRU    .S1     A5,31,A6
           ADD     .L1     A6,A5,A5
           SHR     .S1     A5,1,A5
           STW     .D1     A5,*+A1[A3]
	.line	25
;------------------------------------------------------------------------------
;  50 | k=u;
;------------------------------------------------------------------------------
           MV      .L1     A4,A10
	.line	26
;------------------------------------------------------------------------------
;  51 | for (j=1;j<alpha05;j++) {
;------------------------------------------------------------------------------
           MVK     .S2     1,B9
           CMPLT   .L2     B9,B6,B0
   [!B0]   B       .S1     L4
           NOP             5
           ; BRANCH OCCURS
L3:        
	.line	27
;------------------------------------------------------------------------------
;  52 | real+=2;
;------------------------------------------------------------------------------
           ADD     .L1     8,A0,A0
	.line	28
;------------------------------------------------------------------------------
;  53 | imag+=2;
;------------------------------------------------------------------------------
           ADD     .L1     8,A1,A1
	.line	30
;------------------------------------------------------------------------------
;  55 | br=real[alpha];
;------------------------------------------------------------------------------
           LDW     .D1     *+A0[A3],B8
	.line	31
;------------------------------------------------------------------------------
;  56 | bi=imag[alpha];
;------------------------------------------------------------------------------
           LDW     .D1     *+A1[A3],A8
	.line	33
;------------------------------------------------------------------------------
;  58 | ar=wkreal[k];
;------------------------------------------------------------------------------
           LDW     .D1     *+A2[A10],A5
	.line	34
;------------------------------------------------------------------------------
;  59 | ai=wkimag[k];
;------------------------------------------------------------------------------
           LDW     .D1     *+A9[A10],B5
           NOP             4
	.line	37
;------------------------------------------------------------------------------
;  62 | cr=MUL_SHIFT( ((ar*br)-(ai*bi)) );
;------------------------------------------------------------------------------

           MPYLH   .M2X    B8,A5,B0
||         MPYLH   .M1X    B5,A8,A6

           MPYLH   .M2X    A5,B8,B4
||         MPYLH   .M1X    A8,B5,A11
           NOP             1

           ADD     .L2     B0,B4,B4
||         ADD     .L1     A11,A6,A6

           MPYU    .M2X    B8,A5,B0
||         MPYU    .M1X    A8,B5,A11

           SHL     .S1     A6,0x10,A6
||         SHL     .S2     B4,0x10,B4

           ADD     .L2     B0,B4,B4
||         ADD     .L1     A11,A6,A6
           SUB     .L1X    B4,A6,A6
           SHR     .S1     A6,15,A11
	.line	38
;------------------------------------------------------------------------------
;  63 | ci=MUL_SHIFT( ((ar*bi)+(ai*br)) );
;------------------------------------------------------------------------------

           MPYLH   .M2     B8,B5,B0
||         MPYLH   .M1     A8,A5,A12

           MPYLH   .M1     A5,A8,A6
||         MPYLH   .M2     B5,B8,B4

           MV      .L2X    A5,B8
||         MPYU    .M2     B8,B5,B5

           MPYU    .M2X    A8,B8,B8
||         ADD     .L1     A12,A6,A5
||         ADD     .L2     B0,B4,B4

           SHL     .S1     A5,0x10,A5
||         SHL     .S2     B4,0x10,B4

           ADD     .L1X    B8,A5,A5
||         ADD     .L2     B5,B4,B4
           ADD     .L1X    B4,A5,A5
           SHR     .S1     A5,15,A6
	.line	41
;------------------------------------------------------------------------------
;  66 | ar=*real; /* +1 rounding? */
;------------------------------------------------------------------------------
           LDW     .D1     *A0,A5
           NOP             3
	.line	42
;------------------------------------------------------------------------------
;  67 | ai=*imag; /* +1 rounding? */
;------------------------------------------------------------------------------
           LDW     .D1     *A1,B5
	.line	43
;------------------------------------------------------------------------------
;  68 | *real=(ar+cr)/2;
;------------------------------------------------------------------------------
           ADD     .L1     A11,A5,A8
           SHRU    .S2X    A8,31,B4
           ADD     .L2X    B4,A8,B4
           SHR     .S2     B4,1,B4
           STW     .D1     B4,*A0
	.line	44
;------------------------------------------------------------------------------
;  69 | *imag=(ai+ci)/2;
;------------------------------------------------------------------------------
           ADD     .L1X    A6,B5,A8
           SHRU    .S1     A8,31,A12
           ADD     .L1     A12,A8,A8
           SHR     .S1     A8,1,A8
           STW     .D1     A8,*A1
	.line	45
;------------------------------------------------------------------------------
;  70 | real[alpha]=(ar-cr)/2;
;------------------------------------------------------------------------------
           SUB     .L1     A5,A11,A5
           SHRU    .S1     A5,31,A8
           ADD     .L1     A8,A5,A5
           SHR     .S1     A5,1,A5
           STW     .D1     A5,*+A0[A3]
	.line	46
;------------------------------------------------------------------------------
;  71 | imag[alpha]=(ai-ci)/2;
;------------------------------------------------------------------------------
           SUB     .L2X    B5,A6,B4
           SHRU    .S2     B4,31,B5
           ADD     .L2     B5,B4,B4
           SHR     .S2     B4,1,B4
           STW     .D1     B4,*+A1[A3]
	.line	47
;------------------------------------------------------------------------------
;  72 | k+=u;
;------------------------------------------------------------------------------
           ADD     .L1     A4,A10,A10
	.line	26
           ADD     .L2     1,B9,B9
           CMPLT   .L2     B9,B6,B0
   [ B0]   B       .S1     L3
           NOP             5
           ; BRANCH OCCURS
L4:        
	.line	12
           MV      .L2X    A7,B4
           ADD     .L2     B7,B4,B4
           MV      .L1X    B4,A7
           LDW     .D2     *+SP(12),B4
           NOP             4

           SHL     .S2     B4,1,B4
||         MV      .L2X    A7,B5
           CMPLT   .L2     B5,B4,B0
   [ B0]   B       .S1     L2
           NOP             5
           ; BRANCH OCCURS
L5:        
	.line	50
           LDW     .D2     *+SP(28),A12
           LDW     .D2     *+SP(24),A11
           LDW     .D2     *+SP(20),A10
           LDW     .D2     *++SP(32),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	75,000081c00h,32


	.sect	".text"
	.global	_fft_mixradix_faststep
	.sym	_fft_mixradix_faststep,_fft_mixradix_faststep,32,2,0
	.func	81

;***************************************************************
;* FUNCTION NAME: _fft_mixradix_faststep                       *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           A12,B0,B4,B5,B6,B7,B8,SP          *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           A12,B0,B3,B4,B5,B6,B7,B8,SP       *
;*   Local Frame Size  : 0 Args + 16 Auto + 12 Save = 28 byte  *
;***************************************************************
_fft_mixradix_faststep:
           STW     .D2     A12,*SP--(28)
           STW     .D2     A10,*+SP(20)
           STW     .D2     A11,*+SP(24)
	.sym	_preal,4,20,17,32
	.sym	_pimag,20,20,17,32
	.sym	_size,6,4,17,32
	.sym	_step,22,4,17,32
	.sym	_preal,4,20,1,32
	.sym	_pimag,8,20,1,32
	.sym	_size,12,4,1,32
	.sym	_step,16,4,1,32
	.sym	_i,5,4,4,32
	.sym	_j,16,4,4,32
	.sym	_alpha1,4,4,4,32
	.sym	_alpha2,7,4,4,32
	.sym	_alpha3,6,4,4,32
	.sym	_alpha4,23,4,4,32
	.sym	_alpha05,8,4,4,32
	.sym	_a,0,4,4,32
	.sym	_t1,22,4,4,32
	.sym	_t2,10,4,4,32
	.sym	_t3,20,4,4,32
	.sym	_t4,2,4,4,32
	.sym	_t5,21,4,4,32
	.sym	_t6,11,4,4,32
	.sym	_t7,1,4,4,32
	.sym	_t8,12,4,4,32
	.sym	_real,3,20,4,32
	.sym	_imag,9,20,4,32
	.line	1
;------------------------------------------------------------------------------
;  81 | void fft_mixradix_faststep(FFT_TYPE *preal,FFT_TYPE *pimag,const int  \
;        size,const int step) {
;  82 | register int i,j,alpha1,alpha2,alpha3,alpha4,alpha05;
;  83 | register FFT_TYPE a,t1,t2,t3,t4,t5,t6,t7,t8; /* temporary */
;  84 | register FFT_TYPE *real,*imag;
;------------------------------------------------------------------------------

           STW     .D2     A6,*+SP(12)
||         MV      .L1X    B6,A0

           STW     .D2     A0,*+SP(16)
||         MV      .L2X    A4,B5
           STW     .D2     B5,*+SP(4)
           STW     .D2     B4,*+SP(8)
	.line	6
;------------------------------------------------------------------------------
;  86 | alpha1=2*(1<<(2*step)); /* 2*exp(log(4)*step) */
;------------------------------------------------------------------------------

           MVK     .S2     1,B5
||         MV      .L2X    A0,B4
           SHL     .S2     B4,1,B4
           SHL     .S2     B5,B4,B4
           SHL     .S1X    B4,1,A4
	.line	7
;------------------------------------------------------------------------------
;  87 | alpha2=2*alpha1;
;------------------------------------------------------------------------------
           SHL     .S1     A4,1,A7
	.line	8
;------------------------------------------------------------------------------
;  88 | alpha3=3*alpha1;
;------------------------------------------------------------------------------
           MVK     .S1     3,A3
           MPYLHU  .M1     A3,A4,A0
           MPYU    .M1     A3,A4,A3
           SHL     .S1     A0,0x10,A0
           ADD     .L1     A3,A0,A6
	.line	9
;------------------------------------------------------------------------------
;  89 | alpha4=4*alpha1;
;------------------------------------------------------------------------------
           SHL     .S2X    A4,2,B7
	.line	10
;------------------------------------------------------------------------------
;  90 | alpha05=alpha1/2;
;------------------------------------------------------------------------------
           SHRU    .S1     A4,31,A0
           ADD     .L1     A0,A4,A0
           SHR     .S1     A0,1,A8
	.line	11
;------------------------------------------------------------------------------
;  91 | for (i=0;i<2*size;i+=alpha4) {
;------------------------------------------------------------------------------
           ZERO    .L1     A5
           LDW     .D2     *+SP(12),A0
           NOP             4
           SHL     .S1     A0,1,A0
           CMPLT   .L1     A5,A0,A1
   [!A1]   B       .S1     L11
           NOP             5
           ; BRANCH OCCURS
L8:        
	.line	12
;------------------------------------------------------------------------------
;  92 | real=preal+i;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),A0
           NOP             4
           ADDAW   .D1     A0,A5,A3
	.line	13
;------------------------------------------------------------------------------
;  93 | imag=pimag+i;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),A0
           NOP             4
           ADDAW   .D1     A0,A5,A9
	.line	14
;------------------------------------------------------------------------------
;  94 | for (j=alpha05;j!=0;j--) {
;------------------------------------------------------------------------------
           MV      .L2X    A8,B0
   [!B0]   B       .S1     L10
           NOP             5
           ; BRANCH OCCURS
L9:        
	.line	16
;------------------------------------------------------------------------------
;  96 | t1=(*real); /* ar1 +2 rounding? */
;------------------------------------------------------------------------------
           LDW     .D1     *A3,B6
	.line	17
;------------------------------------------------------------------------------
;  97 | t3=(*imag); /* ai1 +2 rounding? */
;------------------------------------------------------------------------------
           LDW     .D1     *A9,B4
	.line	18
;------------------------------------------------------------------------------
;  98 | a=real[alpha1];   /* ar3 */
;------------------------------------------------------------------------------
           LDW     .D1     *+A3[A4],A0
           NOP             4
	.line	19
;------------------------------------------------------------------------------
;  99 | t2=t1-a;      /* ar1-ar3 */
;------------------------------------------------------------------------------
           SUB     .L1X    B6,A0,A10
	.line	20
;------------------------------------------------------------------------------
; 100 | t1+=a;        /* ar1+ar3 */
;------------------------------------------------------------------------------
           ADD     .L2X    A0,B6,B6
	.line	21
;------------------------------------------------------------------------------
; 101 | a=imag[alpha1]; /* ai3 */
;------------------------------------------------------------------------------
           LDW     .D1     *+A9[A4],A0
           NOP             4
	.line	22
;------------------------------------------------------------------------------
; 102 | t4=t3-a;      /* ai1-ai3 */
;------------------------------------------------------------------------------
           SUB     .L1X    B4,A0,A2
	.line	23
;------------------------------------------------------------------------------
; 103 | t3+=a;        /* ai1+ai3 */
;------------------------------------------------------------------------------
           ADD     .L2X    A0,B4,B4
	.line	24
;------------------------------------------------------------------------------
; 104 | t5=real[alpha2];    /* ar2 */
;------------------------------------------------------------------------------
           LDW     .D1     *+A3[A7],B5
	.line	25
;------------------------------------------------------------------------------
; 105 | t7=imag[alpha2];  /* ai2 */
;------------------------------------------------------------------------------
           LDW     .D1     *+A9[A7],A1
	.line	26
;------------------------------------------------------------------------------
; 106 | a=real[alpha3];    /* ar4 */
;------------------------------------------------------------------------------
           LDW     .D1     *+A3[A6],A0
           NOP             4
	.line	27
;------------------------------------------------------------------------------
; 107 | t6=t5-a;       /* ar2-ar4 */
;------------------------------------------------------------------------------
           SUB     .L1X    B5,A0,A11
	.line	28
;------------------------------------------------------------------------------
; 108 | t5+=a;         /* ar2+ar4 */
;------------------------------------------------------------------------------
           ADD     .L2X    A0,B5,B5
	.line	29
;------------------------------------------------------------------------------
; 109 | a=imag[alpha3];  /* ai4 */
;------------------------------------------------------------------------------
           LDW     .D1     *+A9[A6],A0
           NOP             4
	.line	30
;------------------------------------------------------------------------------
; 110 | t8=t7-a;       /* ai2-ai4 */
;------------------------------------------------------------------------------
           SUB     .L1     A1,A0,A12
	.line	31
;------------------------------------------------------------------------------
; 111 | t7+=a;         /* ai2+ai4 */
;------------------------------------------------------------------------------
           ADD     .L1     A0,A1,A1
	.line	33
;------------------------------------------------------------------------------
; 113 | *real=(t1+t5);          /* store b1 */
;------------------------------------------------------------------------------
           ADD     .L2     B5,B6,B8
           STW     .D1     B8,*A3
	.line	34
;------------------------------------------------------------------------------
; 114 | *imag=(t3+t7);
;------------------------------------------------------------------------------
           ADD     .L1X    A1,B4,A0
           STW     .D1     A0,*A9
	.line	35
;------------------------------------------------------------------------------
; 115 | real[alpha3]=(t2-t8);          /* store b4 */
;------------------------------------------------------------------------------
           SUB     .L1     A10,A12,A0
           STW     .D1     A0,*+A3[A6]
	.line	36
;------------------------------------------------------------------------------
; 116 | imag[alpha3]=(t4+t6);
;------------------------------------------------------------------------------
           ADD     .L1     A11,A2,A0
           STW     .D1     A0,*+A9[A6]
	.line	37
;------------------------------------------------------------------------------
; 117 | real[alpha1]=(t2+t8);          /* store b2 */
;------------------------------------------------------------------------------
           ADD     .L1     A12,A10,A0
           STW     .D1     A0,*+A3[A4]
	.line	38
;------------------------------------------------------------------------------
; 118 | imag[alpha1]=(t4-t6);
;------------------------------------------------------------------------------
           SUB     .L1     A2,A11,A0
           STW     .D1     A0,*+A9[A4]
	.line	39
;------------------------------------------------------------------------------
; 119 | real[alpha2]=(t1-t5);          /* store b3 */
;------------------------------------------------------------------------------
           SUB     .L2     B6,B5,B5
           STW     .D1     B5,*+A3[A7]
	.line	40
;------------------------------------------------------------------------------
; 120 | imag[alpha2]=(t3-t7);
;------------------------------------------------------------------------------
           SUB     .L2X    B4,A1,B4
           STW     .D1     B4,*+A9[A7]
	.line	42
;------------------------------------------------------------------------------
; 122 | real+=2;
;------------------------------------------------------------------------------
           MV      .L2X    A3,B4
           ADD     .L2     8,B4,B4
           MV      .L1X    B4,A3
	.line	43
;------------------------------------------------------------------------------
; 123 | imag+=2;
;------------------------------------------------------------------------------
           ADD     .L1     8,A9,A9
	.line	14
           SUB     .L2     B0,1,B0
   [ B0]   B       .S1     L9
           NOP             5
           ; BRANCH OCCURS
L10:        
	.line	11
           MV      .L2X    A5,B4
           ADD     .L2     B7,B4,B4
           MV      .L1X    B4,A5
           LDW     .D2     *+SP(12),B4
           NOP             4

           MV      .L2X    A5,B4
||         SHL     .S2     B4,1,B5
           CMPLT   .L2     B4,B5,B0
   [ B0]   B       .S1     L8
           NOP             5
           ; BRANCH OCCURS
L11:        
	.line	46
           LDW     .D2     *+SP(20),A10

           B       .S2     B3
||         LDW     .D2     *+SP(24),A11
           LDW     .D2     *++SP(28),A12
           NOP             4
           ; BRANCH OCCURS
	.endfunc	126,000001c00h,28


	.sect	".text"
	.global	_fft_mixradix_twiddle0
	.sym	_fft_mixradix_twiddle0,_fft_mixradix_twiddle0,32,2,0
	.func	130

;***************************************************************
;* FUNCTION NAME: _fft_mixradix_twiddle0                       *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           A12,A13,B0,B1,B2,B3,B4,B5,B6,B7,  *
;*                           B8,B9,B10,B11,SP                  *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           A12,A13,B0,B1,B2,B3,B4,B5,B6,B7,  *
;*                           B8,B9,B10,B11,B14,SP              *
;*   Local Frame Size  : 0 Args + 12 Auto + 28 Save = 40 byte  *
;***************************************************************
_fft_mixradix_twiddle0:
           STW     .D2     B11,*SP--(40)
           STW     .D2     A10,*+SP(16)
           STW     .D2     A11,*+SP(20)
           STW     .D2     A12,*+SP(24)
           STW     .D2     A13,*+SP(28)
           STW     .D2     B3,*+SP(32)
           STW     .D2     B10,*+SP(36)
	.sym	_preal,4,20,17,32
	.sym	_pimag,20,20,17,32
	.sym	_size,6,4,17,32
	.sym	_preal,4,20,1,32
	.sym	_pimag,8,20,1,32
	.sym	_size,12,4,1,32
	.sym	_i,8,4,4,32
	.sym	_tmp,20,4,4,32
	.sym	_ar,0,4,4,32
	.sym	_ai,3,4,4,32
	.sym	_real,19,20,4,32
	.sym	_imag,4,20,4,32
	.sym	_wkreal1_16th,7,4,4,32
	.sym	_wkreal3_16th,5,4,4,32
	.sym	_wkreal9_16th,6,4,4,32
	.sym	_wkimag1_16th,23,4,4,32
	.sym	_wkimag3_16th,21,4,4,32
	.sym	_wkimag9_16th,22,4,4,32
	.line	1
;------------------------------------------------------------------------------
; 130 | void fft_mixradix_twiddle0(FFT_TYPE *preal,FFT_TYPE *pimag,const int  \
;        size) {
; 131 | register int i;
; 132 | register FFT_TYPE tmp,ar,ai;
; 133 | register FFT_TYPE *real,*imag;
; 134 | register FFT_TYPE wkreal1_16th,wkreal3_16th,wkreal9_16th;
; 135 | register FFT_TYPE wkimag1_16th,wkimag3_16th,wkimag9_16th;
;------------------------------------------------------------------------------
           STW     .D2     A6,*+SP(12)
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	8
;------------------------------------------------------------------------------
; 137 | wkreal1_16th=fft_COS[FFT_MAXSIZE/16];
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_COS),B4
           NOP             4
           ADDK    .S2     512,B4
           LDW     .D2     *B4,A7
	.line	9
;------------------------------------------------------------------------------
; 138 | wkimag1_16th=fft_SIN[FFT_MAXSIZE/16];
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_SIN+512),B7
	.line	10
;------------------------------------------------------------------------------
; 139 | wkreal3_16th=fft_COS[3*FFT_MAXSIZE/16];
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_COS),A0
           NOP             4
           ADDK    .S1     1536,A0
           LDW     .D1     *A0,A5
	.line	11
;------------------------------------------------------------------------------
; 140 | wkimag3_16th=fft_SIN[3*FFT_MAXSIZE/16];
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_SIN+1536),B5
	.line	12
;------------------------------------------------------------------------------
; 141 | wkreal9_16th=fft_COS[9*FFT_MAXSIZE/16];
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_COS),B4
           NOP             4
           ADDK    .S2     4608,B4
           LDW     .D2     *B4,A6
	.line	13
;------------------------------------------------------------------------------
; 142 | wkimag9_16th=fft_SIN[9*FFT_MAXSIZE/16];
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_SIN+4608),B6
	.line	20
;------------------------------------------------------------------------------
; 149 | for(i=0;i<2*size;i+=32) {
;------------------------------------------------------------------------------
           ZERO    .L1     A8
           LDW     .D2     *+SP(12),B4
           NOP             4

           SHL     .S2     B4,1,B4
||         MV      .L2X    A8,B0
           CMPLT   .L2     B0,B4,B0
   [!B0]   B       .S1     L15
           NOP             1

           MVK     .S2     23170,B8
||         MVK     .S1     23170,A2

           MVK     .S2     23170,B2
||         MVK     .S1     23170,A1

           MVK     .S1     23170,A11
||         MVK     .S2     23170,B9

           MVK     .S1     23170,A10
||         MVK     .S2     23170,B1
           ; BRANCH OCCURS
L14:        
	.line	21
;------------------------------------------------------------------------------
; 150 | real=preal+i;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),B4
           NOP             3
           MV      .L2X    A8,B0
           ADDAW   .D2     B4,B0,B3
	.line	22
;------------------------------------------------------------------------------
; 151 | imag=pimag+i;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),A0
           NOP             4
           ADDAW   .D1     A0,A8,A4
	.line	24
;------------------------------------------------------------------------------
; 153 | ar=real[10];ai=imag[10]; /* 1/8 N */
;------------------------------------------------------------------------------
           LDW     .D2     *+B3(40),B4
           NOP             4
           MV      .L1X    B4,A0
           LDW     .D1     *+A4(40),A3
           NOP             4
	.line	25
;------------------------------------------------------------------------------
; 154 | real[10]=MUL_SHIFT( ((ar+ai)*onedivsqrt2) );
;------------------------------------------------------------------------------
           ADD     .L1     A3,A0,A9
           MPYLHU  .M2X    B2,A9,B0
           MPYU    .M1X    B2,A9,A9
           SHL     .S2     B0,0x10,B0
           ADD     .L1X    A9,B0,A9
           SHR     .S1     A9,15,A9
           STW     .D2     A9,*+B3(40)
	.line	26
;------------------------------------------------------------------------------
; 155 | imag[10]=MUL_SHIFT( ((ai-ar)*onedivsqrt2) );
;------------------------------------------------------------------------------
           SUB     .L2X    A3,B4,B0
           MPYLHU  .M2     B8,B0,B4
           MPYU    .M2     B8,B0,B0
           SHL     .S2     B4,0x10,B4
           ADD     .L2     B0,B4,B4
           SHR     .S2     B4,15,B4
           STW     .D1     B4,*+A4(40)
	.line	28
;------------------------------------------------------------------------------
; 157 | tmp=-real[12]; /* 1/2 N */
;------------------------------------------------------------------------------
           LDW     .D2     *+B3(48),B4
           NOP             4
           NEG     .L2     B4,B4
	.line	29
;------------------------------------------------------------------------------
; 158 | real[12]=imag[12];
;------------------------------------------------------------------------------
           LDW     .D1     *+A4(48),B0
           NOP             4
           STW     .D2     B0,*+B3(48)
	.line	30
;------------------------------------------------------------------------------
; 159 | imag[12]=tmp;
;------------------------------------------------------------------------------
           STW     .D1     B4,*+A4(48)
	.line	32
;------------------------------------------------------------------------------
; 161 | ar=real[14];ai=imag[14]; /* 3/8 N */
;------------------------------------------------------------------------------
           LDW     .D2     *+B3(56),B4
           NOP             4
           MV      .L1X    B4,A0
           LDW     .D1     *+A4(56),A3
           NOP             4
	.line	33
;------------------------------------------------------------------------------
; 162 | real[14]=MUL_SHIFT( ((ai-ar)*onedivsqrt2) );
;------------------------------------------------------------------------------
           SUB     .L1     A3,A0,A12
           MPYLHU  .M1     A10,A12,A9
           MPYU    .M1     A10,A12,A12
           SHL     .S1     A9,0x10,A9
           ADD     .L1     A12,A9,A9
           SHR     .S2X    A9,15,B4
           STW     .D2     B4,*+B3(56)
	.line	34
;------------------------------------------------------------------------------
; 163 | imag[14]=MUL_SHIFT( ((-ar-ai)*onedivsqrt2) );
;------------------------------------------------------------------------------
           MV      .L2X    A0,B4
           NEG     .L2     B4,B4
           SUB     .L2X    B4,A3,B4
           MPYLHU  .M1X    A11,B4,A0
           MPYU    .M2X    A11,B4,B4
           SHL     .S1     A0,0x10,A0
           ADD     .L1X    B4,A0,A0
           SHR     .S1     A0,15,A0
           STW     .D1     A0,*+A4(56)
	.line	36
;------------------------------------------------------------------------------
; 165 | ar=real[18];ai=imag[18];
;------------------------------------------------------------------------------
           LDW     .D2     *+B3(72),B4
           NOP             4
           MV      .L1X    B4,A0
           LDW     .D1     *+A4(72),A3
           NOP             4
	.line	37
;------------------------------------------------------------------------------
; 166 | real[18]=MUL_SHIFT( ((ar*wkreal1_16th)-(ai*wkimag1_16th)) );
;------------------------------------------------------------------------------

           MPYLH   .M2X    B7,A3,B10
||         MPYLH   .M1X    A7,B4,A9
           MPYLH   .M2X    B4,A7,B4
           MPYLH   .M2X    A3,B7,B0
           NOP             1

           ADD     .L2     B10,B0,B4
||         MV      .S2X    A0,B11
||         ADD     .L1X    A9,B4,A9

           MPYU    .M1X    B7,A3,A12
||         MPYU    .M2X    A7,B11,B0

           SHL     .S2     B4,0x10,B4
||         SHL     .S1     A9,0x10,A9

           ADD     .L1X    B0,A9,A9
||         ADD     .L2X    A12,B4,B4
           SUB     .L2X    A9,B4,B4
           SHR     .S2     B4,15,B4
           STW     .D2     B4,*+B3(72)
	.line	38
;------------------------------------------------------------------------------
; 167 | imag[18]=MUL_SHIFT( ((ar*wkimag1_16th)+(ai*wkreal1_16th)) );
;------------------------------------------------------------------------------

           MPYLH   .M1     A7,A3,A12
||         MV      .L2X    A0,B4

           MPYLH   .M1     A3,A7,A9
||         MPYLH   .M2     B7,B4,B0
           MPYLH   .M2     B4,B7,B4

           ADD     .L1     A12,A9,A0
||         MPYU    .M1X    B7,A0,A9

           MPYU    .M1     A7,A3,A3
||         ADD     .L2     B0,B4,B4

           SHL     .S2     B4,0x10,B4
||         SHL     .S1     A0,0x10,A0

           ADD     .L1     A3,A0,A0
||         ADD     .L2X    A9,B4,B4
           ADD     .L2X    A0,B4,B4
           SHR     .S2     B4,15,B4
           STW     .D1     B4,*+A4(72)
	.line	40
;------------------------------------------------------------------------------
; 169 | ar=real[20];ai=imag[20]; /* 1/8 N */
;------------------------------------------------------------------------------
           LDW     .D2     *+B3(80),B4
           NOP             4
           MV      .L1X    B4,A0
           LDW     .D1     *+A4(80),A3
           NOP             4
	.line	41
;------------------------------------------------------------------------------
; 170 | real[20]=MUL_SHIFT( ((ar+ai)*onedivsqrt2) );
;------------------------------------------------------------------------------
           ADD     .L1     A3,A0,A9
           MPYLHU  .M2X    B9,A9,B4
           MPYU    .M1X    B9,A9,A9
           SHL     .S2     B4,0x10,B4
           ADD     .L1X    A9,B4,A9
           SHR     .S1     A9,15,A9
           STW     .D2     A9,*+B3(80)
	.line	42
;------------------------------------------------------------------------------
; 171 | imag[20]=MUL_SHIFT( ((ai-ar)*onedivsqrt2) );
;------------------------------------------------------------------------------
           MV      .L2X    A0,B4
           SUB     .L2X    A3,B4,B0
           MPYLHU  .M2     B1,B0,B4
           MPYU    .M2     B1,B0,B0
           SHL     .S2     B4,0x10,B4
           ADD     .L2     B0,B4,B4
           SHR     .S2     B4,15,B4
           STW     .D1     B4,*+A4(80)
	.line	44
;------------------------------------------------------------------------------
; 173 | ar=real[22];ai=imag[22];
;------------------------------------------------------------------------------
           LDW     .D2     *+B3(88),B4
           NOP             4
           MV      .L1X    B4,A0
           LDW     .D1     *+A4(88),A3
           NOP             4
	.line	45
;------------------------------------------------------------------------------
; 174 | real[22]=MUL_SHIFT( ((ar*wkreal3_16th)-(ai*wkimag3_16th)) );
;------------------------------------------------------------------------------
           MPYLH   .M2X    B5,A3,B4
           MV      .L2X    A0,B10

           MPYLH   .M1X    A5,B10,A12
||         MPYLH   .M2X    A3,B5,B0
           MPYLH   .M2X    B10,A5,B10

           MPYU    .M1X    B5,A3,A9
||         ADD     .L2     B4,B0,B4
||         MV      .S2X    A0,B11

           MPYU    .M2X    A5,B11,B0
||         ADD     .L1X    A12,B10,A12

           SHL     .S1     A12,0x10,A12
||         SHL     .S2     B4,0x10,B4

           ADD     .L1X    B0,A12,A12
||         ADD     .L2X    A9,B4,B4
           SUB     .L2X    A12,B4,B4
           SHR     .S2     B4,15,B4
           STW     .D2     B4,*+B3(88)
	.line	46
;------------------------------------------------------------------------------
; 175 | imag[22]=MUL_SHIFT( ((ar*wkimag3_16th)+(ai*wkreal3_16th)) );
;------------------------------------------------------------------------------
           MV      .L2X    A0,B4

           MPYLH   .M1     A5,A3,A12
||         MPYLH   .M2     B5,B4,B0

           MPYLH   .M1     A3,A5,A13
||         MPYLH   .M2     B4,B5,B4
           MPYU    .M1     A5,A3,A9

           ADD     .L2     B0,B4,B4
||         ADD     .L1     A12,A13,A0
||         MPYU    .M1X    B5,A0,A3

           SHL     .S2     B4,0x10,B4
||         SHL     .S1     A0,0x10,A0

           ADD     .L1     A9,A0,A0
||         ADD     .L2X    A3,B4,B4
           ADD     .L2X    A0,B4,B4
           SHR     .S2     B4,15,B4
           STW     .D1     B4,*+A4(88)
	.line	48
;------------------------------------------------------------------------------
; 177 | ar=real[26];ai=imag[26];
;------------------------------------------------------------------------------
           LDW     .D2     *+B3(104),B4
           NOP             4
           MV      .L1X    B4,A0
           LDW     .D1     *+A4(104),A3
           NOP             4
	.line	49
;------------------------------------------------------------------------------
; 178 | real[26]=MUL_SHIFT( ((ar*wkreal3_16th)-(ai*wkimag3_16th)) );
;------------------------------------------------------------------------------
           MPYLH   .M2X    B5,A3,B0
           MPYLH   .M2X    A3,B5,B4
           MPYLH   .M1     A0,A5,A12

           MPYLH   .M1     A5,A0,A9
||         MV      .L2X    A0,B10
||         ADD     .S2     B0,B4,B4
           MPYU    .M2X    B5,A3,B0

           MPYU    .M2X    A5,B10,B10
||         ADD     .L1     A9,A12,A9

           SHL     .S1     A9,0x10,A9
||         SHL     .S2     B4,0x10,B4

           ADD     .L2     B0,B4,B4
||         ADD     .L1X    B10,A9,A9
           SUB     .L2X    A9,B4,B4
           SHR     .S2     B4,15,B4
           STW     .D2     B4,*+B3(104)
	.line	50
;------------------------------------------------------------------------------
; 179 | imag[26]=MUL_SHIFT( ((ar*wkimag3_16th)+(ai*wkreal3_16th)) );
;------------------------------------------------------------------------------
           MV      .L2X    A0,B4

           MPYLH   .M1     A5,A3,A12
||         MPYLH   .M2     B4,B5,B10

           MPYLH   .M2     B5,B4,B4
||         MPYLH   .M1     A3,A5,A9
           MV      .L2X    A0,B0

           ADD     .L1     A12,A9,A0
||         MPYU    .M2     B5,B0,B4
||         ADD     .L2     B4,B10,B0
||         MPYU    .M1     A5,A3,A3

           SHL     .S2     B0,0x10,B0
||         SHL     .S1     A0,0x10,A0

           ADD     .L1     A3,A0,A0
||         ADD     .L2     B4,B0,B0
           ADD     .L2X    A0,B0,B4
           SHR     .S2     B4,15,B4
           STW     .D1     B4,*+A4(104)
	.line	52
;------------------------------------------------------------------------------
; 181 | ar=real[28];ai=imag[28];
;------------------------------------------------------------------------------
           LDW     .D2     *+B3(112),B4
           NOP             4
           MV      .L1X    B4,A0
           LDW     .D1     *+A4(112),A3
           NOP             4
	.line	53
;------------------------------------------------------------------------------
; 182 | real[28]=MUL_SHIFT( ((ai-ar)*onedivsqrt2) );
;------------------------------------------------------------------------------
           SUB     .L1     A3,A0,A12
           MPYLHU  .M1     A1,A12,A9
           MPYU    .M1     A1,A12,A12
           SHL     .S1     A9,0x10,A9
           ADD     .L1     A12,A9,A9
           SHR     .S1     A9,15,A9
           STW     .D2     A9,*+B3(112)
	.line	54
;------------------------------------------------------------------------------
; 183 | imag[28]=MUL_SHIFT( ((-ar-ai)*onedivsqrt2) );
;------------------------------------------------------------------------------
           NEG     .L2     B4,B4
           SUB     .L1X    B4,A3,A0
           MPYLHU  .M1     A2,A0,A3
           MPYU    .M1     A2,A0,A0
           SHL     .S1     A3,0x10,A3
           ADD     .L1     A0,A3,A0
           SHR     .S1     A0,15,A0
           STW     .D1     A0,*+A4(112)
	.line	56
;------------------------------------------------------------------------------
; 185 | ar=real[30];ai=imag[30];
;------------------------------------------------------------------------------
           LDW     .D2     *+B3(120),B4
           NOP             4
           MV      .L1X    B4,A0
           LDW     .D1     *+A4(120),A3
           NOP             3
	.line	57
;------------------------------------------------------------------------------
; 186 | real[30]=MUL_SHIFT( ((ar*wkreal9_16th)-(ai*wkimag9_16th)) );
;------------------------------------------------------------------------------
           MPYLH   .M1     A6,A0,A12

           MPYLH   .M2X    B6,A3,B4
||         MPYLH   .M1     A0,A6,A9
           MPYLH   .M2X    A3,B6,B10

           ADD     .L1     A12,A9,A9
||         MV      .L2X    A0,B0

           ADD     .L2     B4,B10,B4
||         MPYU    .M1X    B6,A3,A12
||         MPYU    .M2X    A6,B0,B0

           SHL     .S1     A9,0x10,A9
||         SHL     .S2     B4,0x10,B4

           ADD     .L2X    A12,B4,B4
||         ADD     .L1X    B0,A9,A9
           SUB     .L2X    A9,B4,B4
           SHR     .S2     B4,15,B4
           STW     .D2     B4,*+B3(120)
	.line	58
;------------------------------------------------------------------------------
; 187 | imag[30]=MUL_SHIFT( ((ar*wkimag9_16th)+(ai*wkreal9_16th)) );
;------------------------------------------------------------------------------
           MV      .L2X    A0,B4
           MPYLH   .M2     B6,B4,B0

           MPYLH   .M2     B4,B6,B4
||         MPYLH   .M1     A3,A6,A9
           MPYLH   .M1     A6,A3,A12

           ADD     .L2     B0,B4,B4
||         MV      .S2X    A3,B3

           MPYU    .M2X    A6,B3,B0
||         ADD     .L1     A12,A9,A0
||         MPYU    .M1X    B6,A0,A3

           SHL     .S1     A0,0x10,A0
||         SHL     .S2     B4,0x10,B4

           ADD     .L1X    B0,A0,A0
||         ADD     .L2X    A3,B4,B4
           ADD     .L1X    A0,B4,A0
           SHR     .S1     A0,15,A0
           STW     .D1     A0,*+A4(120)
	.line	20
           MV      .L2X    A8,B4
           ADDK    .S2     32,B4
           MV      .L1X    B4,A8
           LDW     .D2     *+SP(12),B4
           NOP             4

           MV      .L2X    A8,B4
||         SHL     .S2     B4,1,B0
           CMPLT   .L2     B4,B0,B0
   [ B0]   B       .S1     L14
           NOP             5
           ; BRANCH OCCURS
L15:        
	.line	60
           LDW     .D2     *+SP(32),B3
           LDW     .D2     *+SP(28),A13
           LDW     .D2     *+SP(24),A12
           LDW     .D2     *+SP(20),A11
           LDW     .D2     *+SP(16),A10

           B       .S2     B3
||         LDW     .D2     *+SP(36),B10
           LDW     .D2     *++SP(40),B11
           NOP             4
           ; BRANCH OCCURS
	.endfunc	189,00c083c00h,40


	.sect	".text"
	.global	_fft_mixradix_twiddleN
	.sym	_fft_mixradix_twiddleN,_fft_mixradix_twiddleN,32,2,0
	.func	192

;***************************************************************
;* FUNCTION NAME: _fft_mixradix_twiddleN                       *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,B0,B1,B2,B3,B4,  *
;*                           B5,B6,B7,B8,B9,SP                 *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,B0,B1,B2,B3,B4,  *
;*                           B5,B6,B7,B8,B9,B14,SP             *
;*   Local Frame Size  : 0 Args + 88 Auto + 4 Save = 92 byte   *
;***************************************************************
_fft_mixradix_twiddleN:
           STW     .D2     B3,*SP--(92)
	.sym	_preal,4,20,17,32
	.sym	_pimag,20,20,17,32
	.sym	_size,6,4,17,32
	.sym	_step,22,4,17,32
	.sym	_preal,4,20,1,32
	.sym	_pimag,8,20,1,32
	.sym	_size,12,4,1,32
	.sym	_step,16,4,1,32
	.sym	_i,23,4,4,32
	.sym	_j,20,4,1,32
	.sym	_k,24,4,1,32
	.sym	_v,28,4,1,32
	.sym	_u,32,4,1,32
	.sym	_nn,36,4,1,32
	.sym	_n2,40,4,1,32
	.sym	_n05,44,4,1,32
	.sym	_radix,48,4,1,32
	.sym	_radix2,52,4,1,32
	.sym	_radix3,56,4,1,32
	.sym	_wkreal,60,20,1,32
	.sym	_wkimag,64,20,1,32
	.sym	_real,68,20,1,32
	.sym	_imag,72,20,1,32
	.sym	_ar,76,4,1,32
	.sym	_ai,80,4,1,32
	.sym	_br,84,4,1,32
	.sym	_bi,88,4,1,32
	.line	1
;------------------------------------------------------------------------------
; 192 | void fft_mixradix_twiddleN(FFT_TYPE *preal,FFT_TYPE *pimag,const int  \
;        size,const int step) {
;------------------------------------------------------------------------------
           STW     .D2     B6,*+SP(16)

           STW     .D2     A6,*+SP(12)
||         MV      .L1X    B4,A0
           STW     .D2     A0,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	2
;------------------------------------------------------------------------------
; 193 | register int i=0;
; 194 | int j,k,v,u;
; 195 | int nn,n2,n05;
; 196 | int radix,radix2,radix3;
; 197 | FFT_TYPE *wkreal,*wkimag,*real,*imag;
; 198 | FFT_TYPE ar,ai,br,bi;
;------------------------------------------------------------------------------
           ZERO    .L2     B7
	.line	9
;------------------------------------------------------------------------------
; 200 | wkreal=fft_COS; /* cos */
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_COS),B4
           NOP             4
           STW     .D2     B4,*+SP(60)
	.line	10
;------------------------------------------------------------------------------
; 201 | wkimag=fft_SIN; /* sin */
;------------------------------------------------------------------------------
           MVK     .S1     _fft_SIN,A0
           MVKH    .S1     _fft_SIN,A0
           STW     .D2     A0,*+SP(64)
	.line	11
;------------------------------------------------------------------------------
; 202 | nn=4*(1<<(step*2));
;------------------------------------------------------------------------------

           MV      .L1X    B6,A0
||         MVK     .S1     1,A3
           SHL     .S1     A0,1,A0
           SHL     .S1     A3,A0,A0
           SHL     .S1     A0,2,A0
           STW     .D2     A0,*+SP(36)
	.line	12
;------------------------------------------------------------------------------
; 203 | radix=FFT_MAXSIZE/(2*nn);
;------------------------------------------------------------------------------
           B       .S1     __I_DIV
           NOP             2
           MVK     .S2     RL1,B3

           MV      .L2X    A0,B4
||         MVKH    .S2     RL1,B3

           SHL     .S2     B4,1,B4
||         MVK     .S1     2048,A4
RL1:       ; CALL OCCURS
           STW     .D2     A4,*+SP(48)
	.line	13
;------------------------------------------------------------------------------
; 204 | radix2=2*radix;
;------------------------------------------------------------------------------
           MV      .L2X    A4,B4
           SHL     .S2     B4,1,B4
           STW     .D2     B4,*+SP(52)
	.line	14
;------------------------------------------------------------------------------
; 205 | radix3=3*radix;
;------------------------------------------------------------------------------

           MV      .L2X    A4,B4
||         MVK     .S2     3,B5
           MPYLHU  .M2     B5,B4,B6
           MPYU    .M2     B5,B4,B4
           SHL     .S2     B6,0x10,B6
           ADD     .L2     B4,B6,B4
           STW     .D2     B4,*+SP(56)
	.line	15
;------------------------------------------------------------------------------
; 206 | v=5*FFT_MAXSIZE/4;
;------------------------------------------------------------------------------
           MVK     .S2     2560,B4
           STW     .D2     B4,*+SP(28)
	.line	16
;------------------------------------------------------------------------------
; 207 | n2=nn*2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(36),A0
           NOP             4
           SHL     .S1     A0,1,A0
           STW     .D2     A0,*+SP(40)
	.line	17
;------------------------------------------------------------------------------
; 208 | n05=nn/2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(36),A0
           NOP             4
           SHRU    .S1     A0,31,A3
           ADD     .L1     A3,A0,A0
           SHR     .S1     A0,1,A0
           STW     .D2     A0,*+SP(44)
	.line	18
;------------------------------------------------------------------------------
; 209 | real=preal;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),A0
           NOP             4
           STW     .D2     A0,*+SP(68)
	.line	19
;------------------------------------------------------------------------------
; 210 | imag=pimag;
; 211 | #ifdef FFT_PRINT
; 212 | printf("twiddle step%d nn%d v%d radix%d\n",step,nn,v,radix);
; 213 | #endif
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B4
           NOP             4
           STW     .D2     B4,*+SP(72)
	.line	24
;------------------------------------------------------------------------------
; 215 | for(i=0;i<2*size;i+=(8*nn)) {
;------------------------------------------------------------------------------
           ZERO    .L2     B7
           LDW     .D2     *+SP(12),B4
           NOP             4
           SHL     .S2     B4,1,B4
           CMPLT   .L2     B7,B4,B0
   [!B0]   B       .S1     L27
           NOP             5
           ; BRANCH OCCURS
L18:        
	.line	28
;------------------------------------------------------------------------------
; 219 | k=i+n2+2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(40),B4
           NOP             4
           ADD     .L2     B4,B7,B4
           ADD     .L2     2,B4,B4
           STW     .D2     B4,*+SP(24)
	.line	29
;------------------------------------------------------------------------------
; 220 | u=radix2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(52),B4
           NOP             4
           STW     .D2     B4,*+SP(32)
	.line	31
;------------------------------------------------------------------------------
; 222 | for(j=1;j<n05;j++) {
;------------------------------------------------------------------------------
           MVK     .S1     1,A0
           STW     .D2     A0,*+SP(20)
           LDW     .D2     *+SP(44),A0
           LDW     .D2     *+SP(20),B4
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [!A1]   B       .S1     L20
           NOP             5
           ; BRANCH OCCURS
L19:        
	.line	32
;------------------------------------------------------------------------------
; 223 | ar=real[k];ai=imag[k];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A0
           LDW     .D2     *+SP(68),A3
           NOP             4
           LDW     .D1     *+A3[A0],A0
           NOP             4
           STW     .D2     A0,*+SP(76)
           LDW     .D2     *+SP(24),B5
           LDW     .D2     *+SP(72),B4
           NOP             4
           LDW     .D2     *+B4[B5],B4
           NOP             4
           STW     .D2     B4,*+SP(80)
	.line	33
;------------------------------------------------------------------------------
; 224 | br=wkreal[u];bi=wkimag[u];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(32),A3
           LDW     .D2     *+SP(60),A0
           NOP             4
           LDW     .D1     *+A0[A3],A0
           NOP             4
           STW     .D2     A0,*+SP(84)
           LDW     .D2     *+SP(64),B4
           NOP             3
           MV      .L2X    A3,B5
           LDW     .D2     *+B4[B5],B4
           NOP             4
           STW     .D2     B4,*+SP(88)
	.line	34
;------------------------------------------------------------------------------
; 225 | real[k]=MUL_SHIFT( ((ar*br)-(ai*bi)) );
;------------------------------------------------------------------------------

           MV      .L2X    A0,B5
||         LDW     .D2     *+SP(80),A4
           LDW     .D2     *+SP(88),A0
           LDW     .D2     *+SP(76),B4
           NOP             2
           MV      .L2X    A4,B9
           MPYLH   .M2X    A0,B9,B9

           MPYLH   .M2     B4,B5,B8
||         MPYLH   .M1     A4,A0,A5
           MPYLH   .M2     B5,B4,B6

           ADD     .L1X    B9,A5,A4
||         MPYU    .M1     A0,A4,A5
||         LDW     .D2     *+SP(68),A3

           LDW     .D2     *+SP(24),A0
||         ADD     .L2     B6,B8,B5
||         MPYU    .M2     B5,B4,B4

           SHL     .S2     B5,0x10,B5
||         SHL     .S1     A4,0x10,A4

           ADD     .L1     A5,A4,A4
||         ADD     .L2     B4,B5,B5
           SUB     .L2X    B5,A4,B4
           SHR     .S2     B4,15,B4
           STW     .D1     B4,*+A3[A0]
	.line	35
;------------------------------------------------------------------------------
; 226 | imag[k]=MUL_SHIFT( ((ar*bi)+(ai*br)) );
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(80),A0
           LDW     .D2     *+SP(84),A3
           LDW     .D2     *+SP(76),B4
           LDW     .D2     *+SP(88),B5
           NOP             2
           MPYLH   .M1     A3,A0,A5
           MPYLH   .M1     A0,A3,A4
           MPYLH   .M2     B4,B5,B6

           ADD     .L1     A5,A4,A0
||         MPYU    .M1     A3,A0,A3
||         MV      .S1X    B4,A6
||         MPYLH   .M2     B5,B4,B8

           LDW     .D2     *+SP(24),B4
||         MPYU    .M1X    B5,A6,A4

           LDW     .D2     *+SP(72),B5
||         ADD     .L2     B8,B6,B6

           SHL     .S1     A0,0x10,A0
||         SHL     .S2     B6,0x10,B6

           ADD     .L1     A3,A0,A0
||         ADD     .L2X    A4,B6,B6
           ADD     .L2X    A0,B6,B6
           SHR     .S2     B6,15,B6
           STW     .D2     B6,*+B5[B4]
	.line	36
;------------------------------------------------------------------------------
; 227 | k+=2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A0
           NOP             4
           ADD     .L1     2,A0,A0
           STW     .D2     A0,*+SP(24)
	.line	37
;------------------------------------------------------------------------------
; 228 | u+=radix2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(32),A0
           LDW     .D2     *+SP(52),B4
           NOP             4
           ADD     .L1X    B4,A0,A0
           STW     .D2     A0,*+SP(32)
	.line	31
           LDW     .D2     *+SP(20),B4
           NOP             4
           ADD     .L2     1,B4,B4
           STW     .D2     B4,*+SP(20)
           LDW     .D2     *+SP(44),A0
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [ A1]   B       .S1     L19
           NOP             5
           ; BRANCH OCCURS
L20:        
	.line	40
;------------------------------------------------------------------------------
; 231 | ar=-real[k];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),B4
           LDW     .D2     *+SP(68),B5
           NOP             4
           LDW     .D2     *+B5[B4],B4
           NOP             4
           NEG     .L2     B4,B4
           STW     .D2     B4,*+SP(76)
	.line	41
;------------------------------------------------------------------------------
; 232 | real[k]=imag[k];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A3
           LDW     .D2     *+SP(72),A4
           NOP             4
           LDW     .D1     *+A4[A3],A4
           NOP             3
           MV      .L1X    B5,A0
           STW     .D1     A4,*+A0[A3]
	.line	42
;------------------------------------------------------------------------------
; 233 | imag[k]=ar;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(76),B4
           LDW     .D2     *+SP(24),A0
           LDW     .D2     *+SP(72),A3
           NOP             4
           STW     .D1     B4,*+A3[A0]
	.line	43
;------------------------------------------------------------------------------
; 234 | k+=2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A0
           NOP             4
           ADD     .L1     2,A0,A0
           STW     .D2     A0,*+SP(24)
	.line	44
;------------------------------------------------------------------------------
; 235 | u+=radix2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(52),B5
           LDW     .D2     *+SP(32),B4
           NOP             4
           ADD     .L2     B5,B4,B4
           STW     .D2     B4,*+SP(32)
	.line	46
;------------------------------------------------------------------------------
; 237 | for(j=1;j<n05;j++) {
;------------------------------------------------------------------------------
           MVK     .S2     1,B4
           STW     .D2     B4,*+SP(20)
           LDW     .D2     *+SP(44),A0
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [!A1]   B       .S1     L22
           NOP             5
           ; BRANCH OCCURS
L21:        
	.line	47
;------------------------------------------------------------------------------
; 238 | ar=real[k];ai=imag[k];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A0
           LDW     .D2     *+SP(68),A3
           NOP             4
           LDW     .D1     *+A3[A0],A0
           NOP             4
           STW     .D2     A0,*+SP(76)
           LDW     .D2     *+SP(24),B4
           LDW     .D2     *+SP(72),B5
           NOP             4
           LDW     .D2     *+B5[B4],B4
           NOP             4
           STW     .D2     B4,*+SP(80)
	.line	48
;------------------------------------------------------------------------------
; 239 | br=wkreal[u];bi=wkimag[u];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(60),A3
           LDW     .D2     *+SP(32),A0
           NOP             4
           LDW     .D1     *+A3[A0],A0
           NOP             4
           STW     .D2     A0,*+SP(84)
           LDW     .D2     *+SP(64),B5
           LDW     .D2     *+SP(32),B4
           NOP             4
           LDW     .D2     *+B5[B4],B4
           NOP             4
           STW     .D2     B4,*+SP(88)
	.line	49
;------------------------------------------------------------------------------
; 240 | real[k]=MUL_SHIFT( ((ar*br)-(ai*bi)) );
;------------------------------------------------------------------------------

           MV      .L2X    A0,B4
||         LDW     .D2     *+SP(80),A4
           LDW     .D2     *+SP(88),A0
           LDW     .D2     *+SP(76),B5
           NOP             2
           MV      .L2X    A4,B9
           MPYLH   .M2X    A0,B9,B9

           MPYLH   .M2     B5,B4,B8
||         MPYLH   .M1     A4,A0,A5
           MPYLH   .M2     B4,B5,B6

           ADD     .L1X    B9,A5,A4
||         MPYU    .M1     A0,A4,A5
||         LDW     .D2     *+SP(68),A3

           LDW     .D2     *+SP(24),A0
||         ADD     .L2     B6,B8,B4
||         MPYU    .M2     B4,B5,B5

           SHL     .S2     B4,0x10,B4
||         SHL     .S1     A4,0x10,A4

           ADD     .L1     A5,A4,A4
||         ADD     .L2     B5,B4,B4
           SUB     .L2X    B4,A4,B4
           SHR     .S2     B4,15,B4
           STW     .D1     B4,*+A3[A0]
	.line	50
;------------------------------------------------------------------------------
; 241 | imag[k]=MUL_SHIFT( ((ar*bi)+(ai*br)) );
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(80),A0
           LDW     .D2     *+SP(84),A3
           LDW     .D2     *+SP(88),B5
           LDW     .D2     *+SP(76),B4
           NOP             2
           MPYLH   .M1     A3,A0,A5
           MPYLH   .M1     A0,A3,A4
           MPYLH   .M2     B4,B5,B6

           MV      .L1X    B4,A6
||         ADD     .S1     A5,A4,A0
||         MPYU    .M1     A3,A0,A3
||         MPYLH   .M2     B5,B4,B8

           MPYU    .M1X    B5,A6,A4
||         LDW     .D2     *+SP(24),B4

           LDW     .D2     *+SP(72),B5
||         ADD     .L2     B8,B6,B6

           SHL     .S1     A0,0x10,A0
||         SHL     .S2     B6,0x10,B6

           ADD     .L1     A3,A0,A0
||         ADD     .L2X    A4,B6,B6
           ADD     .L2X    A0,B6,B6
           SHR     .S2     B6,15,B6
           STW     .D2     B6,*+B5[B4]
	.line	51
;------------------------------------------------------------------------------
; 242 | k+=2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A0
           NOP             4
           ADD     .L1     2,A0,A0
           STW     .D2     A0,*+SP(24)
	.line	52
;------------------------------------------------------------------------------
; 243 | u+=radix2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(32),A0
           LDW     .D2     *+SP(52),B4
           NOP             4
           ADD     .L1X    B4,A0,A0
           STW     .D2     A0,*+SP(32)
	.line	46
           LDW     .D2     *+SP(20),B4
           NOP             4
           ADD     .L2     1,B4,B4
           STW     .D2     B4,*+SP(20)
           LDW     .D2     *+SP(44),A0
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [ A1]   B       .S1     L21
           NOP             5
           ; BRANCH OCCURS
L22:        
	.line	54
;------------------------------------------------------------------------------
; 245 | u=radix;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(48),B4
           NOP             4
           STW     .D2     B4,*+SP(32)
	.line	55
;------------------------------------------------------------------------------
; 246 | k+=2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),B4
           NOP             4
           ADD     .L2     2,B4,B4
           STW     .D2     B4,*+SP(24)
	.line	56
;------------------------------------------------------------------------------
; 247 | for(j=1;j<nn;j++) {
;------------------------------------------------------------------------------
           MVK     .S1     1,A0
           STW     .D2     A0,*+SP(20)
           LDW     .D2     *+SP(36),A0
           LDW     .D2     *+SP(20),B4
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [!A1]   B       .S1     L24
           NOP             5
           ; BRANCH OCCURS
L23:        
	.line	57
;------------------------------------------------------------------------------
; 248 | ar=real[k];ai=imag[k];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A0
           LDW     .D2     *+SP(68),A3
           NOP             4
           LDW     .D1     *+A3[A0],A0
           NOP             4
           STW     .D2     A0,*+SP(76)
           LDW     .D2     *+SP(24),B4
           LDW     .D2     *+SP(72),B5
           NOP             4
           LDW     .D2     *+B5[B4],B4
           NOP             4
           STW     .D2     B4,*+SP(80)
	.line	58
;------------------------------------------------------------------------------
; 249 | br=wkreal[u];bi=wkimag[u];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(60),A3
           LDW     .D2     *+SP(32),A0
           NOP             4
           LDW     .D1     *+A3[A0],A0
           NOP             4
           STW     .D2     A0,*+SP(84)
           LDW     .D2     *+SP(32),B5
           LDW     .D2     *+SP(64),B4
           NOP             4
           LDW     .D2     *+B4[B5],B4
           NOP             4
           STW     .D2     B4,*+SP(88)
	.line	59
;------------------------------------------------------------------------------
; 250 | real[k]=MUL_SHIFT( ((ar*br)-(ai*bi)) );
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(76),B6

           MV      .L2X    A0,B4
||         LDW     .D2     *+SP(80),A4
           LDW     .D2     *+SP(88),A0
           NOP             3

           MPYLH   .M2     B6,B4,B8
||         MV      .L2X    A4,B9

           MPYLH   .M2X    A0,B9,B9
||         MPYLH   .M1     A4,A0,A5
           MPYLH   .M2     B4,B6,B5

           ADD     .L1X    B9,A5,A4
||         MPYU    .M1     A0,A4,A5
||         LDW     .D2     *+SP(68),A3

           LDW     .D2     *+SP(24),A0
||         ADD     .L2     B5,B8,B4
||         MPYU    .M2     B4,B6,B5

           SHL     .S1     A4,0x10,A4
||         SHL     .S2     B4,0x10,B4

           ADD     .L1     A5,A4,A4
||         ADD     .L2     B5,B4,B4
           SUB     .L2X    B4,A4,B4
           SHR     .S2     B4,15,B4
           STW     .D1     B4,*+A3[A0]
	.line	60
;------------------------------------------------------------------------------
; 251 | imag[k]=MUL_SHIFT( ((ar*bi)+(ai*br)) );
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(84),A3
           LDW     .D2     *+SP(80),A0
           LDW     .D2     *+SP(76),B4
           LDW     .D2     *+SP(88),B5
           NOP             2
           MPYLH   .M1     A0,A3,A4
           MPYLH   .M1     A3,A0,A5

           MPYLH   .M2     B5,B4,B8
||         MPYU    .M1     A3,A0,A3

           MPYLH   .M2     B4,B5,B6
||         MV      .L1X    B4,A6
||         ADD     .S1     A5,A4,A0

           LDW     .D2     *+SP(24),B4
||         MPYU    .M1X    B5,A6,A4

           LDW     .D2     *+SP(72),B5
||         ADD     .L2     B8,B6,B6

           SHL     .S1     A0,0x10,A0
||         SHL     .S2     B6,0x10,B6

           ADD     .L1     A3,A0,A0
||         ADD     .L2X    A4,B6,B6
           ADD     .L2X    A0,B6,B6
           SHR     .S2     B6,15,B6
           STW     .D2     B6,*+B5[B4]
	.line	61
;------------------------------------------------------------------------------
; 252 | k+=2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A0
           NOP             4
           ADD     .L1     2,A0,A0
           STW     .D2     A0,*+SP(24)
	.line	62
;------------------------------------------------------------------------------
; 253 | u+=radix;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(32),A0
           LDW     .D2     *+SP(48),B4
           NOP             4
           ADD     .L1X    B4,A0,A0
           STW     .D2     A0,*+SP(32)
	.line	56
           LDW     .D2     *+SP(20),B4
           NOP             4
           ADD     .L2     1,B4,B4
           STW     .D2     B4,*+SP(20)
           LDW     .D2     *+SP(36),A0
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [ A1]   B       .S1     L23
           NOP             5
           ; BRANCH OCCURS
L24:        
	.line	64
;------------------------------------------------------------------------------
; 255 | u=radix3;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(56),B4
           NOP             4
           STW     .D2     B4,*+SP(32)
	.line	65
;------------------------------------------------------------------------------
; 256 | k+=2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),B4
           NOP             4
           ADD     .L2     2,B4,B4
           STW     .D2     B4,*+SP(24)
	.line	67
;------------------------------------------------------------------------------
; 258 | for(j=1;j<nn;j++) {
;------------------------------------------------------------------------------
           MVK     .S1     1,A0
           STW     .D2     A0,*+SP(20)
           LDW     .D2     *+SP(36),A0
           LDW     .D2     *+SP(20),B4
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [!A1]   B       .S1     L26
           NOP             5
           ; BRANCH OCCURS
L25:        
	.line	68
;------------------------------------------------------------------------------
; 259 | ar=real[k];ai=imag[k];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A0
           LDW     .D2     *+SP(68),A3
           NOP             4
           LDW     .D1     *+A3[A0],A0
           NOP             4
           STW     .D2     A0,*+SP(76)
           LDW     .D2     *+SP(72),A3
           LDW     .D2     *+SP(24),A0
           NOP             4
           LDW     .D1     *+A3[A0],A0
           NOP             4
           STW     .D2     A0,*+SP(80)
	.line	69
;------------------------------------------------------------------------------
; 260 | br=wkreal[u];bi=wkimag[u];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(60),A3
           LDW     .D2     *+SP(32),A0
           NOP             4
           LDW     .D1     *+A3[A0],B4
           NOP             4
           STW     .D2     B4,*+SP(84)
           MV      .L1     A0,A3
           LDW     .D2     *+SP(64),A0
           NOP             4
           LDW     .D1     *+A0[A3],B4
           NOP             4
           STW     .D2     B4,*+SP(88)
	.line	70
;------------------------------------------------------------------------------
; 261 | real[k]=MUL_SHIFT( ((ar*br)-(ai*bi)) );
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(76),B6
           LDW     .D2     *+SP(80),A4
           LDW     .D2     *+SP(88),A0
           LDW     .D2     *+SP(84),B4
           NOP             2
           MV      .L2X    A4,B9
           MPYLH   .M2X    A0,B9,B9

           MPYLH   .M2     B4,B6,B5
||         MPYLH   .M1     A4,A0,A5
           MPYLH   .M2     B6,B4,B8

           LDW     .D2     *+SP(68),A3
||         ADD     .L1X    B9,A5,A4
||         MPYU    .M1     A0,A4,A5

           LDW     .D2     *+SP(24),A0
||         ADD     .L2     B5,B8,B4
||         MPYU    .M2     B4,B6,B5

           SHL     .S1     A4,0x10,A4
||         SHL     .S2     B4,0x10,B4

           ADD     .L1     A5,A4,A4
||         ADD     .L2     B5,B4,B4
           SUB     .L1X    B4,A4,A4
           SHR     .S1     A4,15,A4
           STW     .D1     A4,*+A3[A0]
	.line	71
;------------------------------------------------------------------------------
; 262 | imag[k]=MUL_SHIFT( ((ar*bi)+(ai*br)) );
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(80),A0
           LDW     .D2     *+SP(84),A3
           LDW     .D2     *+SP(88),B5
           LDW     .D2     *+SP(76),B4
           NOP             2
           MPYLH   .M1     A3,A0,A5
           MPYLH   .M1     A0,A3,A4
           MPYLH   .M2     B4,B5,B6

           MPYLH   .M2     B5,B4,B8
||         ADD     .L1     A5,A4,A0
||         MPYU    .M1     A3,A0,A3
||         MV      .S1X    B4,A6

           MPYU    .M1X    B5,A6,A4
||         LDW     .D2     *+SP(24),B4

           LDW     .D2     *+SP(72),B5
||         ADD     .L2     B8,B6,B6

           SHL     .S1     A0,0x10,A0
||         SHL     .S2     B6,0x10,B6

           ADD     .L1     A3,A0,A0
||         ADD     .L2X    A4,B6,B6
           ADD     .L2X    A0,B6,B6
           SHR     .S2     B6,15,B6
           STW     .D2     B6,*+B5[B4]
	.line	72
;------------------------------------------------------------------------------
; 263 | k+=2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A0
           NOP             4
           ADD     .L1     2,A0,A0
           STW     .D2     A0,*+SP(24)
	.line	73
;------------------------------------------------------------------------------
; 264 | u+=radix3;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(32),A0
           LDW     .D2     *+SP(56),A3
           NOP             4
           ADD     .L1     A3,A0,A0
           STW     .D2     A0,*+SP(32)
	.line	74
;------------------------------------------------------------------------------
; 265 | u%=v;
;------------------------------------------------------------------------------
           B       .S1     __I_MOD
           LDW     .D2     *+SP(28),B4
           NOP             2
           MVK     .S2     RL2,B3

           MV      .L1     A0,A4
||         MVKH    .S2     RL2,B3
RL2:       ; CALL OCCURS
           STW     .D2     A4,*+SP(32)
	.line	67
           LDW     .D2     *+SP(20),B4
           NOP             4
           ADD     .L2     1,B4,B4
           STW     .D2     B4,*+SP(20)
           LDW     .D2     *+SP(36),A0
           NOP             4
           CMPLT   .L1X    B4,A0,A1
   [ A1]   B       .S1     L25
           NOP             5
           ; BRANCH OCCURS
L26:        
	.line	24
           LDW     .D2     *+SP(36),B4
           NOP             4
           SHL     .S2     B4,3,B4
           ADD     .L2     B4,B7,B7
           LDW     .D2     *+SP(12),A0
           NOP             4
           SHL     .S1     A0,1,A0
           CMPLT   .L1X    B7,A0,A1
   [ A1]   B       .S1     L18
           NOP             5
           ; BRANCH OCCURS
L27:        
	.line	77
           LDW     .D2     *++SP(92),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	268,000080000h,92


	.sect	".text"
	.global	_fft_mixradix_twiddle
	.sym	_fft_mixradix_twiddle,_fft_mixradix_twiddle,32,2,0
	.func	274

;***************************************************************
;* FUNCTION NAME: _fft_mixradix_twiddle                        *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           A12,A13,A14,B0,B1,B2,B3,B4,B5,B6, *
;*                           B7,B8,B9,B10,SP                   *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           A12,A13,A14,B0,B1,B2,B3,B4,B5,B6, *
;*                           B7,B8,B9,B10,B14,SP               *
;*   Local Frame Size  : 0 Args + 16 Auto + 28 Save = 44 byte  *
;***************************************************************
_fft_mixradix_twiddle:
           STW     .D2     B10,*SP--(44)
           STW     .D2     A10,*+SP(20)
           STW     .D2     A11,*+SP(24)
           STW     .D2     A12,*+SP(28)
           STW     .D2     A13,*+SP(32)
           STW     .D2     A14,*+SP(36)
           STW     .D2     B3,*+SP(40)
	.sym	_preal,4,20,17,32
	.sym	_pimag,20,20,17,32
	.sym	_size,6,4,17,32
	.sym	_step,22,4,17,32
	.sym	_preal,4,20,1,32
	.sym	_pimag,8,20,1,32
	.sym	_size,12,4,1,32
	.sym	_step,16,4,1,32
	.sym	_tmp,0,4,4,32
	.sym	_i,8,4,4,32
	.sym	_j,0,4,4,32
	.sym	_k,21,4,4,32
	.sym	_nn,7,4,4,32
	.sym	_n2,10,4,4,32
	.sym	_v,26,4,4,32
	.sym	_u,4,4,4,32
	.sym	_radix,11,4,4,32
	.sym	_radix2,13,4,4,32
	.sym	_radix3,12,4,4,32
	.sym	_real,23,20,4,32
	.sym	_imag,24,20,4,32
	.sym	_wkreal,9,20,4,32
	.sym	_wkimag,3,20,4,32
	.sym	_ar,22,4,4,32
	.sym	_ai,20,4,4,32
	.sym	_br,5,4,4,32
	.sym	_bi,6,4,4,32
	.line	1
;------------------------------------------------------------------------------
; 274 | void fft_mixradix_twiddle(FFT_TYPE *preal,FFT_TYPE *pimag,const int   \
;       size,const int step) {
; 275 | register int tmp,i,j,k,nn,n2,v,u;
; 276 | register int radix,radix2,radix3;
; 277 | register FFT_TYPE *real,*imag,*wkreal,*wkimag;
; 278 | register FFT_TYPE ar,ai,br,bi;
;------------------------------------------------------------------------------
           STW     .D2     B6,*+SP(16)
           STW     .D2     A6,*+SP(12)
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	7
;------------------------------------------------------------------------------
; 280 | wkreal=fft_COS; /* cos */
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_COS),A9
	.line	8
;------------------------------------------------------------------------------
; 281 | wkimag=fft_SIN; /* sin */
;------------------------------------------------------------------------------
           MVK     .S2     _fft_SIN,B4
           MVKH    .S2     _fft_SIN,B4
           MV      .L1X    B4,A3
	.line	9
;------------------------------------------------------------------------------
; 282 | nn=4*(1<<(step*2));
;------------------------------------------------------------------------------

           MV      .L2     B6,B4
||         MVK     .S2     1,B5
           SHL     .S2     B4,1,B4
           SHL     .S2     B5,B4,B4
           SHL     .S1X    B4,2,A7
	.line	10
;------------------------------------------------------------------------------
; 283 | n2=2*nn;
;------------------------------------------------------------------------------
           SHL     .S1     A7,1,A10
	.line	11
;------------------------------------------------------------------------------
; 284 | radix=FFT_MAXSIZE/(2*nn);
;------------------------------------------------------------------------------
           B       .S1     __I_DIV
           NOP             3

           SHL     .S1     A7,1,A0
||         MVK     .S2     RL3,B3

           MV      .L2X    A0,B4
||         MVKH    .S2     RL3,B3
||         MVK     .S1     2048,A4
RL3:       ; CALL OCCURS
           MV      .L1     A4,A11
	.line	12
;------------------------------------------------------------------------------
; 285 | radix2=2*radix;
;------------------------------------------------------------------------------
           SHL     .S1     A11,1,A13
	.line	13
;------------------------------------------------------------------------------
; 286 | radix3=3*radix;
;------------------------------------------------------------------------------
           MVK     .S1     3,A4
           MPYLHU  .M1     A4,A11,A0
           MPYU    .M1     A4,A11,A4
           SHL     .S1     A0,0x10,A0
           ADD     .L1     A4,A0,A12
	.line	14
;------------------------------------------------------------------------------
; 287 | v=2*FFT_MAXSIZE;
;------------------------------------------------------------------------------
           MVK     .S2     4096,B10
	.line	15
;------------------------------------------------------------------------------
; 288 | real=preal;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),B7
	.line	16
;------------------------------------------------------------------------------
; 289 | imag=pimag;
; 290 | #ifdef FFT_PRINT
; 291 | printf("twiddle step%d nn%d v%d radix%d\n",step,nn,v,radix);
; 292 | #endif
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B8
	.line	20
;------------------------------------------------------------------------------
; 293 | for(i=0;i<2*size;i+=(8*nn)) {
;------------------------------------------------------------------------------
           ZERO    .L1     A8
           LDW     .D2     *+SP(12),B4
           NOP             4
           SHL     .S2     B4,1,B4
           CMPLT   .L1X    A8,B4,A1
   [!A1]   B       .S1     L37
           NOP             5
           ; BRANCH OCCURS
L30:        
	.line	21
;------------------------------------------------------------------------------
; 294 | k=i+n2+2;
;------------------------------------------------------------------------------
           ADD     .L1     A10,A8,A0
           ADD     .L2X    2,A0,B5
	.line	22
;------------------------------------------------------------------------------
; 295 | u=radix2;
;------------------------------------------------------------------------------
           MV      .L1     A13,A4
	.line	24
;------------------------------------------------------------------------------
; 297 | for(j=1;j<nn;j++) {
;------------------------------------------------------------------------------
           MVK     .S1     1,A0
           CMPLT   .L1     A0,A7,A1
   [!A1]   B       .S1     L32
           NOP             5
           ; BRANCH OCCURS
L31:        
	.line	25
;------------------------------------------------------------------------------
; 298 | ar=real[k];ai=imag[k];
;------------------------------------------------------------------------------
           LDW     .D2     *+B7[B5],B6
           LDW     .D2     *+B8[B5],B4
	.line	26
;------------------------------------------------------------------------------
; 299 | br=wkreal[u];bi=wkimag[u];
;------------------------------------------------------------------------------
           LDW     .D1     *+A9[A4],A5
           LDW     .D1     *+A3[A4],A6
           NOP             3
	.line	27
;------------------------------------------------------------------------------
; 300 | real[k]=MUL_SHIFT( ((ar*br)-(ai*bi)) );
;------------------------------------------------------------------------------
           MPYLH   .M1X    A5,B6,A14

           MPYLH   .M1X    B6,A5,A2
||         MPYLH   .M2X    B4,A6,B9

           MPYU    .M2X    A6,B4,B1
||         MPYLH   .M1X    A6,B4,A1
           MPYU    .M2X    A5,B6,B0

           ADD     .L1     A14,A2,A1
||         ADD     .L2X    A1,B9,B9

           SHL     .S1     A1,0x10,A1
||         SHL     .S2     B9,0x10,B9

           ADD     .L1X    B0,A1,A1
||         ADD     .L2     B1,B9,B9
           SUB     .L2X    A1,B9,B9
           SHR     .S2     B9,15,B9
           STW     .D2     B9,*+B7[B5]
	.line	28
;------------------------------------------------------------------------------
; 301 | imag[k]=MUL_SHIFT( ((ar*bi)+(ai*br)) );
;------------------------------------------------------------------------------

           MPYLH   .M2X    A6,B6,B9
||         MPYLH   .M1X    B6,A6,A2

           MPYU    .M1X    A6,B6,A6
||         MPYLH   .M2X    B4,A5,B0
           MPYLH   .M2X    A5,B4,B6
           MPYU    .M1X    A5,B4,A1

           ADD     .L2     B6,B0,B4
||         ADD     .L1X    B9,A2,A5

           SHL     .S2     B4,0x10,B4
||         SHL     .S1     A5,0x10,A5

           ADD     .L2X    A1,B4,B4
||         ADD     .L1     A6,A5,A5
           ADD     .L1X    B4,A5,A5
           SHR     .S1     A5,15,A5
           STW     .D2     A5,*+B8[B5]
	.line	29
;------------------------------------------------------------------------------
; 302 | k+=2;
;------------------------------------------------------------------------------
           ADD     .L2     2,B5,B5
	.line	30
;------------------------------------------------------------------------------
; 303 | u+=radix2;
;------------------------------------------------------------------------------
           ADD     .L1     A13,A4,A4
	.line	24
           ADD     .L1     1,A0,A0
           CMPLT   .L1     A0,A7,A1
   [ A1]   B       .S1     L31
           NOP             5
           ; BRANCH OCCURS
L32:        
	.line	33
;------------------------------------------------------------------------------
; 306 | u=radix;
;------------------------------------------------------------------------------
           MV      .L1     A11,A4
	.line	34
;------------------------------------------------------------------------------
; 307 | k+=2;
;------------------------------------------------------------------------------
           ADD     .L2     2,B5,B5
	.line	35
;------------------------------------------------------------------------------
; 308 | for(j=1;j<nn;j++) {
;------------------------------------------------------------------------------
           MVK     .S1     1,A0
           CMPLT   .L1     A0,A7,A1
   [!A1]   B       .S1     L34
           NOP             5
           ; BRANCH OCCURS
L33:        
	.line	36
;------------------------------------------------------------------------------
; 309 | ar=real[k];ai=imag[k];
;------------------------------------------------------------------------------
           LDW     .D2     *+B7[B5],B6
           LDW     .D2     *+B8[B5],B4
	.line	37
;------------------------------------------------------------------------------
; 310 | br=wkreal[u];bi=wkimag[u];
;------------------------------------------------------------------------------
           LDW     .D1     *+A9[A4],A5
           LDW     .D1     *+A3[A4],A6
           NOP             3
	.line	38
;------------------------------------------------------------------------------
; 311 | real[k]=MUL_SHIFT( ((ar*br)-(ai*bi)) );
;------------------------------------------------------------------------------
           MPYLH   .M1X    A5,B6,A14

           MPYLH   .M1X    B6,A5,A1
||         MPYLH   .M2X    B4,A6,B9

           MPYU    .M2X    A6,B4,B1
||         MPYLH   .M1X    A6,B4,A2
           MPYU    .M2X    A5,B6,B0

           ADD     .L1     A14,A1,A1
||         ADD     .L2X    A2,B9,B9

           SHL     .S2     B9,0x10,B9
||         SHL     .S1     A1,0x10,A1

           ADD     .L1X    B0,A1,A1
||         ADD     .L2     B1,B9,B9
           SUB     .L2X    A1,B9,B9
           SHR     .S2     B9,15,B9
           STW     .D2     B9,*+B7[B5]
	.line	39
;------------------------------------------------------------------------------
; 312 | imag[k]=MUL_SHIFT( ((ar*bi)+(ai*br)) );
;------------------------------------------------------------------------------

           MPYLH   .M2X    B4,A5,B0
||         MPYU    .M1X    A6,B6,A2

           MPYLH   .M2X    A6,B6,B9
||         MPYLH   .M1X    B6,A6,A1
           MPYLH   .M2X    A5,B4,B6
           MPYU    .M1X    A5,B4,A6

           ADD     .L2     B6,B0,B4
||         ADD     .L1X    B9,A1,A5

           SHL     .S2     B4,0x10,B4
||         SHL     .S1     A5,0x10,A5

           ADD     .L2X    A6,B4,B4
||         ADD     .L1     A2,A5,A5
           ADD     .L1X    B4,A5,A5
           SHR     .S1     A5,15,A5
           STW     .D2     A5,*+B8[B5]
	.line	40
;------------------------------------------------------------------------------
; 313 | k+=2;
;------------------------------------------------------------------------------
           ADD     .L2     2,B5,B5
	.line	41
;------------------------------------------------------------------------------
; 314 | u+=radix;
;------------------------------------------------------------------------------
           ADD     .L1     A11,A4,A4
	.line	35
           ADD     .L1     1,A0,A0
           CMPLT   .L1     A0,A7,A1
   [ A1]   B       .S1     L33
           NOP             5
           ; BRANCH OCCURS
L34:        
	.line	43
;------------------------------------------------------------------------------
; 316 | u=radix3;
;------------------------------------------------------------------------------
           MV      .L1     A12,A4
	.line	44
;------------------------------------------------------------------------------
; 317 | k+=2;
;------------------------------------------------------------------------------
           ADD     .L2     2,B5,B5
	.line	46
;------------------------------------------------------------------------------
; 319 | for(j=1;j<nn;j++) {
;------------------------------------------------------------------------------
           MVK     .S1     1,A0
           CMPLT   .L1     A0,A7,A1
   [!A1]   B       .S1     L36
           NOP             5
           ; BRANCH OCCURS
L35:        
	.line	47
;------------------------------------------------------------------------------
; 320 | ar=real[k];ai=imag[k];
;------------------------------------------------------------------------------
           LDW     .D2     *+B7[B5],B6
           LDW     .D2     *+B8[B5],B4
	.line	48
;------------------------------------------------------------------------------
; 321 | br=wkreal[u];bi=wkimag[u];
;------------------------------------------------------------------------------
           LDW     .D1     *+A9[A4],A5
           LDW     .D1     *+A3[A4],A6
           NOP             3
	.line	49
;------------------------------------------------------------------------------
; 322 | real[k]=MUL_SHIFT( ((ar*br)-(ai*bi)) );
;------------------------------------------------------------------------------
           MPYLH   .M1X    A5,B6,A2

           MPYLH   .M1X    B6,A5,A1
||         MPYLH   .M2X    B4,A6,B9

           MPYU    .M2X    A6,B4,B1
||         MPYLH   .M1X    A6,B4,A14
           MPYU    .M2X    A5,B6,B0

           ADD     .L1     A2,A1,A1
||         ADD     .L2X    A14,B9,B9

           SHL     .S2     B9,0x10,B9
||         SHL     .S1     A1,0x10,A1

           ADD     .L1X    B0,A1,A1
||         ADD     .L2     B1,B9,B9
           SUB     .L2X    A1,B9,B9
           SHR     .S2     B9,15,B9
           STW     .D2     B9,*+B7[B5]
	.line	50
;------------------------------------------------------------------------------
; 323 | imag[k]=MUL_SHIFT( ((ar*bi)+(ai*br)) );
;------------------------------------------------------------------------------

           MPYLH   .M2X    A6,B6,B9
||         MPYLH   .M1X    B6,A6,A1

           MPYU    .M1X    A6,B6,A6
||         MPYLH   .M2X    B4,A5,B0
           MPYLH   .M2X    A5,B4,B6
           ADD     .L1X    B9,A1,A1

           ADD     .L2     B6,B0,B4
||         MPYU    .M1X    A5,B4,A5

           SHL     .S2     B4,0x10,B4
||         SHL     .S1     A1,0x10,A1

           ADD     .L2X    A5,B4,B4
||         ADD     .L1     A6,A1,A1
           ADD     .L1X    B4,A1,A5
           SHR     .S1     A5,15,A5
           STW     .D2     A5,*+B8[B5]
	.line	51
;------------------------------------------------------------------------------
; 324 | k+=2;
;------------------------------------------------------------------------------
           ADD     .L2     2,B5,B5
	.line	52
;------------------------------------------------------------------------------
; 325 | u+=radix3;
;------------------------------------------------------------------------------
           ADD     .L1     A12,A4,A4
	.line	53
;------------------------------------------------------------------------------
; 326 | u%=v;
;------------------------------------------------------------------------------
           B       .S1     __I_MOD
           NOP             3
           MVK     .S2     RL4,B3

           MV      .L2     B10,B4
||         MVKH    .S2     RL4,B3
RL4:       ; CALL OCCURS
	.line	46
           ADD     .L1     1,A0,A0
           CMPLT   .L1     A0,A7,A1
   [ A1]   B       .S1     L35
           NOP             5
           ; BRANCH OCCURS
L36:        
	.line	20
           SHL     .S1     A7,3,A0
           ADD     .L1     A0,A8,A8
           LDW     .D2     *+SP(12),B4
           NOP             4
           SHL     .S2     B4,1,B4
           CMPLT   .L1X    A8,B4,A1
   [ A1]   B       .S1     L30
           NOP             5
           ; BRANCH OCCURS
L37:        
	.line	56
           LDW     .D2     *+SP(40),B3
           LDW     .D2     *+SP(32),A13
           LDW     .D2     *+SP(28),A12
           LDW     .D2     *+SP(24),A11
           LDW     .D2     *+SP(20),A10

           B       .S2     B3
||         LDW     .D2     *+SP(36),A14
           LDW     .D2     *++SP(44),B10
           NOP             4
           ; BRANCH OCCURS
	.endfunc	329,004087c00h,44


	.sect	".text"
	.global	_fft_mixradix
	.sym	_fft_mixradix,_fft_mixradix,32,2,0
	.func	332

;***************************************************************
;* FUNCTION NAME: _fft_mixradix                                *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Local Frame Size  : 0 Args + 8 Auto + 4 Save = 12 byte    *
;***************************************************************
_fft_mixradix:
           STW     .D2     B3,*SP--(12)
	.sym	_symb,4,20,17,32
	.sym	_base,20,4,17,32
	.sym	_symb,4,20,1,32
	.sym	_base,8,4,1,32
	.line	1
;------------------------------------------------------------------------------
; 332 | void fft_mixradix(FFT_TYPE *symb,int base) {
; 333 | #ifdef FFT_PRINT
; 334 | printf("fft\n");
; 335 | #endif
; 336 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	6
;------------------------------------------------------------------------------
; 337 | prof_start(profile_fft);
; 338 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_start
           NOP             3
           MVK     .S2     RL5,B3

           MVK     .S1     7,A4
||         MVKH    .S2     RL5,B3
RL5:       ; CALL OCCURS
	.line	8
;------------------------------------------------------------------------------
; 339 | _fft_mixradix(symb,symb+1,base);
; 340 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),A6

           B       .S1     __fft_mixradix
||         LDW     .D2     *+SP(4),B4
           LDW     .D2     *+SP(4),A4
           NOP             2
           MVK     .S2     RL6,B3

           ADD     .L2     4,B4,B4
||         MVKH    .S2     RL6,B3
RL6:       ; CALL OCCURS
	.line	10
;------------------------------------------------------------------------------
; 341 | prof_stop();
; 342 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_stop
           NOP             3
           MVK     .S2     RL7,B3
           MVKH    .S2     RL7,B3
RL7:       ; CALL OCCURS
	.line	12
           LDW     .D2     *++SP(12),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	343,000080000h,12


	.sect	".text"
	.global	_ifft_mixradix
	.sym	_ifft_mixradix,_ifft_mixradix,32,2,0
	.func	345

;***************************************************************
;* FUNCTION NAME: _ifft_mixradix                               *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Local Frame Size  : 0 Args + 8 Auto + 4 Save = 12 byte    *
;***************************************************************
_ifft_mixradix:
           STW     .D2     B3,*SP--(12)
	.sym	_symb,4,20,17,32
	.sym	_base,20,4,17,32
	.sym	_symb,4,20,1,32
	.sym	_base,8,4,1,32
	.line	1
;------------------------------------------------------------------------------
; 345 | void ifft_mixradix(FFT_TYPE *symb,int base) {
; 346 | #ifdef FFT_PRINT
; 347 | printf("ifft\n");
; 348 | #endif
; 349 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	6
;------------------------------------------------------------------------------
; 350 | prof_start(profile_ifft);
; 351 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_start
           NOP             3
           MVK     .S2     RL8,B3

           MVK     .S1     6,A4
||         MVKH    .S2     RL8,B3
RL8:       ; CALL OCCURS
	.line	8
;------------------------------------------------------------------------------
; 352 | _fft_mixradix(symb+1,symb,base);
; 353 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),B4
           NOP             4
           ADD     .L2     4,B4,B4

           B       .S1     __fft_mixradix
||         MV      .L1X    B4,A4
||         LDW     .D2     *+SP(8),A6
           LDW     .D2     *+SP(4),B4
           NOP             2
           MVK     .S2     RL9,B3
           MVKH    .S2     RL9,B3
RL9:       ; CALL OCCURS
	.line	10
;------------------------------------------------------------------------------
; 354 | prof_stop();
; 355 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_stop
           NOP             3
           MVK     .S2     RL10,B3
           MVKH    .S2     RL10,B3
RL10:      ; CALL OCCURS
	.line	12
           LDW     .D2     *++SP(12),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	356,000080000h,12


	.sect	".text"
	.global	__fft_mixradix
	.sym	__fft_mixradix,__fft_mixradix,32,2,0
	.func	358

;***************************************************************
;* FUNCTION NAME: __fft_mixradix                               *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Local Frame Size  : 0 Args + 32 Auto + 4 Save = 36 byte   *
;***************************************************************
__fft_mixradix:
           STW     .D2     B3,*SP--(36)
	.sym	_real,4,20,17,32
	.sym	_imag,20,20,17,32
	.sym	_base,6,4,17,32
	.sym	_real,4,20,1,32
	.sym	_imag,8,20,1,32
	.sym	_base,12,4,1,32
	.sym	_size,16,4,1,32
	.sym	_i,20,4,1,32
	.sym	_j,24,4,1,32
	.sym	_quadsteps,28,4,1,32
	.sym	_dualstep,32,4,1,32
	.line	1
;------------------------------------------------------------------------------
; 358 | void _fft_mixradix(FFT_TYPE *real,FFT_TYPE *imag,int base) {
; 359 | int size,i,j,quadsteps,dualstep;
;------------------------------------------------------------------------------

           STW     .D2     A6,*+SP(12)
||         MV      .L1X    B4,A0
           STW     .D2     A0,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	4
;------------------------------------------------------------------------------
; 361 | quadsteps=base/2;
;------------------------------------------------------------------------------
           MV      .L1     A6,A0
           SHRU    .S1     A0,31,A3
           ADD     .L1     A3,A0,A0
           SHR     .S1     A0,1,A0
           STW     .D2     A0,*+SP(28)
	.line	5
;------------------------------------------------------------------------------
; 362 | dualstep=base%2;
;------------------------------------------------------------------------------

           MVK     .S2     1,B7
||         MV      .L2X    A6,B4
           SHRU    .S2     B4,31,B5

           ADD     .L2     B5,B4,B7
||         NOT     .S2     B7,B5
           AND     .L2     B5,B7,B5
           SUB     .L2     B4,B5,B4
           STW     .D2     B4,*+SP(32)
	.line	7
;------------------------------------------------------------------------------
; 364 | size=(1<<base);
;------------------------------------------------------------------------------

           MV      .L2X    A6,B4
||         MVK     .S2     1,B5
           SHL     .S2     B5,B4,B4
           STW     .D2     B4,*+SP(16)
	.line	8
;------------------------------------------------------------------------------
; 365 | fft_mixradix_faststep(real,imag,size,0);
; 366 | #ifdef FFT_PRINT
; 367 | printf("quadstep 0\n");
; 368 | #endif  
;------------------------------------------------------------------------------

           B       .S1     _fft_mixradix_faststep
||         LDW     .D2     *+SP(8),B4
           LDW     .D2     *+SP(16),A6
           NOP             2
           MVK     .S2     RL11,B3

           MVKH    .S2     RL11,B3
||         ZERO    .L2     B6
RL11:      ; CALL OCCURS
	.line	12
;------------------------------------------------------------------------------
; 369 | fft_mixradix_twiddle0(real,imag,size);
; 370 | #ifdef FFT_PRINT
; 371 | printf("twiddlestep 0\n");
; 372 | #endif  
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),A6

           B       .S1     _fft_mixradix_twiddle0
||         LDW     .D2     *+SP(8),B4
           LDW     .D2     *+SP(4),A4
           NOP             2
           MVK     .S2     RL12,B3
           MVKH    .S2     RL12,B3
RL12:      ; CALL OCCURS
	.line	16
;------------------------------------------------------------------------------
; 373 | for (i=1;i<quadsteps-1;i++) {
;------------------------------------------------------------------------------
           MVK     .S1     1,A0
           STW     .D2     A0,*+SP(20)
           LDW     .D2     *+SP(28),B5
           NOP             4

           MV      .L2X    A0,B4
||         SUB     .S2     B5,1,B5
           CMPLT   .L2     B4,B5,B0
   [!B0]   B       .S1     L47
           NOP             5
           ; BRANCH OCCURS
L46:        
	.line	17
;------------------------------------------------------------------------------
; 374 | fft_mixradix_faststep(real,imag,size,i);
; 375 | #ifdef FFT_PRINT
; 376 | printf("quadstep %d\n",i);
; 377 | #endif  
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),A6
           LDW     .D2     *+SP(20),B6

           B       .S1     _fft_mixradix_faststep
||         LDW     .D2     *+SP(8),B4
           LDW     .D2     *+SP(4),A4
           NOP             2
           MVK     .S2     RL13,B3
           MVKH    .S2     RL13,B3
RL13:      ; CALL OCCURS
	.line	21
;------------------------------------------------------------------------------
; 378 | fft_mixradix_twiddleN(real,imag,size,i);
; 379 | #ifdef FFT_PRINT
; 380 | printf("twiddlestep %d\n",i);
; 381 | #endif  
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),A6
           LDW     .D2     *+SP(20),B6

           B       .S1     _fft_mixradix_twiddleN
||         LDW     .D2     *+SP(8),B4
           LDW     .D2     *+SP(4),A4
           NOP             2
           MVK     .S2     RL14,B3
           MVKH    .S2     RL14,B3
RL14:      ; CALL OCCURS
	.line	16
           LDW     .D2     *+SP(20),A0
           NOP             4
           ADD     .L1     1,A0,A0
           STW     .D2     A0,*+SP(20)
           LDW     .D2     *+SP(28),B5
           NOP             4

           MV      .L2X    A0,B4
||         SUB     .S2     B5,1,B5
           CMPLT   .L2     B4,B5,B0
   [ B0]   B       .S1     L46
           NOP             5
           ; BRANCH OCCURS
L47:        
	.line	26
;------------------------------------------------------------------------------
; 383 | fft_mixradix_faststep(real,imag,size,i);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),A6
           LDW     .D2     *+SP(20),B6

           B       .S1     _fft_mixradix_faststep
||         LDW     .D2     *+SP(8),B4
           LDW     .D2     *+SP(4),A4
           NOP             2
           MVK     .S2     RL15,B3
           MVKH    .S2     RL15,B3
RL15:      ; CALL OCCURS
	.line	27
;------------------------------------------------------------------------------
; 384 | if (dualstep>0) fft_radix2_step(real,imag,size,base-1);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(32),B4
           NOP             4
           CMPLT   .L2     0,B4,B0
   [!B0]   B       .S1     L49
           NOP             5
           ; BRANCH OCCURS
           LDW     .D2     *+SP(12),B5
           LDW     .D2     *+SP(16),A6

           B       .S1     _fft_radix2_step
||         LDW     .D2     *+SP(8),B4
           LDW     .D2     *+SP(4),A4
           NOP             2
           MVK     .S2     RL16,B3

           SUB     .L2     B5,1,B6
||         MVKH    .S2     RL16,B3
RL16:      ; CALL OCCURS
L49:        
	.line	28
           LDW     .D2     *++SP(36),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	385,000080000h,36


	.sect	".text"
	.global	_mul_int30
	.sym	_mul_int30,_mul_int30,36,2,0
	.func	387

;***************************************************************
;* FUNCTION NAME: _mul_int30                                   *
;*                                                             *
;*   Regs Modified     : A0,A3,A4,B4,B5,B6,B7,SP               *
;*   Regs Used         : A0,A3,A4,B3,B4,B5,B6,B7,SP            *
;*   Local Frame Size  : 0 Args + 8 Auto + 0 Save = 8 byte     *
;***************************************************************
_mul_int30:
           SUB     .L2     SP,8,SP
	.sym	_a,4,4,17,32
	.sym	_b,20,4,17,32
	.sym	_a,4,4,1,32
	.sym	_b,8,4,1,32
	.sym	_msb,21,4,4,32
	.sym	_lsb1,0,4,4,32
	.sym	_lsb2,20,4,4,32
	.line	1
;------------------------------------------------------------------------------
; 387 | int mul_int30(int a,int b) {
; 388 | register int msb,lsb1,lsb2;
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	4
;------------------------------------------------------------------------------
; 390 | msb=(a>>15)*(b>>15);
;------------------------------------------------------------------------------
           MV      .L1     A4,A0

           SHR     .S2     B4,15,B4
||         SHR     .S1     A0,15,A0

           MPYLH   .M1X    B4,A0,A3
||         MPYLH   .M2X    A0,B4,B5
           NOP             1
           ADD     .L2X    A3,B5,B5
           MPYU    .M2X    B4,A0,B4
           SHL     .S2     B5,0x10,B5
           ADD     .L2     B4,B5,B5
	.line	5
;------------------------------------------------------------------------------
; 391 | lsb1=(a>>15)*(b&0x00007fff);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B4
           NOP             3
           MV      .L1     A4,A0

           EXTU    .S2     B4,17,17,B4
||         SHR     .S1     A0,15,A0

           MPYLH   .M1X    A0,B4,A4
||         MPYLH   .M2X    B4,A0,B6
           MPYU    .M1X    B4,A0,A3
           ADD     .L1X    B6,A4,A0
           SHL     .S1     A0,0x10,A0
           ADD     .L1     A3,A0,A0
	.line	6
;------------------------------------------------------------------------------
; 392 | lsb2=(a&0x00007fff)*(b>>15);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B4
           LDW     .D2     *+SP(4),A3
           NOP             4

           EXTU    .S1     A3,17,17,A3
||         SHR     .S2     B4,15,B4
           MPYLH   .M2X    B4,A3,B7
           MPYLH   .M2X    A3,B4,B6
           NOP             1

           ADD     .L2     B7,B6,B4
||         MPYU    .M1X    B4,A3,A3
           SHL     .S2     B4,0x10,B4
           ADD     .L2X    A3,B4,B4
	.line	8
;------------------------------------------------------------------------------
; 394 | return(msb+((lsb1+lsb2+(1<<14))/(1<<15)));
;------------------------------------------------------------------------------

           ADD     .L1X    B4,A0,A0
||         MVK     .S1     16384,A3
           ADD     .L1     A3,A0,A3
           SHR     .S1     A3,14,A0
           SHRU    .S1     A0,17,A0
           ADD     .L1     A0,A3,A0
           SHR     .S1     A0,15,A0
           ADD     .L1X    A0,B5,A4
	.line	9
           B       .S2     B3
           NOP             4
           ADD     .L2     8,SP,SP
           ; BRANCH OCCURS
	.endfunc	395,000000000h,8



;******************************************************
;* UNDEFINED EXTERNAL REFERENCES                      *
;******************************************************
	.global	_fft_SIN
	.global	_fft_COS
	.global	_prof_start
	.global	_prof_stop
	.global	__I_DIV
	.global	__I_MOD
