


/*


	simple FFT-algorithm
	Cooley-Tukey,input vektor must be bitreversaled
	(see E.Oran Brigham FFT - fast fourrier transformation p220,pic11-4c)

	max_error fft_Wk vs. matlab = 3.3219e-08
	max_error fft()  vs. matlab = 1.0994e-06 - size 32
	max_error fft()  vs. matlab = 2.4120e-06 - size 2048

	fft=sum(xk*wk)
	ifft=1/N*sum(xk*wk)

	max theoretischer fehler 4095*Err; max(Err)=0.5Bit
*/

#include <math.h>
#include <values.h>
#include "fft_double.h"

#ifndef M_PI
#define M_PI PI
#endif

double fft_Wk_double[2*FFT_MAXSIZE_DOUBLE];

/* straight algorithm (may be speeded up) 
   the input a will be mirrored.
   a0*2^0+a1*2^1+...+abase*2^base =>> abase*2^0+abase-1*2^1+...+a0*2^base
*/
int bitreversal_double(int a,int base) {
  int i,b,res=0;

  for (i=0;i<base;i++) {
    b=a/2;
    res=2*res+(a>2*b);
    a=b;
  }
  return(res);
}

/* size MUST be a power of 2! It is the number of doubles.
   (each complex value consists of two doubles)
 */
int fftreversal_double(double *symb,int base) {
  int i,j,size;
  double tmp;

  /* first and last element are never touched. All others can
     be symetrically switched - but i have to check, i switch
     them only once!
   */
  size=(1<<base);
  for (i=1;i<size;i++) {
    j=bitreversal_double(i,base);

    if (i<j) {
      tmp=symb[2*i];
      symb[2*i]=symb[2*j];
      symb[2*j]=tmp;

      tmp=symb[2*i+1];
      symb[2*i+1]=symb[2*j+1];
      symb[2*j+1]=tmp;
    }
  }
}

/* all Wk's are calculated in a table. That are N/2 values
   the maximum fft-size is set to 2048 complex values.
   calculation with the formula:
   exp(j*phi)= cos(phi)+j*sin(phi)
*/
void fft_init_double(void) {
  int i;
  double phi;
  
  for (i=0;i<FFT_MAXSIZE_DOUBLE;i++) {
    phi= -2*M_PI*i/FFT_MAXSIZE_DOUBLE;
    fft_Wk_double[2*i]=cos(phi);
    fft_Wk_double[2*i+1]=sin(phi);
  }
}

/* size is the number of complex numbers! 
   Each complex has two doubles, real and imag, real first.
   */
void fft_step_double(double *symb,int size,int step) {
  int i,k,idx,alpha,a,b,u;
  double *wk;
  double t[2];
  
  alpha=(1<<step);
  u=2*FFT_MAXSIZE_DOUBLE/size;
  /* printf("-- step %d size %d alpha %d\n",step,size,alpha); */
  for (i=0;i<(size/2);i++) {
    /* address calculation */
    a=2*alpha*(i/alpha)+(i%alpha);
    b=a+alpha;
    /* calculation and operand store */
    k=size/(2*alpha)*(a%alpha);
    /* printf("i%3d a%3d b%3d k%3d\n",i,a,b,k); */
    wk=fft_Wk_double+k*u;
    complex_mul_double(symb+2*b,wk,t);
    complex_sub_double(symb+2*a,t,symb+2*b); /* overwriting b first */
    complex_add_double(symb+2*a,t,symb+2*a);
  }
}

void fft_double(double *symb,int base) {
  int i,size;

  size=(1<<base); /* 2^base */
  printf("fft :size=%d base=%d\n",size,base);
  fftreversal_double(symb,base);
  for (i=0;i<base;i++) fft_step_double(symb,size,i);
}

/* IFFT(x)=[FFT(x*)]* */
void ifft_double(double *symb,int base) {
  int i,size;

  size=(1<<base); /* 2^base */
  printf("ifft :size=%d base=%d\n",size,base);
  for (i=0;i<size;i++) complex_conjugate(symb+2*i);
  fftreversal_double(symb,base);
  for (i=0;i<base;i++) fft_step_double(symb,size,i);
  for (i=0;i<size;i++) complex_conjugate(symb+2*i);
  for (i=0;i<2*size;i++) symb[i]=symb[i]/size; /* scaling */
}


void complex_add_double(double *a,double *b,double *dest) {
  *dest=*a+*b;
  dest[1]=a[1]+b[1];
}

void complex_sub_double(double *a,double *b,double *dest) {
  *dest=*a-*b;
  dest[1]=a[1]-b[1];
}

void complex_mul_double(double *a,double *b,double *dest) {
  dest[0]= a[0]*b[0] - a[1]*b[1];
  dest[1]= a[0]*b[1] + a[1]*b[0];
}

