

#include "conf.h"
#include "fft.h"
#include "profile.h"

void fft_r4(int n,FFT_TYPE *x) {
  int n2,ie,i,k;

#ifdef COFDM_PROFILE
  prof_start(profile_fft);
#endif
  n2=n;
  ie=1;
  i=0;
  for (k=n;k>1;k>>=2) {
    fft_step4(n,n2,ie,x,x+1);
    n2>>=2;
    ie<<=2;
    i++;
  }

#ifdef COFDM_PROFILE
  prof_stop();
#endif
}

void ifft_r4(int n,FFT_TYPE *x) {
  int n2,ie,k;

  n2=n;
  ie=1;
#ifdef COFDM_PROFILE
  prof_start(profile_ifft);
#endif
  for (k=n;k>1;k>>=2) {
    fft_step4(n,n2,ie,x+1,x);
    ie<<=2;
    n2>>=2;
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}

void fft_r2(int n,FFT_TYPE *x) {
  int n2,ie,k;

#ifdef COFDM_PROFILE
  prof_start(profile_fft);
#endif
  n2=n;
  ie=1;
  for (k=n;k>1;k>>=1) {
    fft_step2(n,n2,ie,x,x+1);
    ie<<=1;
    n2>>=1;
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}

void ifft_r2(int n,FFT_TYPE *x) {
  int n2,ie,k;

#ifdef COFDM_PROFILE
  prof_start(profile_ifft);
#endif
  n2=n;
  ie=1;
  for (k=n;k>1;k>>=1) {
    fft_step2(n,n2,ie,x+1,x);
    ie<<=1;
    n2>>=1;
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
}
/* shift_round
   xt             = (real[l] - real[m] +1)>>1;
   real[m]        = (real[m] + real[l] +1)>>1;
   yt             = (imag[l] - imag[m] +1)>>1;
   imag[m]        = (imag[m] + imag[l] +1)>>1;
   real[l]        = ((-c*xt - s*yt +(1<<14))>>15);
   imag[l]        = ((-c*yt + s*xt +(1<<14))>>15);
 */
/* shift
   xt             = (real[l] - real[m] )>>1;
   real[m]        = (real[m] + real[l] )>>1;
   yt             = (imag[l] - imag[m] )>>1;
   imag[m]        = (imag[m] + imag[l] )>>1;
   real[l]        = ((-c*xt - s*yt +(1<<14))>>15);
   imag[l]        = ((-c*yt + s*xt +(1<<14))>>15);
 */
/* round
   xt             = (real[l] - real[m] );
   real[m]        = (real[m] + real[l] );
   yt             = (imag[l] - imag[m] );
   imag[m]        = (imag[m] + imag[l] );
   real[l]        = ((-c*xt - s*yt +(1<<14))>>15);
   imag[l]        = ((-c*yt + s*xt +(1<<14))>>15);
 */
/* noround
   xt             = (real[l] - real[m] );
   real[m]        = (real[m] + real[l] );
   yt             = (imag[l] - imag[m] );
   imag[m]        = (imag[m] + imag[l] );
   real[l]        = ((-c*xt - s*yt )>>15);
   imag[l]        = ((-c*yt + s*xt )>>15);
 */
void fft_step2(int nn,int nn2,int nie,FFT_TYPE *real,FFT_TYPE *imag) {
  register int n,n1,n2,ie,ia,i,j,k,l,m;
  register FFT_TYPE xt,yt,c,s;
  FFT_TYPE *wc,*ws;
  
  ws=fft_SIN;
  wc=fft_COS;
  n=nn;
  n1=nn2;
  n2=nn2>>1;
  ie=nie;
  ia = 0;
  for (j=0; j < n2; j++) {
    c = wc[ia];
    s = ws[ia];
    ia = ia + ie;
    for (i=j; i < n; i += n1) {
      m=i*2;
      l = 2*(i + n2);
      xt             = (real[l] - real[m] );
      real[m]        = (real[m] + real[l] );
      yt             = (imag[l] - imag[m] );
      imag[m]        = (imag[m] + imag[l] );
      real[l]        = ((-c*xt - s*yt +(1<<14))>>15);
      imag[l]        = ((-c*yt + s*xt +(1<<14))>>15);
    }
  }
}

void fft_step4(int nn,int nn2,int ie,register FFT_TYPE *x,register FFT_TYPE *y) {
  int ia1,ia2,ia3;
  register int n,n1,n2,i,i0,i1,i2,i3,j;
  register FFT_TYPE t,r1,r2,s1,s2,tmp;
  FFT_TYPE co1,co2,co3,si1,si2,si3,*wsin,*wcos;

  n=nn;
  n1=nn2;
  n2=nn2>>2;
  ia1=0;
  wsin=fft_SIN;
  wcos=fft_COS;

  /*    printf("n1=%d n2=%d ia1=%d ie=%d\n",n1,n2,ia1,ie); */
  /* printf("n=%d n1=%d n2=%d ie=%d\n",n,n1,n2,ie); */
  for(j=0;j<n2;j++) {
    ia2=ia1+ia1;
    ia3=ia2+ia1;
    co1=wcos[ia1];
    si1=wsin[ia1];
    co2=wcos[ia2];
    si2=wsin[ia2];
    co3=wcos[ia3];
    si3=wsin[ia3];
    ia1=(ia1+ie)%5120;
    /* printf("  j=%d ia1=%d ia2=%d ia3=%d\n",j,ia1,ia2,ia3); */
    /* printf("j=%d co1=%5.3f si1=%5.3f co2=%5.3f si2=%5.3f co3=%5.3f si3=%5.3f\n",j,co1,si1,co2,si2,co3,si3); */
    for (i=j;i<n;i+=n1) {
      i0=i<<1;
      i2= i+n2;
      i1=i2+n2;
      i3=i1+n2;
      i1<<=1;
      i2<<=1;
      i3<<=1;
      /* printf("    i=%d i0=%d i1=%d i2=%d i3=%d\n",i,i0,i1,i2,i3); */
      tmp=x[i2];
      r1=x[i0];
      r2=r1-tmp;
      r1+=tmp;
      t=x[i1]+x[i3];
      x[i0]=(r1+t);
      r1-=t;
      tmp=y[i2];
      s1=y[i0];
      s2=s1-tmp;
      s1+=tmp;
      t=y[i1]+y[i3];
      y[i0]=(s1+t);
      s1-=t;
      x[i2]=MUL_SHIFT(r1*co2-s1*si2);
      y[i2]=MUL_SHIFT(s1*co2+r1*si2);
      t=y[i1]-y[i3];
      r1=r2+t;
      r2-=t;
      t=x[i1]-x[i3];
      s1=s2-t;
      s2+=t;
      x[i1]=MUL_SHIFT(r1*co1-s1*si1);
      y[i1]=MUL_SHIFT(s1*co1+r1*si1);
      x[i3]=MUL_SHIFT(r2*co3-s2*si3);
      y[i3]=MUL_SHIFT(s2*co3+r2*si3);
    }
  }
}

