;***************************************************************
;* TMS320C6x ANSI C Codegen                       Version 1.00 *
;* Date/Time created: Fri Apr  3 11:16:51 1998                 *
;***************************************************************

;***************************************************************
;* GLOBAL FILE PARAMETERS                                      *
;*                                                             *
;*   Architecture    : TMS320C6200                             *
;*   Endian          : Little                                  *
;*   Memory Model    : Small                                   *
;*   Redundant Loops : Enabled                                 *
;*   Pipelining      : Enabled                                 *
;*   Debug Info      : Debug                                   *
;*                                                             *
;***************************************************************

FP	.set	A15
DP	.set	B14
SP	.set	B15

;	ac6x -DARCHC6X -i/import/home.hi213001/guest52/projekt/include -i/usr/local/dsp/c6x_tools/include fft_burrus.c /import/home.hi213001/guest52/projekt/obj/c6x/libCOFDM/fft_burrus.if 
	.file	"fft_burrus.c"
	.file	"/usr/local/dsp/c6x_tools/include/assert.h"
	.file	"/usr/local/dsp/c6x_tools/include/stdarg.h"
	.sym	_va_list,0,18,13,32
	.file	"/usr/local/dsp/c6x_tools/include/stdlib.h"
	.stag	.fake0,64
	.member	_quot,0,4,8,32
	.member	_rem,32,4,8,32
	.eos
	.sym	_div_t,0,8,13,64,.fake0
	.stag	.fake1,128
	.member	_quot,0,5,8,40
	.member	_rem,64,5,8,40
	.eos
	.sym	_ldiv_t,0,8,13,128,.fake1
	.sym	_size_t,0,14,13,32
	.sym	_wchar_t,0,2,13,8
	.file	"/usr/local/dsp/c6x_tools/include/ctype.h"
	.file	"/usr/local/dsp/c6x_tools/include/math.h"
	.file	"/usr/local/dsp/c6x_tools/include/stddef.h"
	.sym	_ptrdiff_t,0,4,13,32
	.file	"/usr/local/dsp/c6x_tools/include/string.h"
	.file	"/usr/local/dsp/c6x_tools/include/errno.h"
	.file	"/usr/local/dsp/c6x_tools/include/setjmp.h"
	.sym	_jmp_buf,0,52,13,416,,13
	.file	"/usr/local/dsp/c6x_tools/include/stdio.h"
	.stag	.fake2,224
	.member	_fd,0,4,8,32
	.member	_buf,32,28,8,32
	.member	_pos,64,28,8,32
	.member	_bufend,96,28,8,32
	.member	_buff_stop,128,28,8,32
	.member	_flags,160,14,8,32
	.member	_index,192,4,8,32
	.eos
	.sym	_FILE,0,8,13,224,.fake2
	.sym	_fpos_t,0,4,13,32
	.stag	.fake3,320
	.member	_name,0,50,8,72,,9
	.member	_flags,80,13,8,16
	.member	_OPEN,96,148,8,32
	.member	_CLOSE,128,148,8,32
	.member	_READ,160,148,8,32
	.member	_WRITE,192,148,8,32
	.member	_LSEEK,224,148,8,32
	.member	_UNLINK,256,148,8,32
	.member	_RENAME,288,148,8,32
	.eos
	.sym	__DEVICE,0,8,13,320,.fake3
	.file	"/usr/local/dsp/c6x_tools/include/time.h"
	.sym	_clock_t,0,14,13,32
	.sym	_time_t,0,14,13,32
	.stag	_tm,288
	.member	_tm_sec,0,14,8,32
	.member	_tm_min,32,4,8,32
	.member	_tm_hour,64,4,8,32
	.member	_tm_mday,96,4,8,32
	.member	_tm_mon,128,4,8,32
	.member	_tm_year,160,4,8,32
	.member	_tm_wday,192,4,8,32
	.member	_tm_yday,224,4,8,32
	.member	_tm_isdst,256,4,8,32
	.eos
	.stag	.fake4,128
	.member	_daylight,0,3,8,16
	.member	_timezone,32,14,8,32
	.member	_tzname,64,50,8,32,,4
	.member	_dstname,96,50,8,32,,4
	.eos
	.sym	_TZ,0,8,13,128,.fake4
	.file	"/import/home.hi213001/guest52/projekt/include/conf.h"
	.sym	_WORD,0,14,13,32
	.sym	_BYTE,0,12,13,8
	.sym	_SHORT,0,13,13,16
	.file	"/import/home.hi213001/guest52/projekt/include/fft.h"
	.file	"/import/home.hi213001/guest52/projekt/include/profile.h"
	.etag	_profile_functions,32
	.member	_calib0,0,4,16,32
	.member	_calib1,1,4,16,32
	.member	_overhead,2,4,16,32
	.member	_suspend,3,4,16,32
	.member	_profile_conv,4,4,16,32
	.member	_profile_convtail,5,4,16,32
	.member	_profile_ifft,6,4,16,32
	.member	_profile_fft,7,4,16,32
	.member	_profile_prbsgenerate,8,4,16,32
	.member	_profile_prbsscramble,9,4,16,32
	.member	_profile_calcpi,10,4,16,32
	.member	_profile_mstsymbol,11,4,16,32
	.member	_profile_ficsymbol,12,4,16,32
	.member	_profile_interleave,13,4,16,32
	.member	_profile_timeconfig,14,4,16,32
	.member	_profile_symbol,15,4,16,32
	.member	_profile_crccalc,16,4,16,32
	.member	_profile_berlekamp,17,4,16,32
	.member	_profile_syndrom,18,4,16,32
	.member	_profile_rscorrect,19,4,16,32
	.member	_profile_dqpsk,20,4,16,32
	.member	_profile_program,21,4,16,32
	.member	_profile_reversal,22,4,16,32
	.member	_profile_outinterleave,23,4,16,32
	.eos
	.sym	_profile_funcs,0,10,13,32,_profile_functions
	.stag	_sprof_entry,128
	.member	_count,0,4,8,32
	.member	_start,32,14,8,32
	.member	_cycles,64,14,8,32
	.member	_called_by,96,4,8,32
	.eos
	.sym	_tprof_entry,0,8,13,128,_sprof_entry
	.file	"fft_burrus.c"
	.sect	".text"
	.global	_fft_r4
	.sym	_fft_r4,_fft_r4,32,2,0
	.func	11

;***************************************************************
;* FUNCTION NAME: _fft_r4                                      *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,B0, *
;*                           B1,B2,B3,B4,B5,B6,B7,B8,B9,SP     *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,B0, *
;*                           B1,B2,B3,B4,B5,B6,B7,B8,B9,SP     *
;*   Local Frame Size  : 0 Args + 24 Auto + 8 Save = 32 byte   *
;***************************************************************
_fft_r4:
           STW     .D2     B3,*SP--(32)
           STW     .D2     A10,*+SP(28)
	.sym	_n,4,4,17,32
	.sym	_x,20,20,17,32
	.sym	_n,4,4,1,32
	.sym	_x,8,20,1,32
	.sym	_n2,12,4,1,32
	.sym	_ie,16,4,1,32
	.sym	_i,20,4,1,32
	.sym	_k,24,4,1,32
	.line	1
;------------------------------------------------------------------------------
;  11 | void fft_r4(int n,FFT_TYPE *x) {
;  12 | int n2,ie,i,k;
;  14 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	5
;------------------------------------------------------------------------------
;  15 | prof_start(profile_fft);
;  16 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_start
           NOP             3
           MVK     .S2     RL0,B3

           MVK     .S1     7,A4
||         MVKH    .S2     RL0,B3
RL0:       ; CALL OCCURS
	.line	7
;------------------------------------------------------------------------------
;  17 | n2=n;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),A0
           NOP             4
           STW     .D2     A0,*+SP(12)
	.line	8
;------------------------------------------------------------------------------
;  18 | ie=1;
;------------------------------------------------------------------------------
           MVK     .S2     1,B4
           STW     .D2     B4,*+SP(16)
	.line	9
;------------------------------------------------------------------------------
;  19 | i=0;
;------------------------------------------------------------------------------
           ZERO    .L1     A10
           STW     .D2     A10,*+SP(20)
	.line	10
;------------------------------------------------------------------------------
;  20 | for (k=n;k>1;k>>=2) {
;------------------------------------------------------------------------------
           MV      .L2X    A0,B4
           STW     .D2     B4,*+SP(24)
           CMPLT   .L2     1,B4,B0
   [!B0]   B       .S1     L3
           NOP             5
           ; BRANCH OCCURS
L2:        
	.line	11
;------------------------------------------------------------------------------
;  21 | fft_step4(n,n2,ie,x,x+1);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B5
           LDW     .D2     *+SP(16),A6

           B       .S1     _fft_step4
||         LDW     .D2     *+SP(12),B4
           LDW     .D2     *+SP(4),A4
           NOP             2

           ADD     .L2     4,B5,B5
||         MV      .D2     B5,B6
||         MVK     .S2     RL1,B3

           MV      .L1X    B5,A8
||         MVKH    .S2     RL1,B3
RL1:       ; CALL OCCURS
	.line	12
;------------------------------------------------------------------------------
;  22 | n2>>=2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(12),A0
           NOP             4
           SHR     .S1     A0,2,A0
           STW     .D2     A0,*+SP(12)
	.line	13
;------------------------------------------------------------------------------
;  23 | ie<<=2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),B4
           NOP             4
           SHL     .S1X    B4,2,A0
           STW     .D2     A0,*+SP(16)
	.line	14
;------------------------------------------------------------------------------
;  24 | i++;
;  27 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(20),A0
           NOP             4
           ADD     .L1     1,A0,A0
           STW     .D2     A0,*+SP(20)
	.line	10
           LDW     .D2     *+SP(24),B4
           NOP             4
           SHR     .S2     B4,2,B4
           STW     .D2     B4,*+SP(24)
           CMPLT   .L2     1,B4,B0
   [ B0]   B       .S1     L2
           NOP             5
           ; BRANCH OCCURS
L3:        
	.line	18
;------------------------------------------------------------------------------
;  28 | prof_stop();
;  29 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_stop
           NOP             3
           MVK     .S2     RL2,B3
           MVKH    .S2     RL2,B3
RL2:       ; CALL OCCURS
	.line	20
           LDW     .D2     *+SP(28),A10
           LDW     .D2     *++SP(32),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	30,000080400h,32


	.sect	".text"
	.global	_ifft_r4
	.sym	_ifft_r4,_ifft_r4,32,2,0
	.func	32

;***************************************************************
;* FUNCTION NAME: _ifft_r4                                     *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Local Frame Size  : 0 Args + 20 Auto + 4 Save = 24 byte   *
;***************************************************************
_ifft_r4:
           STW     .D2     B3,*SP--(24)
	.sym	_n,4,4,17,32
	.sym	_x,20,20,17,32
	.sym	_n,4,4,1,32
	.sym	_x,8,20,1,32
	.sym	_n2,12,4,1,32
	.sym	_ie,16,4,1,32
	.sym	_k,20,4,1,32
	.line	1
;------------------------------------------------------------------------------
;  32 | void ifft_r4(int n,FFT_TYPE *x) {
;  33 | int n2,ie,k;
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	4
;------------------------------------------------------------------------------
;  35 | n2=n;
;------------------------------------------------------------------------------
           MV      .L2X    A4,B4
           STW     .D2     B4,*+SP(12)
	.line	5
;------------------------------------------------------------------------------
;  36 | ie=1;
;  37 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           MVK     .S1     1,A0
           STW     .D2     A0,*+SP(16)
	.line	7
;------------------------------------------------------------------------------
;  38 | prof_start(profile_ifft);
;  39 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_start
           NOP             3
           MVK     .S2     RL3,B3

           MVK     .S1     6,A4
||         MVKH    .S2     RL3,B3
RL3:       ; CALL OCCURS
	.line	9
;------------------------------------------------------------------------------
;  40 | for (k=n;k>1;k>>=2) {
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),B4
           NOP             4
           STW     .D2     B4,*+SP(20)
           CMPLT   .L2     1,B4,B0
   [!B0]   B       .S1     L8
           NOP             5
           ; BRANCH OCCURS
L7:        
	.line	10
;------------------------------------------------------------------------------
;  41 | fft_step4(n,n2,ie,x+1,x);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B5
           LDW     .D2     *+SP(16),A6

           B       .S1     _fft_step4
||         LDW     .D2     *+SP(12),B4
           LDW     .D2     *+SP(4),A4
           NOP             2
           MVK     .S2     RL4,B3

           MV      .L1X    B5,A8
||         ADD     .L2     4,B5,B6
||         MVKH    .S2     RL4,B3
RL4:       ; CALL OCCURS
	.line	11
;------------------------------------------------------------------------------
;  42 | ie<<=2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),B4
           NOP             4
           SHL     .S2     B4,2,B4
           STW     .D2     B4,*+SP(16)
	.line	12
;------------------------------------------------------------------------------
;  43 | n2>>=2;
;  45 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(12),A0
           NOP             4
           SHR     .S1     A0,2,A0
           STW     .D2     A0,*+SP(12)
	.line	9
           LDW     .D2     *+SP(20),B4
           NOP             4
           SHR     .S2     B4,2,B4
           STW     .D2     B4,*+SP(20)
           MV      .L1X    B4,A0
           CMPLT   .L1     1,A0,A1
   [ A1]   B       .S1     L7
           NOP             5
           ; BRANCH OCCURS
L8:        
	.line	15
;------------------------------------------------------------------------------
;  46 | prof_stop();
;  47 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_stop
           NOP             3
           MVK     .S2     RL5,B3
           MVKH    .S2     RL5,B3
RL5:       ; CALL OCCURS
	.line	17
           LDW     .D2     *++SP(24),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	48,000080000h,24


	.sect	".text"
	.global	_fft_r2
	.sym	_fft_r2,_fft_r2,32,2,0
	.func	50

;***************************************************************
;* FUNCTION NAME: _fft_r2                                      *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Local Frame Size  : 0 Args + 20 Auto + 4 Save = 24 byte   *
;***************************************************************
_fft_r2:
           STW     .D2     B3,*SP--(24)
	.sym	_n,4,4,17,32
	.sym	_x,20,20,17,32
	.sym	_n,4,4,1,32
	.sym	_x,8,20,1,32
	.sym	_n2,12,4,1,32
	.sym	_ie,16,4,1,32
	.sym	_k,20,4,1,32
	.line	1
;------------------------------------------------------------------------------
;  50 | void fft_r2(int n,FFT_TYPE *x) {
;  51 | int n2,ie,k;
;  53 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	5
;------------------------------------------------------------------------------
;  54 | prof_start(profile_fft);
;  55 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_start
           NOP             3
           MVK     .S2     RL6,B3

           MVK     .S1     7,A4
||         MVKH    .S2     RL6,B3
RL6:       ; CALL OCCURS
	.line	7
;------------------------------------------------------------------------------
;  56 | n2=n;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),A0
           NOP             4
           STW     .D2     A0,*+SP(12)
	.line	8
;------------------------------------------------------------------------------
;  57 | ie=1;
;------------------------------------------------------------------------------
           MVK     .S2     1,B4
           STW     .D2     B4,*+SP(16)
	.line	9
;------------------------------------------------------------------------------
;  58 | for (k=n;k>1;k>>=1) {
;------------------------------------------------------------------------------
           MV      .L2X    A0,B4
           STW     .D2     B4,*+SP(20)
           CMPLT   .L2     1,B4,B0
   [!B0]   B       .S1     L13
           NOP             5
           ; BRANCH OCCURS
L12:        
	.line	10
;------------------------------------------------------------------------------
;  59 | fft_step2(n,n2,ie,x,x+1);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B5
           LDW     .D2     *+SP(16),A6

           B       .S1     _fft_step2
||         LDW     .D2     *+SP(12),B4
           LDW     .D2     *+SP(4),A4
           NOP             2

           ADD     .L2     4,B5,B5
||         MV      .D2     B5,B6
||         MVK     .S2     RL7,B3

           MV      .L1X    B5,A8
||         MVKH    .S2     RL7,B3
RL7:       ; CALL OCCURS
	.line	11
;------------------------------------------------------------------------------
;  60 | ie<<=1;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),B4
           NOP             4
           SHL     .S2     B4,1,B4
           STW     .D2     B4,*+SP(16)
	.line	12
;------------------------------------------------------------------------------
;  61 | n2>>=1;
;  63 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(12),A0
           NOP             4
           SHR     .S1     A0,1,A0
           STW     .D2     A0,*+SP(12)
	.line	9
           LDW     .D2     *+SP(20),B4
           NOP             4
           SHR     .S2     B4,1,B4
           STW     .D2     B4,*+SP(20)
           MV      .L1X    B4,A0
           CMPLT   .L1     1,A0,A1
   [ A1]   B       .S1     L12
           NOP             5
           ; BRANCH OCCURS
L13:        
	.line	15
;------------------------------------------------------------------------------
;  64 | prof_stop();
;  65 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_stop
           NOP             3
           MVK     .S2     RL8,B3
           MVKH    .S2     RL8,B3
RL8:       ; CALL OCCURS
	.line	17
           LDW     .D2     *++SP(24),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	66,000080000h,24


	.sect	".text"
	.global	_ifft_r2
	.sym	_ifft_r2,_ifft_r2,32,2,0
	.func	68

;***************************************************************
;* FUNCTION NAME: _ifft_r2                                     *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,B0,B1,  *
;*                           B2,B3,B4,B5,B6,B7,B8,B9,SP        *
;*   Local Frame Size  : 0 Args + 20 Auto + 4 Save = 24 byte   *
;***************************************************************
_ifft_r2:
           STW     .D2     B3,*SP--(24)
	.sym	_n,4,4,17,32
	.sym	_x,20,20,17,32
	.sym	_n,4,4,1,32
	.sym	_x,8,20,1,32
	.sym	_n2,12,4,1,32
	.sym	_ie,16,4,1,32
	.sym	_k,20,4,1,32
	.line	1
;------------------------------------------------------------------------------
;  68 | void ifft_r2(int n,FFT_TYPE *x) {
;  69 | int n2,ie,k;
;  71 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           STW     .D2     B4,*+SP(8)
           STW     .D2     A4,*+SP(4)
	.line	5
;------------------------------------------------------------------------------
;  72 | prof_start(profile_ifft);
;  73 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_start
           NOP             3
           MVK     .S2     RL9,B3

           MVK     .S1     6,A4
||         MVKH    .S2     RL9,B3
RL9:       ; CALL OCCURS
	.line	7
;------------------------------------------------------------------------------
;  74 | n2=n;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(4),A0
           NOP             4
           STW     .D2     A0,*+SP(12)
	.line	8
;------------------------------------------------------------------------------
;  75 | ie=1;
;------------------------------------------------------------------------------
           MVK     .S2     1,B4
           STW     .D2     B4,*+SP(16)
	.line	9
;------------------------------------------------------------------------------
;  76 | for (k=n;k>1;k>>=1) {
;------------------------------------------------------------------------------
           MV      .L2X    A0,B4
           STW     .D2     B4,*+SP(20)
           CMPLT   .L2     1,B4,B0
   [!B0]   B       .S1     L18
           NOP             5
           ; BRANCH OCCURS
L17:        
	.line	10
;------------------------------------------------------------------------------
;  77 | fft_step2(n,n2,ie,x+1,x);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B5
           LDW     .D2     *+SP(16),A6

           B       .S1     _fft_step2
||         LDW     .D2     *+SP(12),B4
           LDW     .D2     *+SP(4),A4
           NOP             2
           MVK     .S2     RL10,B3

           MV      .L1X    B5,A8
||         ADD     .L2     4,B5,B6
||         MVKH    .S2     RL10,B3
RL10:      ; CALL OCCURS
	.line	11
;------------------------------------------------------------------------------
;  78 | ie<<=1;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),B4
           NOP             4
           SHL     .S2     B4,1,B4
           STW     .D2     B4,*+SP(16)
	.line	12
;------------------------------------------------------------------------------
;  79 | n2>>=1;
;  81 | #ifdef COFDM_PROFILE
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(12),A0
           NOP             4
           SHR     .S1     A0,1,A0
           STW     .D2     A0,*+SP(12)
	.line	9
           LDW     .D2     *+SP(20),B4
           NOP             4
           SHR     .S2     B4,1,B4
           STW     .D2     B4,*+SP(20)
           MV      .L1X    B4,A0
           CMPLT   .L1     1,A0,A1
   [ A1]   B       .S1     L17
           NOP             5
           ; BRANCH OCCURS
L18:        
	.line	15
;------------------------------------------------------------------------------
;  82 | prof_stop();
;  83 | #endif
;------------------------------------------------------------------------------
           B       .S1     _prof_stop
           NOP             3
           MVK     .S2     RL11,B3
           MVKH    .S2     RL11,B3
RL11:      ; CALL OCCURS
	.line	17
           LDW     .D2     *++SP(24),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	84,000080000h,24


	.sect	".text"
	.global	_fft_step2
	.sym	_fft_step2,_fft_step2,32,2,0
	.func	86

;***************************************************************
;* FUNCTION NAME: _fft_step2                                   *
;*                                                             *
;*   Regs Modified     : A0,A1,A3,A4,A5,A6,A7,A8,A9,B0,B1,B2,  *
;*                           B3,B4,B5,B6,B7,B8,B9,SP           *
;*   Regs Used         : A0,A1,A3,A4,A5,A6,A7,A8,A9,B0,B1,B2,  *
;*                           B3,B4,B5,B6,B7,B8,B9,B14,SP       *
;*   Local Frame Size  : 0 Args + 28 Auto + 4 Save = 32 byte   *
;***************************************************************
_fft_step2:
           STW     .D2     B3,*SP--(32)
	.sym	_nn,4,4,17,32
	.sym	_nn2,20,4,17,32
	.sym	_nie,6,4,17,32
	.sym	_real,22,20,17,32
	.sym	_imag,8,20,17,32
	.sym	_nn,4,4,1,32
	.sym	_nn2,8,4,1,32
	.sym	_nie,12,4,1,32
	.sym	_real,16,20,1,32
	.sym	_imag,20,20,1,32
	.sym	_n,23,4,4,32
	.sym	_n1,24,4,4,32
	.sym	_n2,8,4,4,32
	.sym	_ie,25,4,4,32
	.sym	_ia,0,4,4,32
	.sym	_i,20,4,4,32
	.sym	_j,6,4,4,32
	.sym	_k,0,4,4,32
	.sym	_l,7,4,4,32
	.sym	_i2,22,4,4,32
	.sym	_xt,16,4,4,32
	.sym	_yt,17,4,4,32
	.sym	_c,9,4,4,32
	.sym	_s,21,4,4,32
	.sym	_wc,24,20,1,32
	.sym	_ws,28,20,1,32
	.line	1
;------------------------------------------------------------------------------
;  86 | void fft_step2(int nn,int nn2,int nie,FFT_TYPE *real,FFT_TYPE *imag)  \
;        {
;  87 | register int n,n1,n2,ie,ia,i,j,k,l,i2;
;  88 | register FFT_TYPE xt,yt,c,s;
;  89 | FFT_TYPE *wc,*ws;
;------------------------------------------------------------------------------
           STW     .D2     A8,*+SP(20)
           STW     .D2     B6,*+SP(16)

           STW     .D2     B4,*+SP(8)
||         MV      .L2X    A6,B5
           STW     .D2     B5,*+SP(12)
           STW     .D2     A4,*+SP(4)
	.line	6
;------------------------------------------------------------------------------
;  91 | ws=fft_SIN;
;------------------------------------------------------------------------------
           MVK     .S1     _fft_SIN,A3
           MVKH    .S1     _fft_SIN,A3
           STW     .D2     A3,*+SP(28)
	.line	7
;------------------------------------------------------------------------------
;  92 | wc=fft_COS;
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_COS),B4
           NOP             4
           STW     .D2     B4,*+SP(24)
	.line	8
;------------------------------------------------------------------------------
;  93 | n=nn;
;------------------------------------------------------------------------------
           MV      .L2X    A4,B7
	.line	9
;------------------------------------------------------------------------------
;  94 | n1=nn2;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(8),B8
           NOP             4
	.line	10
;------------------------------------------------------------------------------
;  95 | n2=nn2>>1;
;------------------------------------------------------------------------------
           MV      .L2     B8,B4
           SHR     .S1X    B4,1,A8
	.line	11
;------------------------------------------------------------------------------
;  96 | ie=nie;
;------------------------------------------------------------------------------
           MV      .L2     B5,B9
	.line	12
;------------------------------------------------------------------------------
;  97 | ia = 0;
;------------------------------------------------------------------------------
           ZERO    .L1     A0
	.line	13
;------------------------------------------------------------------------------
;  98 | for (j=0; j < n2; j++) {
;------------------------------------------------------------------------------
           ZERO    .L1     A6
           CMPLT   .L1     A6,A8,A1
   [!A1]   B       .S1     L25
           NOP             5
           ; BRANCH OCCURS
L22:        
	.line	14
;------------------------------------------------------------------------------
;  99 | c = wc[ia];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A3
           NOP             4
           LDW     .D1     *+A3[A0],A9
	.line	15
;------------------------------------------------------------------------------
; 100 | s = ws[ia];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(28),B4
           NOP             3
           MV      .L2X    A0,B5
           LDW     .D2     *+B4[B5],B5
	.line	16
;------------------------------------------------------------------------------
; 101 | ia = ia + ie;
;------------------------------------------------------------------------------
           MV      .L2X    A0,B4
           ADD     .L2     B9,B4,B4
           MV      .L1X    B4,A0
	.line	17
;------------------------------------------------------------------------------
; 102 | for (i=j; i < n; i += n1) {
;------------------------------------------------------------------------------
           MV      .L2X    A6,B4
           CMPLT   .L2     B4,B7,B0
   [!B0]   B       .S1     L24
           NOP             5
           ; BRANCH OCCURS
L23:        
	.line	18
;------------------------------------------------------------------------------
; 103 | i2=i*2;
;------------------------------------------------------------------------------
           SHL     .S2     B4,1,B6
	.line	19
;------------------------------------------------------------------------------
; 104 | l = 2*(i + n2);
;------------------------------------------------------------------------------
           ADD     .L1X    A8,B4,A3
           SHL     .S1     A3,1,A7
	.line	20
;------------------------------------------------------------------------------
; 105 | xt              = (real[l] - real[i2]);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),B0
           NOP             4
           MV      .L1X    B0,A3

           LDW     .D1     *+A3[A7],A3
||         LDW     .D2     *+B0[B6],B0
           NOP             4
           SUB     .L2X    A3,B0,B0
	.line	21
;------------------------------------------------------------------------------
; 106 | real[i2]       = (real[i2] + real[l]);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),A3
           NOP             4
           MV      .L1     A3,A4

           LDW     .D1     *+A4[A7],A4
||         MV      .L1X    B6,A5
           LDW     .D1     *+A3[A5],A3
           LDW     .D2     *+SP(16),B1
           NOP             3
           ADD     .L1     A4,A3,A3
           STW     .D2     A3,*+B1[B6]
	.line	22
;------------------------------------------------------------------------------
; 107 | yt              = (imag[l] - imag[i2]);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(20),B1
           NOP             4
           MV      .L1X    B1,A3

           LDW     .D2     *+B1[B6],B1
||         LDW     .D1     *+A3[A7],A3
           NOP             4
           SUB     .L2X    A3,B1,B1
	.line	23
;------------------------------------------------------------------------------
; 108 | imag[i2]       = (imag[i2] + imag[l]);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(20),B2
           NOP             4
           MV      .L1X    B2,A3

           LDW     .D1     *+A3[A7],A3
||         LDW     .D2     *+B2[B6],B3
           NOP             4
           ADD     .L2X    A3,B3,B3
           STW     .D2     B3,*+B2[B6]
	.line	24
;------------------------------------------------------------------------------
; 109 | real[l]       = MUL_SHIFT((-s*yt - c*xt));
;------------------------------------------------------------------------------

           MPYLH   .M2     B1,B5,B6
||         MPYLH   .M1X    B0,A9,A1

           MPYLH   .M2     B5,B1,B2
||         MPYLH   .M1X    A9,B0,A5
           MV      .L1X    B5,A3

           ADD     .L1     A1,A5,A3
||         MPYU    .M1X    B1,A3,A4
||         ADD     .L2     B6,B2,B6

           LDW     .D2     *+SP(16),A5
||         SHL     .S2     B6,0x10,B6
||         MPYU    .M2X    B0,A9,B2

           ADD     .L2X    A4,B6,B6
||         SHL     .S1     A3,0x10,A3

           ADD     .L1X    B2,A3,A3
||         NEG     .L2     B6,B6
           SUB     .L1X    B6,A3,A3
           SHR     .S1     A3,15,A3
           STW     .D1     A3,*+A5[A7]
	.line	25
;------------------------------------------------------------------------------
; 110 | imag[l]       = MUL_SHIFT((-c*yt + s*xt));
;------------------------------------------------------------------------------
           MPYLH   .M2X    A9,B1,B6

           MPYLH   .M2     B0,B5,B3
||         MPYLH   .M1X    B1,A9,A3
           MPYLH   .M2     B5,B0,B2
           ADD     .L1X    A3,B6,A3

           LDW     .D2     *+SP(20),A4
||         ADD     .L2     B3,B2,B0
||         MPYU    .M2     B0,B5,B6
||         MPYU    .M1X    B1,A9,A5

           SHL     .S1     A3,0x10,A3
||         SHL     .S2     B0,0x10,B0

           ADD     .L2     B6,B0,B0
||         ADD     .L1     A5,A3,A3
           SUB     .L2X    B0,A3,B6
           SHR     .S2     B6,15,B6
           STW     .D1     B6,*+A4[A7]
	.line	17
           ADD     .L2     B8,B4,B4
           CMPLT   .L2     B4,B7,B0
   [ B0]   B       .S1     L23
           NOP             5
           ; BRANCH OCCURS
L24:        
	.line	13
           ADD     .L1     1,A6,A6
           CMPLT   .L1     A6,A8,A1
   [ A1]   B       .S1     L22
           NOP             5
           ; BRANCH OCCURS
L25:        
	.line	28
           LDW     .D2     *++SP(32),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	113,000080000h,32


	.sect	".text"
	.global	_fft_step4
	.sym	_fft_step4,_fft_step4,32,2,0
	.func	115

;***************************************************************
;* FUNCTION NAME: _fft_step4                                   *
;*                                                             *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A9,A10,A11,   *
;*                           A12,B0,B1,B2,B3,B4,B5,B6,B7,B8,B9,*
;*                           SP                                *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,*
;*                           A12,B0,B1,B2,B3,B4,B5,B6,B7,B8,B9,*
;*                           B14,SP                            *
;*   Local Frame Size  : 0 Args + 56 Auto + 16 Save = 72 byte  *
;***************************************************************
_fft_step4:
           STW     .D2     B3,*SP--(72)
           STW     .D2     A10,*+SP(60)
           STW     .D2     A11,*+SP(64)
           STW     .D2     A12,*+SP(68)
	.sym	_nn,4,4,17,32
	.sym	_nn2,20,4,17,32
	.sym	_ie,6,4,17,32
	.sym	_x,22,20,17,32
	.sym	_y,8,20,17,32
	.sym	_nn,4,4,1,32
	.sym	_nn2,8,4,1,32
	.sym	_ie,12,4,1,32
	.sym	_x,7,20,4,32
	.sym	_y,8,20,4,32
	.sym	_ia1,16,4,1,32
	.sym	_ia2,20,4,1,32
	.sym	_ia3,24,4,1,32
	.sym	_n,22,4,4,32
	.sym	_n1,23,4,4,32
	.sym	_n2,9,4,4,32
	.sym	_i,6,4,4,32
	.sym	_i0,11,4,4,32
	.sym	_i1,10,4,4,32
	.sym	_i2,5,4,4,32
	.sym	_i3,2,4,4,32
	.sym	_j,3,4,4,32
	.sym	_t,0,4,4,32
	.sym	_r1,21,4,4,32
	.sym	_r2,20,4,4,32
	.sym	_s1,4,4,4,32
	.sym	_s2,1,4,4,32
	.sym	_tmp,0,4,4,32
	.sym	_co1,28,4,1,32
	.sym	_co2,32,4,1,32
	.sym	_co3,36,4,1,32
	.sym	_si1,40,4,1,32
	.sym	_si2,44,4,1,32
	.sym	_si3,48,4,1,32
	.sym	_wsin,52,20,1,32
	.sym	_wcos,56,20,1,32
	.line	1
;------------------------------------------------------------------------------
; 115 | void fft_step4(int nn,int nn2,int ie,register FFT_TYPE *x,register F  \
;       FT_TYPE *y) {
; 116 | int ia1,ia2,ia3;
; 117 | register int n,n1,n2,i,i0,i1,i2,i3,j;
; 118 | register FFT_TYPE t,r1,r2,s1,s2,tmp;
; 119 | FFT_TYPE co1,co2,co3,si1,si2,si3,*wsin,*wcos;
;------------------------------------------------------------------------------
           STW     .D2     A6,*+SP(12)

           STW     .D2     B4,*+SP(8)
||         MV      .L2X    A4,B5

           MV      .L1X    B6,A7
||         STW     .D2     B5,*+SP(4)
	.line	7
;------------------------------------------------------------------------------
; 121 | n=nn;
;------------------------------------------------------------------------------
           MV      .L2     B5,B6
	.line	8
;------------------------------------------------------------------------------
; 122 | n1=nn2;
;------------------------------------------------------------------------------
           MV      .L2     B4,B7
	.line	9
;------------------------------------------------------------------------------
; 123 | n2=nn2>>2;
;------------------------------------------------------------------------------
           SHR     .S1X    B4,2,A9
	.line	10
;------------------------------------------------------------------------------
; 124 | ia1=0;
;------------------------------------------------------------------------------
           ZERO    .L1     A0
           STW     .D2     A0,*+SP(16)
	.line	11
;------------------------------------------------------------------------------
; 125 | wsin=fft_SIN;
;------------------------------------------------------------------------------
           MVK     .S1     _fft_SIN,A0
           MVKH    .S1     _fft_SIN,A0
           STW     .D2     A0,*+SP(52)
	.line	12
;------------------------------------------------------------------------------
; 126 | wcos=fft_COS;
;------------------------------------------------------------------------------
           LDW     .D2     *+B14(_fft_COS),B4
           NOP             4
           STW     .D2     B4,*+SP(56)
	.line	16
;------------------------------------------------------------------------------
; 130 | for(j=0;j<n2;j++) {
;------------------------------------------------------------------------------
           ZERO    .L1     A3
           CMPLT   .L1     A3,A9,A1
   [!A1]   B       .S1     L31
           NOP             5
           ; BRANCH OCCURS
L28:        
	.line	17
;------------------------------------------------------------------------------
; 131 | ia2=ia1+ia1;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),A0
           NOP             4
           MV      .L2X    A0,B4
           ADD     .L1X    B4,A0,A0
           STW     .D2     A0,*+SP(20)
	.line	18
;------------------------------------------------------------------------------
; 132 | ia3=ia2+ia1;
;------------------------------------------------------------------------------
           ADD     .L1X    B4,A0,A0
           STW     .D2     A0,*+SP(24)
	.line	19
;------------------------------------------------------------------------------
; 133 | co1=wcos[ia1];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(56),A4
           NOP             3
           MV      .L1X    B4,A0
           LDW     .D1     *+A4[A0],A0
           NOP             4
           STW     .D2     A0,*+SP(28)
	.line	20
;------------------------------------------------------------------------------
; 134 | si1=wsin[ia1];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(52),B5
           NOP             4
           LDW     .D2     *+B5[B4],B4
           NOP             4
           STW     .D2     B4,*+SP(40)
	.line	21
;------------------------------------------------------------------------------
; 135 | co2=wcos[ia2];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(20),A0
           NOP             4
           LDW     .D1     *+A4[A0],A0
           NOP             4
           STW     .D2     A0,*+SP(32)
	.line	22
;------------------------------------------------------------------------------
; 136 | si2=wsin[ia2];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(20),B4
           NOP             4
           LDW     .D2     *+B5[B4],B4
           NOP             4
           STW     .D2     B4,*+SP(44)
	.line	23
;------------------------------------------------------------------------------
; 137 | co3=wcos[ia3];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),A0
           NOP             4
           LDW     .D1     *+A4[A0],A0
           NOP             4
           STW     .D2     A0,*+SP(36)
	.line	24
;------------------------------------------------------------------------------
; 138 | si3=wsin[ia3];
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(24),B4
           NOP             4
           LDW     .D2     *+B5[B4],B4
           NOP             4
           STW     .D2     B4,*+SP(48)
	.line	25
;------------------------------------------------------------------------------
; 139 | ia1=(ia1+ie)%5120;
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(16),A0

           B       .S1     __I_MOD
||         LDW     .D2     *+SP(12),B4
           NOP             2
           MVK     .S2     RL12,B3
           MVKH    .S2     RL12,B3

           MVK     .S2     5120,B4
||         ADD     .L1X    B4,A0,A4
RL12:      ; CALL OCCURS
           MV      .L2X    A4,B4
           STW     .D2     B4,*+SP(16)
	.line	28
;------------------------------------------------------------------------------
; 142 | for (i=j;i<n;i+=n1) {
;------------------------------------------------------------------------------
           MV      .L1     A3,A6
           CMPLT   .L1X    A6,B6,A1
   [!A1]   B       .S1     L30
           NOP             5
           ; BRANCH OCCURS
L29:        
	.line	29
;------------------------------------------------------------------------------
; 143 | i0=i<<1;
;------------------------------------------------------------------------------
           SHL     .S1     A6,1,A11
	.line	30
;------------------------------------------------------------------------------
; 144 | i2= i+n2;
;------------------------------------------------------------------------------
           ADD     .L1     A9,A6,A5
	.line	31
;------------------------------------------------------------------------------
; 145 | i1=i2+n2;
;------------------------------------------------------------------------------
           ADD     .L1     A9,A5,A10
	.line	32
;------------------------------------------------------------------------------
; 146 | i3=i1+n2;
;------------------------------------------------------------------------------
           ADD     .L1     A9,A10,A2
	.line	33
;------------------------------------------------------------------------------
; 147 | i1<<=1;
;------------------------------------------------------------------------------
           SHL     .S1     A10,1,A10
	.line	34
;------------------------------------------------------------------------------
; 148 | i2<<=1;
;------------------------------------------------------------------------------
           SHL     .S1     A5,1,A5
	.line	35
;------------------------------------------------------------------------------
; 149 | i3<<=1;
;------------------------------------------------------------------------------
           SHL     .S1     A2,1,A2
	.line	37
;------------------------------------------------------------------------------
; 151 | tmp=x[i2];
;------------------------------------------------------------------------------
           LDW     .D1     *+A7[A5],A0
	.line	38
;------------------------------------------------------------------------------
; 152 | r1=x[i0];
;------------------------------------------------------------------------------
           LDW     .D1     *+A7[A11],B4
           NOP             4
           MV      .L2     B4,B5
	.line	39
;------------------------------------------------------------------------------
; 153 | r2=r1-tmp;
;------------------------------------------------------------------------------
           SUB     .L2X    B5,A0,B4
	.line	40
;------------------------------------------------------------------------------
; 154 | r1+=tmp;
;------------------------------------------------------------------------------
           ADD     .L2X    A0,B5,B5
	.line	41
;------------------------------------------------------------------------------
; 155 | t=x[i1]+x[i3];
;------------------------------------------------------------------------------
           LDW     .D1     *+A7[A2],A4
           LDW     .D1     *+A7[A10],A0
           NOP             4
           ADD     .L1     A4,A0,A0
	.line	42
;------------------------------------------------------------------------------
; 156 | x[i0]=(r1+t);
;------------------------------------------------------------------------------
           ADD     .L1X    A0,B5,A4
           STW     .D1     A4,*+A7[A11]
	.line	43
;------------------------------------------------------------------------------
; 157 | r1-=t;
;------------------------------------------------------------------------------
           SUB     .L2X    B5,A0,B5
	.line	44
;------------------------------------------------------------------------------
; 158 | tmp=y[i2];
;------------------------------------------------------------------------------
           LDW     .D1     *+A8[A5],A0
	.line	45
;------------------------------------------------------------------------------
; 159 | s1=y[i0];
;------------------------------------------------------------------------------
           LDW     .D1     *+A8[A11],A4
           NOP             4
	.line	46
;------------------------------------------------------------------------------
; 160 | s2=s1-tmp;
;------------------------------------------------------------------------------
           SUB     .L1     A4,A0,A1
	.line	47
;------------------------------------------------------------------------------
; 161 | s1+=tmp;
;------------------------------------------------------------------------------
           ADD     .L1     A0,A4,A4
	.line	48
;------------------------------------------------------------------------------
; 162 | t=y[i1]+y[i3];
;------------------------------------------------------------------------------
           LDW     .D1     *+A8[A2],A12
           LDW     .D1     *+A8[A10],A0
           NOP             4
           ADD     .L1     A12,A0,A0
	.line	49
;------------------------------------------------------------------------------
; 163 | y[i0]=(s1+t);
;------------------------------------------------------------------------------
           ADD     .L1     A0,A4,A12
           STW     .D1     A12,*+A8[A11]
	.line	50
;------------------------------------------------------------------------------
; 164 | s1-=t;
;------------------------------------------------------------------------------
           SUB     .L1     A4,A0,A4
	.line	51
;------------------------------------------------------------------------------
; 165 | x[i2]=MUL_SHIFT(r1*co2-s1*si2);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(44),B9
           NOP             1
           LDW     .D2     *+SP(32),B8
           NOP             2
           MPYLH   .M1X    A4,B9,A0
           MPYLH   .M1X    B9,A4,A11
           MPYLH   .M2     B5,B8,B0

           MPYLH   .M2     B8,B5,B1
||         ADD     .L1     A11,A0,A0
           MPYU    .M1X    B9,A4,A11

           ADD     .L2     B1,B0,B8
||         MPYU    .M2     B8,B5,B9

           SHL     .S1     A0,0x10,A0
||         SHL     .S2     B8,0x10,B8

           ADD     .L1     A11,A0,A0
||         ADD     .L2     B9,B8,B8
           SUB     .L1X    B8,A0,A0
           SHR     .S1     A0,15,A0
           STW     .D1     A0,*+A7[A5]
	.line	52
;------------------------------------------------------------------------------
; 166 | y[i2]=MUL_SHIFT(s1*co2+r1*si2);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(44),B8
           LDW     .D2     *+SP(32),B9
           NOP             4

           MPYLH   .M1X    B9,A4,A0
||         MPYLH   .M2     B5,B8,B0

           MPYLH   .M1X    A4,B9,A11
||         MPYLH   .M2     B8,B5,B1
           NOP             1

           ADD     .L2     B1,B0,B5
||         MPYU    .M2     B8,B5,B8
||         ADD     .L1     A0,A11,A0
||         MPYU    .M1X    B9,A4,A4

           SHL     .S1     A0,0x10,A0
||         SHL     .S2     B5,0x10,B5

           ADD     .L2     B8,B5,B5
||         ADD     .L1     A4,A0,A0
           ADD     .L2X    B5,A0,B5
           SHR     .S2     B5,15,B5
           STW     .D1     B5,*+A8[A5]
	.line	53
;------------------------------------------------------------------------------
; 167 | t=y[i1]-y[i3];
;------------------------------------------------------------------------------
           LDW     .D1     *+A8[A2],A0
           LDW     .D1     *+A8[A10],B5
           NOP             4
           SUB     .L1X    B5,A0,A0
	.line	54
;------------------------------------------------------------------------------
; 168 | r1=r2+t;
;------------------------------------------------------------------------------
           ADD     .L2X    A0,B4,B5
	.line	55
;------------------------------------------------------------------------------
; 169 | r2-=t;
;------------------------------------------------------------------------------
           SUB     .L2X    B4,A0,B4
	.line	56
;------------------------------------------------------------------------------
; 170 | t=x[i1]-x[i3];
;------------------------------------------------------------------------------
           LDW     .D1     *+A7[A2],A0
           LDW     .D1     *+A7[A10],A4
           NOP             4
           SUB     .L1     A4,A0,A0
	.line	57
;------------------------------------------------------------------------------
; 171 | s1=s2-t;
;------------------------------------------------------------------------------
           SUB     .L1     A1,A0,A4
	.line	58
;------------------------------------------------------------------------------
; 172 | s2+=t;
;------------------------------------------------------------------------------
           ADD     .L1     A0,A1,A1
	.line	59
;------------------------------------------------------------------------------
; 173 | x[i1]=MUL_SHIFT(r1*co1-s1*si1);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(28),B8
           LDW     .D2     *+SP(40),A0
           NOP             4

           MPYLH   .M2     B8,B5,B0
||         MPYLH   .M1     A4,A0,A5

           MPYLH   .M2     B5,B8,B9
||         MPYLH   .M1     A0,A4,A11
           NOP             1

           ADD     .L1     A11,A5,A0
||         MPYU    .M1     A0,A4,A5
||         ADD     .L2     B0,B9,B8
||         MPYU    .M2     B8,B5,B9

           SHL     .S1     A0,0x10,A0
||         SHL     .S2     B8,0x10,B8

           ADD     .L1     A5,A0,A0
||         ADD     .L2     B9,B8,B8
           SUB     .L2X    B8,A0,B8
           SHR     .S2     B8,15,B8
           STW     .D1     B8,*+A7[A10]
	.line	60
;------------------------------------------------------------------------------
; 174 | y[i1]=MUL_SHIFT(s1*co1+r1*si1);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(28),B9
           LDW     .D2     *+SP(40),B8
           NOP             3
           MV      .L1X    B5,A0

           MPYLH   .M1X    B9,A4,A5
||         MPYLH   .M2     B8,B5,B1

           MPYLH   .M1X    A4,B9,A11
||         MPYLH   .M2     B5,B8,B0

           MPYU    .M2X    B9,A4,B8
||         MPYU    .M1X    B8,A0,A4

           ADD     .L2     B1,B0,B5
||         ADD     .L1     A5,A11,A0

           SHL     .S2     B5,0x10,B5
||         SHL     .S1     A0,0x10,A0

           ADD     .L1X    B8,A0,A0
||         ADD     .L2X    A4,B5,B5
           ADD     .L1X    B5,A0,A0
           SHR     .S1     A0,15,A0
           STW     .D1     A0,*+A8[A10]
	.line	61
;------------------------------------------------------------------------------
; 175 | x[i3]=MUL_SHIFT(r2*co3-s2*si3);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(36),B5
           LDW     .D2     *+SP(48),B8
           NOP             2
           MV      .L1X    B4,A0

           MPYLH   .M1X    B5,A0,A0
||         MPYLH   .M2     B4,B5,B9

           MPYLH   .M2X    B8,A1,B0
||         MPYLH   .M1X    A1,B8,A4
           ADD     .L1X    A0,B9,A0

           ADD     .L2X    B0,A4,B5
||         MPYU    .M2     B5,B4,B9
           MPYU    .M2X    B8,A1,B8

           SHL     .S1     A0,0x10,A0
||         SHL     .S2     B5,0x10,B5

           ADD     .L2     B8,B5,B5
||         ADD     .L1X    B9,A0,A0
           SUB     .L2X    A0,B5,B5
           SHR     .S2     B5,15,B5
           STW     .D1     B5,*+A7[A2]
	.line	62
;------------------------------------------------------------------------------
; 176 | y[i3]=MUL_SHIFT(s2*co3+r2*si3);
;------------------------------------------------------------------------------
           LDW     .D2     *+SP(36),B5
           LDW     .D2     *+SP(48),A4
           NOP             3
           MPYLH   .M1X    B5,A1,A5

           MPYLH   .M1X    B4,A4,A0
||         MPYLH   .M2X    A4,B4,B8

           MPYU    .M1X    A4,B4,A4
||         MPYLH   .M2X    A1,B5,B9
           MPYU    .M2X    B5,A1,B4

           ADD     .L1X    B8,A0,A0
||         ADD     .L2X    A5,B9,B5

           SHL     .S1     A0,0x10,A0
||         SHL     .S2     B5,0x10,B5

           ADD     .L2     B4,B5,B5
||         ADD     .L1     A4,A0,A0
           ADD     .L2X    A0,B5,B4
           SHR     .S2     B4,15,B4
           STW     .D1     B4,*+A8[A2]
	.line	28
           ADD     .L1X    B7,A6,A6
           CMPLT   .L2X    A6,B6,B0
   [ B0]   B       .S1     L29
           NOP             5
           ; BRANCH OCCURS
L30:        
	.line	16
           ADD     .L1     1,A3,A3
           CMPLT   .L1     A3,A9,A1
   [ A1]   B       .S1     L28
           NOP             5
           ; BRANCH OCCURS
L31:        
	.line	65
           LDW     .D2     *+SP(68),A12
           LDW     .D2     *+SP(64),A11
           LDW     .D2     *+SP(60),A10
           LDW     .D2     *++SP(72),B3
           NOP             4
           B       .S2     B3
           NOP             5
           ; BRANCH OCCURS
	.endfunc	179,000081c00h,72



;******************************************************
;* UNDEFINED EXTERNAL REFERENCES                      *
;******************************************************
	.global	_fft_SIN
	.global	_fft_COS
	.global	_prof_stop
	.global	_prof_start
	.global	__I_MOD
