
/*
  ETI
  The ETI-frames are never touched!
  These Files only provides a set of convenient access routines
  and serves as an interface. Here, you won't find IO routines!
  The routines are based upon ETI-NI-frames with ERR/FSYNC at
  the beginning!

  */

#include "eti.h"
#include "parameters.h"

WORD eti_sort_SSTC[64];
WORD *eti_MSTadress[64];
WORD *eti_dataoffset;

int eti_ERR(WORD *eti_ni_frame) { return(eti_ni_frame[0]>>24); }
int eti_FSYNC(WORD *eti_ni_frame) { return(eti_ni_frame[0]&0x00ffffff); }

int eti_FCT(WORD *eti_ni_frame) { return(eti_ni_frame[1]>>24); }
int eti_FICF(WORD *eti_ni_frame){ return((eti_ni_frame[1]&0x00800000)>0); }
int eti_NST(WORD *eti_ni_frame) { return((eti_ni_frame[1]&0x007f0000)>>16); }
int eti_FP(WORD *eti_ni_frame)  { return((eti_ni_frame[1]&0x0000e000)>>13); }
int eti_MID(WORD *eti_ni_frame) { return((eti_ni_frame[1]&0x00001800)>>11); }
int eti_FL(WORD *eti_ni_frame)  { return((eti_ni_frame[1]&0x000007ff) ); }

/* these funcs work on the eti-frame
   nr von 0 bis NST-1 */
unsigned int eti_u_SSTC(WORD *eti_ni_frame,int nr) {
  return (eti_ni_frame[2+nr]); }
int eti_u_SCID(WORD *eti_ni_frame,int nr) {
  return((eti_ni_frame[2+nr]&0xfc000000)>>26); }
int eti_u_SAD(WORD *eti_ni_frame,int nr) {
  return((eti_ni_frame[2+nr]&0x03ff0000)>>16); }
int eti_u_TPL(WORD *eti_ni_frame,int nr) {
  return((eti_ni_frame[2+nr]&0x0000fc00)>>10); }
int eti_u_STL(WORD *eti_ni_frame,int nr) {
  return((eti_ni_frame[2+nr]&0x000003ff) ); }

int eti_MNSC(WORD *eti_ni_frame) { 
  return((eti_ni_frame[(eti_NST(eti_ni_frame)+2)]&0xffff0000)>>16); }
int eti_CRCH(WORD *eti_ni_frame) {
  return((eti_ni_frame[(eti_NST(eti_ni_frame)+2)]&0x0000ffff) ); }

WORD *eti_FIC(WORD *eti_ni_frame) {
  if (eti_FICF(eti_ni_frame)) {
    return(eti_ni_frame+eti_NST(eti_ni_frame)+3); }
  else return(0);
}

int eti_CRCM(WORD *eti_ni_frame) {
  return( (eti_ni_frame[eti_FL(eti_ni_frame)+2]&0xffff0000)>>16 ); }
int eti_Rfu(WORD *eti_ni_frame) {
  return( eti_ni_frame[eti_FL(eti_ni_frame)+2]&0x0000ffff); }

unsigned int eti_TIST(WORD *eti_ni_frame) {
  return( eti_ni_frame[eti_FL(eti_ni_frame)+3] ); }


void eti_sort_STC(WORD *eti_ni_frame) {
  int i,j;
  WORD tval,ttmp,*offset,*tdat,*t;
   
  /* calculate all MST-startadresses and copy the SSTC */
  offset= eti_ni_frame + 3 + eti_NST(eti_ni_frame) + 
    (eti_FICF(eti_ni_frame)*FicSize);
  eti_dataoffset=offset;
  for(i=0;i<eti_NST(eti_ni_frame);i++) {
    eti_sort_SSTC[i]=eti_u_SSTC(eti_ni_frame,i);
    eti_MSTadress[i]=offset;
    offset+=eti_u_STL(eti_ni_frame,i)*2;
  }

  /* bubble-sort over sad (smallest first) 
     sorts the MSTadress accordingly
   */
  for (i=0;i<eti_NST(eti_ni_frame)-1;i++) {
    tval=eti_sort_SSTC[i];
    tdat=eti_MSTadress[i];
    for (j=i+1;j<eti_NST(eti_ni_frame);j++) {
      if (((tval>>16)&1023) > ((eti_ni_frame[j+2]>>16)&1023)) {
	/* switching tval & eti_ni_frame[2+j] */
	ttmp=tval;
	tval=eti_sort_SSTC[j];
	eti_sort_SSTC[j]=ttmp;
	/* switching tdat & eti_MSTadress[j] */
	t=eti_MSTadress[j];
	eti_MSTadress[j]=tdat;
	tdat=t;
      }
    }
    eti_sort_SSTC[i]=tval;
    eti_MSTadress[i]=tdat;
  }
}

int eti_checkcrch(WORD *eti_niframe) {
  int t,off;

  off=(eti_NST(eti_niframe)+1)*4; /* EOH offset in Bytes */
  t=crc_calc(eti_niframe+1,off+2);

  if ( t == eti_CRCH(eti_niframe) ) return(TRUE);
  else return(FALSE);
}

int eti_checkcrcm(WORD *eti_niframe) {
  int t,off1,off2;

  off1=(eti_NST(eti_niframe)+3);   /* MST offset in Words */
  off2=(eti_FL(eti_niframe)+2)*4;  /* EOF offset in Bytes */
  t=crc_calc(eti_niframe+off1,off2-off1*4);

  if ( t == eti_CRCM(eti_niframe) ) return(TRUE);
  else return(FALSE);
}

