
/*

  Type and Protectionlevel

  */

#include "conf.h"
#include "tpl.h"

t_Profil Profil;
BYTE tab_stl[14]={ 12,18,21,24,30,36,42,48,60,72,84,96,120,144 };

/* AFAIK it is possible to condesense the three tables into two */

/* tab_L consists of L1-L4,each 8 bits long
   sorted as ProtectionLevel*14+idx(STL,tab_stl)
   */
WORD tab_L[70] = {
 0x03050D03, 0x03051903, 0x00000000, 0x060B1C03, 0x060A2903,
 0x060D3203, 0x00000000, 0x0B143E03, 0x0B165403, 0x0B156D03,
 0x0B188203, 0x0B1A9803, 0x00000000, 0x0C1CF503, 0x03040E03,
 0x03041A03, 0x060A1703, 0x060A1D03, 0x060A2903, 0x060A3503,
 0x0B153103, 0x0B153D03, 0x0B155503, 0x0B146E03, 0x0B168403,
 0x0B169C03, 0x0B1AC803, 0x00000000, 0x03040E03, 0x03041A03,
 0x060C1503, 0x060C1B03, 0x060B2803, 0x060C3303, 0x0B172F03,
 0x0B163C03, 0x0B185203, 0x0B186A03, 0x0B148603, 0x0B1B9703,
 0x00000000, 0x0B18FA03, 0x03031200, 0x03041A03, 0x060A1703,
 0x06092100, 0x060A2903, 0x070A3403, 0x0B153103, 0x0B153D03,
 0x0B175303, 0x0B166C03, 0x0C1A7F03, 0x0B189A03, 0x0B19C903,
 0x00000000, 0x03041100, 0x04031A03, 0x060A1703, 0x06091F02,
 0x060A2903, 0x07093503, 0x0E113203, 0x0C133E03, 0x0B135703,
 0x0B146E03, 0x0C168303, 0x0B189A03, 0x0B1AC803, 0x0B1BF703
};

/* tab_PrI consists of PrI1-4,each 8 bits long
   sorted by ProtectionLevel*14+idx(STL,tab_stl)
   */
WORD tab_PrI[70]={
 0x18110C11, 0x18120D12, 0x00000000, 0x18120C12, 0x18110C12,
 0x18120D13, 0x00000000, 0x18110D13, 0x18120C13, 0x18140D18,
 0x18140C14, 0x18130E12, 0x00000000, 0x18140E17, 0x160D080D,
 0x180E080F, 0x170D080D, 0x170D080D, 0x170D080D, 0x160C090C,
 0x170C090E, 0x160C090E, 0x160B090D, 0x160D090D, 0x18100A0F,
 0x180E0A0D, 0x18110911, 0x00000000, 0x0F090608, 0x0F0A0609,
 0x10070609, 0x10080609, 0x10080607, 0x1009060A, 0x10080609,
 0x1009060A, 0x1008060B, 0x100A060B, 0x100A0709, 0x100A070A,
 0x00000000, 0x1009070A, 0x0B060500, 0x09060406, 0x09060405,
 0x0B060500, 0x0B060506, 0x09060406, 0x09060408, 0x0B060507,
 0x0B060509, 0x0A060409, 0x0C080401, 0x0C09050A, 0x0D09050A,
 0x00000000, 0x05030200, 0x05040203, 0x05040203, 0x05030203,
 0x06030203, 0x05040204, 0x05040205, 0x05030204, 0x05040204,
 0x06040205, 0x08060206, 0x06050205, 0x08050206, 0x08060207
};

/* tab_SCS consists of the Subchannelsize AFTER puncturing (in CUs) */
SHORT tab_SCS[70]= {
  /*              BitRate
      32     48     56     64     80     96    112    128    160    192    224    256    320    384      PL*/
  0x0023,0x0034,0x0000,0x0046,0x0054,0x0068,0x0000,0x008C,0x00A8,0x00D0,0x00E8,0x0118,0x0000,0x01A0,/* 1 */
  0x001D,0x002A,0x0034,0x003A,0x0046,0x0054,0x0068,0x0074,0x008C,0x00A8,0x00D0,0x00E8,0x0118,0x0000,/* 2 */
  0x0018,0x0023,0x002A,0x0030,0x003A,0x0046,0x0054,0x0060,0x0074,0x008C,0x00A8,0x00C0,0x0000,0x0118,/* 3 */
  0x0015,0x001D,0x0023,0x002A,0x0034,0x003A,0x0046,0x0054,0x0068,0x0074,0x008C,0x00A8,0x00D0,0x0000,/* 4 */
  0x0010,0x0018,0x001D,0x0020,0x0028,0x0030,0x003A,0x0040,0x0050,0x0060,0x0074,0x0080,0x00A0,0x00C0 /* 5 */
};

void decode_TPL(WORD SSTC) {
  int i,n,pl,option,tmp;
  int tpl,stl,idx_stl;

  stl=SSTC&0x000003ff;
  tpl=((SSTC>>10)&63);

  if ((tpl&32)>0) {
    /* Equal Error Protection */
    option=(tpl & 31)>>2;
    pl=(tpl&3)+1;
    if (option==0) {
      /* multiple of 8 kbit/s */
      n=stl/3;
      if (pl==4) {
	Profil.L[0]=4*n-3;Profil.L[1]=2*n+3;Profil.L[2]=0;Profil.L[3]=0;
	Profil.PrI[0]=3;Profil.PrI[1]=2;
	Profil.SCS=(4*((4*n-3)*(8+3)+(2*n+3)*(8+2))+12)/64;
      } else if (pl==3) {
	Profil.L[0]=6*n-3;Profil.L[1]=3;Profil.L[2]=0;Profil.L[3]=0;
	Profil.PrI[0]=8;Profil.PrI[1]=7;
	Profil.SCS=(4*((6*n-3)*(8+8)+3*(8+7))+12)/64;
      } else if (pl==2) {
	if (n>1) {
	  Profil.L[0]=2*n-3;Profil.L[1]=4*n+3;Profil.L[2]=0;Profil.L[3]=0;
	  Profil.PrI[0]=14;Profil.PrI[1]=13;
	  Profil.SCS=(4*((2*n-3)*(8+14)+(4*n+3)*(8+13))+12)/64;
	} else {
	  Profil.L[0]=5;Profil.L[1]=1;Profil.L[2]=0;Profil.L[3]=0;
	  Profil.PrI[0]=13;Profil.PrI[1]=12;
	  Profil.SCS=(4*(5*(8+13)+1*(8+12))+12)/64;
	}
      } else if (pl==1) {
	Profil.L[0]=6*n-3;Profil.L[1]=3;Profil.L[2]=0;Profil.L[3]=0;
	Profil.PrI[0]=24;Profil.PrI[1]=23;
	Profil.SCS=(4*((6*n-3)*(8+24)+3*(8+23))+12)/64;
      }
    } else if (option==1) {
      /* multiple of 32kbit/s */
      n=stl/12;
      Profil.L[0]=24*n-3;Profil.L[1]=3;Profil.L[2]=0;Profil.L[3]=0;
      if (pl==4) {
	Profil.PrI[0]=2;Profil.PrI[1]=1;
	Profil.SCS=(4*((24*n-3)*(8+2)+3*(8+1))+12)/64;
      } else if (pl==3) {
	Profil.PrI[0]=4;Profil.PrI[1]=3;
	Profil.SCS=(4*((24*n-3)*(8+4)+3*(8+3))+12)/64;
      } else if (pl==2) {
	Profil.PrI[0]=6;Profil.PrI[1]=5;
	Profil.SCS=(4*((24*n-3)*(8+6)+3*(8+5))+12)/64;
      } else if (pl==1) {
	Profil.PrI[0]=10;Profil.PrI[1]=9;
	Profil.SCS=(4*((24*n-3)*(8+10)+3*(8+9))+12)/64;
      }
    } else {
      /* printf("Error in decodeTPL: unknown option\n"); */
    }
  } else {
    /* Unequal Error protection */
    if ((tpl & 16)==0) printf("decodeTPL: Rfu used\n"); /* Rfu used */
    if ((tpl & 8)>0) printf("decodeTPL: alternate Table\n");  /* Table */
    pl=(tpl&7)+1;
    if (pl>5) printf("decodeTPL: invalid protectionlevel\n"); /* pl */
    for (i=0;i<14;i++) {
      if (stl==tab_stl[i]) break;
    }
    if (i==14) {
      /* Some error routine.. for UNIX just printf */
      printf("Error in decode_TPL: unknown BitRate\n");
      i=13;
    }
    idx_stl=i;
    tmp=tab_L[(pl-1)*14+idx_stl];
    Profil.L[0]=tmp>>24;
    Profil.L[1]=(tmp>>16)&255;
    Profil.L[2]=(tmp>>8)&255;
    Profil.L[3]=tmp&255;
    tmp=tab_PrI[(pl-1)*14+idx_stl];
    Profil.PrI[0]=tmp>>24;
    Profil.PrI[1]=(tmp>>16)&255;
    Profil.PrI[2]=(tmp>>8)&255;
    Profil.PrI[3]=tmp&255;
    Profil.SCS=tab_SCS[(pl-1)*14+idx_stl];
  }
}
