
/*
  

  alt3-conv-enc
  based on a step4 conv-algorithm
  using look-up tables

*/

#include "conf.h"
#include "prbs.h"


BYTE punct_len[24][8]={
  {2,1,1,1,1,1,1,1},{2,1,1,1,2,1,1,1},{2,1,2,1,2,1,1,1},{2,1,2,1,2,1,2,1},
  {2,2,2,1,2,1,2,1},{2,2,2,1,2,2,2,1},{2,2,2,2,2,2,2,1},{2,2,2,2,2,2,2,2},
  {3,2,2,2,2,2,2,2},{3,2,2,2,3,2,2,2},{3,2,3,2,3,2,2,2},{3,2,3,2,3,2,3,2},
  {3,3,3,2,3,2,3,2},{3,3,3,2,3,3,3,2},{3,3,3,3,3,3,3,2},{3,3,3,3,3,3,3,3},
  {4,3,3,3,3,3,3,3},{4,3,3,3,4,3,3,3},{4,3,4,3,4,3,3,3},{4,3,4,3,4,3,4,3},
  {4,4,4,3,4,3,4,3},{4,4,4,3,4,4,4,3},{4,4,4,4,4,4,4,3},{4,4,4,4,4,4,4,4}
};

SHORT conv_tab[16][64];
SHORT conv_tail[64];

int conv_reg;

/* <val> is a bit (0-1), returned is a value from 0-3 */
int conv_step1(int val) {
  int a,b,c;

  a=val^((conv_reg&2)>0)^((conv_reg&4)>0)^((conv_reg&16)>0)^((conv_reg&32)>0);
  b=val^((conv_reg&1)>0)^((conv_reg&2)>0)^((conv_reg&4)>0)^((conv_reg&32)>0);
  c=val^((conv_reg&1)>0)^((conv_reg&8)>0)^((conv_reg&32)>0);

  conv_reg<<=1;
  conv_reg+=val;
  return((a<<3)+(b<<2)+(c<<1)+a);
}

void conv_init(void) {
  int i,j,k,l,m;
  int bit;
  int x,y;
  int reg,inp;

  for (j=0;j<16;j++) {
    for (i=0;i<64;i++) {
      inp=j;
      x=0;
      conv_reg=i;
      for (k=0;k<4;k++) {
	bit=inp&1;
	x<<=4;
	x+=conv_step1(bit);
	inp>>=1;
      }
      conv_tab[j][bitreversal(i,6)]=x;
    }
  }
  for (i=0;i<64;i++) {
    conv_reg=i;
    x=0;
    for (k=0;k<6;k++) {
      y+=conv_step1(0);
      y>>=2;
      x<<=2;
      x+=y;
    }
    conv_tail[i]=x;
  }
}

/* <val> is a nibble (0-15), returned is a value from 0-65535 */
int conv_step4(int val) {
  int q,r;

  q=conv_tab[val][conv_reg];
  conv_reg>>=4;
  conv_reg+=(val<<2);
  return(q);
}

int puncture(WORD src,WORD *dest,int pi) {
  int i,len,bits=0;
  WORD x=0,y;
  
  for (i=0;i<8;i++) {
    len=punct_len[pi-1][i];
    x<<=len;
    x+=(src>>32-len);
    x<<=(4-len);
    src<<=4;
    bits+=len;
  }
  *dest=x;
  return(bits);
}

/* source is the data to read, prbsoff the index of the next scramblingword,
   offset the offset in bits where to insert the next bit, dest the pointer
   to the current working place, n the number of Words to be processed and
   pi the index of the ProtectionInterval
*/
int endisp_conv_punct(WORD *source,int prbsoff,int offset,WORD *dest,int n,int pi) {
  int i,j,t,o,newoff,len,ins;
  WORD P,Q;
  WORD R,S,T;
  WORD dst,src;

  
  dest+=offset/32;
  dst=*dest;
  newoff=offset;
  o=(offset%32);
  if (o==0) dst=0;
  for (j=0;j<n;j++) {
    src=(source[j]^prbs_32(prbsoff+j));
    src=(source[j]);
    for (i=0;i<4;i++) {
      t=((src&0xf0000000)>>28);
      R=(conv_step4(t)<<16);
      t=((src&0x0f000000)>>24);
      R+=conv_step4(t);
      src<<=8;
      len=puncture(R,&S,pi);
      ins=32-o;
      /* printf("len%d ins%d dest%8x R%8x S%8x t%2x\n",len,ins,*dest,R,S,t); */
      if (ins>len) {
	dst<<=len;
	dst+=S;
	o+=len;
      } else {
	dst<<=(ins);
	dst+=(S>>(len-ins));
	*dest=dst;
	dest++;
	dst=(S&((1<<(len-ins+1))-1));
	o=(len-ins);
      }
      newoff+=len;
    }
  }
  if (o>0) *dest=dst;

#ifdef COFDM_PROFILE
  prof_stop();
#endif

  return(newoff-offset);
}

/* writes out the punctured tailvector (12 Bits)
   The tailvector is PI[7] - 1100110011001100...
   This routine expands the size of the tailvector with
   zeros to fill the WORD completely. This should be
   equal to appending the zero paddingbits.
   The routine returns the number of written plus expanded bits.
*/
int conv_punct_tail(int offset,WORD *dest) {
  int a,i,o;
  WORD t;

  o=offset;
  dest+=(offset/32);
  t=*dest;
  for (i=0;i<6;i++) {
    a=((conv_reg&2)>0)^((conv_reg&4)>0)^((conv_reg&16)>0)^((conv_reg&32)>0);
    t<<=1;
    t+=a;
    offset++;
    if ((offset%32)==0) {
      *dest=t;
      dest++;
    }
    a=((conv_reg&1)>0)^((conv_reg&2)>0)^((conv_reg&4)>0)^((conv_reg&32)>0);
    t<<=1;
    t+=a;
    offset++;
    if ((offset%32)==0) {
      *dest=t;
      dest++;
    }
    conv_reg<<=1;
  }
  if ((offset%32)!=0) {
    /* adjust to fit WORD */
    t<<=(WORDSIZE-(offset%WORDSIZE));
    *dest=t;
    offset+=(WORDSIZE-(offset%WORDSIZE));
  }
  return(offset-o);
}
