
/*
  

  alt3-conv-enc
  based on a step4 conv-algorithm
  using look-up tables
  the tail vektor may be precalculated, too

*/

#include "conf.h"
#include "prbs.h"
#include "profile.h"


BYTE punct_len[24][8]={
  {2,1,1,1,1,1,1,1},{2,1,1,1,2,1,1,1},{2,1,2,1,2,1,1,1},{2,1,2,1,2,1,2,1},
  {2,2,2,1,2,1,2,1},{2,2,2,1,2,2,2,1},{2,2,2,2,2,2,2,1},{2,2,2,2,2,2,2,2},
  {3,2,2,2,2,2,2,2},{3,2,2,2,3,2,2,2},{3,2,3,2,3,2,2,2},{3,2,3,2,3,2,3,2},
  {3,3,3,2,3,2,3,2},{3,3,3,2,3,3,3,2},{3,3,3,3,3,3,3,2},{3,3,3,3,3,3,3,3},
  {4,3,3,3,3,3,3,3},{4,3,3,3,4,3,3,3},{4,3,4,3,4,3,3,3},{4,3,4,3,4,3,4,3},
  {4,4,4,3,4,3,4,3},{4,4,4,3,4,4,4,3},{4,4,4,4,4,4,4,3},{4,4,4,4,4,4,4,4}
};

SHORT conv_tab[16][64]={
 0x0, 0x6dd2, 0xdd29, 0xb0fb, 0xd29f, 0xbf4d, 0xfb6, 0x6264,
 0x29f0, 0x4422, 0xf4d9, 0x990b, 0xfb6f, 0x96bd, 0x2646, 0x4b94,
 0x9f00, 0xf2d2, 0x4229, 0x2ffb, 0x4d9f, 0x204d, 0x90b6, 0xfd64,
 0xb6f0, 0xdb22, 0x6bd9, 0x60b, 0x646f, 0x9bd, 0xb946, 0xd494,
 0xf000, 0x9dd2, 0x2d29, 0x40fb, 0x229f, 0x4f4d, 0xffb6, 0x9264,
 0xd9f0, 0xb422, 0x4d9, 0x690b, 0xb6f, 0x66bd, 0xd646, 0xbb94,
 0x6f00, 0x2d2, 0xb229, 0xdffb, 0xbd9f, 0xd04d, 0x60b6, 0xd64,
 0x46f0, 0x2b22, 0x9bd9, 0xf60b, 0x946f, 0xf9bd, 0x4946, 0x2494,
 0xf, 0x6ddd, 0xdd26, 0xb0f4, 0xd290, 0xbf42, 0xfb9, 0x626b,
 0x29ff, 0x442d, 0xf4d6, 0x9904, 0xfb60, 0x96b2, 0x2649, 0x4b9b,
 0x9f0f, 0xf2dd, 0x4226, 0x2ff4, 0x4d90, 0x2042, 0x90b9, 0xfd6b,
 0xb6ff, 0xdb2d, 0x6bd6, 0x604, 0x6460, 0x9b2, 0xb949, 0xd49b,
 0xf00f, 0x9ddd, 0x2d26, 0x40f4, 0x2290, 0x4f42, 0xffb9, 0x926b,
 0xd9ff, 0xb42d, 0x4d6, 0x6904, 0xb60, 0x66b2, 0xd649, 0xbb9b,
 0x6f0f, 0x2dd, 0xb226, 0xdff4, 0xbd90, 0xd042, 0x60b9, 0xd6b,
 0x46ff, 0x2b2d, 0x9bd6, 0xf604, 0x9460, 0xf9b2, 0x4949, 0x249b,
 0xf6, 0x6d24, 0xdddf, 0xb00d, 0xd269, 0xbfbb, 0xf40, 0x6292,
 0x2906, 0x44d4, 0xf42f, 0x99fd, 0xfb99, 0x964b, 0x26b0, 0x4b62,
 0x9ff6, 0xf224, 0x42df, 0x2f0d, 0x4d69, 0x20bb, 0x9040, 0xfd92,
 0xb606, 0xdbd4, 0x6b2f, 0x6fd, 0x6499, 0x94b, 0xb9b0, 0xd462,
 0xf0f6, 0x9d24, 0x2ddf, 0x400d, 0x2269, 0x4fbb, 0xff40, 0x9292,
 0xd906, 0xb4d4, 0x42f, 0x69fd, 0xb99, 0x664b, 0xd6b0, 0xbb62,
 0x6ff6, 0x224, 0xb2df, 0xdf0d, 0xbd69, 0xd0bb, 0x6040, 0xd92,
 0x4606, 0x2bd4, 0x9b2f, 0xf6fd, 0x9499, 0xf94b, 0x49b0, 0x2462,
 0xf9, 0x6d2b, 0xddd0, 0xb002, 0xd266, 0xbfb4, 0xf4f, 0x629d,
 0x2909, 0x44db, 0xf420, 0x99f2, 0xfb96, 0x9644, 0x26bf, 0x4b6d,
 0x9ff9, 0xf22b, 0x42d0, 0x2f02, 0x4d66, 0x20b4, 0x904f, 0xfd9d,
 0xb609, 0xdbdb, 0x6b20, 0x6f2, 0x6496, 0x944, 0xb9bf, 0xd46d,
 0xf0f9, 0x9d2b, 0x2dd0, 0x4002, 0x2266, 0x4fb4, 0xff4f, 0x929d,
 0xd909, 0xb4db, 0x420, 0x69f2, 0xb96, 0x6644, 0xd6bf, 0xbb6d,
 0x6ff9, 0x22b, 0xb2d0, 0xdf02, 0xbd66, 0xd0b4, 0x604f, 0xd9d,
 0x4609, 0x2bdb, 0x9b20, 0xf6f2, 0x9496, 0xf944, 0x49bf, 0x246d,
 0xf6d, 0x62bf, 0xd244, 0xbf96, 0xddf2, 0xb020, 0xdb, 0x6d09,
 0x269d, 0x4b4f, 0xfbb4, 0x9666, 0xf402, 0x99d0, 0x292b, 0x44f9,
 0x906d, 0xfdbf, 0x4d44, 0x2096, 0x42f2, 0x2f20, 0x9fdb, 0xf209,
 0xb99d, 0xd44f, 0x64b4, 0x966, 0x6b02, 0x6d0, 0xb62b, 0xdbf9,
 0xff6d, 0x92bf, 0x2244, 0x4f96, 0x2df2, 0x4020, 0xf0db, 0x9d09,
 0xd69d, 0xbb4f, 0xbb4, 0x6666, 0x402, 0x69d0, 0xd92b, 0xb4f9,
 0x606d, 0xdbf, 0xbd44, 0xd096, 0xb2f2, 0xdf20, 0x6fdb, 0x209,
 0x499d, 0x244f, 0x94b4, 0xf966, 0x9b02, 0xf6d0, 0x462b, 0x2bf9,
 0xf62, 0x62b0, 0xd24b, 0xbf99, 0xddfd, 0xb02f, 0xd4, 0x6d06,
 0x2692, 0x4b40, 0xfbbb, 0x9669, 0xf40d, 0x99df, 0x2924, 0x44f6,
 0x9062, 0xfdb0, 0x4d4b, 0x2099, 0x42fd, 0x2f2f, 0x9fd4, 0xf206,
 0xb992, 0xd440, 0x64bb, 0x969, 0x6b0d, 0x6df, 0xb624, 0xdbf6,
 0xff62, 0x92b0, 0x224b, 0x4f99, 0x2dfd, 0x402f, 0xf0d4, 0x9d06,
 0xd692, 0xbb40, 0xbbb, 0x6669, 0x40d, 0x69df, 0xd924, 0xb4f6,
 0x6062, 0xdb0, 0xbd4b, 0xd099, 0xb2fd, 0xdf2f, 0x6fd4, 0x206,
 0x4992, 0x2440, 0x94bb, 0xf969, 0x9b0d, 0xf6df, 0x4624, 0x2bf6,
 0xf9b, 0x6249, 0xd2b2, 0xbf60, 0xdd04, 0xb0d6, 0x2d, 0x6dff,
 0x266b, 0x4bb9, 0xfb42, 0x9690, 0xf4f4, 0x9926, 0x29dd, 0x440f,
 0x909b, 0xfd49, 0x4db2, 0x2060, 0x4204, 0x2fd6, 0x9f2d, 0xf2ff,
 0xb96b, 0xd4b9, 0x6442, 0x990, 0x6bf4, 0x626, 0xb6dd, 0xdb0f,
 0xff9b, 0x9249, 0x22b2, 0x4f60, 0x2d04, 0x40d6, 0xf02d, 0x9dff,
 0xd66b, 0xbbb9, 0xb42, 0x6690, 0x4f4, 0x6926, 0xd9dd, 0xb40f,
 0x609b, 0xd49, 0xbdb2, 0xd060, 0xb204, 0xdfd6, 0x6f2d, 0x2ff,
 0x496b, 0x24b9, 0x9442, 0xf990, 0x9bf4, 0xf626, 0x46dd, 0x2b0f,
 0xf94, 0x6246, 0xd2bd, 0xbf6f, 0xdd0b, 0xb0d9, 0x22, 0x6df0,
 0x2664, 0x4bb6, 0xfb4d, 0x969f, 0xf4fb, 0x9929, 0x29d2, 0x4400,
 0x9094, 0xfd46, 0x4dbd, 0x206f, 0x420b, 0x2fd9, 0x9f22, 0xf2f0,
 0xb964, 0xd4b6, 0x644d, 0x99f, 0x6bfb, 0x629, 0xb6d2, 0xdb00,
 0xff94, 0x9246, 0x22bd, 0x4f6f, 0x2d0b, 0x40d9, 0xf022, 0x9df0,
 0xd664, 0xbbb6, 0xb4d, 0x669f, 0x4fb, 0x6929, 0xd9d2, 0xb400,
 0x6094, 0xd46, 0xbdbd, 0xd06f, 0xb20b, 0xdfd9, 0x6f22, 0x2f0,
 0x4964, 0x24b6, 0x944d, 0xf99f, 0x9bfb, 0xf629, 0x46d2, 0x2b00,
 0xf6dd, 0x9b0f, 0x2bf4, 0x4626, 0x2442, 0x4990, 0xf96b, 0x94b9,
 0xdf2d, 0xb2ff, 0x204, 0x6fd6, 0xdb2, 0x6060, 0xd09b, 0xbd49,
 0x69dd, 0x40f, 0xb4f4, 0xd926, 0xbb42, 0xd690, 0x666b, 0xbb9,
 0x402d, 0x2dff, 0x9d04, 0xf0d6, 0x92b2, 0xff60, 0x4f9b, 0x2249,
 0x6dd, 0x6b0f, 0xdbf4, 0xb626, 0xd442, 0xb990, 0x96b, 0x64b9,
 0x2f2d, 0x42ff, 0xf204, 0x9fd6, 0xfdb2, 0x9060, 0x209b, 0x4d49,
 0x99dd, 0xf40f, 0x44f4, 0x2926, 0x4b42, 0x2690, 0x966b, 0xfbb9,
 0xb02d, 0xddff, 0x6d04, 0xd6, 0x62b2, 0xf60, 0xbf9b, 0xd249,
 0xf6d2, 0x9b00, 0x2bfb, 0x4629, 0x244d, 0x499f, 0xf964, 0x94b6,
 0xdf22, 0xb2f0, 0x20b, 0x6fd9, 0xdbd, 0x606f, 0xd094, 0xbd46,
 0x69d2, 0x400, 0xb4fb, 0xd929, 0xbb4d, 0xd69f, 0x6664, 0xbb6,
 0x4022, 0x2df0, 0x9d0b, 0xf0d9, 0x92bd, 0xff6f, 0x4f94, 0x2246,
 0x6d2, 0x6b00, 0xdbfb, 0xb629, 0xd44d, 0xb99f, 0x964, 0x64b6,
 0x2f22, 0x42f0, 0xf20b, 0x9fd9, 0xfdbd, 0x906f, 0x2094, 0x4d46,
 0x99d2, 0xf400, 0x44fb, 0x2929, 0x4b4d, 0x269f, 0x9664, 0xfbb6,
 0xb022, 0xddf0, 0x6d0b, 0xd9, 0x62bd, 0xf6f, 0xbf94, 0xd246,
 0xf62b, 0x9bf9, 0x2b02, 0x46d0, 0x24b4, 0x4966, 0xf99d, 0x944f,
 0xdfdb, 0xb209, 0x2f2, 0x6f20, 0xd44, 0x6096, 0xd06d, 0xbdbf,
 0x692b, 0x4f9, 0xb402, 0xd9d0, 0xbbb4, 0xd666, 0x669d, 0xb4f,
 0x40db, 0x2d09, 0x9df2, 0xf020, 0x9244, 0xff96, 0x4f6d, 0x22bf,
 0x62b, 0x6bf9, 0xdb02, 0xb6d0, 0xd4b4, 0xb966, 0x99d, 0x644f,
 0x2fdb, 0x4209, 0xf2f2, 0x9f20, 0xfd44, 0x9096, 0x206d, 0x4dbf,
 0x992b, 0xf4f9, 0x4402, 0x29d0, 0x4bb4, 0x2666, 0x969d, 0xfb4f,
 0xb0db, 0xdd09, 0x6df2, 0x20, 0x6244, 0xf96, 0xbf6d, 0xd2bf,
 0xf624, 0x9bf6, 0x2b0d, 0x46df, 0x24bb, 0x4969, 0xf992, 0x9440,
 0xdfd4, 0xb206, 0x2fd, 0x6f2f, 0xd4b, 0x6099, 0xd062, 0xbdb0,
 0x6924, 0x4f6, 0xb40d, 0xd9df, 0xbbbb, 0xd669, 0x6692, 0xb40,
 0x40d4, 0x2d06, 0x9dfd, 0xf02f, 0x924b, 0xff99, 0x4f62, 0x22b0,
 0x624, 0x6bf6, 0xdb0d, 0xb6df, 0xd4bb, 0xb969, 0x992, 0x6440,
 0x2fd4, 0x4206, 0xf2fd, 0x9f2f, 0xfd4b, 0x9099, 0x2062, 0x4db0,
 0x9924, 0xf4f6, 0x440d, 0x29df, 0x4bbb, 0x2669, 0x9692, 0xfb40,
 0xb0d4, 0xdd06, 0x6dfd, 0x2f, 0x624b, 0xf99, 0xbf62, 0xd2b0,
 0xf9b0, 0x9462, 0x2499, 0x494b, 0x2b2f, 0x46fd, 0xf606, 0x9bd4,
 0xd040, 0xbd92, 0xd69, 0x60bb, 0x2df, 0x6f0d, 0xdff6, 0xb224,
 0x66b0, 0xb62, 0xbb99, 0xd64b, 0xb42f, 0xd9fd, 0x6906, 0x4d4,
 0x4f40, 0x2292, 0x9269, 0xffbb, 0x9ddf, 0xf00d, 0x40f6, 0x2d24,
 0x9b0, 0x6462, 0xd499, 0xb94b, 0xdb2f, 0xb6fd, 0x606, 0x6bd4,
 0x2040, 0x4d92, 0xfd69, 0x90bb, 0xf2df, 0x9f0d, 0x2ff6, 0x4224,
 0x96b0, 0xfb62, 0x4b99, 0x264b, 0x442f, 0x29fd, 0x9906, 0xf4d4,
 0xbf40, 0xd292, 0x6269, 0xfbb, 0x6ddf, 0xd, 0xb0f6, 0xdd24,
 0xf9bf, 0x946d, 0x2496, 0x4944, 0x2b20, 0x46f2, 0xf609, 0x9bdb,
 0xd04f, 0xbd9d, 0xd66, 0x60b4, 0x2d0, 0x6f02, 0xdff9, 0xb22b,
 0x66bf, 0xb6d, 0xbb96, 0xd644, 0xb420, 0xd9f2, 0x6909, 0x4db,
 0x4f4f, 0x229d, 0x9266, 0xffb4, 0x9dd0, 0xf002, 0x40f9, 0x2d2b,
 0x9bf, 0x646d, 0xd496, 0xb944, 0xdb20, 0xb6f2, 0x609, 0x6bdb,
 0x204f, 0x4d9d, 0xfd66, 0x90b4, 0xf2d0, 0x9f02, 0x2ff9, 0x422b,
 0x96bf, 0xfb6d, 0x4b96, 0x2644, 0x4420, 0x29f2, 0x9909, 0xf4db,
 0xbf4f, 0xd29d, 0x6266, 0xfb4, 0x6dd0, 0x2, 0xb0f9, 0xdd2b,
 0xf946, 0x9494, 0x246f, 0x49bd, 0x2bd9, 0x460b, 0xf6f0, 0x9b22,
 0xd0b6, 0xbd64, 0xd9f, 0x604d, 0x229, 0x6ffb, 0xdf00, 0xb2d2,
 0x6646, 0xb94, 0xbb6f, 0xd6bd, 0xb4d9, 0xd90b, 0x69f0, 0x422,
 0x4fb6, 0x2264, 0x929f, 0xff4d, 0x9d29, 0xf0fb, 0x4000, 0x2dd2,
 0x946, 0x6494, 0xd46f, 0xb9bd, 0xdbd9, 0xb60b, 0x6f0, 0x6b22,
 0x20b6, 0x4d64, 0xfd9f, 0x904d, 0xf229, 0x9ffb, 0x2f00, 0x42d2,
 0x9646, 0xfb94, 0x4b6f, 0x26bd, 0x44d9, 0x290b, 0x99f0, 0xf422,
 0xbfb6, 0xd264, 0x629f, 0xf4d, 0x6d29, 0xfb, 0xb000, 0xddd2,
 0xf949, 0x949b, 0x2460, 0x49b2, 0x2bd6, 0x4604, 0xf6ff, 0x9b2d,
 0xd0b9, 0xbd6b, 0xd90, 0x6042, 0x226, 0x6ff4, 0xdf0f, 0xb2dd,
 0x6649, 0xb9b, 0xbb60, 0xd6b2, 0xb4d6, 0xd904, 0x69ff, 0x42d,
 0x4fb9, 0x226b, 0x9290, 0xff42, 0x9d26, 0xf0f4, 0x400f, 0x2ddd,
 0x949, 0x649b, 0xd460, 0xb9b2, 0xdbd6, 0xb604, 0x6ff, 0x6b2d,
 0x20b9, 0x4d6b, 0xfd90, 0x9042, 0xf226, 0x9ff4, 0x2f0f, 0x42dd,
 0x9649, 0xfb9b, 0x4b60, 0x26b2, 0x44d6, 0x2904, 0x99ff, 0xf42d,
 0xbfb9, 0xd26b, 0x6290, 0xf42, 0x6d26, 0xf4, 0xb00f, 0xdddd
};

int conv_reg;

/* <val> is a bit (0-1), returned is a value from 0-3 */
int conv_step1(int val) {
  int a,b,c;

  a=val^((conv_reg&2)>0)^((conv_reg&4)>0)^((conv_reg&16)>0)^((conv_reg&32)>0);
  b=val^((conv_reg&1)>0)^((conv_reg&2)>0)^((conv_reg&4)>0)^((conv_reg&32)>0);
  c=val^((conv_reg&1)>0)^((conv_reg&8)>0)^((conv_reg&32)>0);

  conv_reg<<=1;
  conv_reg+=val;
  return((a<<3)+(b<<2)+(c<<1)+a);
}

void conv_init(void) {
  conv_reg=0;
}

void conv_init_tab(void) {
  int i,j,k,l,m;
  int bit;
  int x,y;
  int reg,inp;

  for (j=0;j<16;j++) {
    for (i=0;i<64;i++) {
      inp=j;
      x=0;
      conv_reg=i;
      for (k=0;k<4;k++) {
	bit=inp&1;
	x<<=4;
	x+=conv_step1(bit);
	inp>>=1;
      }
      conv_tab[bitreversal(j,4)][i]=x;
    }
  }
}

/* <val> is a nibble (0-15), returned is a value from 0-65535 */
int conv_step4(int val) {
  int q,r;

  q=conv_tab[val][conv_reg];
  conv_reg<<=4;
  conv_reg+=val;
  conv_reg&=63;
  return(q);
}

int puncture(WORD src,WORD *dest,int pi) {
  int i,len,bits=0;
  WORD x=0,y;
  
  for (i=0;i<8;i++) {
    len=punct_len[pi-1][i];
    x<<=len;
    x+=(src>>(32-len));
    src<<=4;
    bits+=len;
  }
  *dest=x;
  return(bits);
}

/* source is the data to read, prbsoff the index of the next scramblingword,
   offset the offset in bits where to insert the next bit, dest the pointer
   to the current working place, n the number of Words to be processed and
   pi the index of the ProtectionInterval
*/
int endisp_conv_punct(WORD *source,int prbsoff,int offset,WORD *dest,int n,int pi) {
  register int i,j,t,o,newoff,len,ins;
  register WORD R,S,T;
  register BYTE *punct;
  WORD dst,src;
  
#ifdef COFDM_PROFILE
  prof_start(profile_conv);
#endif

  dest+=offset/32;
  dst=*dest;
  newoff=offset;
  o=(offset%32);
  if (o==0) dst=0;
  for (j=0;j<n;j++) {
    src=(source[j]^prbs_32(prbsoff+j));

    for (i=0;i<4;i++) {

      t=((src&0xf0000000)>>28);
      /* instead of call to conv_step4 */
      R=((conv_tab[t][conv_reg])<<16);
      conv_reg<<=4;
      conv_reg+=t;
      conv_reg&=63;
      /* printf("step1 t %x, conv_reg %4x, R %8x\n",t,conv_reg,R); */

      t=((src&0x0f000000)>>24);
      /* instead of call to conv_step4 */
      R+=(conv_tab[t][conv_reg]);
      conv_reg<<=4;
      conv_reg+=t;
      conv_reg&=63;
      /*printf("step2 t %x, conv_reg %4x, R %8x\n",t,conv_reg,R);*/

      src<<=8;

      /* instead of functioncall puncture: */
      len=0;S=0;
      punct=punct_len[pi-1];
      t=*punct;S+=(R>>(32-t));
      R<<=4;len+=t;punct++;
      t=*punct;S<<=t;S+=(R>>(32-t));
      R<<=4;len+=t;punct++;
      t=*punct;S<<=t;S+=(R>>(32-t));
      R<<=4;len+=t;punct++;
      t=*punct;S<<=t;S+=(R>>(32-t));
      R<<=4;len+=t;punct++;
      t=*punct;S<<=t;S+=(R>>(32-t));
      R<<=4;len+=t;punct++;
      t=*punct;S<<=t;S+=(R>>(32-t));
      R<<=4;len+=t;punct++;
      t=*punct;S<<=t;S+=(R>>(32-t));
      R<<=4;len+=t;punct++;
      t=*punct;S<<=t;S+=(R>>(32-t));
      len+=t;
      /* end of puncture */

      ins=32-o;
      /*printf("len%d, ins%d, dst %8x, dest%8x, S%8x\n",len,ins,dst,*dest,S);*/

      if (ins>len) {
	dst<<=len;
	dst+=S;
	o+=len;
      } else {
	dst<<=(ins-1); /* prevent dst<<=32; which does nothing at all */
	dst<<=1;
	dst+=(S>>(len-ins));
	*dest=dst;
	dest++;
	dst=S;
	o=(len-ins);
      }
      newoff+=len;
    }
  }
  if (o>0) *dest=dst;

#ifdef COFDM_PROFILE
  prof_stop();
#endif

  return(newoff-offset);
}

/* writes out the punctured tailvector (12 Bits)
   The tailvector is PI[7] - 1100110011001100...
   This routine expands the size of the tailvector with
   zeros to fill the WORD completely. This should be
   equal to appending the zero paddingbits.
   The routine returns the number of written plus expanded bits.
*/
int conv_punct_tail(int offset,WORD *dest) {
  int a,i,o;
  WORD t;

  o=offset;
  dest+=(offset/32);
  t=*dest;
  for (i=0;i<6;i++) {
    a=((conv_reg&2)>0)^((conv_reg&4)>0)^((conv_reg&16)>0)^((conv_reg&32)>0);
    t<<=1;
    t+=a;
    offset++;
    if ((offset%32)==0) {
      *dest=t;
      dest++;
    }
    a=((conv_reg&1)>0)^((conv_reg&2)>0)^((conv_reg&4)>0)^((conv_reg&32)>0);
    t<<=1;
    t+=a;
    offset++;
    if ((offset%32)==0) {
      *dest=t;
      dest++;
    }
    conv_reg<<=1;
  }
  if ((offset%32)!=0) {
    /* adjust to fit WORD */
    t<<=(WORDSIZE-(offset%WORDSIZE));
    *dest=t;
    offset+=(WORDSIZE-(offset%WORDSIZE));
  }
  conv_reg=0;
  return(offset-o);
}
