
/*


  A combination of
  * energy_dispersal
  * convolutional coder
  * puncturing

  Use this IN PLACE of conv_enc and puncture

  increases performance

  */

#include "conv_punct.h"
#include "prbs.h"
#ifdef COFDM_PROFILE
#include "profile.h"
#endif

WORD punct_vectors[24]={                       /*  from 32:  */
  0xc8888888,0xc888c888,0xc8c8c888,0xc8c8c8c8, /*  9-12 bits */
  0xccc8c8c8,0xccc8ccc8,0xccccccc8,0xcccccccc, /* 13-16 bits */
  0xeccccccc,0xeccceccc,0xecececcc,0xecececec, /* 17-20 bits */
  0xeeececec,0xeeeceeec,0xeeeeeeec,0xeeeeeeee, /* 21-24 bits */
  0xfeeeeeee,0xfeeefeee,0xfefefeee,0xfefefefe, /* 25-28 bits */
  0xfffefefe,0xfffefffe,0xfffffffe,0xffffffff  /* 29-32 bits */
};

int conv_reg;

void conv_init(void) {
  conv_reg=0;
}

void conv_initreg(void) {
  conv_reg=0;
}

/* this routine gets <n> Words (32 Bit) from src, which
   results in 128*<n> convolutional coded Bits, and writes
   36 to 128 Bit per <n> (dependend on pi, exactly 4*(8+PI), but
   only with the given puncturing vectors) to dest+(offset Bits).
   The returned integer is the number of written bits.

   The algorithm is dependend on the puncturingvectors !! If you
   change the vectors, the code may be adjusted, too !!

   The last written Bits are NOT completely correct, if
   ((offset%WORDSIZE) != 0)! That doesnt't matter with these routines.
   */
int endisp_conv_punct(WORD *source,int prbsoff,int offset,WORD *dest,int n,int pi) {
  int i,j,t,a1,a2,a3,o;
  WORD P;
  WORD dst,src;
  
#ifdef COFDM_PROFILE
  prof_start(profile_conv);
#endif
  dest+=offset/32;
  dst=*dest;
  o=offset;
  for(j=0;j<n;j++) {
    src=(source[j]^prbs_32(prbsoff+j));
    for (i=0;i<32;i++) {
      t=((src&MSB)>0);
      src<<=1;
      if ((i%8)==0) P=punct_vectors[pi-1];
      if (P&0x80000000) {
	a1=t^((conv_reg&2)>0)^((conv_reg&4)>0)^
	  ((conv_reg&16)>0)^((conv_reg&32)>0);
	dst<<=1;
	dst+=a1;
	offset++;
	if ((offset%32)==0) {
	  *dest=dst;
	  dest++;
	}
      }
      if (P&0x40000000) {
	a2=t^((conv_reg&1)>0)^((conv_reg&2)>0)^
	  ((conv_reg&4)>0)^((conv_reg&32)>0);
	dst<<=1;
	dst+=a2;
	offset++;
	if ((offset%32)==0) {
	  *dest=dst;
	  dest++;
	}
      }
      if (P&0x20000000) {
	a3=t^((conv_reg&1)>0)^((conv_reg&8)>0)^((conv_reg&32)>0);
	dst<<=1;
	dst+=a3;
	offset++;
	if ((offset%32)==0) {
	  *dest=dst;
	  dest++;
	}
      }
      if (P&0x10000000) {
	/* This algorithm assumes, that if the fourth convolutional bit
	   is used, it is identical with a1 and already calculated !
	   (This is only true for the given puncturing vectors !) */
	dst<<=1;
	dst+=a1;
	offset++;
	if ((offset%32)==0) {
	  *dest=dst;
	  dest++;
	}
      }
      P<<=4;
      
      conv_reg<<=1;
      conv_reg+=t;
    }
  }
  if ((offset%32)!=0) *dest=dst;
#ifdef COFDM_PROFILE
  prof_stop();
#endif
  return(offset-o);
}

/* writes out the punctured tailvector (12 Bits)
   The tailvector is PI[7] - 1100110011001100...
   This routine expands the size of the tailvector with
   zeros to fill the WORD completely. This should be
   equal to appending the zero paddingbits.
   The routine returns the number of written plus expanded bits.
*/
int conv_punct_tail(int offset,WORD *dest) {
  int a,i,o;
  WORD t;

#ifdef COFDM_PROFILE
  prof_start(profile_convtail);
#endif
  o=offset;
  dest+=(offset/32);
  t=*dest;
  for (i=0;i<6;i++) {
    a=((conv_reg&2)>0)^((conv_reg&4)>0)^((conv_reg&16)>0)^((conv_reg&32)>0);
    t<<=1;
    t+=a;
    offset++;
    if ((offset%32)==0) {
      *dest=t;
      dest++;
    }
    a=((conv_reg&1)>0)^((conv_reg&2)>0)^((conv_reg&4)>0)^((conv_reg&32)>0);
    t<<=1;
    t+=a;
    offset++;
    if ((offset%32)==0) {
      *dest=t;
      dest++;
    }
    conv_reg<<=1;
  }
  if ((offset%32)!=0) {
    /* adjust to fit WORD */
    t<<=(WORDSIZE-(offset%WORDSIZE));
    *dest=t;
    offset+=(WORDSIZE-(offset%WORDSIZE));
  }
#ifdef COFDM_PROFILE
  prof_stop();
#endif
  return(offset-o);
}
