
#include "conf.h"
#include "fft.h"
#include "ofdm.h"
#define CIFSIZE 55296

/* symbol buffer, maximum size (mode1) plus overhead assigned 
   overhead: one word more than nescessary may be coded.
   That is a maximum of 4 words after convolutional coding.
   The tail-vektor of 12 bit may be added, if the stream is complete.
   The Vektor is expanded to fit in a Word (should be max 8bits).
   There may be a symbol offset of 31 bits from the last call. The
   calculation of the number of needed words resembles only to
   complete words.
   summary: 4*32+12+31 is always less than six words.

   dsymb is defined here to grant some testroutines access
 */
extern WORD dsymb[96+6];

void symb_init(void);
int FIC_symbol(WORD *etiA,WORD *etiB,FFT_TYPE *symbol);
int MST_symbol(WORD *eti,FFT_TYPE *symbol);
