
#include "conf.h"

/* the modell concerns only data representatian - no machine details
   All external data is assumed in WORD-format. The first processed
   bit is the highest value bit: 0x8000000 */
#define _big_endian_modell

/* small routines which accesses 8Bits out of a 32Bits Word */
/* idx addresses linear Bytes (0..3, big endian) */
#ifdef _big_endian_modell
#define byteoutofword(cell,idx) (((cell)>>((3-(idx))*8))&255)
#define byteintoword(cell,byte,idx) { \
  (cell)=((cell)&((0xff000000>>(idx*8))^0xffffffff))|((byte)<<((3-(idx))*8)); }
#define nextbyte(cell) (((cell)&0xff000000)>>24)
#define shiftin(cell,byte) { (cell)<<=8;(cell)^=(byte); }
#define shiftout(cell) ((cell)<<=8)
#else
#define byteoutofword(cell,idx) (((cell)>>((idx)*8))&255)
#define byteintoword(cell,byte,idx) { \
  (cell)=((cell)&((0xff<<(idx*8))^0xffffffff))|((byte)<<(idx)*8); }
#define nextbyte(cell) ((cell)&0x000000ff)
#define shiftout(cell) (cell>>=8)
#define shiftin(cell,byte) { (cell)>>=8;(cell)^=((byte)<<24); }
#endif

void gfq_Wpolydivi(WORD *a,int lba,WORD *b,int lwb,WORD *remainder);
WORD gfq_Wsyndrom(WORD *poly,int ll,int x);
int rs_Wcorrect(WORD *msg,int ll,int rootoff,int rootnr,WORD *buf);
void rs_Wencode(WORD *msgbuf,int msglen,int rootoff,int rootnbr,WORD *buf);
