




#include <time.h>
#include "conf.h"

#ifndef INCLUDE_PROFILE
#define INCLUDE_PROFILE

#define PROFILE_MAXENTRYS 50

/* WARNING - the order of the names correspond to the strings in profile.c
   and MUST NOT BE CHANGED! */
enum profile_functions {
  calib0,calib1,overhead,suspend,profile_conv,profile_convtail,profile_ifft,
  profile_fft,profile_prbsgenerate,profile_prbsscramble,profile_calcpi,
  profile_mstsymbol,profile_ficsymbol,profile_interleave,
  profile_timeconfig,profile_symbol,profile_crccalc,profile_berlekamp,
  profile_syndrom,profile_rscorrect,profile_dqpsk,profile_program,
  profile_reversal,profile_outinterleave
};
typedef enum profile_functions profile_funcs;

struct sprof_entry {
  int count;
  clock_t start;
  clock_t cycles;
  int called_by;
};

typedef struct sprof_entry tprof_entry;
extern tprof_entry profiles[];

clock_t prof_calib();
void prof_start(int idx);
void prof_stop();
void prof_suspend(void);
void prof_resume(void);
void prof_printf();


#endif
